/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class BooleanFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "boolean";

    protected BooleanFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored() && !this.fieldType().hasDocValues()) {
            return;
        }
        Boolean value = context.parseExternalValue(Boolean.class);
        if (value == null) {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                if (this.fieldType().nullValue() != null) {
                    value = this.fieldType().nullValue();
                }
            } else {
                value = context.parser().booleanValue();
            }
        }
        if (value == null) {
            return;
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            fields.add((IndexableField)new Field(this.fieldType().name(), (CharSequence)(value != false ? "T" : "F"), (IndexableFieldType)this.fieldType()));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            this.createFieldNamesField(context, fields);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        public BooleanFieldType() {
        }

        protected BooleanFieldType(BooleanFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new BooleanFieldType(this);
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Boolean nullValue() {
            return (Boolean)super.nullValue();
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            switch (sValue) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            switch (value.toString()) {
                case "F": {
                    return false;
                }
                case "T": {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected [T] or [F] but got [" + value + "]");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BOOLEAN);
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return CoreValuesSourceType.BOOLEAN;
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(XContentMapValues.nodeBooleanValue(propNode, name + ".null_value"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, BooleanFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public BooleanFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new BooleanFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef((CharSequence)"T");
        public static final BytesRef FALSE = new BytesRef((CharSequence)"F");
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new BooleanFieldType();

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.freeze();
        }
    }
}

