/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestDeduplicator;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final TransportRequestDeduplicator<UpdateIndexShardSnapshotStatusRequest> remoteFailedRequestDeduplicator = new TransportRequestDeduplicator();
    private final SnapshotStateExecutor snapshotStateExecutor = new SnapshotStateExecutor();
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;

    public SnapshotShardsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (DiscoveryNode.isDataNode(settings)) {
            clusterService.addListener(this);
        }
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler("internal:cluster/snapshot/update_snapshot_status") != null);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            SnapshotsInProgress previousSnapshots = (SnapshotsInProgress)event.previousState().custom("snapshots");
            SnapshotsInProgress currentSnapshots = (SnapshotsInProgress)event.state().custom("snapshots");
            if (previousSnapshots == null && currentSnapshots != null || previousSnapshots != null && !previousSnapshots.equals(currentSnapshots)) {
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.cancelRemoved(currentSnapshots);
                    if (currentSnapshots != null) {
                        this.startNewSnapshots(currentSnapshots);
                    }
                }
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                Map<ShardId, IndexShardSnapshotStatus> shards = snapshotShards.getValue();
                if (!shards.containsKey(shardId)) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                shards.get(shardId).abortIfNotCompleted("shard is closing, aborting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            return current == null ? null : new HashMap<ShardId, IndexShardSnapshotStatus>(current);
        }
    }

    private void cancelRemoved(@Nullable SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress != null && snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting");
            }
        }
    }

    private void startNewSnapshots(SnapshotsInProgress snapshotsInProgress) {
        String localNodeId = this.clusterService.localNode().getId();
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            SnapshotsInProgress.State entryState = entry.state();
            if (entryState == SnapshotsInProgress.State.STARTED) {
                HashMap<ShardId, IndexShardSnapshotStatus> startedShards = null;
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (!localNodeId.equals(shardSnapshotStatus.nodeId()) || shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || snapshotShards.containsKey(shardId)) continue;
                    logger.trace("[{}] - Adding shard to the queue", (Object)shardId);
                    if (startedShards == null) {
                        startedShards = new HashMap<ShardId, IndexShardSnapshotStatus>();
                    }
                    startedShards.put(shardId, IndexShardSnapshotStatus.newInitializing(shardSnapshotStatus.generation()));
                }
                if (startedShards == null || startedShards.isEmpty()) continue;
                this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap()).putAll(startedShards);
                this.startNewShards(entry, (Map<ShardId, IndexShardSnapshotStatus>)startedShards);
                continue;
            }
            if (entryState != SnapshotsInProgress.State.ABORTED) continue;
            Snapshot snapshot = entry.snapshot();
            Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
            for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                IndexShardSnapshotStatus indexShardSnapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(objectObjectCursor.key);
                if (indexShardSnapshotStatus == null) {
                    if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.ABORTED || !localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).nodeId())) continue;
                    this.notifyFailedSnapshotShard(snapshot, (ShardId)objectObjectCursor.key, ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).reason());
                    continue;
                }
                indexShardSnapshotStatus.abortIfNotCompleted("snapshot has been aborted");
            }
        }
    }

    private void startNewShards(SnapshotsInProgress.Entry entry, Map<ShardId, IndexShardSnapshotStatus> startedShards) {
        this.threadPool.executor("snapshot").execute(() -> {
            final Snapshot snapshot = entry.snapshot();
            Map indicesMap = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
            for (Map.Entry shardEntry : startedShards.entrySet()) {
                final ShardId shardId = (ShardId)shardEntry.getKey();
                final IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)shardEntry.getValue();
                IndexId indexId = (IndexId)indicesMap.get(shardId.getIndexName());
                assert (indexId != null);
                assert (SnapshotsService.useShardGenerations(entry.version()) || snapshotStatus.generation() == null) : "Found non-null shard generation [" + snapshotStatus.generation() + "] for snapshot with old-format compatibility";
                this.snapshot(shardId, snapshot, indexId, entry.userMetadata(), snapshotStatus, entry.version(), new ActionListener<String>(){

                    @Override
                    public void onResponse(String newGeneration) {
                        assert (newGeneration != null);
                        assert (newGeneration.equals(snapshotStatus.generation()));
                        if (logger.isDebugEnabled()) {
                            IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                            logger.debug("snapshot [{}] completed to [{}] with [{}] at generation [{}]", (Object)snapshot, (Object)snapshot.getRepository(), (Object)lastSnapshotStatus, (Object)snapshotStatus.generation());
                        }
                        SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, newGeneration);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        String failure;
                        if (e instanceof AbortedSnapshotException) {
                            failure = "aborted";
                            logger.debug(() -> new ParameterizedMessage("[{}][{}] aborted shard snapshot", (Object)shardId, (Object)snapshot), (Throwable)e);
                        } else {
                            failure = SnapshotShardsService.summarizeFailure(e);
                            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                        }
                        snapshotStatus.moveToFailed(SnapshotShardsService.this.threadPool.absoluteTimeInMillis(), failure);
                        SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, failure);
                    }
                });
            }
        });
    }

    static String summarizeFailure(Throwable t) {
        if (t.getCause() == null) {
            return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
        }
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            sb.append(t.getClass().getSimpleName());
            if (t.getMessage() != null) {
                sb.append("[");
                sb.append(t.getMessage());
                sb.append("]");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("; nested: ");
        }
        return sb.toString();
    }

    private void snapshot(ShardId shardId, Snapshot snapshot, IndexId indexId, Map<String, Object> userMetadata, IndexShardSnapshotStatus snapshotStatus, Version version, ActionListener<String> listener) {
        try {
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
            if (!indexShard.routingEntry().primary()) {
                throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
            }
            if (indexShard.routingEntry().relocating()) {
                throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
            }
            IndexShardState indexShardState = indexShard.state();
            if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
                throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
            }
            Repository repository = this.repositoriesService.repository(snapshot.getRepository());
            Engine.IndexCommitRef snapshotRef = null;
            try {
                snapshotRef = indexShard.acquireLastIndexCommit(true);
                IndexCommit snapshotIndexCommit = snapshotRef.getIndexCommit();
                repository.snapshotShard(indexShard.store(), indexShard.mapperService(), snapshot.getSnapshotId(), indexId, snapshotRef.getIndexCommit(), SnapshotShardsService.getShardStateId(indexShard, snapshotIndexCommit), snapshotStatus, version, userMetadata, ActionListener.runBefore(listener, snapshotRef::close));
            }
            catch (Exception e) {
                IOUtils.close((Closeable[])new Closeable[]{snapshotRef});
                throw e;
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Nullable
    private static String getShardStateId(IndexShard indexShard, IndexCommit snapshotIndexCommit) throws IOException {
        Map userCommitData = snapshotIndexCommit.getUserData();
        SequenceNumbers.CommitInfo seqNumInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userCommitData.entrySet());
        long maxSeqNo = seqNumInfo.maxSeqNo;
        if (maxSeqNo != seqNumInfo.localCheckpoint || maxSeqNo != indexShard.getLastSyncedGlobalCheckpoint()) {
            return null;
        }
        return (String)userCommitData.get("history_uuid") + "-" + userCommitData.getOrDefault("force_merge_uuid", "na") + "-" + maxSeqNo;
    }

    private void syncShardStatsOnNewMaster(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        this.remoteFailedRequestDeduplicator.clear();
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localShard.getValue().generation());
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, indexShardSnapshotStatus.getFailure());
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, String generation) {
        assert (generation != null);
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.ShardState.SUCCESS, generation));
    }

    private void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String failure) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.ShardState.FAILED, failure, null));
    }

    private void sendSnapshotShardUpdate(final Snapshot snapshot, ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status) {
        this.remoteFailedRequestDeduplicator.executeOnce(new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                logger.trace("[{}] [{}] updated snapshot state", (Object)snapshot, (Object)status);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
            }
        }, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), "internal:cluster/snapshot/update_snapshot_status", (TransportRequest)req, new TransportResponseHandler<UpdateIndexShardSnapshotStatusResponse>(){

            @Override
            public UpdateIndexShardSnapshotStatusResponse read(StreamInput in) throws IOException {
                return new UpdateIndexShardSnapshotStatusResponse(in);
            }

            @Override
            public void handleResponse(UpdateIndexShardSnapshotStatusResponse response) {
                reqListener.onResponse(null);
            }

            @Override
            public void handleException(TransportException exp) {
                reqListener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        }));
    }

    private void innerUpdateSnapshotState(UpdateIndexShardSnapshotStatusRequest request, final ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
        logger.trace("received updated snapshot restore state [{}]", (Object)request);
        this.clusterService.submitStateUpdateTask("update snapshot state", request, ClusterStateTaskConfig.build(Priority.NORMAL), this.snapshotStateExecutor, new ClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new UpdateIndexShardSnapshotStatusResponse());
            }
        });
    }

    public static class UpdateIndexShardSnapshotStatusRequest
    extends MasterNodeRequest<UpdateIndexShardSnapshotStatusRequest> {
        private final Snapshot snapshot;
        private final ShardId shardId;
        private final SnapshotsInProgress.ShardSnapshotStatus status;

        public UpdateIndexShardSnapshotStatusRequest(StreamInput in) throws IOException {
            super(in);
            this.snapshot = new Snapshot(in);
            this.shardId = new ShardId(in);
            this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
        }

        public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
            this.masterNodeTimeout = TimeValue.timeValueNanos((long)Long.MAX_VALUE);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateIndexShardSnapshotStatusRequest that = (UpdateIndexShardSnapshotStatusRequest)o;
            return this.snapshot.equals(that.snapshot) && this.shardId.equals(that.shardId) && this.status.equals(that.status);
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.shardId, this.status);
        }
    }

    private static class SnapshotStateExecutor
    implements ClusterStateTaskExecutor<UpdateIndexShardSnapshotStatusRequest> {
        private SnapshotStateExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<UpdateIndexShardSnapshotStatusRequest> execute(ClusterState currentState, List<UpdateIndexShardSnapshotStatusRequest> tasks) {
            SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
            if (snapshots != null) {
                int changedCount = 0;
                ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
                    boolean updated = false;
                    for (UpdateIndexShardSnapshotStatusRequest updateSnapshotState : tasks) {
                        if (!entry.snapshot().equals(updateSnapshotState.snapshot())) continue;
                        logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot(), (Object)updateSnapshotState.shardId(), (Object)updateSnapshotState.status().state());
                        if (!updated) {
                            shards.putAll(entry.shards());
                            updated = true;
                        }
                        shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                        ++changedCount;
                    }
                    if (updated) {
                        if (!SnapshotsInProgress.completed(shards.values())) {
                            entries.add(new SnapshotsInProgress.Entry(entry, shards.build()));
                            continue;
                        }
                        SnapshotsInProgress.Entry updatedEntry = new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.SUCCESS, shards.build());
                        entries.add(updatedEntry);
                        continue;
                    }
                    entries.add(entry);
                }
                if (changedCount > 0) {
                    logger.trace("changed cluster state triggered by {} snapshot state updates", (Object)changedCount);
                    return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build());
                }
            }
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, UpdateIndexShardSnapshotStatusResponse> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super("internal:cluster/snapshot/update_snapshot_status", false, transportService, clusterService, threadPool, actionFilters, UpdateIndexShardSnapshotStatusRequest::new, indexNameExpressionResolver);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected UpdateIndexShardSnapshotStatusResponse read(StreamInput in) throws IOException {
            return new UpdateIndexShardSnapshotStatusResponse(in);
        }

        @Override
        protected void masterOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
            SnapshotShardsService.this.innerUpdateSnapshotState(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    static class UpdateIndexShardSnapshotStatusResponse
    extends ActionResponse {
        UpdateIndexShardSnapshotStatusResponse() {
        }

        UpdateIndexShardSnapshotStatusResponse(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }
}

