/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.answer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;

public class AnswerComparator
implements Comparator<Answer> {
    private static final Logger LOG = LogManager.getLogger(AnswerComparator.class);

    @Override
    public int compare(Answer ans1, Answer argAnswer) {
        int retVal = 0;
        if (Objects.equals(ans1.getQuestionNumber(), argAnswer.getQuestionNumber())) {
            retVal = ans1.getAnswerNumber().compareTo(argAnswer.getAnswerNumber());
        } else if (Objects.equals(ans1.getQuestionnaireQuestion().getParentQuestionNumber(), argAnswer.getQuestionnaireQuestion().getParentQuestionNumber())) {
            retVal = ans1.getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(argAnswer.getQuestionnaireQuestion().getQuestionSeqNumber());
        } else if (Objects.equals(ans1.getQuestionnaireQuestion().getParentQuestionNumber(), argAnswer.getQuestionNumber())) {
            retVal = 1;
        } else if (Objects.equals(ans1.getQuestionNumber(), argAnswer.getQuestionnaireQuestion().getParentQuestionNumber())) {
            retVal = -1;
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() == 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) {
            retVal = ans1.getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(this.getRootAnswer(argAnswer).getQuestionnaireQuestion().getQuestionSeqNumber());
            if (retVal == 0) {
                retVal = -1;
            }
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() != 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0) {
            retVal = this.getRootAnswer(ans1).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(argAnswer.getQuestionnaireQuestion().getQuestionSeqNumber());
            if (retVal == 0) {
                retVal = 1;
            }
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() != 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) {
            retVal = Objects.equals(this.getRootAnswer(ans1).getQuestionNumber(), this.getRootAnswer(argAnswer).getQuestionNumber()) ? this.compareAtSameDepth(ans1, argAnswer) : this.getRootAnswer(ans1).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(this.getRootAnswer(argAnswer).getQuestionnaireQuestion().getQuestionSeqNumber());
        } else {
            LOG.info("no comparison matched " + ans1.getQuestionnaireQuestionsId() + "-" + argAnswer.getQuestionnaireQuestionsId());
            retVal = 0;
        }
        return retVal;
    }

    private Answer getRootAnswer(Answer argAnswer) {
        Answer thisAnswer = argAnswer;
        while (thisAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            thisAnswer = thisAnswer.getParentAnswers().get(0);
        }
        return thisAnswer;
    }

    private int compareAtSameDepth(Answer thisAnswer, Answer argAnswer) {
        int retVal = 0;
        List<Answer> ancestors1 = this.getAncestors(thisAnswer);
        List<Answer> ancestors2 = this.getAncestors(argAnswer);
        if (ancestors1.size() <= ancestors2.size()) {
            retVal = -1;
            for (int i = 0; i < ancestors1.size(); ++i) {
                if (Objects.equals(ancestors1.get(i).getQuestionNumber(), ancestors2.get(i).getQuestionNumber())) continue;
                retVal = ancestors1.get(i).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(ancestors2.get(i).getQuestionnaireQuestion().getQuestionSeqNumber());
                break;
            }
        } else {
            for (int i = 0; i < ancestors2.size(); ++i) {
                retVal = 1;
                if (Objects.equals(ancestors2.get(i).getQuestionNumber(), ancestors1.get(i).getQuestionNumber())) continue;
                retVal = ancestors1.get(i).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(ancestors2.get(i).getQuestionnaireQuestion().getQuestionSeqNumber());
                break;
            }
        }
        return retVal;
    }

    private List<Answer> getAncestors(Answer argAnswer) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        answers.add(argAnswer);
        Answer thisAnswer = argAnswer;
        while (thisAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            thisAnswer = thisAnswer.getParentAnswers().get(0);
            answers.add(thisAnswer);
        }
        Collections.reverse(answers);
        return answers;
    }
}

