/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.SecurityPermissionInfo;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DocumentTypeSecurity
implements Serializable {
    private static final long serialVersionUID = -1886779857180381404L;
    private static final Logger LOG = LogManager.getLogger(DocumentTypeSecurity.class);
    private Boolean active;
    private Boolean initiatorOk;
    private Boolean routeLogAuthenticatedOk;
    private List<KeyValue> searchableAttributes = new ArrayList<KeyValue>();
    private List<Group> workgroups = new ArrayList<Group>();
    private List<SecurityPermissionInfo> permissions = new ArrayList<SecurityPermissionInfo>();
    private List<String> allowedRoles = new ArrayList<String>();
    private List<String> disallowedRoles = new ArrayList<String>();
    private List<String> securityAttributeExtensionNames = new ArrayList<String>();
    private List<String> securityAttributeClassNames = new ArrayList<String>();
    private static XPath xpath = XPathHelper.newXPath();

    public DocumentTypeSecurity() {
    }

    public DocumentTypeSecurity(String standardApplicationId, String documentTypeSecurityXml) {
        try {
            NodeList attributeNodes;
            NodeList roleNodes;
            NodeList permissionNodes;
            NodeList groupNodes;
            Group groupObject;
            NodeList workgroupNodes;
            NodeList searchableAttributeNodes;
            NodeList routeLogAuthNodes;
            if (StringUtils.isEmpty((String)documentTypeSecurityXml)) {
                return;
            }
            InputSource inputSource = new InputSource(new BufferedReader(new StringReader(documentTypeSecurityXml)));
            Element securityElement = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(inputSource).getDocumentElement();
            String active = (String)xpath.evaluate("./@active", securityElement, XPathConstants.STRING);
            if (StringUtils.isEmpty((String)active) || "true".equals(active.toLowerCase())) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
            NodeList initiatorNodes = (NodeList)xpath.evaluate("./initiator", securityElement, XPathConstants.NODESET);
            if (initiatorNodes != null && initiatorNodes.getLength() > 0) {
                Node initiatorNode = initiatorNodes.item(0);
                String value = initiatorNode.getTextContent();
                if (StringUtils.isEmpty((String)value) || value.toLowerCase().equals("true")) {
                    this.setInitiatorOk(true);
                } else {
                    this.initiatorOk = false;
                }
            }
            if ((routeLogAuthNodes = (NodeList)xpath.evaluate("./routeLogAuthenticated", securityElement, XPathConstants.NODESET)) != null && routeLogAuthNodes.getLength() > 0) {
                Node routeLogAuthNode = routeLogAuthNodes.item(0);
                String value = routeLogAuthNode.getTextContent();
                this.routeLogAuthenticatedOk = StringUtils.isEmpty((String)value) || value.toLowerCase().equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if ((searchableAttributeNodes = (NodeList)xpath.evaluate("./searchableAttribute", securityElement, XPathConstants.NODESET)) != null && searchableAttributeNodes.getLength() > 0) {
                for (int i = 0; i < searchableAttributeNodes.getLength(); ++i) {
                    Node searchableAttributeNode = searchableAttributeNodes.item(i);
                    String name = (String)xpath.evaluate("./@name", searchableAttributeNode, XPathConstants.STRING);
                    String idType = (String)xpath.evaluate("./@idType", searchableAttributeNode, XPathConstants.STRING);
                    if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)idType)) continue;
                    ConcreteKeyValue searchableAttribute = new ConcreteKeyValue(name, idType);
                    this.searchableAttributes.add((KeyValue)searchableAttribute);
                }
            }
            if ((workgroupNodes = (NodeList)xpath.evaluate("./workgroup", securityElement, XPathConstants.NODESET)) != null && workgroupNodes.getLength() > 0) {
                LOG.warn("Document Type Security XML is using deprecated element 'workgroup', please use 'groupName' instead.");
                for (int i = 0; i < workgroupNodes.getLength(); ++i) {
                    Node workgroupNode = workgroupNodes.item(i);
                    String value = workgroupNode.getTextContent().trim();
                    if (StringUtils.isEmpty((String)value)) continue;
                    value = Utilities.substituteConfigParameters(value);
                    String namespaceCode = Utilities.parseGroupNamespaceCode(value);
                    String groupName = Utilities.parseGroupName(value);
                    groupObject = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
                    if (groupObject == null) {
                        throw new WorkflowException("Could not find group: " + value);
                    }
                    this.workgroups.add(groupObject);
                }
            }
            if ((groupNodes = (NodeList)xpath.evaluate("./groupName", securityElement, XPathConstants.NODESET)) != null && groupNodes.getLength() > 0) {
                for (int i = 0; i < groupNodes.getLength(); ++i) {
                    String groupName;
                    Node groupNode = groupNodes.item(i);
                    if (groupNode.getNodeType() != 1 || StringUtils.isEmpty((String)(groupName = groupNode.getTextContent().trim()))) continue;
                    groupName = Utilities.substituteConfigParameters(groupName).trim();
                    String namespaceCode = Utilities.substituteConfigParameters(((Element)groupNode).getAttribute("namespace")).trim();
                    groupObject = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
                    if (groupObject != null) {
                        this.workgroups.add(groupObject);
                        continue;
                    }
                    LOG.warn("Could not find group with name '" + groupName + "' and namespace '" + namespaceCode + "' which was defined on Document Type security");
                }
            }
            if ((permissionNodes = (NodeList)xpath.evaluate("./permission", securityElement, XPathConstants.NODESET)) != null && permissionNodes.getLength() > 0) {
                for (int i = 0; i < permissionNodes.getLength(); ++i) {
                    Node permissionNode = permissionNodes.item(i);
                    if (permissionNode.getNodeType() != 1) continue;
                    SecurityPermissionInfo securityPermission = new SecurityPermissionInfo();
                    securityPermission.setPermissionName(Utilities.substituteConfigParameters(((Element)permissionNode).getAttribute("name")).trim());
                    securityPermission.setPermissionNamespaceCode(Utilities.substituteConfigParameters(((Element)permissionNode).getAttribute("namespace")).trim());
                    if (StringUtils.isEmpty((String)securityPermission.getPermissionName()) || StringUtils.isEmpty((String)securityPermission.getPermissionNamespaceCode())) continue;
                    if (permissionNode.hasChildNodes()) {
                        NodeList permissionChildNodes = permissionNode.getChildNodes();
                        for (int j = 0; j < permissionChildNodes.getLength(); ++j) {
                            Node permissionChildNode = permissionChildNodes.item(j);
                            if (permissionChildNode.getNodeType() != 1) continue;
                            String childAttributeName = Utilities.substituteConfigParameters(((Element)permissionChildNode).getAttribute("name")).trim();
                            String childAttributeValue = permissionChildNode.getTextContent().trim();
                            if (!StringUtils.isEmpty((String)childAttributeValue)) {
                                childAttributeValue = Utilities.substituteConfigParameters(childAttributeValue).trim();
                            }
                            if (!StringUtils.isEmpty((String)childAttributeValue)) {
                                childAttributeValue = Utilities.substituteConfigParameters(childAttributeValue).trim();
                            }
                            if (permissionChildNode.getNodeName().trim().equals("permissionDetail")) {
                                securityPermission.getPermissionDetails().put(childAttributeName, childAttributeValue);
                            }
                            if (!permissionChildNode.getNodeName().trim().equals("qualification")) continue;
                            securityPermission.getQualifications().put(childAttributeName, childAttributeValue);
                        }
                    }
                    this.permissions.add(securityPermission);
                }
            }
            if ((roleNodes = (NodeList)xpath.evaluate("./role", securityElement, XPathConstants.NODESET)) != null && roleNodes.getLength() > 0) {
                for (int i = 0; i < roleNodes.getLength(); ++i) {
                    Element roleElement = (Element)roleNodes.item(i);
                    String value = roleElement.getTextContent().trim();
                    String allowedValue = roleElement.getAttribute("allowed");
                    if (StringUtils.isBlank((String)allowedValue)) {
                        allowedValue = "true";
                    }
                    if (StringUtils.isEmpty((String)value)) continue;
                    if (Boolean.parseBoolean(allowedValue)) {
                        this.allowedRoles.add(value);
                        continue;
                    }
                    this.disallowedRoles.add(value);
                }
            }
            if ((attributeNodes = (NodeList)xpath.evaluate("./securityAttribute", securityElement, XPathConstants.NODESET)) != null && attributeNodes.getLength() > 0) {
                for (int i = 0; i < attributeNodes.getLength(); ++i) {
                    Element attributeElement = (Element)attributeNodes.item(i);
                    NamedNodeMap elemAttributes = attributeElement.getAttributes();
                    Object attributeOrClassName = null;
                    String applicationId = standardApplicationId;
                    if (elemAttributes.getNamedItem("name") != null) {
                        String extensionName = elemAttributes.getNamedItem("name").getNodeValue().trim();
                        this.securityAttributeExtensionNames.add(extensionName);
                        continue;
                    }
                    if (elemAttributes.getNamedItem("class") != null) {
                        String className = elemAttributes.getNamedItem("class").getNodeValue().trim();
                        this.securityAttributeClassNames.add(className);
                        continue;
                    }
                    throw new WorkflowException("Cannot find attribute 'name' or attribute 'class' for securityAttribute Node");
                }
            }
        }
        catch (Exception err) {
            throw new WorkflowRuntimeException((Throwable)err);
        }
    }

    public List<String> getSecurityAttributeExtensionNames() {
        return this.securityAttributeExtensionNames;
    }

    public void setSecurityAttributeExtensionNames(List<String> securityAttributeExtensionNames) {
        this.securityAttributeExtensionNames = securityAttributeExtensionNames;
    }

    public List<String> getSecurityAttributeClassNames() {
        return this.securityAttributeClassNames;
    }

    public void setSecurityAttributeClassNames(List<String> securityAttributeClassNames) {
        this.securityAttributeClassNames = securityAttributeClassNames;
    }

    public Boolean getInitiatorOk() {
        return this.initiatorOk;
    }

    public void setInitiatorOk(Boolean initiatorOk) {
        this.initiatorOk = initiatorOk;
    }

    public Boolean getRouteLogAuthenticatedOk() {
        return this.routeLogAuthenticatedOk;
    }

    public void setRouteLogAuthenticatedOk(Boolean routeLogAuthenticatedOk) {
        this.routeLogAuthenticatedOk = routeLogAuthenticatedOk;
    }

    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(List<String> allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    public List<String> getDisallowedRoles() {
        return this.disallowedRoles;
    }

    public void setDisallowedRoles(List<String> disallowedRoles) {
        this.disallowedRoles = disallowedRoles;
    }

    public List<KeyValue> getSearchableAttributes() {
        return this.searchableAttributes;
    }

    public void setSearchableAttributes(List<KeyValue> searchableAttributes) {
        this.searchableAttributes = searchableAttributes;
    }

    public List<Group> getWorkgroups() {
        return this.workgroups;
    }

    public void setWorkgroups(List<Group> workgroups) {
        this.workgroups = workgroups;
    }

    public List<SecurityPermissionInfo> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<SecurityPermissionInfo> permissions) {
        this.permissions = permissions;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        if (this.active != null) {
            return this.active;
        }
        return false;
    }
}

