/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResultBase;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.springframework.beans.factory.InitializingBean;

public class FlywayExecutor
implements InitializingBean {
    private Logger LOG = LogManager.getLogger(FlywayExecutor.class);
    private Flyway flyway;

    public void afterPropertiesSet() {
        Boolean enabled = this.getValueAsBoolean("kc.flyway.enabled", "KC_FLYWAY_ENABLED");
        if (enabled != null && enabled.booleanValue()) {
            String commands = this.getValueAsString("kc.flyway.commands", "KC_FLYWAY_COMMANDS");
            if (StringUtils.isNotBlank((CharSequence)commands)) {
                this.execute(commands);
            } else {
                this.LOG.warn("Flyway is enabled but no flyway commands are found.");
            }
        } else {
            this.LOG.info("Disabled flyway");
        }
    }

    private void execute(String commands) {
        Arrays.stream(commands.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(String::toLowerCase).distinct().map(command -> CollectionUtils.entry(command, this.findMethod((String)command))).forEach(cmdEntry -> {
            String command = (String)cmdEntry.getKey();
            Method cmdMethod = (Method)cmdEntry.getValue();
            if (cmdMethod != null) {
                this.LOG.info("Executing flyway command [" + command + "]");
                try {
                    Object result = cmdMethod.invoke((Object)this.flyway, new Object[0]);
                    if (!this.LOG.isInfoEnabled()) return;
                    this.LOG.info("Executed flyway command [" + command + "] with result [" + this.resultToString(result) + "]");
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.LOG.error("Failed flyway command [" + command + "]", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                this.LOG.error("Not Found flyway command [" + command + "]");
            }
        });
    }

    private String resultToString(Object result) {
        String flywayResult = "flyway result\n\t";
        if (result instanceof MigrationInfoService) {
            MigrationInfoService info = (MigrationInfoService)result;
            InfoResult res = info.getInfoResult();
            return "flyway result\n\t" + this.toStr((OperationResultBase)res) + " schema version: " + res.schemaVersion + " schema name: " + res.schemaName + " all schemas empty: " + res.allSchemasEmpty + "\n pending migrations:\n" + this.toStr(info.pending());
        }
        if (result instanceof MigrateResult) {
            MigrateResult res = (MigrateResult)result;
            return "flyway result\n\t" + this.toStr((OperationResultBase)res) + " initial schema version: " + res.initialSchemaVersion + " target schema version: " + res.targetSchemaVersion + " schema name: " + res.schemaName + " migrations executed: " + res.migrationsExecuted;
        }
        if (result instanceof OperationResultBase) {
            return "flyway result\n\t" + this.toStr((OperationResultBase)result) + " " + result.getClass().getName();
        }
        if (result != null) {
            return "flyway result\n\t" + result;
        }
        return "flyway result\n\t";
    }

    private String toStr(OperationResultBase result) {
        return "flyway version: " + result.flywayVersion + " database: " + result.database + " operation: " + result.operation + " warnings: " + result.warnings;
    }

    private String toStr(MigrationInfo[] applied) {
        return Arrays.stream(applied).map(this::toStr).collect(Collectors.joining("\n"));
    }

    private String toStr(MigrationInfo i) {
        return "\ttype: " + i.getType() + " checksum: " + i.getChecksum() + " version: " + i.getVersion() + " description: " + i.getDescription() + " script: " + i.getScript() + " state: " + i.getState() + " installed on: " + i.getInstalledOn() + " installed by: " + i.getInstalledBy() + " installed rank: " + i.getInstalledRank() + " execution time: " + i.getExecutionTime() + " physical location: " + i.getPhysicalLocation();
    }

    private Method findMethod(String command) {
        try {
            return this.flyway.getClass().getMethod(command, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getValueAsString(String xmlCfg, String envCfg) {
        String cfg = ConfigContext.getConfig().getProperty(xmlCfg);
        String envXml = ConfigContext.getConfig().getProperty(envCfg);
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank((CharSequence)envXml)) {
            return envXml;
        }
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return env;
        }
        if (StringUtils.isNotBlank((CharSequence)cfg)) {
            return cfg;
        }
        return null;
    }

    private Boolean getValueAsBoolean(String xmlCfg, String envCfg) {
        Boolean cfg = ConfigContext.getConfig().getBooleanProperty(xmlCfg);
        Boolean envXml = ConfigContext.getConfig().getBooleanProperty(envCfg);
        String env = System.getenv(envCfg);
        if (envXml != null) {
            return envXml;
        }
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return Boolean.valueOf(env);
        }
        if (cfg != null) {
            return cfg;
        }
        return null;
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    public void setFlyway(Flyway flyway) {
        this.flyway = flyway;
    }
}

