/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.workflow;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.impex.xml.StreamXmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlIngesterService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class KcKewAutoIngestorService {
    private static final Logger LOG = LogManager.getLogger(KcKewAutoIngestorService.class);
    private String cfgPathsToScan;
    private List<String> pathsToScan = new ArrayList<String>();
    private String principalIdToIngestAs;
    private Boolean enabled;
    private DataSource riceDataSource;
    private XmlIngesterService xmlIngesterService;

    public void ingest() throws Exception {
        if (Boolean.FALSE.equals(this.enabled)) {
            LOG.info("Kew ingestion is not enabled. Skipping.");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.cfgPathsToScan)) {
            this.pathsToScan.addAll(Arrays.asList(this.cfgPathsToScan.split(",")));
        }
        HashMap<String, Integer> newChecksums = new HashMap<String, Integer>();
        try (Connection conn = this.riceDataSource.getConnection();){
            conn.setAutoCommit(false);
            Map<String, Integer> previousChecksums = this.readChecksums(conn);
            for (String path : this.pathsToScan) {
                Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath*:" + path + "/**/*.xml");
                try (AutoXmlDocCollection docCollection = new AutoXmlDocCollection(new File(path));){
                    for (Resource file : resources) {
                        byte[] encoded;
                        try (BufferedInputStream is = new BufferedInputStream(file.getInputStream());){
                            encoded = IOUtils.toByteArray((InputStream)is);
                        }
                        Integer checkSum = this.calculateChecksum(encoded);
                        String baseName = new File(file.getFilename()).getName();
                        if (previousChecksums.containsKey(baseName) && previousChecksums.get(baseName).equals(checkSum)) {
                            LOG.info("Skipping " + file + " as it is unchanged.");
                            continue;
                        }
                        LOG.info("Adding " + file + " for ingestion.");
                        newChecksums.put(baseName, checkSum);
                        docCollection.addXmlDoc(new NamedStreamXmlDoc(baseName, new ByteArrayInputStream(encoded), docCollection));
                    }
                    if (docCollection.getXmlDocs().isEmpty()) continue;
                    Collection failed = this.xmlIngesterService.ingest(Collections.singletonList(docCollection), this.principalIdToIngestAs);
                    if (failed != null && !failed.isEmpty()) {
                        throw new RuntimeException("Failed to ingest KEW files from - " + failed);
                    }
                    this.recordChecksums(newChecksums, previousChecksums, conn);
                    previousChecksums.putAll(newChecksums);
                    newChecksums.clear();
                    LOG.info("Successfully ingested " + docCollection.getXmlDocs().size() + " KEW files.");
                }
            }
            conn.commit();
        }
    }

    protected Map<String, Integer> readChecksums(Connection conn) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select file_name, checksum from krew_auto_ingested_checksum");){
            while (rs.next()) {
                result.put(rs.getString("file_name"), rs.getInt("checksum"));
            }
        }
        return result;
    }

    protected void recordChecksums(Map<String, Integer> newChecksums, Map<String, Integer> previousChecksums, Connection conn) throws SQLException {
        if (!newChecksums.isEmpty()) {
            try (PreparedStatement insertStmt = conn.prepareStatement("insert into krew_auto_ingested_checksum (file_name, checksum) values (?, ?)");
                 PreparedStatement updateStmt = conn.prepareStatement("update krew_auto_ingested_checksum set checksum = ? where file_name = ?");){
                for (Map.Entry<String, Integer> entry : newChecksums.entrySet()) {
                    if (previousChecksums.containsKey(entry.getKey())) {
                        updateStmt.setInt(1, entry.getValue());
                        updateStmt.setString(2, entry.getKey());
                        updateStmt.execute();
                        continue;
                    }
                    insertStmt.setString(1, entry.getKey());
                    insertStmt.setInt(2, entry.getValue());
                    insertStmt.execute();
                }
            }
        }
    }

    protected int calculateChecksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)crc32.getValue();
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public List<String> getPathsToScan() {
        return this.pathsToScan;
    }

    public void setPathsToScan(List<String> pathsToScan) {
        this.pathsToScan = pathsToScan;
    }

    public XmlIngesterService getXmlIngesterService() {
        return this.xmlIngesterService;
    }

    public void setXmlIngesterService(XmlIngesterService xmlIngesterService) {
        this.xmlIngesterService = xmlIngesterService;
    }

    public String getPrincipalIdToIngestAs() {
        return this.principalIdToIngestAs;
    }

    public void setPrincipalIdToIngestAs(String principalIdToIngestAs) {
        this.principalIdToIngestAs = principalIdToIngestAs;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getCfgPathsToScan() {
        return this.cfgPathsToScan;
    }

    public void setCfgPathsToScan(String cfgPathsToScan) {
        this.cfgPathsToScan = cfgPathsToScan;
    }

    protected static class AutoXmlDocCollection
    implements XmlDocCollection,
    AutoCloseable {
        private File file;
        private List<StreamXmlDoc> xmlDocs = new ArrayList<StreamXmlDoc>();

        public AutoXmlDocCollection(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public List<? extends XmlDoc> getXmlDocs() {
            return this.xmlDocs;
        }

        @Override
        public void close() throws IOException {
            for (StreamXmlDoc doc : this.xmlDocs) {
                doc.getStream().close();
            }
        }

        public void addXmlDoc(StreamXmlDoc xmlDoc) {
            this.xmlDocs.add(xmlDoc);
        }
    }

    protected static class NamedStreamXmlDoc
    extends StreamXmlDoc {
        private String name;

        public NamedStreamXmlDoc(String name, InputStream stream, XmlDocCollection collection) {
            super(stream, collection);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

