/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.budget.rates;

import com.codiform.moo.Moo;
import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.curry.Translate;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.kuali.coeus.common.api.budget.rates.InstituteRateDto;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="budgetRatesRestController")
public class BudgetRatesRestController
extends RestController {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="fiscalYearMonthService")
    private FiscalYearMonthService fiscalYearMonthService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    private List<String> dtoProperties = this.getDtoProperties();

    protected List<String> getDtoProperties() throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(InstituteRateDto.class).getPropertyDescriptors()).stream().map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/api/v1/institute-rates"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<InstituteRateDto> getInstituteRates(@RequestParam(value="rateClassTypeCode", required=false) String rateClassTypeCode) {
        List rates = rateClassTypeCode != null ? Translate.to(InstituteRateDto.class).fromEach(this.getBusinessObjectService().findMatching(InstituteRate.class, Collections.singletonMap("rateClass.rateClassTypeCode", rateClassTypeCode))) : Translate.to(InstituteRateDto.class).fromEach(this.getBusinessObjectService().findAll(InstituteRate.class));
        if (rates == null || rates.isEmpty()) {
            throw new ResourceNotFoundException("not found");
        }
        return rates;
    }

    @RequestMapping(value={"/api/v1/institute-rates"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateInstituteRates(@Valid @RequestBody List<InstituteRateDto> updatedRates) {
        if (!this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", InstituteRate.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
        RestAuditLogger auditLogger = this.restAuditLoggerFactory.getNewAuditLogger(InstituteRate.class, this.dtoProperties);
        Configuration mooConfig = new Configuration();
        mooConfig.setSourcePropertiesRequired(false);
        Moo moo = new Moo(mooConfig);
        Map currentRates = this.getBusinessObjectService().findAll(InstituteRate.class).stream().collect(Collectors.toMap(InstituteRate::getId, Function.identity()));
        updatedRates.forEach(updatedRate -> {
            InstituteRate currentRate = (InstituteRate)currentRates.get(updatedRate.getId());
            if (currentRate != null && updatedRate.getInstituteRate() != null) {
                if (!this.areNonUpdatableValuesEqual((InstituteRateDto)updatedRate, currentRate)) {
                    throw new UnprocessableEntityException("attempting to update non-updatable values");
                }
                auditLogger.addModifiedItem(currentRate, updatedRate);
                currentRate.setInstituteRate(updatedRate.getInstituteRate());
                currentRate.setStartDate(new Date(updatedRate.getStartDate().getTime()));
                this.getBusinessObjectService().save((PersistableBusinessObject)currentRate);
            } else if (updatedRate.getInstituteRate() == null) {
                auditLogger.addDeletedItem(currentRate);
                this.getBusinessObjectService().delete((Object)currentRate);
            } else {
                InstituteRate newRate = new InstituteRate();
                moo.update(updatedRate).to((Object)newRate);
                if (newRate.getStartDate() == null) {
                    newRate.setStartDate(new Date(this.getFiscalYearMonthService().getFiscalYearStartDate(Integer.parseInt(newRate.getFiscalYear())).getTimeInMillis()));
                }
                auditLogger.addNewItem(newRate);
                this.getBusinessObjectService().save((PersistableBusinessObject)newRate);
            }
        });
        auditLogger.saveAuditLog();
    }

    protected boolean areNonUpdatableValuesEqual(InstituteRateDto updatedRate, InstituteRate currentRate) {
        return new EqualsBuilder().append((Object)currentRate.getRateClassCode(), (Object)updatedRate.getRateClassCode()).append((Object)currentRate.getRateTypeCode(), (Object)updatedRate.getRateTypeCode()).append((Object)currentRate.getActivityTypeCode(), (Object)updatedRate.getActivityTypeCode()).append((Object)currentRate.getFiscalYear(), (Object)updatedRate.getFiscalYear()).append((Object)currentRate.getOnOffCampusFlag(), (Object)updatedRate.getOnOffCampusFlag()).append((Object)currentRate.getUnitNumber(), (Object)updatedRate.getUnitNumber()).isEquals();
    }

    @RequestMapping(value={"/instituteRates"}, method={RequestMethod.GET})
    public String displayInstituteRates() {
        return "instituteRates";
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }
}

