/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.cfda;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.cfda.CFDA;
import org.kuali.coeus.common.impl.cfda.CfdaService;
import org.kuali.coeus.common.impl.cfda.CfdaUpdateResults;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class CfdaServiceImpl
implements CfdaService {
    private static final Pattern CFDA_NUMBER_PATTERN = Pattern.compile("^[0-9]{2}\\.[0-9]{3}$");
    private static final Logger LOG = LogManager.getLogger(CfdaServiceImpl.class);
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;

    protected Map<String, CFDA> retrieveGovCodes() throws IOException {
        String govURL = this.getCfdaUrl();
        LOG.info("Getting government file from URL " + govURL + " for update");
        Resource csvFile = new DefaultResourceLoader(this.getClass().getClassLoader()).getResource(govURL);
        if (csvFile.exists() && csvFile.isReadable()) {
            LOG.info("reading input file");
            try (InputStreamReader screenReader = new InputStreamReader(csvFile.getInputStream());){
                List records = CSVFormat.DEFAULT.withSkipHeaderRecord(true).parse((Reader)screenReader).getRecords();
                Map map = records.stream().filter(record -> {
                    String number = record.get(1);
                    Matcher regExResult = CFDA_NUMBER_PATTERN.matcher(number);
                    return regExResult.matches();
                }).map(record -> {
                    CFDA cfda = new CFDA();
                    cfda.setCfdaNumber(record.get(1));
                    cfda.setCfdaProgramTitleName(this.trimProgramTitleName(record.get(0)));
                    cfda.setCfdaMaintenanceTypeId("AUTOMATIC");
                    return cfda;
                }).map(cfda -> CollectionUtils.entry(cfda.getCfdaNumber(), cfda)).collect(CollectionUtils.entriesToMap(TreeMap::new));
                return map;
            }
        }
        throw new IOException("The file could not be retrieved from " + govURL);
    }

    protected String getCfdaUrl() {
        return this.getParameterService().getParameterValueAsString("KC-GEN", "All", "CFDA_GOV_URL");
    }

    @Override
    public CfdaUpdateResults updateCfda() {
        Map<String, CFDA> govCfdaMap;
        try {
            govCfdaMap = this.retrieveGovCodes();
        }
        catch (IOException ioe) {
            CfdaUpdateResults updateResults = new CfdaUpdateResults();
            updateResults.setMessage("Problem encountered while retrieving cfda numbers, the database was not updated. " + ioe.getMessage());
            LOG.error(ioe.getMessage(), (Throwable)ioe);
            return updateResults;
        }
        CfdaUpdateResults updateResults = new CfdaUpdateResults();
        Map<String, CFDA> kcMap = this.getCfdaValuesInDatabase();
        updateResults.setNumberOfRecordsInKcDatabase(kcMap.size());
        updateResults.setNumberOfRecordsRetrievedFromWebSite(govCfdaMap.size());
        kcMap.forEach((cfdaNumber, kcCfda) -> {
            if (kcCfda.getCfdaMaintenanceTypeId().equalsIgnoreCase("MANUAL")) {
                updateResults.setNumberOfRecordsNotUpdatedBecauseManual(updateResults.getNumberOfRecordsNotUpdatedBecauseManual() + 1);
            } else if (kcCfda.getCfdaMaintenanceTypeId().equalsIgnoreCase("AUTOMATIC")) {
                CFDA govCfda = (CFDA)govCfdaMap.get(cfdaNumber);
                if (govCfda == null) {
                    if (kcCfda.getActive().booleanValue()) {
                        kcCfda.setActive(false);
                        this.businessObjectService.save((PersistableBusinessObject)kcCfda);
                        updateResults.setNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite(updateResults.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + 1);
                    } else {
                        updateResults.setNumberOfRecordsNotUpdatedForHistoricalPurposes(updateResults.getNumberOfRecordsNotUpdatedForHistoricalPurposes() + 1);
                    }
                } else {
                    if (kcCfda.getActive().booleanValue()) {
                        updateResults.setNumberOfRecordsUpdatedBecauseAutomatic(updateResults.getNumberOfRecordsUpdatedBecauseAutomatic() + 1);
                    } else {
                        kcCfda.setActive(true);
                        updateResults.setNumberOfRecordsReActivated(updateResults.getNumberOfRecordsReActivated() + 1);
                    }
                    kcCfda.setCfdaProgramTitleName(govCfda.getCfdaProgramTitleName());
                    this.businessObjectService.save((PersistableBusinessObject)kcCfda);
                }
            }
            govCfdaMap.remove(cfdaNumber);
        });
        this.addNew(govCfdaMap);
        updateResults.setNumberOfRecordsNewlyAddedFromWebSite(govCfdaMap.size());
        return updateResults;
    }

    protected Map<String, CFDA> getCfdaValuesInDatabase() {
        List cfdaValues = this.getBusinessObjectService().findAll(CFDA.class);
        return cfdaValues.stream().map(o -> CollectionUtils.entry(o.getCfdaNumber(), o)).collect(CollectionUtils.entriesToMap(TreeMap::new));
    }

    protected void addNew(Map<String, CFDA> newCfdas) {
        List cfdas = newCfdas.values().stream().peek(cfda -> {
            String cfdaProgramTitleName = this.trimProgramTitleName(cfda.getCfdaProgramTitleName());
            cfda.setCfdaProgramTitleName(SQLUtils.cleanString((String)cfdaProgramTitleName));
            cfda.setActive(true);
            cfda.setCfdaMaintenanceTypeId("AUTOMATIC");
        }).collect(Collectors.toList());
        this.getBusinessObjectService().save(cfdas);
    }

    protected String trimProgramTitleName(String programTitleName) {
        return StringUtils.substring((String)programTitleName, (int)0, (int)300);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }
}

