/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.compliance.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.compliance.core.ProtocolsFundedByDto;
import org.kuali.coeus.common.framework.compliance.core.ProtocolsFundedByService;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component(value="protocolsFundedByService")
public class ProtocolsFundedByServiceImpl
implements ProtocolsFundedByService {
    private static Logger LOG = LogManager.getLogger(ProtocolsFundedByServiceImpl.class);
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;

    @Override
    public List<ProtocolsFundedByDto> getProtocolsFundedByProject(String projectType, String projectId) {
        String url = this.getProtocolsFundedByUrl() + "?type=" + projectType + "&number=" + projectId;
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", Collections.singletonList("application/json"));
        headers.put("Authorization", Collections.singletonList(this.getAuthToken()));
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        return this.getProtocolsFundedByProject(url, (HttpEntity<String>)entity, HttpMethod.GET);
    }

    protected String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    protected String getProtocolsFundedByUrl() {
        return this.getConfigurationService().getPropertyValueAsString("protocols.funded.by.url");
    }

    protected List<ProtocolsFundedByDto> getProtocolsFundedByProject(String url, HttpEntity<String> entity, HttpMethod method) {
        List<ProtocolsFundedByDto> protocolsFundedBy = new ArrayList<ProtocolsFundedByDto>();
        try {
            ResponseEntity<List<ProtocolsFundedByDto>> response = this.getProtocolsFundedBy(url, entity, method);
            if (response.getStatusCode().is2xxSuccessful()) {
                protocolsFundedBy = (List)response.getBody();
            } else {
                LOG.error(url + " returned error " + response.getStatusCode() + " " + response.getBody());
            }
            LOG.debug(url + "returned status code " + response.getStatusCode());
        }
        catch (UnknownHttpStatusCodeException e) {
            LOG.warn(url + "returned status code " + e.getRawStatusCode(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error(url + " returned error " + e.getMessage(), (Throwable)e);
        }
        return protocolsFundedBy;
    }

    protected ResponseEntity<List<ProtocolsFundedByDto>> getProtocolsFundedBy(String url, HttpEntity<String> entity, HttpMethod method) {
        return this.restOperations.exchange(url, method, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ProtocolsFundedByDto>>(){}, new Object[0]);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

