/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.krms.KcKrmsCacheManager;
import org.kuali.coeus.common.framework.krms.KrmsEngineExecutionService;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ResultEvent;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="krmsRulesExecutionService")
public class KrmsRulesExecutionServiceImpl
implements KrmsRulesExecutionService {
    protected final Logger LOG = LogManager.getLogger(KrmsRulesExecutionServiceImpl.class);
    @Autowired
    @Qualifier(value="kcKrmsCacheManager")
    private KcKrmsCacheManager kcKrmsCacheManager;
    @Autowired
    @Qualifier(value="ruleRepositoryService")
    private RuleRepositoryService ruleRepositoryService;
    @Autowired
    @Qualifier(value="krmsEngineExecutionService")
    private KrmsEngineExecutionService krmsEngineExecutionService;

    @Override
    public List<String> processUnitValidations(String unitNumber, KrmsRulesContext rulesContext) {
        this.kcKrmsCacheManager.clearCache();
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        rulesContext.populateContextQualifiers(contextQualifiers);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        EngineResults results = this.krmsEngineExecutionService.execute(selectionCriteria, rulesContext, false);
        if (results != null) {
            String errors = (String)results.getAttribute("validations");
            if (errors != null) {
                String[] errorArray = StringUtils.split((String)errors, (String)",");
                return Arrays.asList(errorArray);
            }
        } else {
            this.LOG.warn("Results returned from KRMS Rules Engine was null.");
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, String>> processUnitKcValidations(String unitNumber, KrmsRulesContext rulesContext) {
        this.kcKrmsCacheManager.clearCache();
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        rulesContext.populateContextQualifiers(contextQualifiers);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        EngineResults results = this.krmsEngineExecutionService.execute(selectionCriteria, rulesContext, false);
        if (results != null) {
            List errors = (List)results.getAttribute("kcValidations");
            if (errors != null) {
                return errors;
            }
        } else {
            this.LOG.warn("Results returned from KRMS Rules Engine was null.");
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Boolean> runApplicableRules(List<String> ruleIds, KrmsRulesContext rulesContext, String agendaTypeId) {
        HashMap<String, Boolean> ruleResults = new HashMap<String, Boolean>();
        if (rulesContext != null) {
            String namespace = rulesContext.getClass().getAnnotation(ParameterConstants.NAMESPACE.class).namespace();
            HashMap<String, String> contextQualifiers = new HashMap<String, String>();
            rulesContext.populateContextQualifiers(contextQualifiers);
            HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
            rulesContext.populateAgendaQualifiers(agendaQualifiers);
            agendaQualifiers.put("typeId", agendaTypeId);
            contextQualifiers.put("namespaceCode", namespace);
            SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, agendaQualifiers);
            EngineResults results = this.krmsEngineExecutionService.execute(selectionCriteria, rulesContext, true);
            List ruleDefinitions = this.ruleRepositoryService.getRules(ruleIds);
            HashMap<String, RuleDefinition> ruleMap = new HashMap<String, RuleDefinition>();
            for (RuleDefinition rule : ruleDefinitions) {
                if (!rule.isActive()) continue;
                ruleMap.put(rule.getName(), rule);
            }
            if (results.getResultsOfType("Rule Evaluated") != null && results.getResultsOfType("Rule Evaluated").size() > 0) {
                for (ResultEvent resultEvent : results.getResultsOfType("Rule Evaluated")) {
                    String ruleName = ((BasicRule)resultEvent.getSource()).getName();
                    if (!ruleMap.containsKey(ruleName)) continue;
                    ruleResults.put(((RuleDefinition)ruleMap.get(ruleName)).getId(), resultEvent.getResult());
                }
            }
        }
        return ruleResults;
    }

    public KcKrmsCacheManager getKcKrmsCacheManager() {
        return this.kcKrmsCacheManager;
    }

    public void setKcKrmsCacheManager(KcKrmsCacheManager kcKrmsCacheManager) {
        this.kcKrmsCacheManager = kcKrmsCacheManager;
    }

    public KrmsEngineExecutionService getKrmsEngineExecutionService() {
        return this.krmsEngineExecutionService;
    }

    public void setKrmsEngineExecutionService(KrmsEngineExecutionService krmsEngineExecutionService) {
        this.krmsEngineExecutionService = krmsEngineExecutionService;
    }

    public RuleRepositoryService getRuleRepositoryService() {
        return this.ruleRepositoryService;
    }

    public void setRuleRepositoryService(RuleRepositoryService ruleRepositoryService) {
        this.ruleRepositoryService = ruleRepositoryService;
    }
}

