/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.attr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataHelperBase;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.common.framework.person.attr.PersonCustomData;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;

public class KcPersonExtendedAttributesMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterRetrieve() {
        this.loadCustomData();
    }

    private void loadCustomData() {
        this.getCustomDataHelper().prepareCustomData();
    }

    @Override
    public void prepareForSave() {
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getDataObject();
        if (!this.isValidPrincipalId(kcPersonExtendedAttributes.getPersonId())) {
            this.reportInvalidPrincipalId(kcPersonExtendedAttributes);
        }
        if (!this.isValidCitizenshipTypeCode(kcPersonExtendedAttributes)) {
            this.reportInvalidCitizenshipTypeCode(kcPersonExtendedAttributes);
        }
        super.prepareForSave();
    }

    public void saveDataObject() {
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getDataObject();
        if (kcPersonExtendedAttributes.getCitizenshipType() == null && kcPersonExtendedAttributes.getCitizenshipTypeCode() != null) {
            kcPersonExtendedAttributes.refreshReferenceObject("citizenshipType");
        }
        super.saveDataObject();
        this.getCustomDataHelper().setCustomAttributeContent(this.getDocumentNumber(), "PersonCustomDataAttribute");
    }

    private void reportInvalidPrincipalId(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.personId", "error.person.principalId.notExist", "Principal ID does not exist.");
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        PersonService personService = KimApiServiceLocator.getPersonService();
        if (StringUtils.isEmpty((CharSequence)principalId)) {
            valid = false;
        } else if (personService.getPerson(principalId) == null) {
            valid = false;
        }
        return valid;
    }

    private void reportInvalidCitizenshipTypeCode(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.citizenshipTypeCode", "error.missingcitizenship", "Please select a citizenship type.");
    }

    private boolean isValidCitizenshipTypeCode(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        Integer citizenshipType = kcPersonExtendedAttributes.getCitizenshipTypeCode();
        return citizenshipType != null;
    }

    @Override
    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            block1: for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.isNotEmpty((CharSequence)field.getPropertyName()) || !field.getPropertyName().equalsIgnoreCase("personId")) continue;
                    field.setFieldConversions("principalId:personId");
                    field.setQuickFinderClassNameImpl(Person.class.getName());
                    field.setFieldDirectInquiryEnabled(true);
                    field.setInquiryParameters("personId:principalId");
                    continue block1;
                }
            }
        }
        return this.filterPersonCustomDataSection(sections);
    }

    private List<Section> filterPersonCustomDataSection(List<Section> sections) {
        ArrayList<Section> filteredSections = new ArrayList<Section>();
        for (Section section : sections) {
            if (StringUtils.equals((CharSequence)section.getSectionTitle(), (CharSequence)"Edit Person Custom Data")) continue;
            filteredSections.add(section);
        }
        return filteredSections;
    }

    public boolean documentNotRouted() {
        WorkflowDocumentService documentService = KewApiServiceLocator.getWorkflowDocumentService();
        Document doc = documentService.getDocument(this.getDocumentNumber());
        return doc.getStatus() == DocumentStatus.SAVED || doc.getStatus() == DocumentStatus.INITIATED;
    }

    public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
        return this.getCustomDataHelper().getCustomAttributeDocuments();
    }

    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    protected void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    protected static class CustomDataHelper
    extends CustomDataHelperBase<PersonCustomData>
    implements Serializable {
        private static final long serialVersionUID = -6829522940099878931L;
        private KcPersonExtendedAttributesMaintainableImpl maintainableImpl;
        private Map<String, CustomAttributeDocument> customAttributeDocuments;

        public CustomDataHelper(KcPersonExtendedAttributesMaintainableImpl maintainableImpl) {
            this.maintainableImpl = maintainableImpl;
            this.customAttributeDocuments = this.getCustomAttributeService().getDefaultCustomAttributeDocuments("PERS", maintainableImpl.getDataObject() != null ? ((KcPersonExtendedAttributes)maintainableImpl.getDataObject()).getPersonCustomDataList() : new ArrayList());
        }

        @Override
        protected PersonCustomData getNewCustomData() {
            return new PersonCustomData();
        }

        @Override
        public List<PersonCustomData> getCustomDataList() {
            if (this.maintainableImpl.getDataObject() != null) {
                return ((KcPersonExtendedAttributes)this.maintainableImpl.getDataObject()).getPersonCustomDataList();
            }
            return new ArrayList<PersonCustomData>();
        }

        @Override
        public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
            return this.customAttributeDocuments;
        }

        public void setCustomAttributeDocuments(Map<String, CustomAttributeDocument> customAttributeDocuments) {
            this.customAttributeDocuments = customAttributeDocuments;
        }

        @Override
        public boolean shouldUpdateCustomDataDocuments() {
            return this.maintainableImpl.documentNotRouted();
        }
    }
}

