/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.signature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.person.signature.PersonSignature;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class ValidPersonSignatureMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String PERSON_SIGNATURE_FILE_INVALID_ERROR_KEY = "error.invalid.personSignature.invalid.fileName";
    private static final String PERSON_SIGNATURE_ID_INVALID_ERROR_KEY = "error.invalid.personSignature.invalid.personSignatureId";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean isPersonSignatureValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        result &= this.isSignatureValid(document);
        return result &= this.isNotDuplicateSignatureId(document);
    }

    private boolean isSignatureValid(MaintenanceDocument document) {
        boolean isSignatureValid = true;
        PersonSignature personSignature = (PersonSignature)document.getNewMaintainableObject().getDataObject();
        if (personSignature.getTemplateFile() == null && personSignature.getFileName() == null) {
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.templateFile", PERSON_SIGNATURE_FILE_INVALID_ERROR_KEY, new String[0]);
            isSignatureValid = false;
        }
        return isSignatureValid;
    }

    private boolean isNotDuplicateSignatureId(MaintenanceDocument document) {
        boolean isValid = true;
        PersonSignature personSignature = (PersonSignature)document.getNewMaintainableObject().getDataObject();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("personId", personSignature.getPersonId());
        if (document.isNew()) {
            isValid = this.getBoService().countMatching(PersonSignature.class, fieldValues) == 0;
        } else if (document.isEdit()) {
            isValid = this.isRecordUpdateValid(fieldValues, personSignature);
        }
        if (!isValid) {
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.personId", PERSON_SIGNATURE_ID_INVALID_ERROR_KEY, new String[0]);
        }
        return isValid;
    }

    private boolean isRecordUpdateValid(Map<String, Object> fieldValues, PersonSignature mdocPersonSignature) {
        boolean isRecordUpdateValid = false;
        List authorizedSignatures = this.getBoService().findMatching(PersonSignature.class, fieldValues);
        if (authorizedSignatures.isEmpty()) {
            isRecordUpdateValid = true;
        } else {
            PersonSignature dbPersonSignature = (PersonSignature)authorizedSignatures.get(0);
            Long dbPersonSignatureId = dbPersonSignature.getPersonSignatureId();
            if (mdocPersonSignature.getPersonSignatureId().equals(dbPersonSignatureId)) {
                isRecordUpdateValid = true;
            }
        }
        return isRecordUpdateValid;
    }
}

