/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.ynq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.framework.ynq.Ynq;
import org.kuali.coeus.common.framework.ynq.YnqExplanationType;
import org.kuali.coeus.common.framework.ynq.YnqGroupName;
import org.kuali.coeus.common.framework.ynq.YnqService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonYnq;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="ynqService")
public class YnqServiceImpl
implements YnqService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<YnqExplanationType> getYnqExplanationTypes() {
        List allTypes = new ArrayList();
        allTypes = this.businessObjectService.findAll(YnqExplanationType.class);
        ArrayList<YnqExplanationType> ynqExplanationTypes = new ArrayList<YnqExplanationType>();
        for (YnqExplanationType type : allTypes) {
            ynqExplanationTypes.add(type);
        }
        return ynqExplanationTypes;
    }

    @Override
    public List<Ynq> getYnq(String questionType) {
        HashMap<String, String> questionTypeMap = new HashMap<String, String>();
        questionTypeMap.put("questionType", questionType);
        questionTypeMap.put("status", "A");
        List allTypes = this.getBusinessObjectService().findMatchingOrderBy(Ynq.class, questionTypeMap, "sortId", true);
        ArrayList<Ynq> ynqs = new ArrayList<Ynq>();
        ynqs.addAll(allTypes);
        Collections.sort(ynqs, new GroupNameComparator());
        return ynqs;
    }

    @Override
    public ProposalPerson getPersonYNQ(ProposalPerson proposalPerson, ProposalDevelopmentDocument document) {
        boolean certificationRequired = false;
        certificationRequired = proposalPerson.getRole() != null && proposalPerson.getRole().getCertificationRequired() != false ? true : proposalPerson.getOptInCertificationStatus() != false;
        if (certificationRequired) {
            String questionType = "I";
            ArrayList<Ynq> ynqs = new ArrayList();
            if (!this.isDocumentSubmitted(document)) {
                ynqs = this.getYnq(questionType);
            }
            if (proposalPerson.getProposalPersonYnqs().isEmpty()) {
                this.addCertificationQuestions(ynqs, proposalPerson);
            } else {
                HashSet<String> proposalPersonQuestionIds = new HashSet<String>();
                for (ProposalPersonYnq proposalPersonYnq : proposalPerson.getProposalPersonYnqs()) {
                    proposalPersonQuestionIds.add(proposalPersonYnq.getQuestionId());
                }
                ArrayList<Ynq> newYnqs = new ArrayList<Ynq>();
                for (Ynq ynq : ynqs) {
                    if (proposalPersonQuestionIds.contains(ynq.getQuestionId())) continue;
                    newYnqs.add(ynq);
                }
                this.addCertificationQuestions(newYnqs, proposalPerson);
            }
        }
        return proposalPerson;
    }

    protected void addCertificationQuestions(List<Ynq> ynqs, ProposalPerson proposalPerson) {
        for (Ynq type : ynqs) {
            ProposalPersonYnq proposalPersonYnq = new ProposalPersonYnq();
            proposalPersonYnq.setYnq(type);
            proposalPersonYnq.setProposalPerson(proposalPerson);
            proposalPerson.getProposalPersonYnqs().add(proposalPersonYnq);
        }
    }

    protected void setRequiredFields(Ynq type, ProposalYnq proposalYnq) {
        if (type.getDateRequiredFor() == null) {
            proposalYnq.setReviewDateRequired(false);
        } else {
            proposalYnq.setReviewDateRequiredDescription("Date required: if answer = ".concat(this.getYnqRequiredLabel(type.getDateRequiredFor())));
        }
        if (type.getExplanationRequiredFor() == null) {
            proposalYnq.setExplanationRequried(false);
        } else {
            proposalYnq.setExplanationRequiredDescription("Explanation required: if answer = ".concat(this.getYnqRequiredLabel(type.getExplanationRequiredFor())));
        }
    }

    protected void getGroupNames(List<ProposalYnq> proposalYnqs, List<YnqGroupName> ynqGroupNames) {
        for (ProposalYnq type : proposalYnqs) {
            this.setRequiredFields(type.getYnq(), type);
            this.setGroupName(type.getYnq().getGroupName(), ynqGroupNames);
        }
    }

    protected void getProposalQuestions(List<ProposalYnq> proposalYnqs, List<YnqGroupName> ynqGroupNames, List<Ynq> ynqs) {
        for (Ynq type : ynqs) {
            ProposalYnq proposalYnq = new ProposalYnq();
            proposalYnq.setQuestionId(type.getQuestionId());
            proposalYnq.setYnq(type);
            this.setRequiredFields(type, proposalYnq);
            proposalYnq.setSortId(type.getSortId());
            proposalYnqs.add(proposalYnq);
            this.setGroupName(type.getGroupName(), ynqGroupNames);
        }
    }

    protected void setGroupName(String groupName, List<YnqGroupName> ynqGroupNames) {
        if (!this.isDuplicateGroupName(groupName, ynqGroupNames)) {
            YnqGroupName ynqGroupName = new YnqGroupName();
            ynqGroupName.setGroupName(groupName);
            ynqGroupNames.add(ynqGroupName);
        }
    }

    @Override
    public void populateProposalQuestions(List<ProposalYnq> proposalYnqs, List<YnqGroupName> ynqGroupNames, ProposalDevelopmentDocument document) {
        String questionType = "P";
        ArrayList<Ynq> ynqs = new ArrayList();
        if (!this.isDocumentSubmitted(document)) {
            ynqs = this.getYnq(questionType);
        }
        if (proposalYnqs.isEmpty()) {
            this.getProposalQuestions(proposalYnqs, ynqGroupNames, ynqs);
        } else {
            if (ynqGroupNames.isEmpty()) {
                this.getGroupNames(proposalYnqs, ynqGroupNames);
            }
            if (!ynqs.isEmpty()) {
                this.addNewProposalQuestions(proposalYnqs, ynqs, ynqGroupNames);
            }
        }
    }

    protected void addNewProposalQuestions(List<ProposalYnq> proposalYnqs, List<Ynq> ynqs, List<YnqGroupName> ynqGroupNames) {
        ArrayList<Ynq> newYnqs = new ArrayList<Ynq>();
        HashSet<String> proposalQuestionIds = new HashSet<String>();
        for (ProposalYnq proposalYnq : proposalYnqs) {
            proposalQuestionIds.add(proposalYnq.getQuestionId());
        }
        for (Ynq ynq : ynqs) {
            if (proposalQuestionIds.contains(ynq.getQuestionId())) continue;
            newYnqs.add(ynq);
        }
        this.getProposalQuestions(proposalYnqs, ynqGroupNames, newYnqs);
    }

    protected boolean isDocumentSubmitted(ProposalDevelopmentDocument document) {
        boolean submitted = false;
        WorkflowDocument wfd = document.getDocumentHeader().getWorkflowDocument();
        document.getDocumentHeader().getWorkflowDocument().isInitiated();
        if (!(wfd.isInitiated() || wfd.isSaved() && (document.getDevelopmentProposal().getS2sAppSubmission() == null || document.getDevelopmentProposal().getS2sAppSubmission().isEmpty()))) {
            submitted = true;
        }
        return submitted;
    }

    protected boolean isDuplicateGroupName(String groupName, List<YnqGroupName> ynqGroupNames) {
        boolean duplicateGroupName = false;
        for (YnqGroupName type : ynqGroupNames) {
            if (!type.getGroupName().equalsIgnoreCase(groupName)) continue;
            duplicateGroupName = true;
            break;
        }
        return duplicateGroupName;
    }

    protected String getYnqRequiredLabel(String ynqCode) {
        String retValue = null;
        for (YnqConstant ynqConstants : YnqConstant.values()) {
            if (!ynqConstants.code().equalsIgnoreCase(ynqCode)) continue;
            retValue = ynqConstants.description();
            break;
        }
        return retValue;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected class GroupNameComparator
    implements Comparator<Ynq> {
        protected GroupNameComparator() {
        }

        @Override
        public int compare(Ynq o1, Ynq o2) {
            int comparator = o1.getSortId() != null && o2.getSortId() != null ? o1.getSortId().compareTo(o2.getSortId()) : o1.getQuestionId().compareTo(o2.getQuestionId());
            return comparator;
        }
    }
}

