/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.questionnaire.impl.QuestionnaireDao;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krms.api.engine.TermResolver;

public class QuestionResolver
implements TermResolver<Object> {
    public static final String QUESTIONNAIRE_SEQ_ID = "Questionnaire ID";
    public static final String QUESTION_SEQ_ID = "Question ID";
    private String outputName;
    private Set<String> prereqs;
    private Set<String> params;
    private QuestionnaireDao questionnaireDao;

    public QuestionResolver(String outputName, Set<String> params) {
        this.outputName = outputName;
        this.prereqs = new HashSet<String>();
        this.prereqs.add("moduleCode");
        this.prereqs.add("moduleItemKey");
        this.prereqs.add("moduleSubItemKey");
        this.params = params == null ? Collections.emptySet() : params;
    }

    public int getCost() {
        return 1;
    }

    public String getOutput() {
        return this.outputName;
    }

    public Set<String> getPrerequisites() {
        return this.prereqs;
    }

    public Set<String> getParameterNames() {
        return this.params;
    }

    public String resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
        String questionnaireId = parameters.get(QUESTIONNAIRE_SEQ_ID);
        String questionId = parameters.get(QUESTION_SEQ_ID);
        String moduleCode = (String)resolvedPrereqs.get("moduleCode");
        String moduleItemKey = (String)resolvedPrereqs.get("moduleItemKey");
        String moduleSubItemKey = resolvedPrereqs.get("moduleSubItemKey").toString();
        return this.getQuestionnaireDao().getQuestionnaireAnswer(moduleCode, moduleItemKey, moduleSubItemKey, questionnaireId, questionId);
    }

    public QuestionnaireDao getQuestionnaireDao() {
        if (this.questionnaireDao == null) {
            this.questionnaireDao = KcServiceLocator.getService(QuestionnaireDao.class);
        }
        return this.questionnaireDao;
    }
}

