/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.SpecialReviewDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class ElasticsearchDevelopmentProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)doc;
        DevelopmentProposal devProposal = document.getDevelopmentProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, document);
        if (devProposal.isInHierarchy()) {
            if (devProposal.isChild()) {
                List proposalDevelopmentDocuments = this.getDataObjectService().findMatching(ProposalDevelopmentDocument.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("developmentProposal.proposalNumber", devProposal.getHierarchyParentProposalNumber())).build()).getResults();
                if (proposalDevelopmentDocuments.size() > 0) {
                    ProposalDevelopmentDocument parentDocument = (ProposalDevelopmentDocument)proposalDevelopmentDocuments.get(0);
                    if (!parentDocument.getDocumentHeader().hasWorkflowDocument()) {
                        parentDocument.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)"kr", (String)parentDocument.getDocumentNumber()));
                    }
                    esDoc.setHierarchyRouteStatus(parentDocument.getDocumentHeader().getWorkflowDocument().getStatus().getLabel());
                    esDoc.setParentProposalNumber(devProposal.getHierarchyParentProposalNumber());
                }
            } else {
                esDoc.setHierarchyRouteStatus(esDoc.getRouteStatus());
                esDoc.setParentProposalNumber(devProposal.getProposalNumber());
            }
            esDoc.setHierarchyChild(devProposal.isChild());
        } else {
            esDoc.setHierarchyRouteStatus(esDoc.getRouteStatus());
            esDoc.setHierarchyChild(false);
        }
        esDoc.setPrimaryKey(devProposal.getProposalNumber());
        esDoc.setNamespace(document.getNamespace());
        esDoc.setSequenceNumber(0);
        esDoc.setSequenceStatus(VersionStatus.ACTIVE.name());
        esDoc.setTypeCode(devProposal.getProposalTypeCode());
        esDoc.setTypeDescription(devProposal.getProposalType().getDescription());
        esDoc.setStatusCode(devProposal.getProposalStateTypeCode());
        esDoc.setStatusDescription(devProposal.getProposalState().getDescription());
        esDoc.setActivityTypes(Set.of(devProposal.getActivityType().getDescription()));
        esDoc.setStartDate(DateUtils.toUtc(devProposal.getRequestedStartDateInitial()));
        esDoc.setEndDate(DateUtils.toUtc(devProposal.getRequestedEndDateInitial()));
        esDoc.setAssignedApproverId(devProposal.getApproverId());
        Optional.ofNullable(devProposal.getApproverId()).map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).map(Person::getName).ifPresent(esDoc::setAssignedApproverName);
        devProposal.getActiveBudget().ifPresent(budget -> esDoc.setTotalBudgetAmount(budget.getTotalCost().doubleValue()));
        esDoc.addCfdaNumber(devProposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.toSet()));
        esDoc.setSpecialReviews(devProposal.getPropSpecialReviews().stream().map(specialReview -> new SpecialReviewDocument(specialReview.getSpecialReviewType().getDescription(), this.getSpecialReviewApprovalType((SpecialReview)specialReview))).collect(Collectors.toList()));
        this.setCommonFields(esDoc, devProposal);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        esDoc.addProposalNumber(devProposal.getProposalNumber());
        esDoc.addDevProposalNumber(devProposal.getProposalNumber());
        esDoc.setTitle(devProposal.getTitle());
        esDoc.setSponsorCode(devProposal.getSponsorCode());
        esDoc.setSponsorName(devProposal.getSponsorName());
        if (devProposal.getPrimeSponsor() != null) {
            esDoc.setPrimeSponsorCode(devProposal.getPrimeSponsorCode());
            esDoc.setPrimeSponsorName(devProposal.getPrimeSponsor().getSponsorName());
        }
        esDoc.setLeadUnitNumber(devProposal.getOwnedByUnitNumber());
        esDoc.setLeadUnitName(devProposal.getOwnedByUnitName());
        this.setDevProposalPersonFields(esDoc, devProposal);
        this.setPdSpecificFields(esDoc, devProposal);
    }

    protected void setDevProposalPersonFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        ProposalPerson proposalPerson = devProposal.getPrincipalInvestigator();
        if (proposalPerson != null) {
            esDoc.setPrincipalInvestigatorId(proposalPerson.getPersonId());
            esDoc.setPrincipalInvestigatorName(proposalPerson.getLastName() + ", " + proposalPerson.getFirstName());
        }
        super.setPersonFields(esDoc, devProposal.getProposalPersons());
    }

    @Override
    public String getNamespace() {
        return "KC-PD";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("View Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof ProposalDevelopmentDocument;
    }
}

