/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.core.LookupableDevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="lookupableDevelopmentProposalLookupableHelperService")
@Scope(value="prototype")
public class LookupableDevelopmentProposalLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final List<String> VALID_LOOKUP_FIELDS = Arrays.asList("proposalNumber", "title", "sponsorCode", "ownedByUnitNumber", "ownedByUnitName", "proposalTypeCode");
    private static final Logger LOG = LogManager.getLogger(LookupableDevelopmentProposalLookupableHelperServiceImpl.class);
    @Autowired
    @Qualifier(value="proposalPersonService")
    private ProposalPersonService proposalPersonService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<String> matchingProposals = new ArrayList<String>();
        HashMap<String, Object> proposalFields = new HashMap<String, Object>();
        boolean doLookup = true;
        for (String key : fieldValues.keySet()) {
            String value = fieldValues.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            if (StringUtils.equals((CharSequence)key, (CharSequence)"investigator")) {
                List<ProposalPerson> proposalPersons = this.proposalPersonService.getProposalPersonsByPartialName(value);
                for (ProposalPerson potentialPerson : proposalPersons) {
                    matchingProposals.add(potentialPerson.getDevelopmentProposal().getProposalNumber());
                }
                if (matchingProposals.size() > 0) {
                    proposalFields.put("proposalNumber", matchingProposals);
                    continue;
                }
                doLookup = false;
                continue;
            }
            if (!VALID_LOOKUP_FIELDS.contains(key)) continue;
            proposalFields.put(key, fieldValues.get(key));
        }
        if (!doLookup) {
            return new ArrayList();
        }
        List unboundedResults = this.businessObjectService.findMatching(LookupableDevelopmentProposal.class, proposalFields);
        List<LookupableDevelopmentProposal> filteredResults = this.filterForPermissionsAndDates(fieldValues, unboundedResults);
        return filteredResults;
    }

    private List<LookupableDevelopmentProposal> filterForPermissionsAndDates(Map<String, String> fieldValues, List<LookupableDevelopmentProposal> unboundedResults) {
        String deadlineDate = fieldValues.get("deadlineDate");
        Date lowerLimit = null;
        Date upperLimit = null;
        boolean checkDates = true;
        if (StringUtils.isEmpty((CharSequence)deadlineDate)) {
            checkDates = false;
        } else {
            try {
                String temp;
                if (deadlineDate.indexOf("..") > -1) {
                    temp = deadlineDate.substring(0, 10);
                    lowerLimit = new Date(new java.util.Date(temp).getTime());
                    temp = deadlineDate.substring(12);
                    upperLimit = new Date(new java.util.Date(temp).getTime());
                } else if (deadlineDate.indexOf("<=") > -1) {
                    temp = deadlineDate.substring(2);
                    upperLimit = new Date(new java.util.Date(temp).getTime());
                } else {
                    temp = deadlineDate.substring(2);
                    lowerLimit = new Date(new java.util.Date(temp).getTime());
                }
            }
            catch (Exception e) {
                LOG.warn("Error formatting dates. Original string = [" + deadlineDate + "]");
                lowerLimit = null;
                upperLimit = null;
            }
        }
        ProposalDevelopmentDocumentAuthorizer authorizer = new ProposalDevelopmentDocumentAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        ArrayList<LookupableDevelopmentProposal> results = new ArrayList<LookupableDevelopmentProposal>();
        for (LookupableDevelopmentProposal potentialProposal : unboundedResults) {
            if (checkDates && !this.dateInRange(potentialProposal.getDeadlineDate(), lowerLimit, upperLimit)) continue;
            String documentNumber = potentialProposal.getDocumentNumber();
            try {
                ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
                if (!authorizer.canOpen(document, user)) continue;
                results.add(potentialProposal);
            }
            catch (WorkflowException e) {
                LOG.warn("Cannot find Document with header id " + documentNumber);
            }
        }
        return results;
    }

    private boolean dateInRange(Date checkDate, Date lowerLimit, Date upperLimit) {
        if (checkDate == null) {
            return true;
        }
        if (lowerLimit != null && checkDate.before(lowerLimit)) {
            return false;
        }
        return upperLimit == null || !checkDate.after(upperLimit);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }
}

