/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.person.PersonTypeConstants;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.view.wizard.framework.WizardControllerService;
import org.kuali.coeus.common.view.wizard.framework.WizardResultsDto;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.coeus.propdev.impl.person.AddKeyPersonEvent;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonQuestionnaireHelper;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentPersonnelController
extends ProposalDevelopmentControllerBase {
    public static final String PROPOSAL_PERSONS_PATH = "document.developmentProposal.proposalPersons";
    public static final String CERTIFICATION_UPDATE_FEATURE_FLAG = "CERTIFICATION_UPDATE_FEATURE_FLAG";
    public static final String CERTIFICATION_ACTION_TYPE_CODE = "104";
    public static final String CERTIFY_NOTIFICATION = "Certify Notification";
    public static final String PERSON_ROLE = "personRole";
    public static final String CERTIFICATION_ACTION_TYPE_COI = "107";
    private static final String INFO_PROPOSAL_CERTIFIED = "info.proposal.certified";
    private static final String WARN_PROPOSAL_CERTIFIED = "warn.proposal.not.certified";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="wizardControllerService")
    private WizardControllerService wizardControllerService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="collectionControllerService")
    private CollectionControllerService collectionControllerService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropDev-PersonnelPage"})
    public ModelAndView navigateToPersonnel(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        for (ProposalPerson person : form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            person.setDevelopmentProposal(form.getProposalDevelopmentDocument().getDevelopmentProposal());
            person.getQuestionnaireHelper().populateAnswers();
        }
        this.setPersonnelLockWarnings(form);
        return super.navigate(form, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=checkForNewerVersionOfCertification"})
    public ModelAndView checkForNewerVersionOfCertification(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        Boolean certificationUpdateFeatureFlag = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", CERTIFICATION_UPDATE_FEATURE_FLAG);
        ProposalDevelopmentDocumentAuthorizer proposalDevelopmentDocumentAuthorizer = new ProposalDevelopmentDocumentAuthorizer();
        if (certificationUpdateFeatureFlag.booleanValue() && this.isNewerVersionPublished(form) && proposalDevelopmentDocumentAuthorizer.isProposalStateEditableForCertification(form.getDevelopmentProposal())) {
            return this.getModelAndViewService().showDialog("PropDev-PersonnelPage-UpdateCertification-Dialog", false, (UifFormBase)form);
        }
        return null;
    }

    protected boolean isNewerVersionPublished(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        for (ProposalPerson person : form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            if (!CollectionUtils.isNotEmpty(person.getQuestionnaireHelper().getAnswerHeaders()) || !person.getQuestionnaireHelper().getAnswerHeaders().get(0).isNewerVersionPublished()) continue;
            return true;
        }
        return false;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateCertification"})
    public ModelAndView updateCertification(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        for (ProposalPerson person : form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            int index = 0;
            for (AnswerHeader answerHeader : person.getQuestionnaireHelper().getAnswerHeaders()) {
                answerHeader.setUpdateOption(form.getUpdateAnswerHeader().getUpdateOption());
                person.getQuestionnaireHelper().updateQuestionnaireAnswer(index);
                ++index;
            }
        }
        form.setUpdateAnswerHeader(new AnswerHeader());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareAddPersonDialog"})
    public ModelAndView prepareAddPersonDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.getAddKeyPersonHelper().setLineType(PersonTypeConstants.EMPLOYEE.getCode());
        form.setFocusId(null);
        return this.getModelAndViewService().showDialog("PropDev-PersonnelPage-Wizard", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigateToPersonError"})
    public ModelAndView navigateToPersonError(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        form.setAjaxReturnType("update-page");
        return this.navigateToPersonnel(form, result, request, response);
    }

    @Override
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=save", "pageId=PropDev-PersonnelPage"})
    public ModelAndView save(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=performPersonnelSearch"})
    public ModelAndView performPersonnelSearch(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        form.getAddKeyPersonHelper().getResults().clear();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object object : this.getWizardControllerService().performWizardSearch(form.getAddKeyPersonHelper().getLookupFieldValues(), form.getAddKeyPersonHelper().getLineType())) {
            WizardResultsDto wizardResult = (WizardResultsDto)object;
            String personId = wizardResult.getKcPerson() != null ? wizardResult.getKcPerson().getPersonId() : wizardResult.getRolodex().getRolodexId().toString();
            if (this.personAlreadyExists(personId, form.getDevelopmentProposal().getProposalPersons())) continue;
            results.add(object);
        }
        form.getAddKeyPersonHelper().setResults(results);
        form.setFocusId(null);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addPerson"})
    public ModelAndView addPerson(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalPerson newProposalPerson = new ProposalPerson();
        for (Object object : form.getAddKeyPersonHelper().getResults()) {
            WizardResultsDto wizardResult = (WizardResultsDto)object;
            if (!wizardResult.isSelected()) continue;
            if (wizardResult.getKcPerson() != null) {
                newProposalPerson.setPersonId(wizardResult.getKcPerson().getPersonId());
                newProposalPerson.setFullName(wizardResult.getKcPerson().getFullName());
                newProposalPerson.setUserName(wizardResult.getKcPerson().getUserName());
                break;
            }
            if (wizardResult.getRolodex() == null) break;
            newProposalPerson.setRolodexId(wizardResult.getRolodex().getRolodexId());
            newProposalPerson.setFullName(wizardResult.getRolodex().getFullName());
            break;
        }
        newProposalPerson.setProposalPersonRoleId((String)form.getAddKeyPersonHelper().getParameter(PERSON_ROLE));
        if (form.getAddKeyPersonHelper().getParameterMap().containsKey("keyPersonProjectRole")) {
            newProposalPerson.setProjectRole((String)form.getAddKeyPersonHelper().getParameter("keyPersonProjectRole"));
        }
        if (!this.getKualiRuleService().applyRules((DocumentEvent)new AddKeyPersonEvent(form.getProposalDevelopmentDocument(), newProposalPerson))) {
            return this.reportKeyPersonError(form);
        }
        this.getKeyPersonnelService().addProposalPerson(newProposalPerson, form.getProposalDevelopmentDocument());
        form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons().sort(ProposalPersonRoleComparator.INSTANCE);
        form.getAddKeyPersonHelper().reset();
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        super.save(form);
        return this.getKcCommonControllerService().closeDialog("PropDev-PersonnelPage-Wizard", (UifFormBase)form);
    }

    protected ModelAndView reportKeyPersonError(ProposalDevelopmentDocumentForm form) {
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setUpdateComponentId("PropDev-PersonnelPage-Wizard");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropDev-CreditAllocationPage"})
    public ModelAndView navigateToCreditAllocation(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mv = super.navigate(form, result, request, response);
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateCreditSplits(form);
        return mv;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteLine", "pageId=PropDev-PersonnelPage"})
    public ModelAndView deletePerson(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedCollectionPath]") String selectedCollectionPath, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) {
        if (selectedCollectionPath.equals(PROPOSAL_PERSONS_PATH)) {
            Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
            Object deleteLine = ((List)collection).get(Integer.parseInt(selectedLine));
            this.deleteProposalPersonBios(form.getDevelopmentProposal(), (ProposalPerson)deleteLine);
            this.deleteCertDetails((ProposalPerson)deleteLine);
        }
        return this.getCollectionControllerService().deleteLine((UifFormBase)form);
    }

    private void deleteCertDetails(ProposalPerson person) {
        if (person.getCertificationDetails() != null) {
            this.getDataObjectService().delete((Object)person.getCertificationDetails());
        }
        if (person.getQuestionnaireHelper() != null && person.getQuestionnaireHelper().getAnswerHeaders() != null) {
            person.getQuestionnaireHelper().getAnswerHeaders().forEach(answerHeader -> this.getBusinessObjectService().delete(answerHeader));
        }
    }

    private void deleteProposalPersonBios(DevelopmentProposal proposal, ProposalPerson deleteLine) {
        ArrayList<ProposalPersonBiography> tmpBios = new ArrayList<ProposalPersonBiography>();
        String personIdOfDeletedLine = deleteLine.getPersonId();
        for (ProposalPersonBiography biography : proposal.getPropPersonBios()) {
            if (personIdOfDeletedLine == null) {
                Integer rolodexId = deleteLine.getRolodexId();
                if (rolodexId != null && rolodexId.equals(biography.getRolodexId())) continue;
                tmpBios.add(biography);
                continue;
            }
            if (personIdOfDeletedLine.equals(biography.getPersonId())) continue;
            tmpBios.add(biography);
        }
        proposal.setPropPersonBios(tmpBios);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearAnswers"})
    public ModelAndView clearAnswers(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        String personNumber = pdForm.getActionParamaterValue("personNumber");
        for (ProposalPerson person : pdForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            if (!StringUtils.equals((CharSequence)personNumber, (CharSequence)person.getProposalPersonNumber().toString())) continue;
            AnswerHeader ah = person.getQuestionnaireHelper().getAnswerHeaders().get(0);
            for (Answer answer : ah.getAnswers()) {
                answer.setAnswer(null);
            }
        }
        this.saveUpdatePersonAnswerHeaders(pdForm.getDevelopmentProposal(), request.getParameter("pageId"));
        return this.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=certificationToggle"})
    public ModelAndView certificationToggle(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        String personNumber = pdForm.getActionParamaterValue("personNumber");
        for (ProposalPerson person : pdForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons()) {
            if (!StringUtils.equals((CharSequence)personNumber, (CharSequence)person.getProposalPersonNumber().toString())) continue;
            person.setOptInCertificationStatus(person.getOptInCertificationStatus() == false);
            if (person.getOptInCertificationStatus().booleanValue()) continue;
            return this.clearAnswers(form, result, request, response);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewCertification"})
    public ModelAndView viewCertification(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) {
        ProposalPerson person = form.getDevelopmentProposal().getProposalPerson(Integer.parseInt(selectedLine));
        person.getQuestionnaireHelper().populateAnswers();
        form.setProposalPersonQuestionnaireHelper(person.getQuestionnaireHelper());
        return this.getModelAndViewService().showDialog("PropDev-SubmitPage-CertificationDetail", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareVerifyCertificationDialog"})
    public ModelAndView prepareVerifyCertificationDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) {
        ProposalPerson person = form.getDevelopmentProposal().getProposalPerson(Integer.parseInt(selectedLine));
        this.prepareNoticationHelper(form, person);
        if (form.getNotificationHelper().getPromptUserForNotificationEditor(form.getNotificationHelper().getNotificationContext())) {
            return this.getModelAndViewService().showDialog("PropDev-PersonnelPage-VerifyNotification-Dialog", true, (UifFormBase)form);
        }
        return this.sendCertificationNotification(form);
    }

    protected void prepareNoticationHelper(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, ProposalPerson person) {
        NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper = form.getNotificationHelper();
        notificationHelper.setNotification(this.getKcNotificationService().createNotificationObject(this.createNotificationContext(form.getDevelopmentProposal(), person)));
        notificationHelper.setNotificationContext(this.createNotificationContext(form.getDevelopmentProposal(), person));
        notificationHelper.setNotificationRecipients(this.createRecipientFromPerson(person));
        notificationHelper.setNewPersonId(person.getPersonId());
    }

    protected ProposalDevelopmentNotificationContext createNotificationContext(DevelopmentProposal developmentProposal, ProposalPerson person) {
        String sponsorHeirarchy = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "COIHierarchyName");
        String sponsorHeirarchyLevelName = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "COIHierarchyLevel1");
        ProposalDevelopmentNotificationContext context = this.getSponsorHierarchyService().isSponsorInHierarchy(developmentProposal.getSponsorCode(), sponsorHeirarchy, 1, sponsorHeirarchyLevelName) ? new ProposalDevelopmentNotificationContext(developmentProposal, CERTIFICATION_ACTION_TYPE_COI, CERTIFY_NOTIFICATION) : new ProposalDevelopmentNotificationContext(developmentProposal, CERTIFICATION_ACTION_TYPE_CODE, CERTIFY_NOTIFICATION);
        ProposalDevelopmentNotificationRenderer renderer = context.getRenderer();
        renderer.setDevelopmentProposal(developmentProposal);
        renderer.setProposalPerson(person);
        return context;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendCertificationNotification"})
    public ModelAndView sendCertificationNotification(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper = form.getNotificationHelper();
        ProposalPerson person = notificationHelper.getNotificationContext().getRenderer().getProposalPerson();
        form.getNotificationHelper().sendNotificationAndPersist(new ProposalDevelopmentNotification(), form.getDevelopmentProposal());
        this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-PersonnelPage-Collection", "info.notifications.sent", new String[]{person.getFullName() + " " + notificationHelper.getNotification().getCreateTimestamp()});
        person.setLastNotification(this.getDateTimeService().getCurrentTimestamp());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendAllCertificationNotifications"})
    public ModelAndView sendAllCertificationNotifications(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        int index = 0;
        for (ProposalPerson proposalPerson : form.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.isSelectedPerson() && !this.isQuestionnaireComplete(proposalPerson.getQuestionnaireHelper())) {
                this.sendPersonNotification(form, String.valueOf(index));
            }
            ++index;
        }
        return super.save(form);
    }

    public void sendPersonNotification(ProposalDevelopmentDocumentForm form, String selectedLine) {
        ProposalPerson person = form.getDevelopmentProposal().getProposalPerson(Integer.parseInt(selectedLine));
        ProposalDevelopmentNotificationContext context = this.createNotificationContext(form.getDevelopmentProposal(), person);
        ProposalDevelopmentNotification notification = new ProposalDevelopmentNotification();
        this.getKcNotificationService().sendNotificationAndPersist(context, notification, this.createRecipientFromPerson(person), form.getDevelopmentProposal());
        this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-PersonnelPage-Collection", "info.notifications.sent", new String[]{person.getFullName() + " " + notification.getCreateTimestamp()});
        person.setLastNotification(this.getDateTimeService().getCurrentTimestamp());
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=movePersonUp"})
    public ModelAndView movePersonUp(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) {
        this.swapAdjacentPersonnel(form.getDevelopmentProposal().getProposalPersons(), Integer.parseInt(selectedLine), MoveOperationEnum.MOVING_PERSON_UP);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=movePersonDown"})
    public ModelAndView movePersonDown(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) {
        this.swapAdjacentPersonnel(form.getDevelopmentProposal().getProposalPersons(), Integer.parseInt(selectedLine), MoveOperationEnum.MOVING_PERSON_DOWN);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=closeCertWithSave"})
    public ModelAndView closeCertWithSave(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String selectedPersonId = form.getProposalPersonQuestionnaireHelper().getProposalPerson().getPersonId();
        Set<String> personIdsMissingCertification = this.getPersonIdsMissingCertification(form.getDevelopmentProposal().getProposalPersons(), selectedPersonId);
        boolean complete = true;
        for (ProposalPerson proposalPerson : form.getDevelopmentProposal().getProposalPersons()) {
            if (!StringUtils.equals((CharSequence)proposalPerson.getPersonId(), (CharSequence)selectedPersonId) || !proposalPerson.needsCertification()) continue;
            ProposalPersonQuestionnaireHelper proposalPersonQuestionnaireHelper = proposalPerson.getQuestionnaireHelper();
            List<AnswerHeader> newAnswerHeaders = form.getProposalPersonQuestionnaireHelper().getAnswerHeaders();
            complete &= this.isQuestionnaireComplete(form.getProposalPersonQuestionnaireHelper());
            this.getBusinessObjectService().save(newAnswerHeaders);
            proposalPersonQuestionnaireHelper.setAnswerHeaders(newAnswerHeaders);
            this.getKeyPersonnelService().saveCertDetails(proposalPerson, this.getGlobalVariableService().getUserSession().getPrincipalId(), this.getDateTimeService().getCurrentTimestamp());
        }
        if (personIdsMissingCertification.size() == 1 && personIdsMissingCertification.contains(selectedPersonId) && complete) {
            this.sendAllCertificationCompleteNotificationIfEnabled(form.getDevelopmentProposal());
        }
        if (complete && this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            this.getGlobalVariableService().getMessageMap().putInfo("GlobalMessages", INFO_PROPOSAL_CERTIFIED, new String[0]);
        } else if (!complete) {
            this.getGlobalVariableService().getMessageMap().putWarning("GlobalMessages", WARN_PROPOSAL_CERTIFIED, new String[0]);
        }
        this.releaseLocksForLoggedInUser(form);
        return this.getKcCommonControllerService().returnHome((UifFormBase)form);
    }

    protected Set<String> getPersonIdsMissingCertification(List<ProposalPerson> proposalPeople, String selectedPersonId) {
        return proposalPeople.stream().filter(person -> {
            if (StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)selectedPersonId)) {
                return person.getQuestionnaireHelper().getAnswerHeaders().stream().map(ah -> this.retrieveCurrentAnswerHeader(ah.getId())).anyMatch(ah -> ah != null && !ah.isCompleted());
            }
            return person.getQuestionnaireHelper().getAnswerHeaders().stream().anyMatch(ah -> !ah.isCompleted());
        }).map(ProposalPerson::getPersonId).collect(Collectors.toSet());
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=closeCertWithoutSave"})
    public ModelAndView closeCertWithoutSave(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.releaseLocksForLoggedInUser(form);
        return this.getKcCommonControllerService().returnHome((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=certifyAnswers"})
    public ModelAndView certifyAnswers(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getModelAndViewService().showDialog("PropDev-CertificationClose-Dialog", true, (UifFormBase)form);
    }

    public boolean isQuestionnaireComplete(ProposalPersonQuestionnaireHelper helper) {
        boolean retVal = true;
        if (helper != null && helper.getAnswerHeaders() != null) {
            for (AnswerHeader ah : helper.getAnswerHeaders()) {
                boolean complete = this.questionnaireAnswerService.isQuestionnaireAnswerComplete(ah.getAnswers());
                ah.setCompleted(complete);
                retVal &= complete;
            }
        }
        return retVal;
    }

    private void swapAdjacentPersonnel(List<ProposalPerson> keyPersonnel, int index1, MoveOperationEnum op) {
        ProposalPerson movingPerson = keyPersonnel.get(index1);
        if (op == MoveOperationEnum.MOVING_PERSON_DOWN && movingPerson.isMoveDownAllowed() || op == MoveOperationEnum.MOVING_PERSON_UP && movingPerson.isMoveUpAllowed()) {
            int index2 = index1 + op.getOffset();
            keyPersonnel.set(index1, keyPersonnel.get(index2));
            keyPersonnel.set(index2, movingPerson);
        }
    }

    protected boolean personAlreadyExists(String personId, List<ProposalPerson> existingPersons) {
        for (ProposalPerson existingPerson : existingPersons) {
            if (!personId.equals(existingPerson.getPersonId())) continue;
            return true;
        }
        return false;
    }

    public WizardControllerService getWizardControllerService() {
        return this.wizardControllerService;
    }

    public void setWizardControllerService(WizardControllerService wizardControllerService) {
        this.wizardControllerService = wizardControllerService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    public static class ProposalPersonRoleComparator
    implements Comparator<ProposalPerson> {
        private static final Comparator<ProposalPerson> INSTANCE = new ProposalPersonRoleComparator();

        @Override
        public int compare(ProposalPerson person1, ProposalPerson person2) {
            int retval = 0;
            if (person1.isInvestigator() || person2.isInvestigator()) {
                if (person1.isPrincipalInvestigator() || person2.isPrincipalInvestigator()) {
                    if (person1.isPrincipalInvestigator()) {
                        --retval;
                    }
                    if (person2.isPrincipalInvestigator()) {
                        ++retval;
                    }
                }
                if (retval == 0 && (person1.isMultiplePi() || person2.isMultiplePi())) {
                    if (person1.isMultiplePi()) {
                        --retval;
                    }
                    if (person2.isMultiplePi()) {
                        ++retval;
                    }
                }
            }
            if (retval == 0 && (person1.isCoInvestigator() || person2.isCoInvestigator())) {
                if (person1.isCoInvestigator()) {
                    --retval;
                }
                if (person2.isCoInvestigator()) {
                    ++retval;
                }
            }
            if (retval == 0 && (person1.isKeyPerson() || person2.isKeyPerson())) {
                if (person1.isKeyPerson()) {
                    --retval;
                }
                if (person2.isKeyPerson()) {
                    ++retval;
                }
            }
            return retval;
        }
    }

    private static enum MoveOperationEnum {
        MOVING_PERSON_DOWN(1),
        MOVING_PERSON_UP(-1);

        private int offset;

        private MoveOperationEnum(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

