/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.persistence.PersistenceVerificationService;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.MessageMap;

public class KcMaintenanceDocumentRuleBase
extends MaintenanceDocumentRuleBase {
    private transient PersistenceVerificationService persistenceVerificationService;
    private transient GlobalVariableService globalVariableService;

    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = super.processGlobalRouteDocumentBusinessRules(document);
        if (document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            MessageMap messages = this.getPersistenceVerificationService().verifyRelationshipsForDelete(this.getNewBo(), this.relationshipDeleteVerificationIgnores());
            success &= !messages.hasErrors();
            this.getGlobalVariableService().getMessageMap().merge(messages);
        }
        return success;
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    protected boolean checkExistenceFromTable(Class<? extends PersistableBusinessObject> clazz, Map<String, ?> fieldValues, String errorField, String errorParam) {
        boolean success;
        boolean bl = success = this.getBoService().countMatching(clazz, fieldValues) != 0;
        if (!success) {
            this.getGlobalVariableService().getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject." + errorField, "error.existence", new String[]{errorParam});
        }
        return success;
    }

    protected void putFieldWarning(String propertyName, String errorConstant) {
        if (!this.errorAlreadyExists("document.newMaintainableObject." + propertyName, errorConstant)) {
            this.getGlobalVariableService().getMessageMap().putWarningWithoutFullErrorPath("document.newMaintainableObject." + propertyName, errorConstant, new String[0]);
        }
    }

    protected void putFieldWarning(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists("document.newMaintainableObject." + propertyName, errorConstant)) {
            this.getGlobalVariableService().getMessageMap().putWarningWithoutFullErrorPath("document.newMaintainableObject." + propertyName, errorConstant, new String[]{parameter});
        }
    }

    protected void putFieldWarning(String propertyName, String errorConstant, String ... parameters) {
        if (!this.errorAlreadyExists("document.newMaintainableObject." + propertyName, errorConstant)) {
            this.getGlobalVariableService().getMessageMap().putWarningWithoutFullErrorPath("document.newMaintainableObject." + propertyName, errorConstant, parameters);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant, String ... parameters) {
        if (!this.errorAlreadyExists("document.newMaintainableObject." + propertyName, errorConstant)) {
            this.getGlobalVariableService().getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject." + propertyName, errorConstant, parameters);
        }
    }

    protected Collection<Class<?>> relationshipDeleteVerificationIgnores() {
        return Collections.emptyList();
    }

    protected PersistenceVerificationService getPersistenceVerificationService() {
        if (this.persistenceVerificationService == null) {
            this.persistenceVerificationService = KcServiceLocator.getService(PersistenceVerificationService.class);
        }
        return this.persistenceVerificationService;
    }

    public void setPersistenceVerificationService(PersistenceVerificationService persistenceVerificationService) {
        this.persistenceVerificationService = persistenceVerificationService;
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

