/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoice;
import org.apache.pdfbox.pdmodel.interactive.form.PDComboBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDListBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public final class PdfBoxUtils {
    private static final Logger LOG = LogManager.getLogger(PdfBoxUtils.class);
    private static final String SEPARATOR = ".";
    private static final String TOP_LEVEL = "|--";
    private static final String CHILD_LEVEL = "|  ";
    private static final String FIELD_VAL_SEPARATOR = " = ";
    private static final String TYPE_STR = "type=";
    private static final String NO_FORM_FIELDS_MSG = " top-level fields were found on the form";
    private static final String COMMA_SEPARATOR = ",  ";
    private static final String VAL_START = "<";
    private static final String VAL_END = ">";
    private static final COSName ARIAL_MT = COSName.getPDFName((String)"ArialMT");
    private static final COSName HELVETICA = COSName.getPDFName((String)"Helvetica");
    private static final COSName HELVETICA_BOLD = COSName.getPDFName((String)"Helvetica-Bold");
    private static final COSName HELVETICA_OBLIQUE = COSName.getPDFName((String)"Helvetica-Oblique");
    private static final String ON_VALUES_STR = "on_values=";
    private static final String OPTIONS_STR = "options=";
    private static final String DEFAULT_APPEARANCE_STR = "defaultAppearance=";

    private PdfBoxUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean isValidPdf(byte[] pdfBytes) {
        boolean bl;
        block9: {
            if (ArrayUtils.isEmpty((byte[])pdfBytes)) {
                return false;
            }
            PDDocument ignored = PDDocument.load((byte[])pdfBytes);
            try {
                bl = true;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidAcroPdf(byte[] pdfBytes) {
        if (ArrayUtils.isEmpty((byte[])pdfBytes)) {
            return false;
        }
        try (PDDocument pdf = PDDocument.load((byte[])pdfBytes);){
            PDDocumentCatalog catalog = pdf.getDocumentCatalog();
            if (catalog != null) {
                PDAcroForm acroForm = catalog.getAcroForm();
                boolean bl2 = acroForm != null && CollectionUtils.isNotEmpty((Collection)acroForm.getFields());
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
    }

    public static void showField(PDDocument pdfDocument, String name) {
        PdfBoxUtils.toggleFieldVisibility(pdfDocument, name, false);
    }

    public static void hideField(PDDocument pdfDocument, String name) {
        PdfBoxUtils.toggleFieldVisibility(pdfDocument, name, true);
    }

    public static void toggleFieldVisibility(PDDocument pdfDocument, String name, boolean visibility) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        PDField field = acroForm.getField(name);
        if (field != null) {
            if (field.getWidgets() != null) {
                field.getWidgets().forEach(w -> {
                    w.setInvisible(visibility);
                    w.setHidden(visibility);
                });
            }
        } else {
            LOG.error("No field found with name:" + name);
        }
    }

    public static void setField(PDDocument pdfDocument, String name, List<String> value) {
        PdfBoxUtils.setF(pdfDocument, name, value);
    }

    public static void setField(PDDocument pdfDocument, String name, boolean value) {
        PdfBoxUtils.setF(pdfDocument, name, value);
    }

    public static void setField(PDDocument pdfDocument, String name, String value) {
        PdfBoxUtils.setF(pdfDocument, name, value);
    }

    public static void setFieldAsStr(PDDocument pdfDocument, String name, Object value) {
        if (value instanceof BigDecimal) {
            PdfBoxUtils.setF(pdfDocument, name, ((BigDecimal)value).toPlainString());
        } else if (value != null) {
            PdfBoxUtils.setF(pdfDocument, name, value.toString());
        }
    }

    private static void setF(PDDocument pdfDocument, String name, Object value) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        PDField field = acroForm.getField(name);
        if (field != null) {
            if (value != null) {
                PdfBoxUtils.setField(field, value);
            }
        } else {
            LOG.error("No field found with name:" + name);
        }
    }

    private static void setField(PDField field, Object value) {
        block11: {
            if (field == null) {
                throw new IllegalArgumentException("field is null");
            }
            if (value == null) {
                return;
            }
            try {
                if (field instanceof PDTextField || field instanceof PDListBox || field instanceof PDRadioButton || field instanceof PDCheckBox) {
                    if (value instanceof Boolean) {
                        field.setValue(PdfBoxUtils.booleanToStr((Boolean)value));
                    } else if (value instanceof String) {
                        field.setValue((String)value);
                    }
                    break block11;
                }
                if (!(field instanceof PDComboBox)) break block11;
                if (value instanceof Boolean) {
                    field.setValue(PdfBoxUtils.convertToDisplayValue((PDChoice)((PDComboBox)field), PdfBoxUtils.booleanToStr((Boolean)value)));
                    break block11;
                }
                if (value instanceof String) {
                    field.setValue(PdfBoxUtils.convertToDisplayValue((PDChoice)((PDComboBox)field), (String)value));
                    break block11;
                }
                if (value instanceof List) {
                    List converted = ((List)value).stream().map(v -> {
                        if (v instanceof String) {
                            return (String)v;
                        }
                        if (v instanceof Boolean) {
                            return PdfBoxUtils.booleanToStr((Boolean)v);
                        }
                        throw new IllegalArgumentException("Invalid value type in List " + (v != null ? v.getClass().getName() : "(null)"));
                    }).map(v -> PdfBoxUtils.convertToDisplayValue((PDChoice)((PDComboBox)field), v)).collect(Collectors.toList());
                    ((PDChoice)field).setValue(converted);
                    break block11;
                }
                throw new IllegalArgumentException(field.getFullyQualifiedName() + " of type " + field.getClass().getName() + " cannot be set with value of type " + value.getClass().getName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setFieldAppearance(PDDocument pdfDocument, String name, String appearanceStr) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((CharSequence)appearanceStr)) {
            throw new IllegalArgumentException("appearanceStr is blank");
        }
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        PDField field = acroForm.getField(name);
        if (field != null) {
            COSDictionary dict = field.getCOSObject();
            dict.setString(COSName.DA, appearanceStr);
        } else {
            LOG.error("No field found with name:" + name);
        }
    }

    private static String convertToDisplayValue(PDChoice field, String value) {
        int index;
        if (CollectionUtils.isNotEmpty((Collection)field.getOptionsDisplayValues()) && CollectionUtils.isNotEmpty((Collection)field.getOptionsExportValues()) && (index = field.getOptionsExportValues().indexOf(value)) != -1) {
            return (String)field.getOptionsDisplayValues().get(index);
        }
        return value;
    }

    public static void doMissingDefaultResourcesWorkaround(PDResources resources) {
        try {
            if (resources.getFont(ARIAL_MT) == null) {
                resources.put(ARIAL_MT, (PDFont)PDType1Font.HELVETICA);
            }
            if (resources.getFont(HELVETICA) == null) {
                resources.put(HELVETICA, (PDFont)PDType1Font.HELVETICA);
            }
            if (resources.getFont(HELVETICA_BOLD) == null) {
                resources.put(HELVETICA_BOLD, (PDFont)PDType1Font.HELVETICA);
            }
            if (resources.getFont(HELVETICA_OBLIQUE) == null) {
                resources.put(HELVETICA_OBLIQUE, (PDFont)PDType1Font.HELVETICA);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String booleanToStr(boolean value) {
        return value ? "Yes" : "Off";
    }

    public static void flatten(PDDocument pdfDocument) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (pdfDocument.getDocumentCatalog().getAcroForm().getDefaultResources() != null) {
            PdfBoxUtils.doMissingDefaultResourcesWorkaround(pdfDocument.getDocumentCatalog().getAcroForm().getDefaultResources());
        }
        try {
            pdfDocument.getDocumentCatalog().getAcroForm().flatten(pdfDocument.getDocumentCatalog().getAcroForm().getFields(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeUsageRights(PDDocument pdfDocument) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        COSDictionary dictionary = pdfDocument.getDocumentCatalog().getCOSObject();
        dictionary.removeItem(COSName.PERMS);
        dictionary.setNeedToBeUpdated(true);
    }

    public static void removeXfaForm(PDDocument pdfDocument) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        COSDictionary dictionary = pdfDocument.getDocumentCatalog().getCOSObject();
        COSDictionary formDictionary = (COSDictionary)dictionary.getDictionaryObject(COSName.ACRO_FORM);
        formDictionary.removeItem(COSName.XFA);
        formDictionary.setNeedToBeUpdated(true);
    }

    public static void markFields(PDDocument pdfDocument, Predicate<? super PDField> predicate) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is null");
        }
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        fields.forEach(field -> PdfBoxUtils.processMarkField(field, field.getPartialName(), predicate));
    }

    public static void markFields(PDDocument pdfDocument) {
        PdfBoxUtils.markFields(pdfDocument, f -> true);
    }

    private static void processMarkField(PDField field, String sParent, Predicate<? super PDField> predicate) {
        String partialName = field.getPartialName();
        if (field instanceof PDNonTerminalField) {
            if (!((String)sParent).equals(field.getPartialName()) && partialName != null) {
                sParent = (String)sParent + SEPARATOR + partialName;
            }
            for (PDField child : ((PDNonTerminalField)field).getChildren()) {
                PdfBoxUtils.processMarkField(child, (String)sParent, predicate);
            }
        } else if (predicate.test((PDField)field) && !(field instanceof PDButton)) {
            StringBuilder outputString = new StringBuilder(VAL_START);
            if (partialName != null) {
                outputString.append(partialName);
            } else {
                outputString.append((String)sParent);
            }
            outputString.append(VAL_END);
            if (field instanceof PDChoice) {
                ArrayList<String> options = new ArrayList<String>(((PDChoice)field).getOptions());
                options.add(outputString.toString());
            }
            PdfBoxUtils.setField(field, outputString.toString());
        }
    }

    public static void logFields(PDDocument pdfDocument, Predicate<? super PDField> predicate) {
        if (pdfDocument == null) {
            throw new IllegalArgumentException("pdfDocument is null");
        }
        if (!LOG.isInfoEnabled()) {
            return;
        }
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        LOG.info(fields.size() + NO_FORM_FIELDS_MSG);
        fields.forEach(field -> PdfBoxUtils.processLogField(field, TOP_LEVEL, field.getPartialName(), predicate));
    }

    public static void logFields(PDDocument pdfDocument) {
        PdfBoxUtils.logFields(pdfDocument, x -> true);
    }

    private static void processLogField(PDField field, String sLevel, String sParent, Predicate<? super PDField> predicate) {
        String partialName = field.getPartialName();
        if (field instanceof PDNonTerminalField) {
            if (!((String)sParent).equals(field.getPartialName()) && partialName != null) {
                sParent = (String)sParent + SEPARATOR + partialName;
            }
            LOG.info(sLevel + (String)sParent);
            for (PDField child : ((PDNonTerminalField)field).getChildren()) {
                PdfBoxUtils.processLogField(child, CHILD_LEVEL + sLevel, (String)sParent, predicate);
            }
        } else if (predicate.test((PDField)field)) {
            String fieldValue = field.getValueAsString();
            StringBuilder outputString = new StringBuilder(sLevel);
            outputString.append((String)sParent);
            if (partialName != null) {
                outputString.append(SEPARATOR).append(partialName);
            }
            outputString.append(FIELD_VAL_SEPARATOR).append(fieldValue).append(COMMA_SEPARATOR);
            if (field instanceof PDCheckBox || field instanceof PDRadioButton) {
                outputString.append(ON_VALUES_STR).append(((PDButton)field).getOnValues()).append(COMMA_SEPARATOR);
            } else if (field instanceof PDChoice) {
                outputString.append(OPTIONS_STR).append(((PDChoice)field).getOptions()).append(COMMA_SEPARATOR);
            }
            COSBase defaultAppearance = field.getCOSObject().getDictionaryObject(COSName.DA);
            if (defaultAppearance != null) {
                outputString.append(DEFAULT_APPEARANCE_STR).append((Object)(defaultAppearance instanceof COSString ? ((COSString)defaultAppearance).getString() : defaultAppearance)).append(COMMA_SEPARATOR);
            }
            outputString.append(TYPE_STR).append(field.getClass().getName());
            LOG.info((CharSequence)outputString);
        }
    }
}

