/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.framework.version.AddBudgetVersionEvent;
import org.kuali.coeus.common.budget.framework.version.BudgetVersionRule;
import org.kuali.coeus.common.budget.impl.core.AbstractBudgetService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetLineItemCalculatedAmountExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.award.budget.AwardBudgetPersonnelCalculatedAmountExt;
import org.kuali.kra.award.budget.AwardBudgetPersonnelDetailsExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.AwardBudgetStatus;
import org.kuali.kra.award.budget.AwardBudgetType;
import org.kuali.kra.award.budget.AwardBudgetVersionRule;
import org.kuali.kra.award.budget.BudgetLimitSummaryHelper;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.external.budget.BudgetAdjustmentClient;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.BeanUtils;

public class AwardBudgetServiceImpl
extends AbstractBudgetService<Award>
implements AwardBudgetService {
    private static final String HIERARCHY_PROPOSAL_NUMBER = "hierarchyProposalNumber";
    private static final String HIERARCHY_PROPOSAL = "hierarchyProposal";
    private static final Logger LOG = LogManager.getLogger(AwardBudgetServiceImpl.class);
    private static final String BUDGET_VERSION_ERROR_PREFIX = "document.parentDocument.budgetDocumentVersion";
    private static final String INST_PROPOSAL_ID = "instProposalId";
    public static final String AWARD_BUDGET_STATUS_CODE = "awardBudgetStatusCode";
    public static final String BUDGET_VERSION_NUMBER = "budgetVersionNumber";
    public static final String BUDGET_ID = "budgetId";
    public static final String BUDGET_LINE_ITEM_ID = "budgetLineItemId";
    public static final String BUDGET_PERIOD_ID = "budgetPeriodId";
    public static final String SUBMIT_COST_SHARING_FLAG = "submitCostSharingFlag";
    public static final String BUDGET_LINE_ITEM_CALCULATED_AMOUNTS = "budgetLineItemCalculatedAmounts";
    public static final String BUDGET_PERSONNEL_DETAILS_LIST = "budgetPersonnelDetailsList";
    public static final String BUDGET_RATE_AND_BASE_LIST = "budgetRateAndBaseList";
    public static final String BUDGET_SUB_AWARD = "budgetSubAward";
    public static final String BUDGET_PERSONNEL_LINE_ITEM_ID = "budgetPersonnelLineItemId";
    public static final String BUDGET_PERSONNEL_CALCULATED_AMOUNTS = "budgetPersonnelCalculatedAmounts";
    public static final String BUDGET_PERSONNEL_RATE_AND_BASE_LIST = "budgetPersonnelRateAndBaseList";
    public static final String VALID_TO_APPLY_IN_RATE = "validToApplyInRate";
    public static final String PERSON_SEQUENCE_NUMBER = "personSequenceNumber";
    public static final String AWARD_NUMBER = "awardNumber";
    public static final String AWARD_ID = "awardId";
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    public static final String UNNAMED = "UNNAMED";
    public static final String CALCULATED_COST = "calculatedCost";
    public static final String RATE_CLASS_TYPE = "rateClassType";
    public static final String AWARD_FANDA_RATE = "awardFandaRate";
    public static final String RATE_CLASS_CODE = "rateClassCode";
    public static final String RATE_TYPE_CODE = "rateTypeCode";
    public static final String ON_OFF_CAMPUS_FLAG = "onOffCampusFlag";
    public static final String COST_ELEMENT_BO = "costElementBO";
    public static final String BUDGET_CATEGORY = "budgetCategory";
    private static final String SET_BUDGET_ID = "setBudgetId";
    private DocumentService documentService;
    private BudgetSummaryService budgetSummaryService;
    private AwardBudgetCalculationService awardBudgetCalculationService;
    private VersionHistoryService versionHistoryService;
    private AwardService awardService;
    private BudgetVersionRule addBudgetVersionRule;
    private DataObjectService dataObjectService;
    private LegacyDataAdapter legacyDataAdapter;
    private BudgetRatesService budgetRatesService;
    private BudgetAdjustmentClient budgetAdjustmentClient;
    private GlobalVariableService globalVariableService;

    @Override
    public void post(AwardBudgetDocument awardBudgetDocument) {
        if (this.getParameterValueAsBoolean("KC-AB", "Document", "Enable_Award_Budget_Queued_Status")) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusQueued");
        } else {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusPosted");
        }
        this.saveDocument(awardBudgetDocument);
    }

    @Override
    public void postWithFinancialIntegration(AwardBudgetDocument awardBudgetDocument) throws Exception {
        if (this.isValidForPostingToFinancialSystem(awardBudgetDocument)) {
            this.getBudgetAdjustmentClient().createBudgetAdjustmentDocument(awardBudgetDocument);
            if (!this.isValidForPostingToFinancialSystem(awardBudgetDocument)) {
                this.post(awardBudgetDocument);
                String docNumber = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
                KNSGlobalVariables.getMessageList().add("message.award.budget.adjustment.budget.posted", new String[]{docNumber});
            }
        } else {
            String budgetAdjustmentDocNbr = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.exists", new String[]{budgetAdjustmentDocNbr});
            LOG.info("Cannot post budget. There is already a budget adjustment document linked to this budget.");
        }
    }

    @Override
    public boolean isFinancialIntegrationOn() {
        String parameterValue = this.getParameterValueAsString("KC-AWARD", "Document", "KUALI_FINANCIALS_INTEGRATION_ON");
        return StringUtils.containsIgnoreCase((CharSequence)parameterValue, (CharSequence)"ON");
    }

    public String getParameterValueAsString(String moduleNamespace, String parameterComponent, String parameterName) {
        return this.getParameterService().getParameterValueAsString(moduleNamespace, parameterComponent, parameterName);
    }

    public boolean getParameterValueAsBoolean(String moduleNamespace, String parameterComponent, String parameterName) {
        return this.getParameterService().getParameterValueAsBoolean(moduleNamespace, parameterComponent, parameterName);
    }

    protected boolean isValidForPostingToFinancialSystem(AwardBudgetDocument awardBudgetDocument) {
        String budgetAdjustmentDocumentNumber = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
        return ObjectUtils.isNull((Object)budgetAdjustmentDocumentNumber) || StringUtils.isEmpty((CharSequence)budgetAdjustmentDocumentNumber);
    }

    @Override
    public AwardBudgetDocument copyBudgetVersion(AwardBudgetDocument budgetDocument, boolean onlyOnePeriod) throws WorkflowException {
        AwardBudgetExt budget = budgetDocument.getBudget();
        AwardDocument awardDocument = (AwardDocument)budgetDocument.getBudget().getBudgetParent().getDocument();
        AwardBudgetExt copiedBudget = this.copyAwardBudget(budgetDocument, onlyOnePeriod, budget, awardDocument);
        budgetDocument.getBudgets().add(copiedBudget);
        copiedBudget.setBudgetDocument(budgetDocument);
        this.fixStartAndEndDatesAndPeriods(budget.getAward(), copiedBudget);
        budgetDocument = (AwardBudgetDocument)this.getDocumentService().saveDocument((Document)budgetDocument);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        this.fixProperty(budget, SET_BUDGET_ID, Long.class, budgetDocument.getBudget().getBudgetId(), objectMap);
        objectMap.clear();
        budgetDocument = this.saveBudgetDocument(budgetDocument, false);
        AwardDocument savedAwardDocument = (AwardDocument)budgetDocument.getBudget().getBudgetParent().getDocument();
        savedAwardDocument.refreshBudgetDocumentVersions();
        return budgetDocument;
    }

    protected void fixStartAndEndDatesAndPeriods(Award award, AwardBudgetExt copiedBudget) {
        copiedBudget.setStartDate(award.getRequestedStartDateInitial());
        copiedBudget.setEndDate(award.getRequestedEndDateInitial());
        this.defaultPeriodsIfNeeded(copiedBudget);
    }

    protected AwardBudgetExt copyAwardBudget(AwardBudgetDocument budgetDocument, boolean onlyOnePeriod, Budget budget, AwardDocument awardDocument) throws WorkflowException {
        String parentDocumentNumber = awardDocument.getDocumentNumber();
        budgetDocument.toCopy();
        awardDocument.getDocumentHeader().setDocumentNumber(parentDocumentNumber);
        awardDocument.setDocumentNumber(parentDocumentNumber);
        if (budgetDocument.getBudget() == null) {
            throw new RuntimeException("Not able to find any Budget Version associated with this document");
        }
        return (AwardBudgetExt)this.copyBudgetVersion(budget, onlyOnePeriod);
    }

    public Budget copyBudgetVersionSuper(Budget budget, boolean onlyOnePeriod) {
        if (onlyOnePeriod) {
            List<BudgetPeriod> oldBudgetPeriods = budget.getBudgetPeriods();
            for (int i = 1; i < oldBudgetPeriods.size(); ++i) {
                BudgetPeriod period = oldBudgetPeriods.get(i);
                period.getBudgetLineItems().clear();
                period.setCostSharingAmount(new ScaleTwoDecimal(0.0));
                period.setExpenseTotal(new ScaleTwoDecimal(0.0));
                period.setTotalCost(new ScaleTwoDecimal(0.0));
                period.setTotalCostLimit(new ScaleTwoDecimal(0.0));
                period.setTotalDirectCost(new ScaleTwoDecimal(0.0));
                period.setTotalIndirectCost(new ScaleTwoDecimal(0.0));
                period.setUnderrecoveryAmount(new ScaleTwoDecimal(0.0));
            }
            if (budget.getBudgetSubAwards() != null && budget.getBudgetSubAwards().size() > 0) {
                List<BudgetSubAwardPeriodDetail> budetSubawardPeriodDetail = budget.getBudgetSubAwards().get(0).getBudgetSubAwardPeriodDetails();
                for (int i = 1; i < budetSubawardPeriodDetail.size(); ++i) {
                    BudgetSubAwardPeriodDetail period = budetSubawardPeriodDetail.get(i);
                    period.setAmountsModified(true);
                    period.setCostShare(new ScaleTwoDecimal(0.0));
                    period.setDirectCost(new ScaleTwoDecimal(0.0));
                    period.setIndirectCost(new ScaleTwoDecimal(0.0));
                    period.setTotalCost(new ScaleTwoDecimal(0.0));
                }
            }
        }
        budget.setBudgetVersionNumber(budget.getBudgetParent().getNextBudgetVersionNumber());
        try {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            this.fixProperty(budget, SET_BUDGET_ID, Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetPeriodId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetLineItemId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetLineItemCalculatedAmountId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetPersonnelLineItemId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetPersonnelCalculatedAmountId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetPersonnelRateAndBaseId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setBudgetRateAndBaseId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budget, "setVersionNumber", Integer.class, null, objectMap);
            objectMap.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<CallSite, BudgetModular> tmpBudgetModulars = new HashMap<CallSite, BudgetModular>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular tmpObject = null;
            if (budgetPeriod.getBudgetModular() != null) {
                tmpObject = (BudgetModular)((Object)ObjectUtils.deepCopy((Serializable)((Object)budgetPeriod.getBudgetModular())));
            }
            tmpBudgetModulars.put((CallSite)((Object)("" + budgetPeriod.getBudget().getVersionNumber() + budgetPeriod.getBudgetPeriod())), tmpObject);
            budgetPeriod.setBudgetModular(null);
        }
        this.copyLineItemToPersonnelDetails(budget);
        budget.setVersionNumber(null);
        budget.setBudgetAdjustmentDocumentNumber(null);
        List<BudgetProjectIncome> projectIncomes = budget.getBudgetProjectIncomes();
        budget.setBudgetProjectIncomes(new ArrayList<BudgetProjectIncome>());
        if (projectIncomes != null && !projectIncomes.isEmpty()) {
            this.updateProjectIncomes(budget, projectIncomes);
        }
        for (BudgetPeriod tmpBudgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular tmpBudgetModular = (BudgetModular)tmpBudgetModulars.get("" + tmpBudgetPeriod.getBudget().getVersionNumber() + tmpBudgetPeriod.getBudgetPeriod());
            if (tmpBudgetModular == null) continue;
            tmpBudgetModular.setBudgetPeriodObj(tmpBudgetPeriod);
            tmpBudgetPeriod.setBudgetModular(tmpBudgetModular);
        }
        return budget;
    }

    @Override
    public boolean limitsMatch(List<AwardBudgetLimit> awardLimits, List<AwardBudgetLimit> budgetLimits) {
        if (awardLimits.size() < budgetLimits.size()) {
            return false;
        }
        for (AwardBudgetLimit limit : awardLimits) {
            AwardBudgetLimit budgetLimit = this.getBudgetLimit(limit.getLimitType(), budgetLimits);
            if (Objects.equals(limit.getLimit(), budgetLimit.getLimit())) continue;
            return false;
        }
        return true;
    }

    public AwardBudgetLimit getBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type, List<AwardBudgetLimit> budgetLimits) {
        for (AwardBudgetLimit limit : budgetLimits) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    private void fixProperty(Object object, String methodName, Class<?> clazz, Object propertyValue, Map<String, Object> objectMap) {
        if (ObjectUtils.isNotNull((Object)object) && object instanceof PersistableBusinessObject) {
            Method[] methods;
            PersistableBusinessObject objectWId = (PersistableBusinessObject)object;
            if (objectMap.get(objectWId.getObjectId()) != null) {
                return;
            }
            objectMap.put(((PersistableBusinessObject)object).getObjectId(), object);
            for (Method method : methods = object.getClass().getMethods()) {
                if (method.getName().equals(methodName)) {
                    if (object instanceof DocumentBase) continue;
                    try {
                        if (clazz.equals(Long.class)) {
                            method.invoke(object, propertyValue);
                            continue;
                        }
                        method.invoke(object, propertyValue);
                    }
                    catch (Throwable e) {
                        LOG.warn(e.getMessage(), e);
                    }
                    continue;
                }
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Throwable e) {
                    LOG.warn(e.getMessage(), e);
                }
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object entry : c) {
                        this.fixProperty(entry, methodName, clazz, propertyValue, objectMap);
                    }
                    continue;
                }
                this.fixProperty(value, methodName, clazz, propertyValue, objectMap);
            }
        }
    }

    private boolean isPropertyGetterMethod(Method method, Method[] methods) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            String setterName = method.getName().replaceFirst("get", "set");
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateProjectIncomes(Budget budget, List<BudgetProjectIncome> projectIncomes) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetProjectIncome projectIncome : projectIncomes) {
                if (!budgetPeriod.getBudgetPeriod().equals(projectIncome.getBudgetPeriodNumber())) continue;
                projectIncome.setBudgetId(budget.getBudgetId());
                projectIncome.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
            }
        }
    }

    @Override
    public Budget copyBudgetVersion(Budget budget, boolean onlyOnePeriod) {
        AwardBudgetExt copy = (AwardBudgetExt)this.copyBudgetVersionSuper(budget, onlyOnePeriod);
        for (BudgetPeriod period : copy.getBudgetPeriods()) {
            AwardBudgetPeriodExt awardPeriod = (AwardBudgetPeriodExt)period;
            awardPeriod.getAwardBudgetPeriodFnAAmounts().clear();
            awardPeriod.getAwardBudgetPeriodFringeAmounts().clear();
        }
        return copy;
    }

    @Override
    public void toggleStatus(AwardBudgetDocument awardBudgetDocument) {
        String currentStatusCode = awardBudgetDocument.getAwardBudget().getAwardBudgetStatusCode();
        if (currentStatusCode.equals(this.getParameterValue("awardBudgetStatusToBePosted"))) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusDoNotPost");
        } else if (currentStatusCode.equals(this.getParameterValue("awardBudgetStatusDoNotPost"))) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusToBePosted");
        }
        this.saveDocument(awardBudgetDocument);
    }

    protected void saveDocument(AwardBudgetDocument awardBudgetDocument) {
        try {
            this.getDocumentService().saveDocument((Document)awardBudgetDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processApproval(AwardBudgetDocument awardBudgetDocument) {
        WorkflowDocument workFlowDocument = this.getWorkflowDocument(awardBudgetDocument);
        if (workFlowDocument.isFinal()) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusToBePosted");
            this.saveDocument(awardBudgetDocument);
        }
    }

    @Override
    public void processDisapproval(AwardBudgetDocument awardBudgetDocument) {
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusReturned");
    }

    @Override
    public void processSubmision(AwardBudgetDocument awardBudgetDocument) {
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusSubmitted");
    }

    protected void processStatusChange(AwardBudgetDocument awardBudgetDocument, String routingStatus) {
        WorkflowDocument workflowDocument = this.getWorkflowDocument(awardBudgetDocument);
        String submittedStatusCode = this.getParameterValue(routingStatus);
        String submittedStatus = this.findStatusDescription(submittedStatusCode);
        awardBudgetDocument.getAwardBudget().setAwardBudgetStatusCode(submittedStatusCode);
        workflowDocument.setApplicationDocumentStatus(submittedStatus);
    }

    protected String getParameterValue(String awardBudgetParameter) {
        return this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, awardBudgetParameter);
    }

    protected String findStatusDescription(String statusCode) {
        AwardBudgetStatus budgetStatus = (AwardBudgetStatus)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetStatus.class, (Object)statusCode);
        return budgetStatus.getDescription();
    }

    @Override
    public AwardBudgetDocument rebudget(AwardDocument awardDocument, String documentDescription) throws WorkflowException {
        return this.createNewBudgetDocument(documentDescription, awardDocument.getAward(), true);
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    @Override
    public Budget getNewBudgetVersion(BudgetParentDocument<Award> parentBudgetDocument, String documentDescription, Map<String, Object> options) {
        AwardBudgetDocument budgetDocument;
        AwardDocument awardDocument = (AwardDocument)parentBudgetDocument;
        try {
            budgetDocument = this.getNewBudgetVersionDocument(parentBudgetDocument, documentDescription, options);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        if (budgetDocument != null) {
            AwardBudgetExt budget = budgetDocument.getBudget();
            if (budget.getBudgetPeriods().isEmpty() && budget.getStartDate() != null) {
                budget.setBudgetPeriods(this.getBudgetSummaryService().generateBudgetPeriods(budget));
            }
            awardDocument.getAward().getCurrentVersionBudgets().add(budget);
            awardDocument.getAward().getBudgets().add(budget);
            try {
                budgetDocument = (AwardBudgetDocument)this.getDocumentService().saveDocument((Document)budgetDocument);
            }
            catch (WorkflowException e) {
                throw new RuntimeException(e);
            }
            return budgetDocument.getBudget();
        }
        return null;
    }

    @Override
    public AwardBudgetDocument getNewBudgetVersionDocument(BudgetParentDocument<Award> parentBudgetDocument, String documentDescription, Map<String, Object> options) throws WorkflowException {
        AwardDocument parentDocument = (AwardDocument)parentBudgetDocument;
        if (this.checkForOutstandingBudgets(parentDocument.getAward())) {
            return null;
        }
        return this.createNewBudgetDocument(documentDescription, parentDocument.getAward(), false);
    }

    protected AwardBudgetDocument createNewBudgetDocument(String documentDescription, Award award, boolean rebudget) throws WorkflowException {
        AwardBudgetDocument awardBudgetDocument;
        boolean success = this.isValidBudgetVersion(documentDescription, award);
        if (!success) {
            return null;
        }
        Integer budgetVersionNumber = award.getNextBudgetVersionNumber();
        if (this.isPostedBudgetExist(award)) {
            ScaleTwoDecimal obligatedChangeAmount = this.getTotalCostLimit(award);
            AwardBudgetExt previousPostedBudget = this.getLatestPostedBudget(award);
            AwardBudgetDocument postedBudgetDocument = previousPostedBudget.getBudgetDocument();
            awardBudgetDocument = this.copyBudgetVersion(postedBudgetDocument);
            this.copyObligatedAmountToLineItems(awardBudgetDocument, obligatedChangeAmount);
        } else {
            awardBudgetDocument = (AwardBudgetDocument)this.getDocumentService().getNewDocument(AwardBudgetDocument.class);
        }
        awardBudgetDocument.getDocumentHeader().setDocumentDescription(documentDescription);
        AwardBudgetExt awardBudget = awardBudgetDocument.getAwardBudget();
        awardBudget.setBudgetVersionNumber(budgetVersionNumber);
        awardBudget.setBudgetDocument(awardBudgetDocument);
        awardBudget.setAward(award);
        awardBudget.setAwardId(award.getAwardId());
        awardBudget.setName(documentDescription);
        awardBudget.setDocumentNumber(awardBudgetDocument.getDocumentNumber());
        AwardBudgetExt lastBudgetVersion = this.getLastBudgetVersion(award);
        awardBudget.setOnOffCampusFlag(lastBudgetVersion == null ? "D" : lastBudgetVersion.getOnOffCampusFlag());
        if (awardBudgetDocument.getDocumentHeader() != null && awardBudgetDocument.getDocumentHeader().hasWorkflowDocument()) {
            awardBudget.setBudgetInitiator(awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        }
        awardBudget.setStartDate(award.getRequestedStartDateInitial());
        awardBudget.setEndDate(award.getRequestedEndDateInitial());
        this.defaultPeriodsIfNeeded(awardBudget);
        if (awardBudget.getOhRatesNonEditable()) {
            awardBudget.setOhRateClassCode(this.getAwardParameterValue("awardBudgetDefaultFnARateClassCode"));
            awardBudget.setUrRateClassCode(this.getAwardParameterValue("awardBudgetDefaultUnderrecoveryRateClassCode"));
        } else {
            awardBudget.setOhRateClassCode(this.getBudgetParameterValue("defaultOverheadRateClassCode"));
            awardBudget.setUrRateClassCode(this.getBudgetParameterValue("defaultUnderrecoveryRateClassCode"));
        }
        awardBudget.setOhRateTypeCode(this.getBudgetParameterValue("defaultOverheadRateTypeCode"));
        awardBudget.setModularBudgetFlag(this.getParameterService().getParameterValueAsBoolean(Budget.class, "defaultModularFlag"));
        awardBudget.setAwardBudgetStatusCode(this.getAwardParameterValue("awardBudgetStatusInProgress"));
        awardBudget.setBudgetAdjustmentDocumentNumber("");
        awardBudget.setRateClassTypesReloaded(true);
        this.setBudgetLimits(awardBudgetDocument, award);
        if (this.isPostedBudgetExist(award) && awardBudget.getTotalCostLimit().equals((Object)ScaleTwoDecimal.ZERO)) {
            rebudget = true;
        }
        this.recalculateBudget(awardBudgetDocument.getBudget());
        this.saveBudgetDocument(awardBudgetDocument, rebudget);
        awardBudgetDocument = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(awardBudgetDocument.getDocumentNumber());
        return awardBudgetDocument;
    }

    protected boolean isValidBudgetVersion(String documentDescription, Award award) throws WorkflowException {
        return new AwardBudgetVersionRule().processAddBudgetVersion(new AddBudgetVersionEvent(BUDGET_VERSION_ERROR_PREFIX, award, documentDescription));
    }

    protected void defaultPeriodsIfNeeded(Budget awardBudget) {
        if (this.incorrectBudgetPeriodDates(awardBudget.getBudgetStartDate(), awardBudget.getBudgetEndDate(), awardBudget.getBudgetPeriods())) {
            awardBudget.getBudgetPeriods().forEach(budgetPeriod -> {
                budgetPeriod.setOldEndDate(budgetPeriod.getEndDate());
                budgetPeriod.setOldStartDate(budgetPeriod.getStartDate());
            });
            awardBudget.getBudgetSummaryService().defaultBudgetPeriods(awardBudget);
            GlobalVariables.getMessageMap().putWarning("GLOBAL_ERRORS", "warn.award.budget.period.dates.updated", new String[0]);
        }
    }

    protected boolean incorrectBudgetPeriodDates(Date startDate, Date endDate, List<BudgetPeriod> budgetPeriods) {
        java.sql.Date budgetEndDate = new java.sql.Date(endDate.getTime());
        java.sql.Date budgetStartDate = new java.sql.Date(startDate.getTime());
        return budgetPeriods.stream().anyMatch(budgetPeriod -> budgetPeriod.getStartDate().before(budgetStartDate) || budgetPeriod.getStartDate().after(budgetEndDate) || budgetPeriod.getEndDate().after(budgetEndDate) || budgetPeriod.getEndDate().before(budgetStartDate));
    }

    private String getBudgetParameterValue(String parameter) {
        return this.getParameterService().getParameterValueAsString(Budget.class, parameter);
    }

    private String getAwardParameterValue(String parameter) {
        return this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, parameter);
    }

    @Override
    public void setBudgetLimits(AwardBudgetDocument awardBudgetDocument, Award award) {
        AwardBudgetExt awardBudget = awardBudgetDocument.getAwardBudget();
        awardBudget.setTotalCostLimit(this.getTotalCostLimit(award));
        awardBudget.setObligatedTotal(new ScaleTwoDecimal(award.getBudgetTotalCostLimit().bigDecimalValue()));
        awardBudget.getAwardBudgetLimits().clear();
        for (AwardBudgetLimit limit : award.getAwardBudgetLimits()) {
            awardBudget.getAwardBudgetLimits().add(new AwardBudgetLimit(limit));
        }
    }

    protected void copyObligatedAmountToLineItems(AwardBudgetDocument awardBudgetDocument, ScaleTwoDecimal obligatedChangeAmount) {
        AwardBudgetExt newAwardBudgetFromPosted = awardBudgetDocument.getAwardBudget();
        List<BudgetPeriod> awardBudgetPeriods = newAwardBudgetFromPosted.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : awardBudgetPeriods) {
            AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
            List<BudgetLineItem> lineItems = awardBudgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : lineItems) {
                AwardBudgetLineItemExt awardBudgetLineItem = (AwardBudgetLineItemExt)budgetLineItem;
                List<BudgetPersonnelDetails> personnelDetailsList = awardBudgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailsList) {
                    AwardBudgetPersonnelDetailsExt awardBudgetPersonnelDetails = (AwardBudgetPersonnelDetailsExt)budgetPersonnelDetails;
                    List<BudgetPersonnelCalculatedAmount> personnelCalcAmounts = awardBudgetPersonnelDetails.getBudgetCalculatedAmounts();
                    for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmountExt : personnelCalcAmounts) {
                        AwardBudgetPersonnelCalculatedAmountExt awardBudgetPersonnelCalculatedAmountExt = (AwardBudgetPersonnelCalculatedAmountExt)budgetPersonnelCalculatedAmountExt;
                        awardBudgetPersonnelCalculatedAmountExt.setObligatedAmount((ScaleTwoDecimal)awardBudgetPersonnelCalculatedAmountExt.getObligatedAmount().add((AbstractDecimal)((ScaleTwoDecimal)awardBudgetPersonnelCalculatedAmountExt.getCalculatedCost().add((AbstractDecimal)awardBudgetPersonnelCalculatedAmountExt.getCalculatedCostSharing()))));
                        awardBudgetPersonnelCalculatedAmountExt.setCalculatedCost(ScaleTwoDecimal.ZERO);
                        awardBudgetPersonnelCalculatedAmountExt.setCalculatedCostSharing(ScaleTwoDecimal.ZERO);
                    }
                    awardBudgetPersonnelDetails.setObligatedAmount((ScaleTwoDecimal)awardBudgetPersonnelDetails.getObligatedAmount().add((AbstractDecimal)((ScaleTwoDecimal)awardBudgetPersonnelDetails.getSalaryRequested().add((AbstractDecimal)awardBudgetPersonnelDetails.getCostSharingAmount()))));
                    awardBudgetPersonnelDetails.setPercentCharged(ScaleTwoDecimal.ZERO);
                    awardBudgetPersonnelDetails.setPercentEffort(ScaleTwoDecimal.ZERO);
                    awardBudgetPersonnelDetails.setSalaryRequested(ScaleTwoDecimal.ZERO);
                    awardBudgetPersonnelDetails.setCostSharingAmount(ScaleTwoDecimal.ZERO);
                }
                List<BudgetLineItemCalculatedAmount> calcAmounts = awardBudgetLineItem.getBudgetCalculatedAmounts();
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calcAmounts) {
                    AwardBudgetLineItemCalculatedAmountExt awardBudgetLineItemCalculatedAmount = (AwardBudgetLineItemCalculatedAmountExt)budgetLineItemCalculatedAmount;
                    awardBudgetLineItemCalculatedAmount.setObligatedAmount((ScaleTwoDecimal)awardBudgetLineItemCalculatedAmount.getObligatedAmount().add((AbstractDecimal)((ScaleTwoDecimal)awardBudgetLineItemCalculatedAmount.getCalculatedCost().add((AbstractDecimal)awardBudgetLineItemCalculatedAmount.getCalculatedCostSharing()))));
                    awardBudgetLineItemCalculatedAmount.setCalculatedCost(ScaleTwoDecimal.ZERO);
                    awardBudgetLineItemCalculatedAmount.setCalculatedCostSharing(ScaleTwoDecimal.ZERO);
                }
                awardBudgetLineItem.setObligatedAmount((ScaleTwoDecimal)awardBudgetLineItem.getObligatedAmount().add((AbstractDecimal)((ScaleTwoDecimal)awardBudgetLineItem.getLineItemCost().add((AbstractDecimal)awardBudgetLineItem.getCostSharingAmount()))));
                awardBudgetLineItem.setLineItemCost(ScaleTwoDecimal.ZERO);
                awardBudgetLineItem.setCostSharingAmount(ScaleTwoDecimal.ZERO);
            }
            awardBudgetPeriod.setObligatedAmount((ScaleTwoDecimal)awardBudgetPeriod.getObligatedAmount().add((AbstractDecimal)awardBudgetPeriod.getTotalCost()));
            awardBudgetPeriod.setTotalCost(ScaleTwoDecimal.ZERO);
            awardBudgetPeriod.setTotalDirectCost(ScaleTwoDecimal.ZERO);
            awardBudgetPeriod.setTotalIndirectCost(ScaleTwoDecimal.ZERO);
            awardBudgetPeriod.setTotalCostLimit(obligatedChangeAmount);
        }
    }

    protected AwardBudgetExt getLatestPostedBudget(Award award) {
        QueryList<AwardBudgetExt> budgets = new QueryList<AwardBudgetExt>();
        budgets.addAll(award.getBudgets());
        Equals eqPostedStatus = new Equals(AWARD_BUDGET_STATUS_CODE, (Comparable)((Object)this.getAwardPostedStatusCode()));
        QueryList postedVersions = budgets.filter(eqPostedStatus);
        if (!postedVersions.isEmpty()) {
            postedVersions.sort(BUDGET_VERSION_NUMBER, false);
            return (AwardBudgetExt)postedVersions.get(0);
        }
        return null;
    }

    @Override
    public ScaleTwoDecimal getTotalCostLimit(Award award) {
        ScaleTwoDecimal obligatedTotal = award.getObligatedDistributableTotal();
        ScaleTwoDecimal costLimit = award.getTotalCostBudgetLimit();
        ScaleTwoDecimal postedTotalAmount = this.getPostedTotalAmount(award);
        if (costLimit == null || costLimit.isGreaterEqual((AbstractDecimal)obligatedTotal)) {
            return (ScaleTwoDecimal)new ScaleTwoDecimal(obligatedTotal.bigDecimalValue()).subtract((AbstractDecimal)postedTotalAmount);
        }
        return (ScaleTwoDecimal)new ScaleTwoDecimal(costLimit.bigDecimalValue()).subtract((AbstractDecimal)postedTotalAmount);
    }

    protected ScaleTwoDecimal getPostedTotalAmount(Award award) {
        String postedStatusCode = this.getAwardPostedStatusCode();
        ScaleTwoDecimal postedTotalAmount = ScaleTwoDecimal.ZERO;
        for (AwardBudgetExt budget : award.getBudgets()) {
            if (!budget.getAwardBudgetStatusCode().equals(postedStatusCode)) continue;
            postedTotalAmount = (ScaleTwoDecimal)postedTotalAmount.add((AbstractDecimal)budget.getTotalCost());
        }
        return postedTotalAmount;
    }

    protected boolean isPostedBudgetExist(Award award) {
        boolean exist = false;
        String postedStatusCode = this.getAwardPostedStatusCode();
        for (AwardBudgetExt budget : award.getBudgets()) {
            if (!budget.getAwardBudgetStatusCode().equals(postedStatusCode)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    protected String getAwardPostedStatusCode() {
        return this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusPosted");
    }

    protected AwardBudgetExt getLastBudgetVersion(Award award) {
        List<AwardBudgetExt> awardBudgetDocumentVersions = award.getBudgets();
        AwardBudgetExt latestBudget = null;
        int versionSize = awardBudgetDocumentVersions.size();
        if (versionSize > 0) {
            latestBudget = awardBudgetDocumentVersions.get(versionSize - 1);
        }
        return latestBudget;
    }

    protected AwardBudgetDocument saveBudgetDocument(AwardBudgetDocument awardBudgetDocument, boolean rebudget) {
        AwardBudgetExt budgetExt = awardBudgetDocument.getAwardBudget();
        String awardBudgetTypeID = this.getParameterValue(rebudget ? "awardBudgetTypeRebudget" : "awardBudgetTypeNew");
        AwardBudgetType awardBudgetType = (AwardBudgetType)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetType.class, (Object)awardBudgetTypeID);
        budgetExt.setAwardBudgetTypeCode(awardBudgetType.getAwardBudgetTypeCode());
        budgetExt.setDescription(awardBudgetType.getDescription());
        budgetExt.setAwardBudgetType(awardBudgetType);
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusInProgress");
        this.saveDocument(awardBudgetDocument);
        return awardBudgetDocument;
    }

    protected void copyProposalBudgetLineItemsToAwardBudget(AwardBudgetPeriodExt awardBudgetPeriod, BudgetPeriod proposalBudgetPeriod) {
        boolean changeLineItemDates = false;
        boolean warnOfRateEffectiveDateChange = false;
        Budget awardBudget = awardBudgetPeriod.getBudget();
        Date currentEffectiveDate = this.getEffectiveRateStartDate(awardBudget);
        List<BudgetLineItem> awardBudgetLineItems = awardBudgetPeriod.getBudgetLineItems();
        List<BudgetLineItem> lineItems = proposalBudgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            String[] ignoreProperties = new String[]{BUDGET_ID, BUDGET_LINE_ITEM_ID, BUDGET_PERIOD_ID, SUBMIT_COST_SHARING_FLAG, BUDGET_LINE_ITEM_CALCULATED_AMOUNTS, BUDGET_PERSONNEL_DETAILS_LIST, BUDGET_RATE_AND_BASE_LIST, BUDGET_SUB_AWARD, HIERARCHY_PROPOSAL, HIERARCHY_PROPOSAL_NUMBER};
            AwardBudgetLineItemExt awardBudgetLineItem = new AwardBudgetLineItemExt();
            BeanUtils.copyProperties((Object)budgetLineItem, (Object)awardBudgetLineItem, (String[])ignoreProperties);
            awardBudgetLineItem.setLineItemNumber(awardBudget.getNextValue("budget.budgetLineItem.lineItemNumber"));
            awardBudgetLineItem.setBudgetId(awardBudgetPeriod.getBudgetId());
            awardBudgetLineItem.setSubAwardNumber(null);
            awardBudgetLineItem.setStartDate(awardBudgetPeriod.getStartDate());
            awardBudgetLineItem.setEndDate(awardBudgetPeriod.getEndDate());
            List<BudgetPersonnelDetails> awardBudgetPersonnelLineItems = awardBudgetLineItem.getBudgetPersonnelDetailsList();
            List<BudgetPersonnelDetails> budgetPersonnelLineItems = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelLineItems) {
                budgetPersonnelDetails.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
                budgetPersonnelDetails.setBudgetLineItem(budgetLineItem);
                AwardBudgetPersonnelDetailsExt awardBudgetPerDetails = new AwardBudgetPersonnelDetailsExt();
                BeanUtils.copyProperties((Object)budgetPersonnelDetails, (Object)awardBudgetPerDetails, (String[])new String[]{BUDGET_PERSONNEL_LINE_ITEM_ID, BUDGET_LINE_ITEM_ID, BUDGET_ID, SUBMIT_COST_SHARING_FLAG, BUDGET_PERSONNEL_CALCULATED_AMOUNTS, BUDGET_PERSONNEL_RATE_AND_BASE_LIST, VALID_TO_APPLY_IN_RATE});
                awardBudgetPerDetails.setPersonNumber(awardBudget.getNextValue("budget.budgetPersonnelDetails.personNumber"));
                BudgetPerson oldBudgetPerson = budgetPersonnelDetails.getBudgetPerson();
                BudgetPerson currentBudgetPerson = this.findMatchingPersonInBudget(awardBudget, oldBudgetPerson, budgetPersonnelDetails.getJobCode());
                if (currentBudgetPerson == null) {
                    currentBudgetPerson = new BudgetPerson();
                    BeanUtils.copyProperties((Object)oldBudgetPerson, (Object)currentBudgetPerson, (String[])new String[]{BUDGET_ID, PERSON_SEQUENCE_NUMBER});
                    currentBudgetPerson.setBudgetId(awardBudgetPeriod.getBudgetId());
                    currentBudgetPerson.setPersonSequenceNumber(awardBudget.getNextValue(PERSON_SEQUENCE_NUMBER));
                    awardBudget.getBudgetPersons().add(currentBudgetPerson);
                    if (currentBudgetPerson.getEffectiveDate() != null && currentEffectiveDate.after(currentBudgetPerson.getEffectiveDate())) {
                        warnOfRateEffectiveDateChange = true;
                    }
                }
                awardBudgetPerDetails.setBudgetPerson(currentBudgetPerson);
                awardBudgetPerDetails.setPersonSequenceNumber(currentBudgetPerson.getPersonSequenceNumber());
                awardBudgetPerDetails.setBudget(awardBudget);
                awardBudgetPerDetails.setBudgetId(awardBudgetPeriod.getBudgetId());
                awardBudgetPerDetails.setCostElement(awardBudgetLineItem.getCostElement());
                changeLineItemDates |= this.adjustLineItemDatesIfNecessary(awardBudgetPerDetails, awardBudgetLineItem.getStartDate(), awardBudgetLineItem.getEndDate());
                awardBudgetPersonnelLineItems.add(awardBudgetPerDetails);
            }
            if (changeLineItemDates) {
                GlobalVariables.getMessageMap().putWarning("GLOBAL_ERRORS", "warn.award.budget.line.item.dates.updated", new String[]{awardBudgetLineItem.getBudgetCategory() != null ? awardBudgetLineItem.getBudgetCategory().getDescription() : "", awardBudgetLineItem.getCostElementName()});
            }
            if (warnOfRateEffectiveDateChange) {
                GlobalVariables.getMessageMap().putWarning("GLOBAL_ERRORS", "warn.award.budget.effective.rate.start.date", new String[0]);
            }
            awardBudgetLineItems.add(awardBudgetLineItem);
            this.populateCalculatedAmount(awardBudgetPeriod, awardBudgetLineItem);
        }
    }

    Date getEffectiveRateStartDate(Budget awardBudget) {
        Date salaryEffectiveDate = this.getBudgetRatesService().getBudgetPersonSalaryEffectiveDate(awardBudget);
        if (salaryEffectiveDate == null || salaryEffectiveDate.after(awardBudget.getStartDate())) {
            salaryEffectiveDate = awardBudget.getStartDate();
        }
        return salaryEffectiveDate;
    }

    protected boolean adjustLineItemDatesIfNecessary(BudgetLineItemBase awardBudgetLineItem, java.sql.Date startDate, java.sql.Date endDate) {
        boolean changeLineItemDates = false;
        if (startDate != null) {
            if (startDate.after(awardBudgetLineItem.getStartDate())) {
                awardBudgetLineItem.setStartDate(startDate);
                changeLineItemDates = true;
            }
            if (startDate.after(awardBudgetLineItem.getEndDate())) {
                awardBudgetLineItem.setEndDate(endDate);
                changeLineItemDates = true;
            }
        }
        if (endDate != null) {
            if (endDate.before(awardBudgetLineItem.getEndDate())) {
                awardBudgetLineItem.setEndDate(endDate);
                changeLineItemDates = true;
            }
            if (endDate.before(awardBudgetLineItem.getStartDate())) {
                awardBudgetLineItem.setStartDate(startDate);
                changeLineItemDates = true;
            }
        }
        return changeLineItemDates;
    }

    protected void populateCalculatedAmount(AwardBudgetPeriodExt awardBudgetPeriod, AwardBudgetLineItemExt awardBudgetLineItem) {
        this.getAwardBudgetCalculationService().populateCalculatedAmount(awardBudgetPeriod.getBudget(), awardBudgetLineItem);
    }

    protected BudgetPerson findMatchingPersonInBudget(Budget budget, BudgetPerson oldBudgetPerson, String jobCode) {
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            if (!budgetPerson.isSamePerson(oldBudgetPerson) || !StringUtils.equals((CharSequence)budgetPerson.getJobCode(), (CharSequence)jobCode)) continue;
            return budgetPerson;
        }
        return null;
    }

    public AwardBudgetDocument copyBudgetVersion(AwardBudgetDocument budgetDocument) throws WorkflowException {
        return this.copyBudgetVersion(budgetDocument, false);
    }

    @Override
    public Budget copyBudgetVersion(Budget budget) {
        return this.copyBudgetVersion(budget, false);
    }

    @Override
    public void copyLineItemsFromProposalPeriods(Collection<BudgetPeriod> rawValues, BudgetPeriod awardBudgetPeriod) throws WorkflowException {
        if (!(awardBudgetPeriod instanceof AwardBudgetPeriodExt)) {
            throw new IllegalArgumentException("awardBudgetPeriod is not an AwardBudgetPeriodExt");
        }
        this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)awardBudgetPeriod.getBudgetId());
        awardBudgetPeriod.getBudgetLineItems().clear();
        for (BudgetPeriod proposalPeriod : rawValues) {
            this.copyProposalBudgetLineItemsToAwardBudget((AwardBudgetPeriodExt)awardBudgetPeriod, proposalPeriod);
        }
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)this.getDocumentService().saveDocument((Document)((AwardBudgetExt)awardBudgetPeriod.getBudget()).getBudgetDocument());
        this.getBudgetRatesService().syncBudgetRatesForRateClassType(RateClassType.INFLATION.getRateClassType(), awardBudgetDocument.getBudget());
        this.getBudgetSummaryService().calculateBudget(awardBudgetPeriod.getBudget());
    }

    protected <T extends PersistableBusinessObject> List<T> findMatching(Class<T> clazz, String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return this.getBusinessObjectService().findMatching(clazz, fieldValues);
    }

    @Override
    public List<BudgetPeriod> findBudgetPeriodsFromLinkedProposal(String awardNumber) {
        return this.findBudgetPeriodsFromLinkedProposal(this.awardService.getActiveOrNewestAward(awardNumber));
    }

    @Override
    public List<BudgetPeriod> findBudgetPeriodsFromLinkedProposal(Award award) {
        HashSet<Long> budgetIdsAdded = new HashSet<Long>();
        ArrayList<BudgetPeriod> budgetPeriods = new ArrayList<BudgetPeriod>();
        for (AwardFundingProposal fundingProposal : award.getAllFundingProposals()) {
            if (!fundingProposal.isActive()) continue;
            List<InstitutionalProposal> instProposals = this.findMatching(InstitutionalProposal.class, PROPOSAL_NUMBER, fundingProposal.getProposal().getProposalNumber());
            for (InstitutionalProposal instProp : instProposals) {
                List<ProposalAdminDetails> proposalAdminDetails = this.findMatching(ProposalAdminDetails.class, INST_PROPOSAL_ID, instProp.getProposalId());
                for (ProposalAdminDetails proposalAdminDetail : proposalAdminDetails) {
                    String developmentProposalNumber = proposalAdminDetail.getDevProposalNumber();
                    DevelopmentProposal proposalDevelopment = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)developmentProposalNumber);
                    ProposalDevelopmentBudgetExt budget = proposalDevelopment.getFinalBudget();
                    if (budgetIdsAdded.contains(budget.getBudgetId())) continue;
                    budgetIdsAdded.add(budget.getBudgetId());
                    for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                        budgetPeriod.setInstitutionalProposalNumber(instProp.getProposalNumber());
                        budgetPeriod.setInstitutionalProposalVersion(instProp.getSequenceNumber());
                        budgetPeriods.add(budgetPeriod);
                    }
                }
            }
        }
        return budgetPeriods;
    }

    @Override
    public boolean checkForOutstandingBudgets(Award award) {
        boolean result = false;
        for (AwardBudgetExt awardBudget : award.getBudgets()) {
            if (StringUtils.equals((CharSequence)awardBudget.getAwardBudgetStatusCode(), (CharSequence)this.getPostedBudgetStatus()) || StringUtils.equals((CharSequence)awardBudget.getAwardBudgetStatusCode(), (CharSequence)this.getRejectedBudgetStatus()) || StringUtils.equals((CharSequence)awardBudget.getAwardBudgetStatusCode(), (CharSequence)this.getCancelledBudgetStatus()) || StringUtils.equals((CharSequence)awardBudget.getAwardBudgetStatusCode(), (CharSequence)this.getDoNotPostBudgetStatus())) continue;
            result = true;
            GlobalVariables.getMessageMap().putError(BUDGET_VERSION_ERROR_PREFIX, "error.budget.unfinalized.exist", new String[]{StringUtils.isBlank((CharSequence)awardBudget.getName()) ? UNNAMED : awardBudget.getName()});
        }
        return result;
    }

    @Override
    public List<String> getInactiveBudgetStatus() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getRejectedBudgetStatus());
        result.add(this.getCancelledBudgetStatus());
        result.add(this.getDoNotPostBudgetStatus());
        result.add(this.getDisapprovedBudgetStatus());
        return result;
    }

    @Override
    public void populateBudgetLimitSummary(BudgetLimitSummaryHelper summary, Award award) {
        AwardBudgetExt currentBudget = this.getCurrentBudget(award);
        if (summary.getCurrentBudget() == null || !Objects.equals(summary.getCurrentBudget(), currentBudget)) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(currentBudget, false);
            summary.setCurrentBudget(currentBudget);
        }
        AwardBudgetExt prevBudget = this.getPreviousBudget(award);
        if (summary.getPreviousBudget() == null || !Objects.equals(summary.getPreviousBudget(), prevBudget)) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(prevBudget, true);
            summary.setPreviousBudget(prevBudget);
        }
    }

    protected AwardBudgetExt getCurrentBudget(Award award) {
        return this.getNewestBudgetByStatus(award, Arrays.asList("1", "5", "10"));
    }

    protected AwardBudgetExt getPreviousBudget(Award award) {
        return this.getNewestBudgetByStatus(award, Collections.singletonList(this.getPostedBudgetStatus()));
    }

    protected AwardBudgetExt getNewestBudgetByStatus(Award award, List<String> statuses) {
        AwardBudgetExt result = null;
        for (AwardBudgetExt version : award.getBudgets()) {
            if (!statuses.contains(version.getAwardBudgetStatusCode()) || result != null && version.getBudgetVersionNumber() <= result.getBudgetVersionNumber()) continue;
            result = version;
        }
        if (result == null) {
            result = new AwardBudgetExt();
        }
        return result;
    }

    @Override
    public List<AwardBudgetExt> getAllBudgetsForAward(Award award) {
        HashSet<AwardBudgetExt> result = new HashSet<AwardBudgetExt>();
        List<VersionHistory> versions = this.getVersionHistoryService().loadVersionHistory(Award.class, award.getAwardNumber());
        for (VersionHistory version : versions) {
            if (version.getSequenceOwnerSequenceNumber() > award.getSequenceNumber() || version.getSequenceOwner() == null || ((Award)version.getSequenceOwner()).getAwardDocument() == null) continue;
            result.addAll(((Award)version.getSequenceOwner()).getCurrentVersionBudgets());
        }
        ArrayList<AwardBudgetExt> listResult = new ArrayList<AwardBudgetExt>(result);
        Collections.sort(listResult);
        return listResult;
    }

    @Override
    public Award getActiveOrNewestAward(String awardNumber) {
        return this.awardService.getActiveOrNewestAward(awardNumber);
    }

    protected String getPostedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusPosted");
    }

    protected String getRejectedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusReturned");
    }

    protected String getCancelledBudgetStatus() {
        return "14";
    }

    protected String getDisapprovedBudgetStatus() {
        return "13";
    }

    protected String getDoNotPostBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusDoNotPost");
    }

    @Override
    public boolean isRateOverridden(BudgetPeriod budgetPeriod) {
        return ((AwardBudgetPeriodExt)budgetPeriod).getRateOverrideFlag();
    }

    @Override
    public void recalculateBudget(Budget budget) {
        List<BudgetPeriod> awardBudgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : awardBudgetPeriods) {
            this.removeBudgetSummaryPeriodCalcAmounts(budgetPeriod);
        }
        this.getAwardBudgetCalculationService().calculateBudget(budget);
        this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(budget);
    }

    @Override
    public void recalculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.removeBudgetSummaryPeriodCalcAmounts(budgetPeriod);
        this.getAwardBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
    }

    @Override
    public void calculateBudgetOnSave(Budget budget) {
        this.getAwardBudgetCalculationService().calculateBudget(budget);
        this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(budget);
        budget.getBudgetPeriods().stream().map(period -> (AwardBudgetPeriodExt)period).forEach(period -> {
            period.setTotalDirectCost(this.calculateTotalDirectCost((AwardBudgetPeriodExt)period));
            period.setTotalCost(this.calculateTotalCost((AwardBudgetPeriodExt)period));
        });
        this.setBudgetCostsFromPeriods(budget);
    }

    protected ScaleTwoDecimal calculateTotalDirectCost(AwardBudgetPeriodExt budgetPeriod) {
        ScaleTwoDecimal previousFringeTotal = budgetPeriod.getPrevTotalFringeAmount();
        ScaleTwoDecimal totalFringeAmount = budgetPeriod.getTotalFringeAmount();
        ScaleTwoDecimal fringeAmountDiff = (ScaleTwoDecimal)totalFringeAmount.subtract((AbstractDecimal)previousFringeTotal);
        return (ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().add((AbstractDecimal)fringeAmountDiff);
    }

    protected ScaleTwoDecimal calculateTotalCost(AwardBudgetPeriodExt budgetPeriod) {
        return (ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().add((AbstractDecimal)budgetPeriod.getTotalIndirectCost());
    }

    @Override
    public void populateSummaryCalcAmounts(Budget budget, BudgetPeriod budgetPeriod) {
        AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
        List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts = awardBudgetPeriod.getAwardBudgetPeriodFringeAmounts();
        awardBudgetPeriodFringeAmounts.clear();
        if (awardBudgetPeriodFringeAmounts.isEmpty()) {
            SortedMap<String, List<ScaleTwoDecimal>> objectCodePersonnelFringe = budget.getObjectCodePersonnelFringeTotals();
            if (objectCodePersonnelFringe != null) {
                for (String costElement : objectCodePersonnelFringe.keySet()) {
                    String[] costElementAndPersonId = costElement.split(",");
                    List fringeTotals = (List)objectCodePersonnelFringe.get(costElement);
                    AwardBudgetPeriodSummaryCalculatedAmount oldAwardBudgetPeriodSummaryCalculatedAmount = this.getSummaryCalculatedAmountFromList(awardBudgetPeriodFringeAmounts, costElementAndPersonId[0]);
                    if (oldAwardBudgetPeriodSummaryCalculatedAmount == null) {
                        AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = this.createNewAwardBudgetPeriodSummaryCalculatedAmount(awardBudgetPeriod, costElementAndPersonId[0], RateClassType.EMPLOYEE_BENEFITS.getRateClassType(), (ScaleTwoDecimal)fringeTotals.get(budgetPeriod.getBudgetPeriod() - 1));
                        awardBudgetPeriodFringeAmounts.add(awardBudgetPeriodSummaryCalculatedAmount);
                        continue;
                    }
                    oldAwardBudgetPeriodSummaryCalculatedAmount.setCalculatedCost((ScaleTwoDecimal)oldAwardBudgetPeriodSummaryCalculatedAmount.getCalculatedCost().add((AbstractDecimal)((ScaleTwoDecimal)fringeTotals.get(budgetPeriod.getBudgetPeriod() - 1))));
                }
            }
            QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = this.filterEBRates(awardBudgetPeriod);
            awardBudgetPeriod.setTotalFringeAmount(ebCalculatedAmounts.sumObjects(CALCULATED_COST));
        }
    }

    private AwardBudgetPeriodSummaryCalculatedAmount getSummaryCalculatedAmountFromList(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts, String costElement) {
        for (AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount : awardBudgetPeriodFringeAmounts) {
            if (!awardBudgetPeriodSummaryCalculatedAmount.getCostElement().equals(costElement)) continue;
            return awardBudgetPeriodSummaryCalculatedAmount;
        }
        return null;
    }

    private QueryList<AwardBudgetPeriodSummaryCalculatedAmount> filterEBRates(AwardBudgetPeriodExt budgetPeriod) {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> qlAwardBudgetPeriodSummaryCalculatedAmounts = new QueryList<AwardBudgetPeriodSummaryCalculatedAmount>(budgetPeriod.getAwardBudgetPeriodFringeAmounts());
        Equals ebClassType = new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        return qlAwardBudgetPeriodSummaryCalculatedAmounts.filter(ebClassType);
    }

    private AwardBudgetPeriodSummaryCalculatedAmount createNewAwardBudgetPeriodSummaryCalculatedAmount(AwardBudgetPeriodExt budgetPeriodExt, String costElement, String rateClassType, ScaleTwoDecimal calculatedCost) {
        AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = new AwardBudgetPeriodSummaryCalculatedAmount();
        awardBudgetPeriodSummaryCalculatedAmount.setBudgetPeriodId(budgetPeriodExt.getBudgetPeriodId());
        awardBudgetPeriodSummaryCalculatedAmount.setCalculatedCost(calculatedCost);
        awardBudgetPeriodSummaryCalculatedAmount.setCostElement(costElement);
        awardBudgetPeriodSummaryCalculatedAmount.setRateClassType(rateClassType);
        return awardBudgetPeriodSummaryCalculatedAmount;
    }

    protected void setBudgetCostsFromPeriods(Budget budget) {
        assert (budget != null) : "The document is null";
        budget.setTotalDirectCost(budget.getSumDirectCostAmountFromPeriods());
        budget.setTotalIndirectCost(budget.getSumIndirectCostAmountFromPeriods());
        budget.setTotalCost(budget.getSumTotalCostAmountFromPeriods());
        budget.setUnderrecoveryAmount(budget.getSumUnderreoveryAmountFromPeriods());
        budget.setCostSharingAmount(budget.getSumCostSharingAmountFromPeriods());
    }

    @Override
    public void removeBudgetSummaryPeriodCalcAmounts(BudgetPeriod budgetPeriod) {
        AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
        awardBudgetPeriod.setTotalFringeAmount(null);
        awardBudgetPeriod.getAwardBudgetPeriodFringeAmounts().clear();
        awardBudgetPeriod.getAwardBudgetPeriodFnAAmounts().clear();
        awardBudgetPeriod.setfAndAOverridden(false);
        awardBudgetPeriod.setFringeOverridden(false);
    }

    @Override
    public boolean validateAddingNewBudget(BudgetParentDocument<Award> parentDocument) {
        AwardDocument awardDocument = (AwardDocument)parentDocument;
        return !this.checkForOutstandingBudgets(awardDocument.getAward());
    }

    @Override
    public boolean checkRateChange(Collection<BudgetRate> savedBudgetRates, Award award) {
        award.refreshReferenceObject(AWARD_FANDA_RATE);
        List<AwardFandaRate> awardFandaRates = award.getAwardFandaRate();
        boolean changeFlag = false;
        for (AwardFandaRate awardFnARate : awardFandaRates) {
            Equals eqCampusFlag;
            Equals eqRateTypeCode;
            RateType fnaRateType = awardFnARate.getFandaRateType();
            Equals eqRateClasCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)fnaRateType.getRateClassCode()));
            And rateClassAndRateType = new And(eqRateClasCode, eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)fnaRateType.getRateTypeCode())));
            And rateClassAndRateTypeAndCampusFlag = new And(rateClassAndRateType, eqCampusFlag = new Equals(ON_OFF_CAMPUS_FLAG, awardFnARate.getOnOffCampusFlag()));
            QueryList<BudgetRate> matchedProposalRate = new QueryList<BudgetRate>(savedBudgetRates).filter(rateClassAndRateTypeAndCampusFlag);
            if (!matchedProposalRate.isEmpty() && matchedProposalRate.size() <= 1 && matchedProposalRate.get(0).getApplicableRate().equals((Object)awardFnARate.getApplicableFandaRate())) continue;
            changeFlag = true;
        }
        Equals eqRateClasCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)this.getBudgetParameterValue("awardBudgetEbRateClassCode")));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)this.getBudgetParameterValue("awardBudgetEbRateTypeCode")));
        And rateClassAndRateType = new And(eqRateClasCode, eqRateTypeCode);
        QueryList<BudgetRate> matchAwardEBCampusRates = new QueryList<BudgetRate>(savedBudgetRates).filter(rateClassAndRateType);
        for (BudgetRate budgetEBRate : matchAwardEBCampusRates) {
            if (budgetEBRate.getOnOffCampusFlag().booleanValue()) {
                if (award.getSpecialEbRateOnCampus() == null || award.getSpecialEbRateOnCampus().equals((Object)budgetEBRate.getApplicableRate())) continue;
                changeFlag = true;
                continue;
            }
            if (award.getSpecialEbRateOffCampus() == null || award.getSpecialEbRateOffCampus().equals((Object)budgetEBRate.getApplicableRate())) continue;
            changeFlag = true;
        }
        if ((award.getSpecialEbRateOnCampus() != null || award.getSpecialEbRateOffCampus() != null) && matchAwardEBCampusRates.isEmpty()) {
            changeFlag = true;
        }
        return changeFlag;
    }

    @Override
    public boolean isBudgetVersionNameValid(BudgetParent parent, String name) {
        try {
            return this.getAddBudgetVersionRule().processAddBudgetVersion(new AddBudgetVersionEvent(BUDGET_VERSION_ERROR_PREFIX, parent, name));
        }
        catch (WorkflowException e) {
            LOG.error((Object)e);
            return false;
        }
    }

    public BudgetVersionRule getAddBudgetVersionRule() {
        if (this.addBudgetVersionRule == null) {
            this.addBudgetVersionRule = new AwardBudgetVersionRule();
        }
        return this.addBudgetVersionRule;
    }

    public void setAddBudgetVersionRule(BudgetVersionRule addBudgetVersionRule) {
        this.addBudgetVersionRule = addBudgetVersionRule;
    }

    @Override
    public void populateNewBudgetLineItem(BudgetLineItem newBudgetLineItem, BudgetPeriod budgetPeriod) {
        List<String> formulatedCostElements;
        Budget budget = budgetPeriod.getBudget();
        newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
        newBudgetLineItem.setBudgetPeriodBO(budgetPeriod);
        newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
        newBudgetLineItem.setStartDate(budgetPeriod.getStartDate());
        newBudgetLineItem.setEndDate(budgetPeriod.getEndDate());
        newBudgetLineItem.setBudgetId(budget.getBudgetId());
        newBudgetLineItem.setLineItemNumber(budget.getNextValue("budget.budgetLineItem.lineItemNumber"));
        newBudgetLineItem.setApplyInRateFlag(true);
        newBudgetLineItem.setSubmitCostSharingFlag(budget.getSubmitCostSharingFlag());
        this.refreshBudgetLineCostElement(newBudgetLineItem);
        String onOffCampusFlag = budget.getOnOffCampusFlag();
        if (onOffCampusFlag.equalsIgnoreCase("D")) {
            newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
        } else {
            newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
        }
        newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
        newBudgetLineItem.setLineItemSequence(newBudgetLineItem.getLineItemNumber());
        this.refreshBudgetLineBudgetCategory(newBudgetLineItem);
        if (this.isBudgetFormulatedCostEnabled() && (formulatedCostElements = this.getFormulatedCostElements()).contains(newBudgetLineItem.getCostElement())) {
            newBudgetLineItem.setFormulatedCostElementFlag(true);
        }
    }

    protected void refreshBudgetLineCostElement(BudgetLineItem newBudgetLineItem) {
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getCostElement())) {
            this.getLegacyDataAdapter().refreshReferenceObject((Object)newBudgetLineItem, COST_ELEMENT_BO);
        }
    }

    protected void refreshBudgetLineBudgetCategory(BudgetLineItem newBudgetLineItem) {
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getBudgetCategoryCode())) {
            this.getLegacyDataAdapter().refreshReferenceObject((Object)newBudgetLineItem, BUDGET_CATEGORY);
        }
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected AwardBudgetCalculationService getAwardBudgetCalculationService() {
        return this.awardBudgetCalculationService;
    }

    public void setAwardBudgetCalculationService(AwardBudgetCalculationService awardBudgetCalculationService) {
        this.awardBudgetCalculationService = awardBudgetCalculationService;
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public BudgetRatesService getBudgetRatesService() {
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    @Override
    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public BudgetAdjustmentClient getBudgetAdjustmentClient() {
        return this.budgetAdjustmentClient;
    }

    public void setBudgetAdjustmentClient(BudgetAdjustmentClient budgetAdjustmentClient) {
        this.budgetAdjustmentClient = budgetAdjustmentClient;
    }
}

