/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.contacts.AwardContactsProjectRoleValuesFinder;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSponsorContactProjectRolesValuesFinder
extends AwardContactsProjectRoleValuesFinder {
    private ParameterService parameterService;
    private KcAuthorizationService kcAuthorizationService;

    public List getKeyValues() {
        List<KeyValue> keyValues = this.buildKeyValues(this.getKeyValuesService().findAllOrderBy(this.getRoleType(), "description", true));
        if (this.canLimitedModifyAwardSponsorContacts()) {
            List<String> contactTypes = this.getLimitedEditabilityAwardSponsorContactTypes();
            return keyValues.stream().filter(keyValue -> contactTypes.contains(keyValue.getKey()) || keyValue.getKey().isEmpty()).collect(Collectors.toList());
        }
        return keyValues;
    }

    @Override
    protected Class<? extends ContactRole> getRoleType() {
        return ContactType.class;
    }

    private List<String> getLimitedEditabilityAwardSponsorContactTypes() {
        String sponsorContactTypes = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "LIMITED_EDITABILITY_AWARD_SPONSOR_CONTACT_TYPES");
        if (StringUtils.isBlank((CharSequence)sponsorContactTypes)) {
            return Collections.emptyList();
        }
        return Arrays.stream(sponsorContactTypes.split(",")).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.toList());
    }

    private boolean canLimitedModifyAwardSponsorContacts() {
        AwardDocument awardDocument = (AwardDocument)this.getDocument();
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return awardDocument != null && this.getKcAuthorizationService().hasPermission(principalId, awardDocument, AwardPermissionConstants.LIMITED_MODIFY_AWARD_SPONSOR_CONTACTS.getAwardPermission()) && awardDocument.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public KcAuthorizationService getKcAuthorizationService() {
        if (this.kcAuthorizationService == null) {
            this.kcAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        }
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }
}

