/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.printing.AwardPrintParameters;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBudgetBaseStream;
import org.kuali.kra.printing.schema.AmountInfoType;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardType;

public class AwardBudgetHistoryTransactionXmlStream
extends AwardBudgetBaseStream {
    private static final String AWARD_AMOUNT_INFO_MODIFIED_VALUE = "1";
    private VersionHistoryService versionHistoryService;

    @Override
    public Map<String, AwardNoticeDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        HashMap<String, AwardNoticeDocument> budgetHierarchyMap = new HashMap<String, AwardNoticeDocument>();
        Award award = (Award)printableBusinessObject;
        Integer sequenceNumber = (Integer)reportParameters.get(AwardPrintParameters.SEQUENCE_NUMBER.getAwardPrintParameter());
        int transactionId = (Integer)reportParameters.get(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter());
        award = this.getAwardVersion(award.getAwardNumber(), sequenceNumber);
        AwardNoticeDocument awardNoticeDocument = AwardNoticeDocument.Factory.newInstance();
        AwardNoticeDocument.AwardNotice awardNotice = AwardNoticeDocument.AwardNotice.Factory.newInstance();
        awardNotice.setAward(this.getAwardType(award, transactionId));
        awardNotice.setSchoolInfo(this.getSchoolInfoType());
        awardNoticeDocument.setAwardNotice(awardNotice);
        budgetHierarchyMap.put(AwardPrintType.AWARD_BUDGET_HISTORY_TRANSACTION.getAwardPrintType(), awardNoticeDocument);
        return budgetHierarchyMap;
    }

    private Award getAwardVersion(String awardNumber, Integer sequenceNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("awardNumber", awardNumber);
        fieldValues.put("sequenceNumber", sequenceNumber);
        List awards = this.businessObjectService.findMatching(Award.class, fieldValues);
        return (Award)awards.iterator().next();
    }

    private AwardType getAwardType(Award award, int transactionIdx) {
        AwardType awardType = AwardType.Factory.newInstance();
        awardType.setAwardAmountInfo(this.getAwardAmountInfo(award, transactionIdx));
        awardType.setAwardTransactionInfo(this.getAwardTransactiontInfo(award));
        return awardType;
    }

    private AwardType.AwardAmountInfo getAwardAmountInfo(Award award, int transactionIdx) {
        AwardType.AwardAmountInfo awardAmountInfo = AwardType.AwardAmountInfo.Factory.newInstance();
        ArrayList<AmountInfoType> amountInfoTypes = new ArrayList<AmountInfoType>();
        AwardAmountInfo amountInfo = award.getAwardAmountInfos().get(transactionIdx);
        if (amountInfo != null) {
            AmountInfoType amountInfoType = this.setAwardAmountInfo(award, amountInfo, amountInfo.getTransactionId());
            AwardAmountInfo prevAwardAmount = this.getPrevAwardAmountInfo(award, amountInfo.getTransactionId(), award.getAwardNumber());
            this.setAwardAmountInfoModifiedValues(amountInfoType, amountInfo, prevAwardAmount);
            amountInfoTypes.add(amountInfoType);
            awardAmountInfo.setAmountInfoArray(amountInfoTypes.toArray(new AmountInfoType[0]));
        }
        return awardAmountInfo;
    }

    private void setAwardAmountInfoModifiedValues(AmountInfoType amountInfoType, AwardAmountInfo awrdAmountInfo, AwardAmountInfo prevAwardAmount) {
        if (prevAwardAmount != null) {
            if (!prevAwardAmount.getAmountObligatedToDate().equals((Object)awrdAmountInfo.getAmountObligatedToDate())) {
                amountInfoType.setAmtObligatedToDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getObliDistributableAmount().equals((Object)awrdAmountInfo.getObliDistributableAmount())) {
                amountInfoType.setObligatedDistributableAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getAnticipatedTotalAmount().equals((Object)awrdAmountInfo.getAnticipatedTotalAmount())) {
                amountInfoType.setAnticipatedTotalAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getAntDistributableAmount().equals((Object)awrdAmountInfo.getAntDistributableAmount())) {
                amountInfoType.setAnticipatedDistributableAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getObligationExpirationDate() != null && !prevAwardAmount.getObligationExpirationDate().equals(awrdAmountInfo.getObligationExpirationDate())) {
                amountInfoType.setObligationExpDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getCurrentFundEffectiveDate() != null && !prevAwardAmount.getCurrentFundEffectiveDate().equals(awrdAmountInfo.getCurrentFundEffectiveDate())) {
                amountInfoType.setCurrentFundEffectiveDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getFinalExpirationDate() != null && !prevAwardAmount.getFinalExpirationDate().equals(awrdAmountInfo.getFinalExpirationDate())) {
                amountInfoType.setFinalExpDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
        }
    }

    private AwardAmountInfo getPrevAwardAmountInfo(Award award, Long transactionId, String awardNumber) {
        if (transactionId != null) {
            AwardAmountInfo prevAwardAmount = award.getAwardAmountInfos().get(0);
            for (AwardAmountInfo curInfo : award.getAwardAmountInfos()) {
                if (Objects.equals(curInfo.getTransactionId(), transactionId)) break;
                if (curInfo.getTransactionId() == null) continue;
                prevAwardAmount = curInfo;
            }
            return prevAwardAmount;
        }
        return null;
    }

    private AmountInfoType setAwardAmountInfo(Award award, AwardAmountInfo awardAmount, Long transacationIdValue) {
        AmountInfoType amountInfoType = AmountInfoType.Factory.newInstance();
        amountInfoType.setTransactionDate(this.dateTimeService.getCalendar((Date)awardAmount.getUpdateTimestamp()));
        if (award.getAccountNumber() != null) {
            amountInfoType.setAccountNumber(award.getAccountNumber());
        }
        if (transacationIdValue != null) {
            amountInfoType.setAmountSequenceNumber(transacationIdValue.intValue());
        }
        if (awardAmount.getAmountObligatedToDate() != null) {
            amountInfoType.setAmtObligatedToDate(awardAmount.getAmountObligatedToDate().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChange() != null) {
            amountInfoType.setAnticipatedChange(awardAmount.getAnticipatedChange().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedChange(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeDirect() != null) {
            amountInfoType.setAnticipatedChangeDirect(awardAmount.getAnticipatedChangeDirect().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedChangeDirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeIndirect() != null) {
            amountInfoType.setAnticipatedChangeIndirect(awardAmount.getAnticipatedChangeIndirect().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedChangeIndirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAntDistributableAmount() != null) {
            amountInfoType.setAnticipatedDistributableAmt(awardAmount.getAntDistributableAmount().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedDistributableAmt(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalAmount() != null) {
            amountInfoType.setAnticipatedTotalAmt(awardAmount.getAnticipatedTotalAmount().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedTotalAmt(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalDirect() != null) {
            amountInfoType.setAnticipatedTotalDirect(awardAmount.getAnticipatedTotalDirect().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedTotalDirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalIndirect() != null) {
            amountInfoType.setAnticipatedTotalIndirect(awardAmount.getAnticipatedTotalIndirect().bigDecimalValue());
        } else {
            amountInfoType.setAnticipatedTotalIndirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        amountInfoType.setAwardNumber(award.getAwardNumber());
        if (awardAmount.getObligatedChange() != null) {
            amountInfoType.setObligatedChange(awardAmount.getObligatedChange().bigDecimalValue());
        } else {
            amountInfoType.setObligatedChange(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getObligatedChangeDirect() != null) {
            amountInfoType.setObligatedChangeDirect(awardAmount.getObligatedChangeDirect().bigDecimalValue());
        } else {
            amountInfoType.setObligatedChangeDirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getObligatedChangeIndirect() != null) {
            amountInfoType.setObligatedChangeIndirect(awardAmount.getObligatedChangeIndirect().bigDecimalValue());
        } else {
            amountInfoType.setObligatedChangeIndirect(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getObliDistributableAmount() != null) {
            amountInfoType.setObligatedDistributableAmt(awardAmount.getObliDistributableAmount().bigDecimalValue());
        } else {
            amountInfoType.setObligatedDistributableAmt(ScaleTwoDecimal.ZERO.bigDecimalValue());
        }
        if (awardAmount.getFinalExpirationDate() != null) {
            amountInfoType.setFinalExpirationDate(this.dateTimeService.getCalendar((Date)awardAmount.getFinalExpirationDate()));
        }
        if (awardAmount.getObligationExpirationDate() != null) {
            amountInfoType.setObligationExpirationDate(this.dateTimeService.getCalendar((Date)awardAmount.getObligationExpirationDate()));
        }
        if (awardAmount.getObligatedTotalIndirect() != null) {
            amountInfoType.setObligatedTotalIndirect(awardAmount.getObligatedTotalIndirect().bigDecimalValue());
        }
        if (awardAmount.getObligatedTotalDirect() != null) {
            amountInfoType.setObligatedTotalDirect(awardAmount.getObligatedTotalDirect().bigDecimalValue());
        }
        if (awardAmount.getCurrentFundEffectiveDate() != null) {
            amountInfoType.setCurrentFundEffectiveDate(this.dateTimeService.getCalendar((Date)awardAmount.getCurrentFundEffectiveDate()));
        }
        return amountInfoType;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

