/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.dao.ojb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.dao.ExconProjectLookupDao;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;

public class ExconProjectLookupDaoOjb
extends LookupDaoOjb
implements ExconProjectLookupDao {
    @Override
    public List<ExconProject> getActiveExconProjectSearchResults(Map<String, String> fieldValues) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"BOTH", (CharSequence)fieldValues.get(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING))) {
            fieldValues.put(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING, "ACTIVE|PENDING");
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ExconProject(), fieldValues);
        criteria.addIn((Object)"projectId", this.getActiveExconProjectIdsQuery());
        QueryByCriteria query = QueryFactory.newQuery(ExconProject.class, (Criteria)criteria, (boolean)false);
        query.addOrderByAscending("projectNumber");
        ArrayList<ExconProject> searchResults = new ArrayList<ExconProject>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query));
        return searchResults;
    }

    private Query getActiveExconProjectIdsQuery() {
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ExconProject.class, (Criteria)new Criteria());
        query.addGroupBy("projectNumber");
        query.setAttributes(new String[]{"max(projectId)"});
        return query;
    }
}

