/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.home;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.framework.keyword.KeywordsManager;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.common.framework.noo.NoticeOfOpportunity;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PrincipalInvestigatorAware;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.type.ProposalType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ValuableItem;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.institutionalproposal.ProposalIpReviewJoin;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.attachments.InstitutionalProposalAttachment;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalFandA;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPersonService;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposal
extends KcPersistableBusinessObjectBase
implements KeywordsManager<InstitutionalProposalScienceKeyword>,
SequenceOwner<InstitutionalProposal>,
Sponsorable,
CustomDataContainer,
Negotiable,
PrincipalInvestigatorAware {
    public static final String PROPOSAL_ID_PROPERTY_STRING = "proposalId";
    public static final String PROPOSAL_NUMBER_PROPERTY_STRING = "proposalNumber";
    public static final String PROPOSAL_SEQUENCE_STATUS_PROPERTY_STRING = "proposalSequenceStatus";
    public static final String PROPOSAL_NUMBER_TEST_DEFAULT_STRING = "1234";
    private static final long serialVersionUID = 1L;
    private static final Integer PROPOSAL_PENDING_STATUS_CODE = 1;
    private static final Integer PROPOSAL_FUNDED_STATUS_CODE = 2;
    public static final String PROPOSAL_STATUS = "proposalStatus";
    public static final String PROPOSAL_TYPE = "proposalType";
    public static final String SPONSOR = "sponsor";
    public static final String PRIME_SPONSOR = "primeSponsor";
    public static final String PROPOSAL_TYPE_CODE = "proposalTypeCode";
    public static final String COMMENT_TYPE = "commentType";
    public static final String ACTIVITY_TYPE = "activityType";
    public static final String ACTIVITY_CODE = "code";
    public static final String SELECT = "(select)";
    private static final Logger LOG = LogManager.getLogger(InstitutionalProposal.class);
    private InstitutionalProposalDocument institutionalProposalDocument;
    private Long proposalId;
    private String proposalNumber;
    private String sponsorProposalNumber;
    private Integer sequenceNumber;
    private Integer proposalTypeCode;
    private String currentAccountNumber;
    private String title;
    private String sponsorCode;
    private Integer rolodexId;
    private String noticeOfOpportunityCode;
    private Integer gradStudHeadcount;
    private ScaleTwoDecimal gradStudPersonMonths;
    private boolean typeOfAccount;
    private String activityTypeCode;
    private Date requestedStartDateInitial;
    private Date requestedStartDateTotal;
    private Date requestedEndDateInitial;
    private Date requestedEndDateTotal;
    private String fiscalMonth;
    private String fiscalYear;
    private ScaleTwoDecimal totalDirectCostInitial;
    private ScaleTwoDecimal totalDirectCostTotal;
    private ScaleTwoDecimal totalIndirectCostInitial;
    private ScaleTwoDecimal totalIndirectCostTotal;
    private String numberOfCopies;
    private Date deadlineDate;
    private String deadlineTime;
    private Date createTimestamp;
    private String deadlineType;
    private String mailBy;
    private String mailType;
    private String mailAccountNumber;
    private String mailDescription;
    private Boolean subcontractFlag;
    private String costSharingIndicator;
    private String idcRateIndicator;
    private String specialReviewIndicator;
    private Integer statusCode;
    private String unitNumber;
    private String scienceCodeIndicator;
    private Integer nsfSequenceNumber;
    private NsfCode nsfCodeBo;
    private String primeSponsorCode;
    private String initialContractAdmin;
    private String ipReviewActivityIndicator;
    private String currentAwardNumber;
    private String opportunity;
    private Integer awardTypeCode;
    private String newDescription;
    private String proposalSequenceStatus;
    private boolean showReturnLink;
    private String instProposalNumber;
    private NoticeOfOpportunity noticeOfOpportunity;
    private ProposalType proposalType;
    private Rolodex rolodex;
    private Sponsor sponsor;
    private Sponsor primeSponsor;
    private ActivityType activityType;
    private AwardType awardType;
    private ProposalStatus proposalStatus;
    private Unit leadUnit;
    private KcPerson ospAdministrator;
    private InstitutionalProposalScienceKeyword proposalScienceKeyword;
    private InstitutionalProposalCostShare proposalCostSharing;
    private InstitutionalProposalPersonCreditSplit proposalPerCreditSplit;
    private ProposalUnitCreditSplit proposalUnitCreditSplit;
    private List<InstitutionalProposalComment> proposalComments;
    private List<InstitutionalProposalCfda> proposalCfdas;
    private IntellectualPropertyReview intellectualPropertyReview;
    private static final String DEFAULT_VALUE = "0";
    private static final int INITIAL_SEQUENCE_NUMBER = 1;
    private static final String ACTIVE = "A";
    private static final String INSTITUTIONAL_PROPOSAL_DOCUMENT = "institutionalProposalDocument";
    private List<ProposalIpReviewJoin> proposalIpReviewJoins;
    private List<InstitutionalProposalPerson> projectPersons;
    private List<InstitutionalProposalUnitContact> institutionalProposalUnitContacts = new ArrayList<InstitutionalProposalUnitContact>();
    private List<InstitutionalProposalCustomData> institutionalProposalCustomDataList;
    private List<InstitutionalProposalNotepad> institutionalProposalNotepads;
    private List<InstitutionalProposalSpecialReview> specialReviews;
    private List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords;
    private List<InstitutionalProposalCostShare> institutionalProposalCostShares;
    private List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs;
    private List<InstitutionalProposalFandA> institutionalProposalFandAs;
    @SkipVersioning
    private List<AwardFundingProposal> awardFundingProposals;
    @SkipVersioning
    private List<AwardFundingProposal> allFundingProposals;
    private Map<String, InstitutionalProposalComment> commentMap;
    private boolean sponsorNihMultiplePi;
    private transient Unit lookupUnit;
    private transient String lookupUnitName;
    private transient String lookupUnitNumber;
    private transient String lookupPersonNumber;
    private transient String devProposalNumber;
    private transient FiscalYearMonthService fiscalYearMonthService;
    private transient ProposalLogService proposalLogService;
    private transient BusinessObjectService businessObjectService;
    private transient UnitService unitService;
    private transient InstitutionalProposalService institutionalProposalService;
    private List<InstitutionalProposalAttachment> instProposalAttachments;
    private transient boolean allowUpdateTimestampToBeReset = true;
    private transient boolean allowUpdateUserToBeReset = true;
    @SkipVersioning
    private transient KcPersonService kcPersonService;
    @SkipVersioning
    private transient InstitutionalProposalPersonService institutionalProposalPersonService;

    public InstitutionalProposal() {
        this.initializeInstitutionalProposalWithDefaultValues();
        this.initializeCollections();
        this.calculateFiscalMonthAndYearFields();
    }

    public void initializeInstitutionalProposalWithDefaultValues() {
        this.setSequenceNumber(1);
        this.setCostSharingIndicator(DEFAULT_VALUE);
        this.setIdcRateIndicator(DEFAULT_VALUE);
        this.setSpecialReviewIndicator(DEFAULT_VALUE);
        this.setScienceCodeIndicator(DEFAULT_VALUE);
        this.ipReviewActivityIndicator = ACTIVE;
        Calendar cl = Calendar.getInstance();
        this.setCreateTimestamp(new Date(cl.getTime().getTime()));
        this.setTotalDirectCostInitial(ScaleTwoDecimal.ZERO);
        this.setTotalDirectCostTotal(ScaleTwoDecimal.ZERO);
        this.setTotalIndirectCostInitial(ScaleTwoDecimal.ZERO);
        this.setTotalIndirectCostTotal(ScaleTwoDecimal.ZERO);
        this.newDescription = this.getDefaultNewDescription();
        this.setProposalSequenceStatus(VersionStatus.PENDING.toString());
        this.setStatusCode(1);
        this.projectPersons = new ArrayList<InstitutionalProposalPerson>();
        this.showReturnLink = true;
    }

    public void initializeCollections() {
        this.institutionalProposalCustomDataList = new ArrayList<InstitutionalProposalCustomData>();
        this.specialReviews = new ArrayList<InstitutionalProposalSpecialReview>();
        this.institutionalProposalScienceKeywords = new ArrayList<InstitutionalProposalScienceKeyword>();
        this.institutionalProposalCostShares = new ArrayList<InstitutionalProposalCostShare>();
        this.institutionalProposalUnrecoveredFandAs = new ArrayList<InstitutionalProposalUnrecoveredFandA>();
        this.proposalIpReviewJoins = new ArrayList<ProposalIpReviewJoin>();
        this.proposalIpReviewJoins.add(new ProposalIpReviewJoin());
        this.awardFundingProposals = new ArrayList<AwardFundingProposal>();
        this.allFundingProposals = new ArrayList<AwardFundingProposal>();
        this.institutionalProposalUnitContacts = new ArrayList<InstitutionalProposalUnitContact>();
        this.institutionalProposalFandAs = new ArrayList<InstitutionalProposalFandA>();
        this.proposalComments = new ArrayList<InstitutionalProposalComment>();
        this.proposalCfdas = new ArrayList<InstitutionalProposalCfda>();
    }

    public void setDefaultInitialContractAdmin() {
        if (!StringUtils.isBlank((CharSequence)this.getUnitNumber())) {
            List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.getUnitNumber());
            unitAdministrators.stream().filter(unitAdministrator -> "2".equals(unitAdministrator.getUnitAdministratorTypeCode())).forEach(unitAdministrator -> this.setInitialContractAdmin(unitAdministrator.getPersonId()));
        }
    }

    public void deactivateFundingProposals() {
        this.getAwardFundingProposals().forEach(fundingProposal -> fundingProposal.setActive(false));
    }

    public void activateFundingProposals() {
        this.getAwardFundingProposals().forEach(fundingProposal -> fundingProposal.setActive(true));
    }

    public boolean isActiveVersion() {
        return this.getProposalSequenceStatus().equals(VersionStatus.ACTIVE.toString());
    }

    public boolean isCancelled() {
        return this.getProposalSequenceStatus().equals(VersionStatus.CANCELED.toString());
    }

    public boolean isFundedByAward(String awardNumber, Integer awardSequence) {
        for (AwardFundingProposal awardFundingProposal : this.getAwardFundingProposals()) {
            if (!awardFundingProposal.getAward().getAwardNumber().equals(awardNumber) || !awardFundingProposal.getAward().getSequenceNumber().equals(awardSequence)) continue;
            return true;
        }
        return false;
    }

    protected void calculateFiscalMonthAndYearFields() {
        Object monthString = this.getFiscalYearMonthService().getCurrentFiscalMonthForDisplay().toString();
        if (((String)monthString).length() == 1) {
            monthString = DEFAULT_VALUE + (String)monthString;
        }
        this.setFiscalMonth((String)monthString);
        this.setFiscalYear(this.getFiscalYearMonthService().getCurrentFiscalYear().toString());
    }

    public InstitutionalProposalDocument getInstitutionalProposalDocument() {
        if (this.institutionalProposalDocument == null) {
            this.refreshReferenceObject(INSTITUTIONAL_PROPOSAL_DOCUMENT);
        }
        if (this.institutionalProposalDocument != null && this.institutionalProposalDocument.getDocumentHeader() != null && this.institutionalProposalDocument.getDocumentNumber() != null && !this.institutionalProposalDocument.getDocumentHeader().hasWorkflowDocument() && GlobalVariables.getUserSession() != null) {
            this.institutionalProposalDocument.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)GlobalVariables.getUserSession().getPrincipalId(), (String)this.institutionalProposalDocument.getDocumentNumber()));
        }
        return this.institutionalProposalDocument;
    }

    public void setInstitutionalProposalDocument(InstitutionalProposalDocument institutionalProposalDocument) {
        this.institutionalProposalDocument = institutionalProposalDocument;
    }

    public void add(AwardFundingProposal afp) {
        this.awardFundingProposals.add(afp);
    }

    public void add(InstitutionalProposalFandA fandA) {
        fandA.setInstitutionalProposal(this);
        this.institutionalProposalFandAs.add(fandA);
    }

    public void add(InstitutionalProposalNotepad institutionalProposalNotepad) {
        institutionalProposalNotepad.setEntryNumber(this.getInstitutionalProposalNotepads().size() + 1);
        institutionalProposalNotepad.setProposalNumber(this.getProposalNumber());
        this.getInstitutionalProposalNotepads().add(institutionalProposalNotepad);
        institutionalProposalNotepad.setInstitutionalProposal(this);
    }

    public void add(InstitutionalProposalCostShare institutionalProposalCostShare) {
        institutionalProposalCostShare.setInstitutionalProposal(this);
        this.institutionalProposalCostShares.add(institutionalProposalCostShare);
    }

    public void add(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA) {
        institutionalProposalUnrecoveredFandA.setInstitutionalProposal(this);
        this.institutionalProposalUnrecoveredFandAs.add(institutionalProposalUnrecoveredFandA);
    }

    public ScaleTwoDecimal getTotalInitialCost() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.totalDirectCostInitial);
        returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.totalIndirectCostInitial);
        return returnValue;
    }

    public ScaleTwoDecimal getTotalCost() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.totalDirectCostTotal);
        returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.totalIndirectCostTotal);
        return returnValue;
    }

    ScaleTwoDecimal getTotalAmount(List<? extends ValuableItem> valuableItems) {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        for (ValuableItem valuableItem : valuableItems) {
            ScaleTwoDecimal amount = valuableItem.getAmount() != null ? valuableItem.getAmount() : ScaleTwoDecimal.ZERO;
            returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)amount);
        }
        return returnVal;
    }

    public ScaleTwoDecimal getTotalCostShareAmount() {
        return this.getTotalAmount(this.institutionalProposalCostShares);
    }

    public ScaleTwoDecimal getTotalUnrecoveredFandAAmount() {
        return this.getTotalAmount(this.institutionalProposalUnrecoveredFandAs);
    }

    public ScaleTwoDecimal getTotalFandAAmount() {
        return this.getTotalAmount(this.institutionalProposalFandAs);
    }

    public List<InstitutionalProposalSpecialReview> getSpecialReviews() {
        return this.specialReviews;
    }

    public void setSpecialReviews(List<InstitutionalProposalSpecialReview> specialReviews) {
        this.specialReviews = specialReviews;
    }

    public List<InstitutionalProposalCustomData> getInstitutionalProposalCustomDataList() {
        return this.institutionalProposalCustomDataList;
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getInstitutionalProposalCustomDataList();
    }

    public List<InstitutionalProposalNotepad> getInstitutionalProposalNotepads() {
        if (this.institutionalProposalNotepads == null) {
            this.institutionalProposalNotepads = new ArrayList<InstitutionalProposalNotepad>();
        }
        return this.institutionalProposalNotepads;
    }

    public void setInstitutionalProposalNotepads(List<InstitutionalProposalNotepad> institutionalProposalNotepads) {
        this.institutionalProposalNotepads = institutionalProposalNotepads;
    }

    public void setInstitutionalProposalCustomDataList(List<InstitutionalProposalCustomData> institutionalProposalCustomDataList) {
        this.institutionalProposalCustomDataList = institutionalProposalCustomDataList;
    }

    public List<InstitutionalProposalScienceKeyword> getInstitutionalProposalScienceKeywords() {
        return this.institutionalProposalScienceKeywords;
    }

    public void setInstitutionalProposalScienceKeywords(List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords) {
        this.institutionalProposalScienceKeywords = institutionalProposalScienceKeywords;
    }

    public void add(InstitutionalProposalPerson projectPerson) {
        this.projectPersons.add(projectPerson);
        projectPerson.setInstitutionalProposal(this);
    }

    public void add(InstitutionalProposalUnitContact institutionalProposalUnitContact) {
        this.institutionalProposalUnitContacts.add(institutionalProposalUnitContact);
        institutionalProposalUnitContact.setInstitutionalProposal(this);
    }

    public KcPerson getOspAdministrator() {
        for (InstitutionalProposalUnitContact contact : this.getInstitutionalProposalUnitContacts()) {
            if (!contact.isOspAdministrator()) continue;
            this.ospAdministrator = contact.getPerson();
            break;
        }
        return this.ospAdministrator;
    }

    public void setInstitutionalProposalUnitContacts(List<InstitutionalProposalUnitContact> institutionalProposalUnitContacts) {
        this.institutionalProposalUnitContacts = institutionalProposalUnitContacts;
    }

    public List<InstitutionalProposalUnitContact> getInstitutionalProposalUnitContacts() {
        return this.institutionalProposalUnitContacts;
    }

    public int getInstitutionalProposalContactsCount() {
        return this.institutionalProposalUnitContacts.size();
    }

    public Long getProposalId() {
        return this.proposalId;
    }

    public void setProposalId(Long proposalId) {
        this.proposalId = proposalId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getSponsorProposalNumber() {
        return this.sponsorProposalNumber;
    }

    public void setSponsorProposalNumber(String sponsorProposalNumber) {
        this.sponsorProposalNumber = sponsorProposalNumber;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getProposalTypeCode() {
        return this.proposalTypeCode;
    }

    public void setProposalTypeCode(Integer proposalTypeCode) {
        this.proposalTypeCode = proposalTypeCode;
    }

    public String getCurrentAccountNumber() {
        return this.currentAccountNumber;
    }

    public void setCurrentAccountNumber(String currentAccountNumber) {
        this.currentAccountNumber = currentAccountNumber;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    @Override
    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getNoticeOfOpportunityCode() {
        return this.noticeOfOpportunityCode;
    }

    public void setNoticeOfOpportunityCode(String noticeOfOpportunityCode) {
        this.noticeOfOpportunityCode = noticeOfOpportunityCode;
    }

    public Integer getGradStudHeadcount() {
        return this.gradStudHeadcount;
    }

    public void setGradStudHeadcount(Integer gradStudHeadcount) {
        this.gradStudHeadcount = gradStudHeadcount;
    }

    public ScaleTwoDecimal getGradStudPersonMonths() {
        return this.gradStudPersonMonths;
    }

    public void setGradStudPersonMonths(ScaleTwoDecimal gradStudPersonMonths) {
        this.gradStudPersonMonths = gradStudPersonMonths;
    }

    public boolean getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(boolean typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
    }

    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public void setRequestedStartDateInitial(Date requestedStartDateInitial) {
        this.requestedStartDateInitial = requestedStartDateInitial;
    }

    public Date getRequestedStartDateTotal() {
        return this.requestedStartDateTotal;
    }

    public void setRequestedStartDateTotal(Date requestedStartDateTotal) {
        this.requestedStartDateTotal = requestedStartDateTotal;
    }

    public Date getRequestedEndDateInitial() {
        return this.requestedEndDateInitial;
    }

    public void setRequestedEndDateInitial(Date requestedEndDateInitial) {
        this.requestedEndDateInitial = requestedEndDateInitial;
    }

    public Date getRequestedEndDateTotal() {
        return this.requestedEndDateTotal;
    }

    public void setRequestedEndDateTotal(Date requestedEndDateTotal) {
        this.requestedEndDateTotal = requestedEndDateTotal;
    }

    public ScaleTwoDecimal getTotalDirectCostInitial() {
        return this.totalDirectCostInitial;
    }

    public void setTotalDirectCostInitial(ScaleTwoDecimal totalDirectCostInitial) {
        this.totalDirectCostInitial = Objects.requireNonNullElse(totalDirectCostInitial, ScaleTwoDecimal.ZERO);
    }

    public ScaleTwoDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public void setTotalDirectCostTotal(ScaleTwoDecimal totalDirectCostTotal) {
        this.totalDirectCostTotal = Objects.requireNonNullElse(totalDirectCostTotal, ScaleTwoDecimal.ZERO);
    }

    public ScaleTwoDecimal getTotalIndirectCostInitial() {
        return this.totalIndirectCostInitial;
    }

    public void setTotalIndirectCostInitial(ScaleTwoDecimal totalIndirectCostInitial) {
        this.totalIndirectCostInitial = Objects.requireNonNullElse(totalIndirectCostInitial, ScaleTwoDecimal.ZERO);
    }

    public ScaleTwoDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public void setTotalIndirectCostTotal(ScaleTwoDecimal totalIndirectCostTotal) {
        this.totalIndirectCostTotal = Objects.requireNonNullElse(totalIndirectCostTotal, ScaleTwoDecimal.ZERO);
    }

    public String getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(String numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(String deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineType() {
        return this.deadlineType;
    }

    public void setDeadlineType(String deadlineType) {
        this.deadlineType = deadlineType;
    }

    public String getMailBy() {
        return this.mailBy;
    }

    public void setMailBy(String mailBy) {
        this.mailBy = mailBy;
    }

    public String getMailType() {
        return this.mailType;
    }

    public void setMailType(String mailType) {
        this.mailType = mailType;
    }

    public Unit getLeadUnit() {
        if (StringUtils.isNotEmpty((CharSequence)this.unitNumber) && this.leadUnit == null) {
            this.leadUnit = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)this.unitNumber);
        }
        return this.leadUnit;
    }

    public String getMailAccountNumber() {
        return this.mailAccountNumber;
    }

    public void setMailAccountNumber(String mailAccountNumber) {
        this.mailAccountNumber = mailAccountNumber;
    }

    public String getMailDescription() {
        return this.mailDescription;
    }

    public void setMailDescription(String mailDescription) {
        this.mailDescription = mailDescription;
    }

    public Boolean getSubcontractFlag() {
        return this.subcontractFlag;
    }

    public void setSubcontractFlag(Boolean subcontractFlag) {
        this.subcontractFlag = subcontractFlag;
    }

    public String getCostSharingIndicator() {
        return this.costSharingIndicator;
    }

    public void setCostSharingIndicator(String costSharingIndicator) {
        this.costSharingIndicator = costSharingIndicator;
    }

    public String getIdcRateIndicator() {
        return this.idcRateIndicator;
    }

    public void setIdcRateIndicator(String idcRateIndicator) {
        this.idcRateIndicator = idcRateIndicator;
    }

    public String getSpecialReviewIndicator() {
        return this.specialReviewIndicator;
    }

    public void setSpecialReviewIndicator(String specialReviewIndicator) {
        this.specialReviewIndicator = specialReviewIndicator;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getScienceCodeIndicator() {
        return this.scienceCodeIndicator;
    }

    public void setScienceCodeIndicator(String scienceCodeIndicator) {
        this.scienceCodeIndicator = scienceCodeIndicator;
    }

    public Integer getNsfSequenceNumber() {
        return this.nsfSequenceNumber;
    }

    public void setNsfSequenceNumber(Integer nsfSequenceNumber) {
        this.nsfSequenceNumber = nsfSequenceNumber;
    }

    @Override
    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getInitialContractAdmin() {
        return this.initialContractAdmin;
    }

    public void setInitialContractAdmin(String initialContractAdmin) {
        this.initialContractAdmin = initialContractAdmin;
    }

    public String getIpReviewActivityIndicator() {
        return this.ipReviewActivityIndicator;
    }

    public void setIpReviewActivityIndicator(String ipReviewActivityIndicator) {
        this.ipReviewActivityIndicator = ipReviewActivityIndicator;
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    @Deprecated
    public String getCfdaNumber() {
        return this.findFirstCfda().map(InstitutionalProposalCfda::getCfdaNumber).orElse(null);
    }

    @Deprecated
    public void setCfdaNumber(String cfdaNumber) {
        if (this.proposalCfdas == null) {
            this.proposalCfdas = new ArrayList<InstitutionalProposalCfda>();
        }
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            this.proposalCfdas.clear();
        } else {
            InstitutionalProposalCfda cfda = this.findFirstCfda().orElseGet(InstitutionalProposalCfda::new);
            this.proposalCfdas.clear();
            cfda.setCfdaNumber(cfdaNumber);
            cfda.setProposalId(this.getProposalId());
            cfda.setInstitutionalProposal(this);
            cfda.setProposalNumber(this.getProposalNumber());
            cfda.setSequenceNumber(this.getSequenceNumber());
            this.proposalCfdas.add(cfda);
        }
    }

    @Deprecated
    private Optional<InstitutionalProposalCfda> findFirstCfda() {
        if (this.proposalCfdas != null) {
            return this.proposalCfdas.stream().findFirst();
        }
        return Optional.empty();
    }

    public String getOpportunity() {
        return this.opportunity;
    }

    public void setOpportunity(String opportunity) {
        this.opportunity = opportunity;
    }

    public Integer getAwardTypeCode() {
        return this.awardTypeCode;
    }

    public void setAwardTypeCode(Integer awardTypeCode) {
        this.awardTypeCode = awardTypeCode;
    }

    public ProposalStatus getProposalStatus() {
        if (this.proposalStatus == null && this.statusCode != null) {
            this.refreshReferenceObject(PROPOSAL_STATUS);
        }
        return this.proposalStatus;
    }

    public void setProposalStatus(ProposalStatus proposalStatus) {
        this.proposalStatus = proposalStatus;
    }

    public NoticeOfOpportunity getNoticeOfOpportunity() {
        return this.noticeOfOpportunity;
    }

    public void setNoticeOfOpportunity(NoticeOfOpportunity noticeOfOpportunity) {
        this.noticeOfOpportunity = noticeOfOpportunity;
    }

    public ProposalType getProposalType() {
        if (this.proposalType == null && this.proposalTypeCode != null) {
            this.refreshReferenceObject(PROPOSAL_TYPE);
        }
        return this.proposalType;
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Sponsor getSponsor() {
        if (InstitutionalProposal.outOfSync(this.sponsorCode, this.sponsor)) {
            this.refreshReferenceObject(SPONSOR);
        }
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
        this.sponsorCode = sponsor != null ? sponsor.getSponsorCode() : null;
    }

    public Sponsor getPrimeSponsor() {
        if (InstitutionalProposal.outOfSync(this.primeSponsorCode, this.primeSponsor)) {
            this.refreshReferenceObject(PRIME_SPONSOR);
        }
        return this.primeSponsor;
    }

    private static boolean outOfSync(String code, Sponsor sponsor) {
        return sponsor == null && !StringUtils.isEmpty((CharSequence)code) || sponsor != null && !StringUtils.equals((CharSequence)sponsor.getSponsorCode(), (CharSequence)code) && !StringUtils.isEmpty((CharSequence)code);
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
        this.primeSponsorCode = primeSponsor != null ? primeSponsor.getSponsorCode() : null;
    }

    public InstitutionalProposalPerson getPrincipalInvestigator() {
        return this.getProjectPersons().stream().filter(InstitutionalProposalPerson::isPrincipalInvestigator).findFirst().orElse(null);
    }

    public void setPrincipalInvestigator(InstitutionalProposalPerson proposalPerson) {
        proposalPerson.setRoleCode("PI");
        this.getProjectPersons().add(proposalPerson);
    }

    @Override
    public String getPrincipalInvestigatorName() {
        InstitutionalProposalPerson pi = this.getPrincipalInvestigator();
        return pi != null ? pi.getFullName() : null;
    }

    @Override
    public String getSponsorName() {
        Sponsor tempSponsor = this.getSponsor();
        return tempSponsor != null ? tempSponsor.getSponsorName() : null;
    }

    public ActivityType getActivityType() {
        if (this.activityType == null && this.activityTypeCode != null) {
            this.refreshReferenceObject(ACTIVITY_TYPE);
        }
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public AwardType getAwardType() {
        return this.awardType;
    }

    public List<AwardFundingProposal> getAwardFundingProposals() {
        return this.awardFundingProposals;
    }

    public AwardFundingProposal getAwardFundingProposal(int index) {
        return this.getAwardFundingProposals().get(index);
    }

    public boolean getAwardFundingProposalsExist() {
        return this.getAllFundingProposals().size() > 0;
    }

    public List<AwardFundingProposal> getActiveAwardFundingProposals() {
        return this.getAwardFundingProposals().stream().filter(AwardFundingProposal::isActive).collect(Collectors.toList());
    }

    public void setAwardType(AwardType awardType) {
        this.awardType = awardType;
    }

    public String getFiscalMonth() {
        return this.fiscalMonth;
    }

    public void setFiscalMonth(String fiscalMonth) {
        this.fiscalMonth = fiscalMonth;
    }

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnitNumber();
    }

    public String getUnitName() {
        return this.getLeadUnitName();
    }

    public void setLeadUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public void setAwardFundingProposals(List<AwardFundingProposal> awardFundingProposals) {
        this.awardFundingProposals = awardFundingProposals;
    }

    public InstitutionalProposalScienceKeyword getProposalScienceKeyword() {
        return this.proposalScienceKeyword;
    }

    public void setProposalScienceKeyword(InstitutionalProposalScienceKeyword proposalScienceKeyword) {
        this.proposalScienceKeyword = proposalScienceKeyword;
    }

    public InstitutionalProposalCostShare getProposalCostSharing() {
        return this.proposalCostSharing;
    }

    public void setProposalCostSharing(InstitutionalProposalCostShare proposalCostSharing) {
        this.proposalCostSharing = proposalCostSharing;
    }

    public List<InstitutionalProposalPerson> getProjectPersons() {
        if (CollectionUtils.isNotEmpty(this.projectPersons)) {
            this.projectPersons.sort(new ProjectPersonComparator());
        }
        return this.projectPersons;
    }

    @Deprecated
    public List<InstitutionalProposalPerson> getUnsortedProjectPersons() {
        return this.projectPersons;
    }

    public void setProjectPersons(List<InstitutionalProposalPerson> projectPersons) {
        this.projectPersons = projectPersons;
    }

    public InstitutionalProposalPersonCreditSplit getProposalPerCreditSplit() {
        return this.proposalPerCreditSplit;
    }

    public void setProposalPerCreditSplit(InstitutionalProposalPersonCreditSplit proposalPerCreditSplit) {
        this.proposalPerCreditSplit = proposalPerCreditSplit;
    }

    public ProposalUnitCreditSplit getProposalUnitCreditSplit() {
        return this.proposalUnitCreditSplit;
    }

    public void setProposalUnitCreditSplit(ProposalUnitCreditSplit proposalUnitCreditSplit) {
        this.proposalUnitCreditSplit = proposalUnitCreditSplit;
    }

    public List<InstitutionalProposalComment> getProposalComments() {
        return this.proposalComments;
    }

    public void setProposalComments(List<InstitutionalProposalComment> proposalComments) {
        this.proposalComments = proposalComments;
    }

    public IntellectualPropertyReview getIntellectualPropertyReview() {
        return this.intellectualPropertyReview;
    }

    public void setIntellectualPropertyReview(IntellectualPropertyReview intellectualPropertyReview) {
        this.intellectualPropertyReview = intellectualPropertyReview;
    }

    public List<ProposalIpReviewJoin> getProposalIpReviewJoins() {
        return this.proposalIpReviewJoins;
    }

    public void setProposalIpReviewJoins(List<ProposalIpReviewJoin> proposalIpReviewJoins) {
        this.proposalIpReviewJoins = proposalIpReviewJoins;
    }

    public ProposalIpReviewJoin getProposalIpReviewJoin() {
        if (!CollectionUtils.isEmpty(this.proposalIpReviewJoins)) {
            return this.proposalIpReviewJoins.get(0);
        }
        return null;
    }

    public void setProposalIpReviewJoin(ProposalIpReviewJoin proposalIpReviewJoin) {
        this.proposalIpReviewJoins.add(0, proposalIpReviewJoin);
    }

    public List<InstitutionalProposalCostShare> getInstitutionalProposalCostShares() {
        return this.institutionalProposalCostShares;
    }

    public void setInstitutionalProposalCostShares(List<InstitutionalProposalCostShare> institutionalProposalCostShares) {
        this.institutionalProposalCostShares = institutionalProposalCostShares;
    }

    public List<InstitutionalProposalUnrecoveredFandA> getInstitutionalProposalUnrecoveredFandAs() {
        return this.institutionalProposalUnrecoveredFandAs;
    }

    public void setInstitutionalProposalUnrecoveredFandAs(List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        this.institutionalProposalUnrecoveredFandAs = institutionalProposalUnrecoveredFandAs;
    }

    public Date getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Date createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getDefaultNewDescription() {
        return SELECT;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public String getProposalSequenceStatus() {
        return this.proposalSequenceStatus;
    }

    public void setProposalSequenceStatus(String proposalSequenceStatus) {
        this.proposalSequenceStatus = proposalSequenceStatus;
    }

    public void addSpecialReview(InstitutionalProposalSpecialReview specialReview) {
        specialReview.setSequenceOwner(this);
        this.getSpecialReviews().add(specialReview);
    }

    public InstitutionalProposalSpecialReview getSpecialReview(int index) {
        return this.getSpecialReviews().get(index);
    }

    @Override
    public List<InstitutionalProposalScienceKeyword> getKeywords() {
        return this.institutionalProposalScienceKeywords;
    }

    public void setKeywords(List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords) {
        this.institutionalProposalScienceKeywords = institutionalProposalScienceKeywords;
    }

    @Override
    public void addKeyword(ScienceKeyword scienceKeyword) {
        InstitutionalProposalScienceKeyword institutionalProposalScienceKeyword = new InstitutionalProposalScienceKeyword(this, scienceKeyword);
        this.getKeywords().add(institutionalProposalScienceKeyword);
    }

    @Override
    public InstitutionalProposalScienceKeyword getKeyword(int index) {
        return this.getKeywords().get(index);
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        List versions = this.getBusinessObjectService().findMatchingOrderBy(InstitutionalProposal.class, Collections.singletonMap(PROPOSAL_NUMBER_PROPERTY_STRING, this.getProposalNumber()), "sequenceNumber", false);
        if (CollectionUtils.isNotEmpty((Collection)versions)) {
            this.sequenceNumber = ((InstitutionalProposal)versions.get(0)).getSequenceNumber() + 1;
        } else {
            Integer n = this.sequenceNumber;
            Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
        }
    }

    @Override
    public InstitutionalProposal getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(InstitutionalProposal newOwner) {
    }

    public void remove(AwardFundingProposal afp) {
        this.awardFundingProposals.remove(afp);
        this.updateFundingStatus();
    }

    @Override
    public void resetPersistenceState() {
        this.proposalId = null;
    }

    @Override
    public String getVersionNameField() {
        return PROPOSAL_NUMBER_PROPERTY_STRING;
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.proposalNumber;
    }

    @Override
    protected void postPersist() {
        super.postPersist();
        this.updateProposalIpReviewJoin();
        if (this.proposalId != null && this.proposalNumber != null) {
            this.updateMergedInstitutionalProposal();
        }
    }

    private void updateMergedInstitutionalProposal() {
        this.getProposalLogService().updateMergedInstProposal(this.proposalId, this.proposalNumber);
    }

    protected void postLoad() {
        super.postLoad();
    }

    public List<InstitutionalProposalAttachment> getInstProposalAttachments() {
        if (this.instProposalAttachments == null) {
            this.instProposalAttachments = new ArrayList<InstitutionalProposalAttachment>();
        }
        return this.instProposalAttachments;
    }

    public InstitutionalProposalAttachment getInstProposalAttachment(int index) {
        return this.instProposalAttachments.get(index);
    }

    public void addAttachment(InstitutionalProposalAttachment attachment) {
        this.getInstProposalAttachments().add(attachment);
        attachment.setInstitutionalProposal(this);
    }

    protected void updateProposalIpReviewJoin() {
        ProposalIpReviewJoin proposalIpReviewJoin = this.getProposalIpReviewJoin();
        if (proposalIpReviewJoin != null) {
            if (proposalIpReviewJoin.getProposalIpReviewJoinId() != null) {
                if (proposalIpReviewJoin.getIntellectualPropertyReview() != null) {
                    proposalIpReviewJoin.setProposalIpReviewJoinId(null);
                }
            } else {
                IntellectualPropertyReview ipReview = new IntellectualPropertyReview();
                ipReview.setSequenceNumber(0);
                ipReview.setProposalNumber(this.getProposalNumber());
                ipReview.setIpReviewSequenceStatus(VersionStatus.ACTIVE.toString());
                this.getBusinessObjectService().save((PersistableBusinessObject)ipReview);
                proposalIpReviewJoin = new ProposalIpReviewJoin();
                proposalIpReviewJoin.setIpReviewId(ipReview.getIpReviewId());
            }
            proposalIpReviewJoin.setProposalId(this.getProposalId());
            this.getBusinessObjectService().save((PersistableBusinessObject)proposalIpReviewJoin);
            this.setProposalIpReviewJoin(proposalIpReviewJoin);
        }
    }

    public List<InstitutionalProposalFandA> getInstitutionalProposalFandAs() {
        return this.institutionalProposalFandAs;
    }

    public void setInstitutionalProposalFandAs(List<InstitutionalProposalFandA> institutionalProposalFandAs) {
        this.institutionalProposalFandAs = institutionalProposalFandAs;
    }

    public ActivityType getActivityTypeFromCode() {
        if (this.activityType == null && this.activityTypeCode != null) {
            HashMap<String, String> identifiers = new HashMap<String, String>();
            identifiers.put(ACTIVITY_CODE, this.activityTypeCode);
            this.activityType = (ActivityType)this.getBusinessObjectService().findByPrimaryKey(ActivityType.class, identifiers);
        }
        return this.activityType;
    }

    public ProposalType getProposalTypeFromCode() {
        if (this.proposalType == null && this.proposalTypeCode != null) {
            HashMap<String, Integer> identifiers = new HashMap<String, Integer>();
            identifiers.put(PROPOSAL_TYPE_CODE, this.proposalTypeCode);
            this.proposalType = (ProposalType)this.getBusinessObjectService().findByPrimaryKey(ProposalType.class, identifiers);
        }
        return this.proposalType;
    }

    public void doProposalLogDataFeed(ProposalLog proposalLog) {
        this.setProposalNumber(proposalLog.getProposalNumber());
        this.setDeadlineDate(proposalLog.getDeadlineDate());
        this.setDeadlineTime(proposalLog.getDeadlineTime());
        this.calculateFiscalMonthAndYearFields();
        this.setProposalTypeCode(Integer.parseInt(proposalLog.getProposalTypeCode()));
        this.setStatusCode(1);
        this.setSponsorCode(proposalLog.getSponsorCode());
        this.setTitle(proposalLog.getTitle());
        this.setLeadUnit(this.getUnitService().getUnit(proposalLog.getLeadUnit()));
        this.setLeadUnitNumber(proposalLog.getLeadUnit());
        this.setDefaultInitialContractAdmin();
        InstitutionalProposalPerson ipPerson = new InstitutionalProposalPerson();
        if (StringUtils.isNotBlank((CharSequence)proposalLog.getPiId()) && proposalLog.getPerson() != null) {
            ipPerson.setPerson(proposalLog.getPerson());
            ipPerson.setFaculty(proposalLog.getPerson().getFacultyFlag());
        } else if (proposalLog.getRolodexId() != null && proposalLog.getRolodex() != null) {
            ipPerson.setRolodex(proposalLog.getRolodex());
        }
        this.initializeDefaultPrincipalInvestigator(ipPerson);
        this.setPrincipalInvestigator(ipPerson);
    }

    public void initializeDefaultPrincipalInvestigator(InstitutionalProposalPerson ipPerson) {
        ipPerson.setProposalNumber(this.getProposalNumber());
        ipPerson.setSequenceNumber(this.getSequenceNumber());
        ipPerson.initializeDefaultCreditSplits();
        InstitutionalProposalPersonUnit ipPersonUnit = new InstitutionalProposalPersonUnit();
        ipPersonUnit.setUnit(this.getLeadUnit());
        ipPersonUnit.setLeadUnit(true);
        ipPersonUnit.initializeDefaultCreditSplits();
        ipPerson.add(ipPersonUnit);
        ipPerson.setInstitutionalProposal(this);
    }

    public UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private void updateFundingStatus() {
        this.setStatusCode(this.awardFundingProposals.size() > 0 ? PROPOSAL_FUNDED_STATUS_CODE : PROPOSAL_PENDING_STATUS_CODE);
    }

    public NsfCode getNsfCodeBo() {
        return this.nsfCodeBo;
    }

    public void setNsfCodeBo(NsfCode nsfCodeBo) {
        this.nsfCodeBo = nsfCodeBo;
    }

    public KcPerson getInitialContractAdminUser() {
        if (!StringUtils.isBlank((CharSequence)this.getInitialContractAdmin())) {
            try {
                return this.getKcPersonService().getKcPersonByPersonId(this.getInitialContractAdmin());
            }
            catch (RuntimeException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public InstitutionalProposalComment getSummaryComment() {
        return this.getInstitutionalProposalCommentByType("12", true);
    }

    public InstitutionalProposalComment getDeliveryComment() {
        return this.getInstitutionalProposalCommentByType("13", true);
    }

    public InstitutionalProposalComment getCostShareComment() {
        return this.getInstitutionalProposalCommentByType("9", true);
    }

    public InstitutionalProposalComment getRatesComment() {
        return this.getInstitutionalProposalCommentByType("8", true);
    }

    public InstitutionalProposalComment getUnrecoveredFandAComment() {
        return this.getInstitutionalProposalCommentByType("8", true);
    }

    public InstitutionalProposalComment getGeneralComment() {
        return this.getInstitutionalProposalCommentByType("16", true);
    }

    public InstitutionalProposalComment getInstitutionalProposalCommentByType(String commentTypeCode, boolean createNew) {
        InstitutionalProposalComment ipComment = this.getCommentMap().get(commentTypeCode);
        if (ipComment == null && createNew) {
            ipComment = new InstitutionalProposalComment(commentTypeCode);
            ipComment.refreshReferenceObject(COMMENT_TYPE);
            this.add(ipComment);
            this.commentMap.put(ipComment.getCommentType().getCommentTypeCode(), ipComment);
        }
        return ipComment;
    }

    public void add(InstitutionalProposalComment ipComment) {
        this.proposalComments.add(ipComment);
        ipComment.setInstitutionalProposal(this);
    }

    private Map<String, InstitutionalProposalComment> getCommentMap() {
        if (this.commentMap == null) {
            this.commentMap = new HashMap<String, InstitutionalProposalComment>();
            for (InstitutionalProposalComment ipc : this.proposalComments) {
                this.commentMap.put(ipc.getCommentType().getCommentTypeCode(), ipc);
            }
        }
        return this.commentMap;
    }

    public void setLookupUnit(Unit lookupUnit) {
        this.lookupUnit = lookupUnit;
    }

    public Unit getLookupUnit() {
        return this.lookupUnit;
    }

    public void setLookupUnitName(String lookupUnitName) {
        this.lookupUnitName = lookupUnitName;
    }

    public String getLookupUnitName() {
        return this.lookupUnitName;
    }

    public void setLookupUnitNumber(String lookupUnitNumber) {
        this.lookupUnitNumber = lookupUnitNumber;
    }

    public String getLookupUnitNumber() {
        return this.lookupUnitNumber;
    }

    public void setLookupPersonNumber(String lookupPersonNumber) {
        this.lookupPersonNumber = lookupPersonNumber;
    }

    public String getLookupPersonNumber() {
        return this.lookupPersonNumber;
    }

    public String getDevProposalNumber() {
        return this.devProposalNumber;
    }

    public void setDevProposalNumber(String devProposalNumber) {
        this.devProposalNumber = devProposalNumber;
    }

    public void setShowReturnLink(boolean val) {
        this.showReturnLink = val;
    }

    public boolean getShowReturnLink() {
        return this.showReturnLink;
    }

    public String getInstProposalNumber() {
        if (this.instProposalNumber == null) {
            this.instProposalNumber = this.proposalNumber;
        }
        return this.instProposalNumber;
    }

    public void setInstProposalNumber(String instProposalNumber) {
        this.instProposalNumber = instProposalNumber;
    }

    public int getTotalUnitCount() {
        int count = 0;
        for (InstitutionalProposalPerson person : this.projectPersons) {
            count += person.getUnits().size();
        }
        return count;
    }

    public boolean isSponsorNihMultiplePi() {
        return this.sponsorNihMultiplePi;
    }

    public void setSponsorNihMultiplePi(boolean sponsorNihMultiplePi) {
        this.sponsorNihMultiplePi = sponsorNihMultiplePi;
    }

    @Override
    public String getLeadUnitName() {
        return this.getLeadUnit() == null ? "" : this.getLeadUnit().getUnitName();
    }

    @Override
    public String getPiName() {
        return this.getPiEmployeeName();
    }

    @Override
    public String getPiEmployeeName() {
        return this.getPrincipalInvestigator() == null ? "" : this.getPrincipalInvestigator().getFullName();
    }

    @Override
    public String getPiNonEmployeeName() {
        return "";
    }

    @Override
    public String getAdminPersonName() {
        return "";
    }

    @Override
    public String getPrimeSponsorName() {
        return this.getPrimeSponsor() == null ? "" : this.getPrimeSponsor().getSponsorName();
    }

    @Override
    public String getSponsorAwardNumber() {
        return "";
    }

    @Override
    public String getSubAwardOrganizationName() {
        return "";
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        return this.getProjectPersons().stream().map(person -> new NegotiationPersonDTO(person.getPerson(), person.getRoleCode())).collect(Collectors.toList());
    }

    @Override
    public String getAssociatedDocumentId() {
        return this.getProposalNumber();
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return this.getProposalTypeCode() != null ? this.getProposalTypeCode().toString() : "";
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return this.getProposalType();
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return "";
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = KcServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.allowUpdateTimestampToBeReset) {
            super.setUpdateTimestamp(updateTimestamp);
        } else {
            this.allowUpdateTimestampToBeReset = true;
        }
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (this.allowUpdateUserToBeReset) {
            super.setUpdateUser(updateUser);
        } else {
            this.allowUpdateUserToBeReset = true;
        }
    }

    public void setAllowUpdateFieldsToBeReset(boolean updateFieldsToBeReset) {
        this.allowUpdateTimestampToBeReset = updateFieldsToBeReset;
        this.allowUpdateUserToBeReset = updateFieldsToBeReset;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public List<AwardFundingProposal> getAllFundingProposals() {
        return this.allFundingProposals;
    }

    public void setAllFundingProposals(List<AwardFundingProposal> allFundingProposals) {
        this.allFundingProposals = allFundingProposals;
    }

    public ProposalLogService getProposalLogService() {
        if (this.proposalLogService == null) {
            this.proposalLogService = KcServiceLocator.getService(ProposalLogService.class);
        }
        return this.proposalLogService;
    }

    public void setProposalLogService(ProposalLogService proposalLogService) {
        this.proposalLogService = proposalLogService;
    }

    protected InstitutionalProposalPersonService getInstitutionalProposalPersonService() {
        if (this.institutionalProposalPersonService == null) {
            this.institutionalProposalPersonService = KcServiceLocator.getService(InstitutionalProposalPersonService.class);
        }
        return this.institutionalProposalPersonService;
    }

    public List<InstitutionalProposalPerson> getPersonsSelectedForCreditSplit() {
        return this.getInstitutionalProposalPersonService().getPersonsSelectedForCreditSplit(this.projectPersons);
    }

    public List<InstitutionalProposalCfda> getProposalCfdas() {
        return this.proposalCfdas;
    }

    public void setProposalCfdas(List<InstitutionalProposalCfda> proposalCfdas) {
        this.proposalCfdas = proposalCfdas;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        try {
            Optional<InstitutionalProposal> newActiveInstitutionalProposal = this.getInstitutionalProposalService().verifyProposalSequencing(this);
            if (LOG.isInfoEnabled() && newActiveInstitutionalProposal.isPresent()) {
                LOG.info("An IP sequencing issue has been detected. This IP sequencing issue was detected on prePersist. Tried saving a PENDING IP with a FINAL document status. Document Number = " + newActiveInstitutionalProposal.get().getInstitutionalProposalDocument().getDocumentNumber(), (Object[])new Throwable().getStackTrace());
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)e);
        }
    }

    static class ProjectPersonComparator
    implements Comparator<InstitutionalProposalPerson> {
        ProjectPersonComparator() {
        }

        @Override
        public int compare(InstitutionalProposalPerson ipp1, InstitutionalProposalPerson ipp2) {
            if (StringUtils.equals((CharSequence)ipp1.getContactRoleCode(), (CharSequence)ipp2.getContactRoleCode())) {
                return this.getPersonLastName(ipp1).compareTo(this.getPersonLastName(ipp2));
            }
            if ("PI".equals(ipp1.getContactRoleCode())) {
                return -1;
            }
            if ("PI".equals(ipp2.getContactRoleCode())) {
                return 1;
            }
            if ("COI".equals(ipp1.getContactRoleCode())) {
                return -1;
            }
            return 1;
        }

        protected String getPersonLastName(InstitutionalProposalPerson person) {
            return person.getContact() != null ? (person.getContact().getLastName() != null ? person.getContact().getLastName().toUpperCase() : "") : "";
        }
    }
}

