/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.keyword.PropScienceKeyword;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.excon.project.service.ExconProjectAssociatedInfoBean;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.dao.InstitutionalProposalDao;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.exception.InstitutionalProposalCreationException;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalFandA;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPersonService;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReviewExemption;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InstitutionalProposalServiceImpl
implements InstitutionalProposalService {
    private static final Logger LOG = LogManager.getLogger(InstitutionalProposalServiceImpl.class);
    private static final String WORKFLOW_EXCEPTION_MESSAGE = "Caught workflow exception creating new Institutional Proposal";
    private static final String VERSION_EXCEPTION_MESSAGE = "Caught version exception creating new Institutional Proposal";
    private static final String ROUTE_MESSAGE = "Autogenerated Institutional Proposal from Development Proposal ";
    private static final String NO_PRIOR_VERSION_MESSAGE = "Tried to version an InstitutionalProposal where no prior version exists.";
    private static final String NEW_DOCUMENT_DESCRIPTION = "Generated by Dev Proposal ";
    private static final String DECIMAL_FORMAT = "00000000";
    private static final String DECIMAL_FORMAT_FOR_NEW_IP = "0000";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String PROPOSAL_SEQUENCE_STATUS = "proposalSequenceStatus";
    private static final String ACTIVE_VALUE = "Y";
    private static final String INST_PROPOSAL_ID = "instProposalId";
    private static final int DEFAULT_STATUS_CODE = 1;
    private static final int WITHDRAWN_STATUS_CODE = 5;
    private static final Integer DEFAULT_COST_SHARE_TYPE_CODE = 1;
    private static final String VALID_FUNDING_PROPOSAL_STATUS_CODES = "validFundingProposalStatusCodes";
    private static final String SEPARATOR = ",";
    private static final String TRUE_INDICATOR_VALUE = "1";
    private static final String FALSE_INDICATOR_VALUE = "0";
    private static final int VERSION_1 = 1;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private VersioningService versioningService;
    private InstitutionalProposalVersioningService institutionalProposalVersioningService;
    private SequenceAccessorService sequenceAccessorService;
    private ParameterService parameterService;
    private InstitutionalProposalDao institutionalProposalDao;
    private FiscalYearMonthService fiscalYearMonthService;
    private InstitutionalProposalPersonService institutionalProposalPersonService;
    private ModularBudgetService modularBudgetService;
    private DataObjectService dataObjectService;
    private ProjectRetrievalService instPropProjectRetrievalService;
    private ProposalTypeService proposalTypeService;
    private ProjectPublisher projectPublisher;

    public FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = KcServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    public ProposalTypeService getProposalTypeService() {
        if (this.proposalTypeService == null) {
            this.proposalTypeService = KcServiceLocator.getService(ProposalTypeService.class);
        }
        return this.proposalTypeService;
    }

    public ProjectPublisher getProjectPublisher() {
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    @Override
    public InstitutionalProposal createInstitutionalProposal(DevelopmentProposal developmentProposal, Budget budget) {
        try {
            InstitutionalProposal institutionalProposal = new InstitutionalProposal();
            institutionalProposal.setProposalNumber(this.getNextInstitutionalProposalNumber());
            InstitutionalProposalDocument institutionalProposalDocument = this.mergeProposals(institutionalProposal, developmentProposal, budget);
            this.setInstitutionalProposalIndicators(institutionalProposalDocument.getInstitutionalProposal());
            this.documentService.routeDocument((Document)institutionalProposalDocument, ROUTE_MESSAGE + developmentProposal.getProposalNumber(), new ArrayList());
            Project project = this.getInstPropProjectRetrievalService().retrieveProject(institutionalProposalDocument.getInstitutionalProposal().getProposalNumber());
            if (project != null) {
                this.getProjectPublisher().publishProject(project);
            }
            return institutionalProposalDocument.getInstitutionalProposal();
        }
        catch (WorkflowException ex) {
            throw new InstitutionalProposalCreationException(WORKFLOW_EXCEPTION_MESSAGE, ex);
        }
    }

    @Override
    public InstitutionalProposal createInstitutionalProposalVersion(String proposalNumber, DevelopmentProposal developmentProposal, Budget budget) {
        try {
            InstitutionalProposalDocument newInstitutionalProposalDocument = this.versionProposal(proposalNumber, developmentProposal, budget);
            this.setInstitutionalProposalIndicators(newInstitutionalProposalDocument.getInstitutionalProposal());
            this.documentService.routeDocument((Document)newInstitutionalProposalDocument, ROUTE_MESSAGE + developmentProposal.getProposalNumber(), new ArrayList());
            this.institutionalProposalVersioningService.updateInstitutionalProposalVersionStatus(newInstitutionalProposalDocument.getInstitutionalProposal(), VersionStatus.ACTIVE);
            Project project = this.getInstPropProjectRetrievalService().retrieveProject(newInstitutionalProposalDocument.getInstitutionalProposal().getProposalNumber());
            if (project != null) {
                this.getProjectPublisher().publishProject(project);
            }
            return newInstitutionalProposalDocument.getInstitutionalProposal();
        }
        catch (VersionException | WorkflowException e) {
            throw new InstitutionalProposalCreationException(VERSION_EXCEPTION_MESSAGE, e);
        }
    }

    @Override
    public InstitutionalProposal getInstitutionalProposal(String proposalId) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalId", proposalId);
        return (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, criteria);
    }

    @Override
    public InstitutionalProposal getPendingInstitutionalProposalVersion(String proposalNumber) {
        return this.institutionalProposalVersioningService.getPendingInstitutionalProposalVersion(proposalNumber);
    }

    @Override
    public InstitutionalProposal getActiveInstitutionalProposalVersion(String proposalNumber) {
        return this.institutionalProposalVersioningService.getActiveInstitutionalProposalVersion(proposalNumber);
    }

    @Override
    public List<InstitutionalProposal> fundInstitutionalProposals(Set<String> proposalNumbers) {
        ArrayList<InstitutionalProposal> updatedProposals = new ArrayList<InstitutionalProposal>();
        try {
            for (String proposalNumber : proposalNumbers) {
                InstitutionalProposal activeVersion = this.getActiveInstitutionalProposal(proposalNumber);
                if (activeVersion != null && !ProposalStatus.FUNDED.equals(activeVersion.getStatusCode())) {
                    LOG.info("Creating a new version of proposal " + proposalNumber + ".");
                    InstitutionalProposal newVersion = this.versioningService.createNewVersion(activeVersion);
                    newVersion.setStatusCode(ProposalStatus.FUNDED);
                    newVersion.setAwardFundingProposals(new ArrayList<AwardFundingProposal>());
                    InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)this.documentService.getNewDocument(InstitutionalProposalDocument.class);
                    institutionalProposalDocument.getDocumentHeader().setDocumentDescription(activeVersion.getInstitutionalProposalDocument().getDocumentHeader().getDocumentDescription());
                    institutionalProposalDocument.setInstitutionalProposal(newVersion);
                    this.setInstitutionalProposalIndicators(institutionalProposalDocument.getInstitutionalProposal());
                    this.documentService.routeDocument((Document)institutionalProposalDocument, "Update Proposal Status to Funded", new ArrayList());
                    updatedProposals.add(newVersion);
                    continue;
                }
                if (activeVersion != null && ProposalStatus.FUNDED.equals(activeVersion.getStatusCode())) {
                    LOG.info("Skipped creating a new version of proposal " + proposalNumber + " - proposal is already Funded.");
                    continue;
                }
                if (activeVersion != null) continue;
                LOG.warn("Could not designate proposal " + proposalNumber + " as Funded: no Active version found.");
            }
            return updatedProposals;
        }
        catch (WorkflowException we) {
            throw new InstitutionalProposalCreationException(WORKFLOW_EXCEPTION_MESSAGE, we);
        }
        catch (VersionException ve) {
            throw new InstitutionalProposalCreationException(VERSION_EXCEPTION_MESSAGE, ve);
        }
    }

    @Override
    public List<InstitutionalProposal> defundInstitutionalProposals(Set<String> proposalNumbers, String awardNumber, Integer awardSequence) {
        ArrayList<InstitutionalProposal> updatedProposals = new ArrayList<InstitutionalProposal>();
        try {
            for (String proposalNumber : proposalNumbers) {
                InstitutionalProposal activeVersion = this.getActiveInstitutionalProposal(proposalNumber);
                if (activeVersion != null && activeVersion.isFundedByAward(awardNumber, awardSequence) && activeVersion.getActiveAwardFundingProposals().size() == 1) {
                    LOG.info("Creating a new version of proposal " + proposalNumber + ".");
                    InstitutionalProposal newVersion = this.versioningService.createNewVersion(activeVersion);
                    newVersion.getAwardFundingProposals().clear();
                    newVersion.setStatusCode(ProposalStatus.PENDING);
                    InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)this.documentService.getNewDocument(InstitutionalProposalDocument.class);
                    institutionalProposalDocument.getDocumentHeader().setDocumentDescription(activeVersion.getInstitutionalProposalDocument().getDocumentHeader().getDocumentDescription());
                    institutionalProposalDocument.setInstitutionalProposal(newVersion);
                    this.setInstitutionalProposalIndicators(institutionalProposalDocument.getInstitutionalProposal());
                    this.documentService.routeDocument((Document)institutionalProposalDocument, "Update Proposal Status to Pending", new ArrayList());
                    updatedProposals.add(newVersion);
                    continue;
                }
                LOG.info("Skipped setting proposal " + proposalNumber + " to Pending. It is either funded by another Award, another version of Award " + awardNumber + ", or no active version found.");
            }
            return updatedProposals;
        }
        catch (WorkflowException we) {
            throw new InstitutionalProposalCreationException(WORKFLOW_EXCEPTION_MESSAGE, we);
        }
        catch (VersionException ve) {
            throw new InstitutionalProposalCreationException(VERSION_EXCEPTION_MESSAGE, ve);
        }
    }

    @Override
    public List<InstitutionalProposal> getProposalsForProposalNumber(String proposalNumber) {
        return new ArrayList<InstitutionalProposal>(this.businessObjectService.findMatchingOrderBy(InstitutionalProposal.class, Collections.singletonMap(PROPOSAL_NUMBER, proposalNumber), SEQUENCE_NUMBER, true));
    }

    @Override
    public List<DevelopmentProposal> getAllLinkedDevelopmentProposals(String proposalNumber) {
        ArrayList<DevelopmentProposal> result = new ArrayList<DevelopmentProposal>();
        List<InstitutionalProposal> proposals = this.getProposalsForProposalNumber(proposalNumber);
        for (InstitutionalProposal curProposal : proposals) {
            ArrayList details = new ArrayList(this.businessObjectService.findMatching(ProposalAdminDetails.class, Collections.singletonMap(INST_PROPOSAL_ID, curProposal.getProposalId())));
            for (ProposalAdminDetails detail : details) {
                result.add((DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)detail.getDevProposalNumber()));
            }
        }
        return result;
    }

    @Override
    public String getNextInstitutionalProposalNumber() {
        boolean fyBasedIp = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "GENERATE_IP_BASED_ON_FY");
        return fyBasedIp ? this.getNextIPFiscalYearBased() : new DecimalFormat(DECIMAL_FORMAT).format(this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_PROPOSAL_PROPOSAL_ID", InstitutionalProposal.class));
    }

    private String getNextIPFiscalYearBased() {
        String fiscalYear = StringUtils.substring((String)this.getFiscalYearMonthService().getCurrentFiscalYear().toString(), (int)2, (int)4);
        String fiscalMonth = StringUtils.leftPad((String)this.getFiscalYearMonthService().getCurrentFiscalMonthForDisplay().toString(), (int)2, (String)FALSE_INDICATOR_VALUE);
        Long nextProposalNumberSeq = this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_IP_FY_BASED_ID", InstitutionalProposal.class);
        return fiscalYear + fiscalMonth + new DecimalFormat(DECIMAL_FORMAT_FOR_NEW_IP).format(nextProposalNumberSeq);
    }

    protected InstitutionalProposal getActiveInstitutionalProposal(String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(PROPOSAL_NUMBER, proposalNumber);
        criteria.put(PROPOSAL_SEQUENCE_STATUS, VersionStatus.ACTIVE.toString());
        List results = this.businessObjectService.findMatching(InstitutionalProposal.class, criteria);
        if (results.isEmpty()) {
            return null;
        }
        return (InstitutionalProposal)results.toArray()[0];
    }

    protected InstitutionalProposalDocument versionProposal(String proposalNumber, DevelopmentProposal developmentProposal, Budget budget) throws VersionException, WorkflowException {
        InstitutionalProposal currentVersion = this.getActiveInstitutionalProposal(proposalNumber);
        if (currentVersion == null) {
            throw new RuntimeException(NO_PRIOR_VERSION_MESSAGE);
        }
        ObjectUtils.materializeObjects(currentVersion.getInstitutionalProposalScienceKeywords());
        InstitutionalProposal newVersion = this.versioningService.createNewVersion(currentVersion);
        return this.mergeProposals(newVersion, developmentProposal, budget);
    }

    protected InstitutionalProposalDocument mergeProposals(InstitutionalProposal institutionalProposal, DevelopmentProposal developmentProposal, Budget budget) throws WorkflowException {
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)this.documentService.getNewDocument(InstitutionalProposalDocument.class);
        institutionalProposalDocument.getDocumentHeader().setDocumentDescription(NEW_DOCUMENT_DESCRIPTION + developmentProposal.getProposalNumber());
        institutionalProposalDocument.setInstitutionalProposal(institutionalProposal);
        this.doBaseFieldsDataFeed(institutionalProposal, developmentProposal);
        this.doCustomAttributeDataFeed(institutionalProposalDocument, developmentProposal);
        institutionalProposal.getProjectPersons().clear();
        for (ProposalPerson pdPerson : developmentProposal.getProposalPersons()) {
            institutionalProposal.add(this.generateInstitutionalProposalPerson(pdPerson));
        }
        institutionalProposal.getSpecialReviews().clear();
        for (ProposalSpecialReview dpSpecialReview : developmentProposal.getPropSpecialReviews()) {
            institutionalProposal.addSpecialReview(this.generateIpSpecialReview(dpSpecialReview));
        }
        if (!institutionalProposal.getSpecialReviews().isEmpty()) {
            institutionalProposal.setSpecialReviewIndicator(TRUE_INDICATOR_VALUE);
        }
        institutionalProposal.getInstitutionalProposalScienceKeywords().clear();
        for (PropScienceKeyword dpKeyword : developmentProposal.getPropScienceKeywords()) {
            institutionalProposal.addKeyword(dpKeyword.getScienceKeyword());
        }
        if (!institutionalProposal.getInstitutionalProposalScienceKeywords().isEmpty()) {
            institutionalProposal.setScienceCodeIndicator(TRUE_INDICATOR_VALUE);
        }
        if (budget != null) {
            this.doBudgetDataFeed(institutionalProposal, budget, developmentProposal.getBudgetRateClassCodes());
        }
        institutionalProposal.refreshNonUpdateableReferences();
        return institutionalProposalDocument;
    }

    protected void doBaseFieldsDataFeed(InstitutionalProposal institutionalProposal, DevelopmentProposal developmentProposal) {
        if (institutionalProposal.getSequenceNumber() == 1) {
            institutionalProposal.setProposalTypeCode(this.convertToInstitutionalProposalTypeCode(developmentProposal.getProposalTypeCode()));
        }
        institutionalProposal.setActivityTypeCode(developmentProposal.getActivityTypeCode());
        if (developmentProposal.getProposalDocument().getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            institutionalProposal.setStatusCode(this.getWithdrawnStatusCode());
        } else {
            institutionalProposal.setStatusCode(this.getDefaultStatusCode());
        }
        institutionalProposal.setSponsorCode(developmentProposal.getSponsorCode());
        institutionalProposal.setTitle(developmentProposal.getTitle());
        institutionalProposal.setSubcontractFlag(developmentProposal.getSubcontracts() != null ? developmentProposal.getSubcontracts() : false);
        institutionalProposal.setRequestedStartDateTotal(developmentProposal.getRequestedStartDateInitial());
        institutionalProposal.setRequestedEndDateTotal(developmentProposal.getRequestedEndDateInitial());
        institutionalProposal.setDeadlineDate(developmentProposal.getDeadlineDate());
        institutionalProposal.setDeadlineTime(developmentProposal.getDeadlineTime());
        institutionalProposal.setNoticeOfOpportunityCode(developmentProposal.getNoticeOfOpportunityCode());
        institutionalProposal.setNumberOfCopies(developmentProposal.getNumberOfCopies());
        institutionalProposal.setDeadlineType(developmentProposal.getDeadlineType());
        institutionalProposal.setMailBy(developmentProposal.getMailBy());
        institutionalProposal.setMailType(developmentProposal.getMailType());
        institutionalProposal.setMailAccountNumber(developmentProposal.getMailAccountNumber());
        institutionalProposal.setMailDescription(developmentProposal.getMailDescription());
        institutionalProposal.setPrimeSponsorCode(developmentProposal.getPrimeSponsorCode());
        institutionalProposal.setCurrentAwardNumber(developmentProposal.getCurrentAwardNumber());
        institutionalProposal.setNewDescription(developmentProposal.getNewDescription());
        institutionalProposal.setNoticeOfOpportunityCode(developmentProposal.getNoticeOfOpportunityCode());
        institutionalProposal.setNsfSequenceNumber(developmentProposal.getNsfSequenceNumber());
        institutionalProposal.setSponsorProposalNumber(developmentProposal.getSponsorProposalNumber());
        institutionalProposal.setOpportunity(developmentProposal.getProgramAnnouncementNumber());
        institutionalProposal.setProposalCfdas(developmentProposal.getProposalCfdas().stream().map(cfda -> {
            InstitutionalProposalCfda ipCfda = new InstitutionalProposalCfda();
            ipCfda.setCfdaNumber(cfda.getCfdaNumber());
            ipCfda.setCfdaDescription(cfda.getCfdaDescription());
            ipCfda.setInstitutionalProposal(institutionalProposal);
            ipCfda.setProposalId(institutionalProposal.getProposalId());
            ipCfda.setProposalNumber(institutionalProposal.getProposalNumber());
            ipCfda.setSequenceNumber(institutionalProposal.getSequenceNumber());
            return ipCfda;
        }).collect(Collectors.toList()));
        institutionalProposal.setLeadUnitNumber(developmentProposal.getUnitNumber());
        institutionalProposal.setDefaultInitialContractAdmin();
        if (developmentProposal.getRolodex() != null) {
            institutionalProposal.setRolodexId(developmentProposal.getRolodex().getRolodexId());
        }
        if (developmentProposal.getAnticipatedAwardType() != null) {
            institutionalProposal.setAwardTypeCode(developmentProposal.getAnticipatedAwardType().getCode());
        }
    }

    private int convertToInstitutionalProposalTypeCode(String developmentProposalTypeCode) {
        if (StringUtils.equals((CharSequence)developmentProposalTypeCode, (CharSequence)this.getProposalTypeService().getNewChangedOrCorrectedProposalTypeCode())) {
            return Integer.parseInt(this.getProposalTypeService().getNewProposalTypeCode());
        }
        if (StringUtils.equals((CharSequence)developmentProposalTypeCode, (CharSequence)this.getProposalTypeService().getSupplementChangedOrCorrectedProposalTypeCode())) {
            return Integer.parseInt(this.getProposalTypeService().getContinuationProposalTypeCode());
        }
        if (StringUtils.equals((CharSequence)developmentProposalTypeCode, (CharSequence)this.getProposalTypeService().getRenewalChangedOrCorrectedProposalTypeCode())) {
            return Integer.parseInt(this.getProposalTypeService().getRenewProposalTypeCode());
        }
        return Integer.parseInt(developmentProposalTypeCode);
    }

    protected void doCustomAttributeDataFeed(InstitutionalProposalDocument institutionalProposalDocument, DevelopmentProposal developmentProposal) {
        Map<String, CustomAttributeDocument> dpCustomAttributes = developmentProposal.getProposalDocument().getCustomAttributeDocuments();
        Map<String, CustomAttributeDocument> ipCustomAttributes = institutionalProposalDocument.getCustomAttributeDocuments();
        List<InstitutionalProposalCustomData> ipCustomDataList = institutionalProposalDocument.getInstitutionalProposal().getInstitutionalProposalCustomDataList();
        for (String key : dpCustomAttributes.keySet()) {
            if (!ipCustomAttributes.containsKey(key)) continue;
            CustomAttributeDocument dpCustomAttributeDocument = dpCustomAttributes.get(key);
            ipCustomAttributes.put(key, dpCustomAttributeDocument);
            InstitutionalProposalCustomData ipCustomData = new InstitutionalProposalCustomData();
            ipCustomData.setCustomAttribute(new CustomAttribute());
            ipCustomData.getCustomAttribute().setId(dpCustomAttributeDocument.getId());
            ipCustomData.setCustomAttributeId(dpCustomAttributeDocument.getId());
            ipCustomData.setInstitutionalProposal(institutionalProposalDocument.getInstitutionalProposal());
            ipCustomData.setValue(this.getCustomAttributeValue(developmentProposal.getProposalDocument().getCustomDataList(), key));
            ipCustomDataList.add(ipCustomData);
        }
    }

    protected String getCustomAttributeValue(List<CustomAttributeDocValue> values, String key) {
        for (CustomAttributeDocValue value : values) {
            if (!StringUtils.equals((CharSequence)String.valueOf(value.getId()), (CharSequence)key)) continue;
            return value.getValue();
        }
        return null;
    }

    protected boolean getOptIn() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
    }

    protected InstitutionalProposalPerson generateInstitutionalProposalPerson(ProposalPerson pdPerson) {
        InstitutionalProposalPerson ipPerson = new InstitutionalProposalPerson();
        ipPerson.setIncludeInCreditAllocation(pdPerson.getIncludeInCreditAllocation());
        if (pdPerson.getPersonId() != null) {
            ipPerson.setPersonId(pdPerson.getPersonId());
        }
        if (pdPerson.getRolodexId() != null) {
            ipPerson.setRolodexId(pdPerson.getRolodexId());
        }
        ipPerson.setContactRoleCode(pdPerson.getRole().getRoleCode());
        boolean generateCreditSplit = BooleanUtils.isTrue((Boolean)this.getInstitutionalProposalPersonService().generateCreditSplitForPerson(ipPerson));
        if (generateCreditSplit) {
            for (ProposalPersonCreditSplit pdPersonCreditSplit : pdPerson.getCreditSplits()) {
                InstitutionalProposalPersonCreditSplit ipPersonCreditSplit = new InstitutionalProposalPersonCreditSplit();
                ipPersonCreditSplit.setCredit(pdPersonCreditSplit.getCredit());
                ipPersonCreditSplit.setInvCreditTypeCode(pdPersonCreditSplit.getInvCreditTypeCode());
                ipPersonCreditSplit.setNewCollectionRecord(pdPersonCreditSplit.isNewCollectionRecord());
                ipPerson.add(ipPersonCreditSplit);
            }
        }
        for (ProposalPersonUnit pdPersonUnit : pdPerson.getUnits()) {
            InstitutionalProposalPersonUnit ipPersonUnit = new InstitutionalProposalPersonUnit();
            ipPersonUnit.setLeadUnit(pdPersonUnit.isLeadUnit());
            ipPersonUnit.setNewCollectionRecord(pdPersonUnit.isNewCollectionRecord());
            ipPersonUnit.setUnitNumber(pdPersonUnit.getUnitNumber());
            if (generateCreditSplit) {
                for (ProposalUnitCreditSplit pdPersonCreditSplit : pdPersonUnit.getCreditSplits()) {
                    InstitutionalProposalPersonUnitCreditSplit ipPersonUnitCreditSplit = new InstitutionalProposalPersonUnitCreditSplit();
                    ipPersonUnitCreditSplit.setCredit(pdPersonCreditSplit.getCredit());
                    ipPersonUnitCreditSplit.setInvCreditTypeCode(pdPersonCreditSplit.getInvCreditTypeCode());
                    ipPersonUnitCreditSplit.setNewCollectionRecord(pdPersonCreditSplit.isNewCollectionRecord());
                    ipPersonUnit.add(ipPersonUnitCreditSplit);
                }
            }
            ipPerson.add(ipPersonUnit);
        }
        ipPerson.setFaculty(pdPerson.getFacultyFlag());
        ipPerson.setFullName(pdPerson.getFullName());
        ipPerson.setKeyPersonRole(pdPerson.getProjectRole());
        ipPerson.setNewCollectionRecord(pdPerson.isNewCollectionRecord());
        ipPerson.setRoleCode(pdPerson.getRole().getRoleCode());
        ipPerson.setTotalEffort(pdPerson.getPercentageEffort());
        ipPerson.setAcademicYearEffort(pdPerson.getAcademicYearEffort());
        ipPerson.setCalendarYearEffort(pdPerson.getCalendarYearEffort());
        ipPerson.setSummerEffort(pdPerson.getSummerEffort());
        return ipPerson;
    }

    protected InstitutionalProposalSpecialReview generateIpSpecialReview(ProposalSpecialReview dpSpecialReview) {
        InstitutionalProposalSpecialReview ipSpecialReview = new InstitutionalProposalSpecialReview();
        ipSpecialReview.setApplicationDate(dpSpecialReview.getApplicationDate());
        ipSpecialReview.setApprovalDate(dpSpecialReview.getApprovalDate());
        ipSpecialReview.setApprovalTypeCode(dpSpecialReview.getApprovalTypeCode());
        ipSpecialReview.setComments(dpSpecialReview.getComments());
        ipSpecialReview.setExpirationDate(dpSpecialReview.getExpirationDate());
        ipSpecialReview.setProtocolNumber(dpSpecialReview.getProtocolNumber());
        ipSpecialReview.setSpecialReviewType(dpSpecialReview.getSpecialReviewType());
        ipSpecialReview.setApprovalType(dpSpecialReview.getApprovalType());
        ipSpecialReview.setSpecialReviewTypeCode(dpSpecialReview.getSpecialReviewTypeCode());
        ipSpecialReview.setSpecialReviewNumber(dpSpecialReview.getSpecialReviewNumber());
        for (String dpExempt : dpSpecialReview.getExemptionTypeCodes()) {
            InstitutionalProposalSpecialReviewExemption newIpSpecialReviewExemption = ipSpecialReview.createSpecialReviewExemption(dpExempt);
            ipSpecialReview.getSpecialReviewExemptions().add(newIpSpecialReviewExemption);
            ipSpecialReview.getExemptionTypeCodes().add(dpExempt);
        }
        return ipSpecialReview;
    }

    protected void doBudgetDataFeed(InstitutionalProposal institutionalProposal, Budget budget, Set<String> budgetRateClassCodes) {
        institutionalProposal.setRequestedStartDateInitial(budget.getBudgetPeriods().get(0).getStartDate());
        institutionalProposal.setRequestedEndDateInitial(budget.getBudgetPeriods().get(0).getEndDate());
        if (budget.getModularBudgetFlag().booleanValue()) {
            ScaleTwoDecimal totalDirect = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalIndirect = ScaleTwoDecimal.ZERO;
            List modularAmounts = this.getModularBudgetService().getModularBudgetAmounts((BudgetContract)budget);
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                BudgetModularContract modularBudget;
                if (budgetPeriod == null || (modularBudget = this.getModularBudgetService().getModularBudgetForPeriod(modularAmounts, (BudgetPeriodContract)budgetPeriod)) == null) continue;
                ScaleTwoDecimal periodTotalIndirect = modularBudget.getBudgetModularIdcs().stream().map(BudgetModularIdcContract::getFundsRequested).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
                if (modularBudget.getTotalDirectCost() != null) {
                    totalDirect = (ScaleTwoDecimal)totalDirect.add((AbstractDecimal)modularBudget.getTotalDirectCost());
                    if (budgetPeriod.getBudgetPeriod() == 1) {
                        institutionalProposal.setTotalDirectCostInitial(modularBudget.getTotalDirectCost());
                    }
                }
                if (budgetPeriod.getBudgetPeriod() == 1) {
                    institutionalProposal.setTotalIndirectCostInitial(periodTotalIndirect);
                }
                totalIndirect = (ScaleTwoDecimal)totalIndirect.add((AbstractDecimal)periodTotalIndirect);
            }
            institutionalProposal.setTotalDirectCostTotal(totalDirect);
            institutionalProposal.setTotalIndirectCostTotal(totalIndirect);
        } else {
            institutionalProposal.setTotalDirectCostInitial(new ScaleTwoDecimal(budget.getBudgetPeriod(0).getTotalDirectCost().bigDecimalValue()));
            institutionalProposal.setTotalIndirectCostInitial(new ScaleTwoDecimal(budget.getBudgetPeriod(0).getTotalIndirectCost().bigDecimalValue()));
            institutionalProposal.setTotalDirectCostTotal(new ScaleTwoDecimal(budget.getTotalDirectCost().bigDecimalValue()));
            institutionalProposal.setTotalIndirectCostTotal(new ScaleTwoDecimal(budget.getTotalIndirectCost().bigDecimalValue()));
        }
        this.populateCostSharesFromBudget(institutionalProposal, budget);
        this.populateUnrecoveredFandA(institutionalProposal, budget);
        this.copyIndirectRates(institutionalProposal, budget, budgetRateClassCodes);
    }

    private void populateUnrecoveredFandA(InstitutionalProposal institutionalProposal, Budget budget) {
        institutionalProposal.getInstitutionalProposalUnrecoveredFandAs().clear();
        for (BudgetUnrecoveredFandA budgetUfa : budget.getBudgetUnrecoveredFandAs()) {
            InstitutionalProposalUnrecoveredFandA ipUfa = new InstitutionalProposalUnrecoveredFandA();
            ipUfa.setApplicableIndirectcostRate(new ScaleTwoDecimal(budgetUfa.getApplicableRate().bigDecimalValue()));
            ipUfa.setFiscalYear(budgetUfa.getFiscalYear().toString());
            ipUfa.setOnCampusFlag(ACTIVE_VALUE.equals(budgetUfa.getOnCampusFlag()));
            ipUfa.setSourceAccount(budgetUfa.getSourceAccount());
            ipUfa.setIndirectcostRateTypeCode(Integer.parseInt(budget.getOhRateClassCode()));
            ipUfa.setUnderrecoveryOfIndirectcost(new ScaleTwoDecimal(budgetUfa.getAmount().bigDecimalValue()));
            institutionalProposal.add(ipUfa);
        }
        if (!institutionalProposal.getInstitutionalProposalUnrecoveredFandAs().isEmpty()) {
            institutionalProposal.setIdcRateIndicator(TRUE_INDICATOR_VALUE);
        }
    }

    private void populateCostSharesFromBudget(InstitutionalProposal institutionalProposal, Budget budget) {
        institutionalProposal.getInstitutionalProposalCostShares().clear();
        for (BudgetCostShare budgetCostShare : budget.getBudgetCostShares()) {
            InstitutionalProposalCostShare ipCostShare = new InstitutionalProposalCostShare();
            ipCostShare.setCostShareTypeCode(this.getCostShareTypeCode(budgetCostShare));
            if (this.isCostShareTypeEnabled()) {
                ProposalDevelopmentBudgetExt budgetExt = (ProposalDevelopmentBudgetExt)budgetCostShare.getBudget();
                institutionalProposal.getCostShareComment().setComments(budgetExt.getCostShareComment());
            }
            ipCostShare.setAmount(new ScaleTwoDecimal(budgetCostShare.getShareAmount().bigDecimalValue()));
            ipCostShare.setCostSharePercentage(new ScaleTwoDecimal(budgetCostShare.getSharePercentage().bigDecimalValue()));
            ipCostShare.setProjectPeriod(budgetCostShare.getProjectPeriod().toString());
            ipCostShare.setSourceAccount(budgetCostShare.getSourceAccount());
            ipCostShare.setUnitNumber(budgetCostShare.getUnitNumber());
            ipCostShare.setUnit(budgetCostShare.getUnit());
            institutionalProposal.add(ipCostShare);
        }
        if (!institutionalProposal.getInstitutionalProposalCostShares().isEmpty()) {
            institutionalProposal.setCostSharingIndicator(TRUE_INDICATOR_VALUE);
        }
    }

    protected Integer getCostShareTypeCode(BudgetCostShare budgetCostShare) {
        if (this.isCostShareTypeEnabled()) {
            return budgetCostShare.getCostShareTypeCode() == null ? this.getCostShareTypeDefault() : budgetCostShare.getCostShareTypeCode();
        }
        return DEFAULT_COST_SHARE_TYPE_CODE;
    }

    protected void copyIndirectRates(InstitutionalProposal institutionalProposal, Budget budget, Set<String> budgetRateClassCodes) {
        if (this.isLifecyleRatesFlowthruEnabled() && budget.getBudgetRates() != null) {
            budget.getBudgetRates().stream().filter(budgetRate -> budgetRate.getRateClass().getRateClassTypeCode().equalsIgnoreCase(RateClassType.OVERHEAD.getRateClassType()) && budgetRateClassCodes.contains(budgetRate.getRateClassCode())).forEach(budgetRate -> {
                InstitutionalProposalFandA fandA = new InstitutionalProposalFandA();
                fandA.setRateTypeCode(budgetRate.getRateClassCode());
                fandA.setActivityTypeCode(budgetRate.getActivityTypeCode());
                fandA.setFiscalYear(budgetRate.getFiscalYear());
                fandA.setApplicableRate(budgetRate.getApplicableRate());
                fandA.setInstituteRate(budgetRate.getInstituteRate());
                fandA.setOnOffCampusFlag(budgetRate.getOnOffCampusFlag());
                fandA.setStartDate(budgetRate.getStartDate());
                institutionalProposal.add(fandA);
            });
        }
    }

    protected Integer getDefaultStatusCode() {
        return 1;
    }

    protected Integer getWithdrawnStatusCode() {
        return 5;
    }

    protected boolean isLifecyleRatesFlowthruEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-IP", "All", "Enable_Lifecycle_Rates_Flowthru");
    }

    protected boolean isCostShareTypeEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "ENABLE_COST_SHARE_ACCOUNT_VALIDATION");
    }

    protected Integer getCostShareTypeDefault() {
        String costSharetype = this.parameterService.getParameterValueAsString("KC-IP", "All", "Default_IP_Award_Cost_Share_Type");
        return !StringUtils.isEmpty((CharSequence)costSharetype) ? Integer.valueOf(Integer.parseInt(costSharetype)) : null;
    }

    @Override
    public InstitutionalProposalDocument createAndSaveNewVersion(InstitutionalProposal currentInstitutionalProposal, InstitutionalProposalDocument currentInstitutionalProposalDocument) throws VersionException, WorkflowException {
        InstitutionalProposal newVersion = this.getVersioningService().createNewVersion(currentInstitutionalProposal);
        this.syncNewCustomAttributes(newVersion, currentInstitutionalProposal);
        newVersion.setProposalSequenceStatus(VersionStatus.PENDING.toString());
        newVersion.setAwardFundingProposals(List.of());
        InstitutionalProposalDocument newInstitutionalProposalDocument = (InstitutionalProposalDocument)this.getDocumentService().getNewDocument(InstitutionalProposalDocument.class);
        newInstitutionalProposalDocument.getDocumentHeader().setDocumentDescription(currentInstitutionalProposalDocument.getDocumentHeader().getDocumentDescription());
        newInstitutionalProposalDocument.setInstitutionalProposal(newVersion);
        this.getDocumentService().saveDocument((Document)newInstitutionalProposalDocument);
        return newInstitutionalProposalDocument;
    }

    protected void syncNewCustomAttributes(InstitutionalProposal newInstitutionalProposal, InstitutionalProposal oldInstitutionalProposal) {
        Set availableCustomAttributes = newInstitutionalProposal.getInstitutionalProposalCustomDataList().stream().map(customData -> customData.getCustomAttributeId().intValue()).collect(Collectors.toSet());
        if (oldInstitutionalProposal.getInstitutionalProposalDocument() != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = oldInstitutionalProposal.getInstitutionalProposalDocument().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                if (availableCustomAttributes.contains(customAttributeDocument.getId().intValue())) continue;
                InstitutionalProposalCustomData customData2 = new InstitutionalProposalCustomData();
                customData2.setCustomAttributeId(customAttributeDocument.getId());
                customData2.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                customData2.setValue("");
                customData2.setInstitutionalProposal(newInstitutionalProposal);
                newInstitutionalProposal.getInstitutionalProposalCustomDataList().add(customData2);
            }
        }
    }

    protected void setInstitutionalProposalIndicators(InstitutionalProposal institutionalProposal) {
        if (!institutionalProposal.getInstitutionalProposalCostShares().isEmpty()) {
            institutionalProposal.setCostSharingIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setCostSharingIndicator(FALSE_INDICATOR_VALUE);
        }
        if (!institutionalProposal.getSpecialReviews().isEmpty()) {
            institutionalProposal.setSpecialReviewIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setSpecialReviewIndicator(FALSE_INDICATOR_VALUE);
        }
        if (!institutionalProposal.getInstitutionalProposalUnrecoveredFandAs().isEmpty()) {
            institutionalProposal.setIdcRateIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setIdcRateIndicator(FALSE_INDICATOR_VALUE);
        }
        if (!institutionalProposal.getInstitutionalProposalScienceKeywords().isEmpty()) {
            institutionalProposal.setScienceCodeIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setScienceCodeIndicator(FALSE_INDICATOR_VALUE);
        }
    }

    @Override
    public ExconProjectAssociatedInfoBean.SyncAction createOrUpdateSpecialReview(String documentNumber, String referenceId, String specialReviewTypeCode, String approvalTypeCode, java.util.Date applicationDate, java.util.Date expirationDate, String protocolStatus) {
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)this.businessObjectService.findBySinglePrimaryKey(InstitutionalProposalDocument.class, (Object)documentNumber);
        if (document != null) {
            ExconProjectAssociatedInfoBean.SyncAction syncAction;
            InstitutionalProposalSpecialReview toUpdate;
            InstitutionalProposal institutionalProposal = document.getInstitutionalProposal();
            Optional<InstitutionalProposalSpecialReview> sr = this.findSpecialReview(institutionalProposal, referenceId, specialReviewTypeCode);
            if (sr.isPresent()) {
                toUpdate = sr.get();
                syncAction = ExconProjectAssociatedInfoBean.SyncAction.UPDATE;
            } else {
                toUpdate = new InstitutionalProposalSpecialReview();
                toUpdate.setSpecialReviewNumber(institutionalProposal.getInstitutionalProposalDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
                toUpdate.setSpecialReviewTypeCode(specialReviewTypeCode);
                toUpdate.setProposalId(institutionalProposal.getProposalId());
                toUpdate.setApprovalTypeCode(approvalTypeCode);
                toUpdate.setProtocolNumber(referenceId);
                institutionalProposal.getSpecialReviews().add(toUpdate);
                syncAction = ExconProjectAssociatedInfoBean.SyncAction.CREATE;
            }
            toUpdate.setProtocolStatus(protocolStatus);
            if (applicationDate != null) {
                toUpdate.setApplicationDate(new Date(applicationDate.getTime()));
            }
            if (expirationDate != null) {
                toUpdate.setExpirationDate(new Date(expirationDate.getTime()));
            }
            this.businessObjectService.save((PersistableBusinessObject)institutionalProposal);
            return syncAction;
        }
        return ExconProjectAssociatedInfoBean.SyncAction.NOOP;
    }

    @Override
    public ExconProjectAssociatedInfoBean.SyncAction deleteSpecialReview(String documentNumber, String referenceId, String specialReviewTypeCode) {
        return Optional.ofNullable((InstitutionalProposalDocument)this.businessObjectService.findBySinglePrimaryKey(InstitutionalProposalDocument.class, (Object)documentNumber)).map(InstitutionalProposalDocument::getInstitutionalProposal).map(proposal -> {
            this.businessObjectService.deleteMatching(InstitutionalProposalSpecialReview.class, Map.of("proposalId", proposal.getProposalId(), "protocolNumber", referenceId, "specialReviewTypeCode", specialReviewTypeCode));
            return ExconProjectAssociatedInfoBean.SyncAction.DELETE;
        }).orElse(ExconProjectAssociatedInfoBean.SyncAction.NOOP);
    }

    private Optional<InstitutionalProposalSpecialReview> findSpecialReview(InstitutionalProposal institutionalProposal, String referenceId, String specialReviewTypeCode) {
        institutionalProposal.refreshReferenceObject("specialReviews");
        return institutionalProposal.getSpecialReviews().stream().filter(sr -> referenceId.equals(sr.getProtocolNumber()) && specialReviewTypeCode.equals(sr.getSpecialReviewTypeCode())).findFirst();
    }

    @Override
    public Optional<InstitutionalProposal> verifyProposalSequencing(InstitutionalProposal institutionalProposal) throws WorkflowException {
        InstitutionalProposal maxSequencedProposal;
        Optional<InstitutionalProposal> lastProposalSequence = this.getLastProposalSequence(institutionalProposal.getProposalNumber());
        if (lastProposalSequence.isPresent() && (maxSequencedProposal = lastProposalSequence.get()).getProposalSequenceStatus().equals(VersionStatus.PENDING.name()) && maxSequencedProposal.getInstitutionalProposalDocument().getDocumentHeader().hasWorkflowDocument() && maxSequencedProposal.getInstitutionalProposalDocument().getDocumentHeader().getWorkflowDocument().isFinal()) {
            this.institutionalProposalVersioningService.updateInstitutionalProposalVersionStatus(maxSequencedProposal, VersionStatus.ACTIVE);
            LOG.info("An IP sequencing issue has been detected. Found an IP with the max sequence in PENDING status and a FINAL document status. Fixing it. Document Number = " + maxSequencedProposal.getInstitutionalProposalDocument().getDocumentNumber());
            return Optional.of(maxSequencedProposal);
        }
        return Optional.empty();
    }

    private Optional<InstitutionalProposal> getLastProposalSequence(String proposalNumber) throws WorkflowException {
        List institutionalProposals = this.getBusinessObjectService().findMatchingOrderBy(InstitutionalProposal.class, Map.of(PROPOSAL_NUMBER, proposalNumber, PROPOSAL_SEQUENCE_STATUS, List.of(VersionStatus.ACTIVE.name(), VersionStatus.ARCHIVED.name(), VersionStatus.PENDING.name())), SEQUENCE_NUMBER, false, new QueryPagingRequest(0, 0)).getResults();
        if (institutionalProposals.size() > 0) {
            InstitutionalProposal institutionalProposal = (InstitutionalProposal)institutionalProposals.get(0);
            institutionalProposal.setInstitutionalProposalDocument((InstitutionalProposalDocument)this.getDocumentService().getByDocumentHeaderId(institutionalProposal.getInstitutionalProposalDocument().getDocumentHeader().getDocumentNumber()));
            return Optional.of(institutionalProposal);
        }
        return Optional.empty();
    }

    public InstitutionalProposalPersonService getInstitutionalProposalPersonService() {
        return this.institutionalProposalPersonService;
    }

    public void setInstitutionalProposalPersonService(InstitutionalProposalPersonService institutionalProposalPersonService) {
        this.institutionalProposalPersonService = institutionalProposalPersonService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void setInstitutionalProposalVersioningService(InstitutionalProposalVersioningService institutionalProposalVersioningService) {
        this.institutionalProposalVersioningService = institutionalProposalVersioningService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    @Override
    public Collection<String> getValidFundingProposalStatusCodes() {
        String value = this.getParameterService().getParameterValueAsString(InstitutionalProposalDocument.class, VALID_FUNDING_PROPOSAL_STATUS_CODES);
        return Arrays.asList(value.split(SEPARATOR));
    }

    @Override
    public Long getProposalId(Award award) {
        return this.getInstitutionalProposalDao().getProposalId(award);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public InstitutionalProposalDao getInstitutionalProposalDao() {
        return this.institutionalProposalDao;
    }

    public void setInstitutionalProposalDao(InstitutionalProposalDao institutionalProposalDao) {
        this.institutionalProposalDao = institutionalProposalDao;
    }

    public ProjectRetrievalService getInstPropProjectRetrievalService() {
        return this.instPropProjectRetrievalService;
    }

    public void setInstPropProjectRetrievalService(ProjectRetrievalService instPropProjectRetrievalService) {
        this.instPropProjectRetrievalService = instPropProjectRetrievalService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }

    public ModularBudgetService getModularBudgetService() {
        return this.modularBudgetService;
    }

    public void setModularBudgetService(ModularBudgetService modularBudgetService) {
        this.modularBudgetService = modularBudgetService;
    }
}

