/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.OrganizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.type.ProposalType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersionStatusConstants;
import org.kuali.coeus.common.framework.version.history.VersionHistorySearchBo;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardAttachment;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardComment;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardCostType;
import org.kuali.kra.subaward.bo.SubAwardFfataReporting;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardNotepad;
import org.kuali.kra.subaward.bo.SubAwardPrintAgreement;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.kra.subaward.bo.SubAwardStatus;
import org.kuali.kra.subaward.bo.SubAwardTemplateAttachment;
import org.kuali.kra.subaward.bo.SubAwardTemplateInfo;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.notification.SubAwardNotification;
import org.kuali.kra.subaward.service.SubAwardFormsService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.AutoPopulatingList;

public class SubAward
extends KcPersistableBusinessObjectBase
implements Permissionable,
SequenceOwner<SubAward>,
CustomDataContainer,
Negotiable {
    private static final long serialVersionUID = 1L;
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    public static final String NOTIFICATION_TYPE_SUBMIT = "501";
    private static final int FDP_SPONSOR_ATTACHMENT_TYPE = 2;
    private Long subAwardId;
    private String subAwardCode;
    private Integer sequenceNumber;
    private String organizationId;
    private Date startDate;
    private Date endDate;
    private Integer subAwardTypeCode;
    private String title;
    private Integer statusCode;
    private String statusDescription;
    private String accountNumber;
    private String vendorNumber;
    private String requisitionerId;
    private String requisitionerUnit;
    private String archiveLocation;
    private Date closeoutDate;
    private String closeoutIndicator;
    private String fundingSourceIndicator;
    private String comments;
    private Integer siteInvestigator;
    private SubAwardDocument subAwardDocument;
    private SubAwardFundingSource subAwardFundingSource;
    private SubAwardContact subAwardContact;
    private SubAwardCloseout subAwardCloseout;
    private SubAwardReports subAwardReports;
    private String organizationName;
    private String requisitionerName;
    private String requisitionerUnitName;
    private String requisitionerUserName;
    private String siteInvestigatorName;
    private String siteInvestigatorId;
    private Organization organization;
    private Unit unit;
    private Rolodex rolodex;
    private transient String rolodexFirstName;
    private SubAwardStatus subAwardStatus;
    private AwardType subAwardType;
    private KcPerson kcPerson;
    private String subAwardSequenceStatus;
    private boolean newVersion;
    private ScaleTwoDecimal totalObligatedAmount;
    private ScaleTwoDecimal totalObligatedDirectAmount;
    private ScaleTwoDecimal totalObligatedIndirectAmount;
    private ScaleTwoDecimal totalAnticipatedAmount;
    private ScaleTwoDecimal totalAnticipatedDirectAmount;
    private ScaleTwoDecimal totalAnticipatedIndirectAmount;
    private ScaleTwoDecimal totalAmountReleased;
    private ScaleTwoDecimal totalAvailableAmount;
    private transient String docIdStatus;
    private transient String lastUpdate;
    private String awardNumber;
    private transient boolean editSubAward = false;
    private transient boolean defaultOpen = true;
    private Integer costType;
    private Date executionDate;
    private String requisitionId;
    private String fedAwardProjDesc;
    private ScaleTwoDecimal fAndARate;
    private Boolean deMinimus;
    private Boolean ffataRequired;
    private String fsrsSubawardNumber;
    private SubAwardCostType subAwardCostType;
    private Date modificationEffectiveDate;
    private String modificationId;
    private Date performanceStartDate;
    private Date performanceEnddate;
    private List<SubAwardAttachment> subAwardAttachments;
    private List<SubAwardTemplateAttachment> subAwardTemplateAttachments;
    private List<SubAwardReports> subAwardReportList;
    private List<SubAwardTemplateInfo> subAwardTemplateInfo;
    private List<SubAwardPrintAgreement> subAwardPrintAgreement;
    @SkipVersioning
    private transient List<SubAwardForms> subAwardForms;
    private List<SubAwardFundingSource> subAwardFundingSourceList;
    private List<SubAwardAmountInfo> subAwardAmountInfoList;
    private List<SubAwardContact> subAwardContactsList;
    private List<SubAwardCloseout> subAwardCloseoutList;
    private List<SubAwardCustomData> subAwardCustomDataList;
    private List<SubAwardFfataReporting> subAwardFfataReporting;
    private List<SubAwardNotification> subAwardNotifications;
    private transient List<SubAwardNotification> allSubAwardNotifications;
    private List<SubAwardNotepad> subAwardNotepads;
    private List<SubAwardComment> subAwardComments;
    @SkipVersioning
    private transient List<SubAwardAmountReleased> subAwardAmountReleasedList;
    @SkipVersioning
    private transient List<SubAwardTemplateAttachment> subAwardTemplateAttachmentsForPrint;
    private VersionHistorySearchBo versionHistory;
    private transient BusinessObjectService businessObjectService;
    private transient SubAwardFormsService subAwardFormsService;
    private transient ParameterService parameterService;

    public List<SubAwardForms> getSubAwardForms() {
        if (CollectionUtils.isEmpty(this.subAwardForms)) {
            this.subAwardForms = this.getSubAwardFormsService().activeByTemplateTypeCode(2);
        }
        return this.subAwardForms;
    }

    public List<SubAwardPrintAgreement> getSubAwardPrintAgreement() {
        if (this.subAwardPrintAgreement == null) {
            this.subAwardPrintAgreement = new ArrayList<SubAwardPrintAgreement>();
        }
        return this.subAwardPrintAgreement;
    }

    public void setSubAwardPrintAgreement(List<SubAwardPrintAgreement> subAwardPrintAgreement) {
        this.subAwardPrintAgreement = subAwardPrintAgreement;
    }

    public List<SubAwardTemplateInfo> getSubAwardTemplateInfo() {
        if (this.subAwardTemplateInfo == null) {
            this.subAwardTemplateInfo = new ArrayList<SubAwardTemplateInfo>();
        }
        return this.subAwardTemplateInfo;
    }

    public void setSubAwardTemplateInfo(List<SubAwardTemplateInfo> subAwardTemplateInfo) {
        this.subAwardTemplateInfo = subAwardTemplateInfo;
    }

    public SubAwardTemplateInfo getSingleSubAwardTemplateInfo() {
        return org.kuali.coeus.sys.framework.util.CollectionUtils.validIndexForList(0, this.getSubAwardTemplateInfo()) ? this.getSubAwardTemplateInfo().get(0) : null;
    }

    public void setSingleSubAwardTemplateInfo(SubAwardTemplateInfo singleSubAwardTemplateInfo) {
        List<SubAwardTemplateInfo> templates = this.getSubAwardTemplateInfo();
        if (org.kuali.coeus.sys.framework.util.CollectionUtils.validIndexForList(0, templates)) {
            templates.set(0, singleSubAwardTemplateInfo);
        } else {
            templates.add(singleSubAwardTemplateInfo);
        }
    }

    public List<SubAwardAttachment> getSubAwardAttachments() {
        if (this.subAwardAttachments == null) {
            this.subAwardAttachments = new ArrayList<SubAwardAttachment>();
        }
        return this.subAwardAttachments;
    }

    public void setSubAwardAttachments(List<SubAwardAttachment> subAwardAttachments) {
        this.subAwardAttachments = subAwardAttachments;
    }

    public SubAwardAttachment getSubAwardAttachment(int index) {
        return this.subAwardAttachments.get(index);
    }

    public void addSubAwardAttachment(SubAwardAttachment subAwardAttachment) {
        this.getSubAwardAttachments().add(subAwardAttachment);
        subAwardAttachment.setSubAward(this);
    }

    public List<SubAwardTemplateAttachment> getSubAwardTemplateAttachments() {
        if (this.subAwardTemplateAttachments == null) {
            this.subAwardTemplateAttachments = new ArrayList<SubAwardTemplateAttachment>();
        }
        return this.subAwardTemplateAttachments;
    }

    public void setSubAwardTemplateAttachments(List<SubAwardTemplateAttachment> subAwardTemplateAttachments) {
        this.subAwardTemplateAttachments = subAwardTemplateAttachments;
    }

    public SubAwardTemplateAttachment getSubAwardTemplateAttachment(int index) {
        return this.subAwardTemplateAttachments.get(index);
    }

    public void addSubAwardTemplateAttachment(SubAwardTemplateAttachment subAwardTemplateAttachment) {
        this.getSubAwardTemplateAttachments().add(subAwardTemplateAttachment);
        subAwardTemplateAttachment.setSubAward(this);
    }

    @Deprecated
    public void setSubAwardTemplateAttachmentsForPrint(List<SubAwardTemplateAttachment> subAwardTemplateAttachmentsForPrint) {
        this.subAwardTemplateAttachmentsForPrint = subAwardTemplateAttachmentsForPrint;
    }

    @Deprecated
    public List<SubAwardTemplateAttachment> getSubAwardTemplateAttachmentsForPrint() {
        if (this.subAwardTemplateAttachmentsForPrint == null) {
            List printAttachmentTypeInclusion = Arrays.stream(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "Subaward_Print_Attachment_Type_Inclusion").split(",")).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.toList());
            List attachments = this.getSubAwardTemplateAttachments().stream().filter(attach -> printAttachmentTypeInclusion.contains(attach.getSubAwardAttachmentTypeCode().toString())).filter(attach -> PdfBoxUtils.isValidPdf(attach.getAttachmentContent())).sorted(Comparator.comparing(attach -> printAttachmentTypeInclusion.indexOf(attach.getSubAwardAttachmentTypeCode().toString()))).collect(Collectors.toList());
            int size = attachments.size();
            if (size > 0) {
                int halfSize = SubAward.isEven(size) ? size / 2 : (size + 1) / 2;
                List left = attachments.subList(0, halfSize);
                List right = attachments.subList(halfSize, size);
                ArrayList<SubAwardTemplateAttachment> sorted = new ArrayList<SubAwardTemplateAttachment>();
                for (int i = 0; i < left.size(); ++i) {
                    sorted.add((SubAwardTemplateAttachment)left.get(i));
                    if (right.size() <= i) continue;
                    sorted.add((SubAwardTemplateAttachment)right.get(i));
                }
                this.subAwardTemplateAttachmentsForPrint = sorted;
            } else {
                this.subAwardTemplateAttachmentsForPrint = Collections.emptyList();
            }
        }
        return this.subAwardTemplateAttachmentsForPrint;
    }

    public SubAwardReports getSubAwardReports() {
        return this.subAwardReports;
    }

    public void setSubAwardReports(SubAwardReports subAwardReports) {
        this.subAwardReports = subAwardReports;
    }

    public List<SubAwardReports> getSubAwardReportList() {
        if (this.subAwardReportList == null) {
            this.subAwardReportList = new ArrayList<SubAwardReports>();
        }
        return this.subAwardReportList;
    }

    public void setSubAwardReportList(List<SubAwardReports> subAwardReportList) {
        this.subAwardReportList = subAwardReportList;
    }

    public void setReports(List<SubAwardReports> reports) {
        this.subAwardReportList = reports;
    }

    public SubAwardReports getSubAwardReportList(int index) {
        return this.subAwardReportList.get(index);
    }

    public void addReport(SubAwardReports report) {
        this.getSubAwardReportList().add(report);
        report.setSubAward(this);
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public KcPerson getKcPerson() {
        return this.kcPerson;
    }

    public void setKcPerson(KcPerson kcPerson) {
        this.kcPerson = kcPerson;
    }

    public String getSubAwardSequenceStatus() {
        return this.subAwardSequenceStatus;
    }

    public void setSubAwardSequenceStatus(String subAwardSequenceStatus) {
        this.subAwardSequenceStatus = subAwardSequenceStatus;
    }

    public String getSubAwardSequenceStatusResult() {
        if (VersionStatusConstants.ACTIVE.getCode().equals(this.getSubAwardSequenceStatus())) {
            return VersionStatusConstants.ACTIVE.getDescription();
        }
        return VersionStatusConstants.PENDING.getDescription();
    }

    public String getRolodexFirstName() {
        if (this.getRolodex() == null) {
            return this.rolodexFirstName;
        }
        return this.getRolodex().getFirstName();
    }

    public void setRolodexFirstName(String rolodexFirstName) {
        this.rolodexFirstName = rolodexFirstName;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getOrganizationName() {
        Organization organization = this.getOrganization();
        if (organization != null) {
            return organization.getOrganizationName();
        }
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getRequisitionerName() {
        this.getRequisitionerUserName();
        return this.requisitionerName;
    }

    public void setRequisitionerName(String requisitionerName) {
        this.requisitionerName = requisitionerName;
    }

    public String getRequisitionerUnitName() {
        return this.requisitionerUnitName;
    }

    public void setRequisitionerUnitName(String requisitionerUnitName) {
        this.requisitionerUnitName = requisitionerUnitName;
    }

    public String getRequisitionerUserName() {
        if (this.requisitionerId != null) {
            KcPerson requisitioner = this.getRequisitioner();
            if (requisitioner != null) {
                this.requisitionerName = requisitioner.getFullName();
                this.requisitionerUserName = requisitioner.getUserName();
            }
        } else {
            this.requisitionerName = null;
        }
        return this.requisitionerUserName;
    }

    public void setRequisitionerUserName(String requisitionerUserName) {
        if (requisitionerUserName != null) {
            KcPerson requisitioner = KcServiceLocator.getService(KcPersonService.class).getKcPersonByUserName(requisitionerUserName);
            if (requisitioner != null) {
                this.requisitionerId = requisitioner.getPersonId();
            }
        } else {
            this.requisitionerName = null;
        }
        this.requisitionerUserName = requisitionerUserName;
    }

    public KcPerson getRequisitioner() {
        if (this.requisitionerId != null) {
            return KcServiceLocator.getService(KcPersonService.class).getKcPersonByPersonId(this.requisitionerId);
        }
        return null;
    }

    public String getSiteInvestigatorName() {
        return this.siteInvestigatorName;
    }

    public void setSiteInvestigatorName(String siteInvestigatorName) {
        this.siteInvestigatorName = siteInvestigatorName;
    }

    public SubAward() {
        this.initializeCollections();
        this.initialize();
    }

    protected void initialize() {
        this.setSequenceNumber(1);
        this.subAwardSequenceStatus = VersionStatus.PENDING.name();
        this.setNewVersion(false);
    }

    public Long getSubAwardId() {
        return this.subAwardId;
    }

    public void setSubAwardId(Long subAwardId) {
        this.subAwardId = subAwardId;
    }

    public String getSubAwardCode() {
        return this.subAwardCode;
    }

    public void setSubAwardCode(String subAwardCode) {
        this.subAwardCode = subAwardCode;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getOrganizationId() {
        OrganizationService organizationService = KcServiceLocator.getService(OrganizationService.class);
        this.organization = organizationService.getOrganization(this.organizationId);
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getSubAwardTypeCode() {
        return this.subAwardTypeCode;
    }

    public void setSubAwardTypeCode(Integer subAwardTypeCode) {
        this.subAwardTypeCode = subAwardTypeCode;
    }

    public String getPurchaseOrderNum() {
        return this.getSubAwardAmountInfoList().stream().map(SubAwardAmountInfo::getPurchaseOrderNum).filter(Objects::nonNull).distinct().collect(Collectors.joining(", "));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getVendorNumber() {
        return this.vendorNumber;
    }

    public void setVendorNumber(String vendorNumber) {
        this.vendorNumber = vendorNumber;
    }

    public String getRequisitionerId() {
        return this.requisitionerId;
    }

    public void setRequisitionerId(String requisitionerId) {
        this.requisitionerId = requisitionerId;
    }

    public String getRequisitionerUnit() {
        if (this.requisitionerUnit != null) {
            UnitService unitService = KcServiceLocator.getService(UnitService.class);
            this.unit = unitService.getUnit(this.requisitionerUnit);
        }
        return this.requisitionerUnit;
    }

    public void setRequisitionerUnit(String requisitionerUnit) {
        this.requisitionerUnit = requisitionerUnit;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public Date getCloseoutDate() {
        return this.closeoutDate;
    }

    public void setCloseoutDate(Date closeoutDate) {
        this.closeoutDate = closeoutDate;
    }

    public String getCloseoutIndicator() {
        return this.closeoutIndicator;
    }

    public void setCloseoutIndicator(String closeoutIndicator) {
        this.closeoutIndicator = closeoutIndicator;
    }

    public String getFundingSourceIndicator() {
        return this.fundingSourceIndicator;
    }

    public void setFundingSourceIndicator(String fundingSourceIndicator) {
        this.fundingSourceIndicator = fundingSourceIndicator;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getSiteInvestigator() {
        if (this.siteInvestigator != null) {
            this.rolodex = (Rolodex)this.getBusinessObjectService().findByPrimaryKey(Rolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, this.siteInvestigator));
            this.siteInvestigatorId = this.rolodex.getRolodexId().toString();
        } else {
            this.rolodex = null;
        }
        return this.siteInvestigator;
    }

    public void setSiteInvestigator(Integer siteInvestigator) {
        if (siteInvestigator != null) {
            this.rolodex = (Rolodex)this.getBusinessObjectService().findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, siteInvestigator));
            this.siteInvestigatorId = this.rolodex.getRolodexId().toString();
        }
        this.siteInvestigator = siteInvestigator;
    }

    public SubAwardFundingSource getSubAwardFundingSource() {
        return this.subAwardFundingSource;
    }

    public void setSubAwardFundingSource(SubAwardFundingSource subAwardFundingSource) {
        this.subAwardFundingSource = subAwardFundingSource;
    }

    public SubAwardContact getSubAwardContact() {
        return this.subAwardContact;
    }

    public void setSubAwardContact(SubAwardContact subAwardContact) {
        this.subAwardContact = subAwardContact;
    }

    public SubAwardCloseout getSubAwardCloseout() {
        return this.subAwardCloseout;
    }

    public void setSubAwardCloseout(SubAwardCloseout subAwardCloseout) {
        this.subAwardCloseout = subAwardCloseout;
    }

    public List<SubAwardFundingSource> getSubAwardFundingSourceList() {
        return this.subAwardFundingSourceList;
    }

    public void setSubAwardFundingSourceList(List<SubAwardFundingSource> subAwardFundingSourceList) {
        this.subAwardFundingSourceList = subAwardFundingSourceList;
    }

    public List<SubAwardAmountInfo> getSubAwardAmountInfoList() {
        return this.subAwardAmountInfoList;
    }

    public void setSubAwardAmountInfoList(List<SubAwardAmountInfo> subAwardAmountInfoList) {
        this.subAwardAmountInfoList = subAwardAmountInfoList;
    }

    public List<SubAwardAmountReleased> getSubAwardAmountReleasedList() {
        if (this.subAwardAmountReleasedList == null) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("subAwardCode", this.getSubAwardCode());
            this.setSubAwardAmountReleasedList((List)this.getCreatedDate(values));
        }
        return this.subAwardAmountReleasedList;
    }

    public Collection<SubAwardAmountReleased> getCreatedDate(Map<String, Object> values) {
        return this.getBusinessObjectService().findMatchingOrderBy(SubAwardAmountReleased.class, values, "createdDate", false);
    }

    public void setSubAwardAmountReleasedList(List<SubAwardAmountReleased> subAwardAmountReleasedList) {
        this.subAwardAmountReleasedList = subAwardAmountReleasedList;
    }

    public List<SubAwardContact> getSubAwardContactsList() {
        return this.subAwardContactsList;
    }

    public void setSubAwardContactsList(List<SubAwardContact> subAwardContactsList) {
        this.subAwardContactsList = subAwardContactsList;
    }

    public List<SubAwardCloseout> getSubAwardCloseoutList() {
        return this.subAwardCloseoutList;
    }

    public void setSubAwardCloseoutList(List<SubAwardCloseout> subAwardCloseoutList) {
        this.subAwardCloseoutList = subAwardCloseoutList;
    }

    public List<SubAwardCustomData> getSubAwardCustomDataList() {
        return this.subAwardCustomDataList;
    }

    public void setSubAwardCustomDataList(List<SubAwardCustomData> subAwardCustomDataList) {
        this.subAwardCustomDataList = subAwardCustomDataList;
    }

    public List<SubAwardFfataReporting> getSubAwardFfataReporting() {
        return this.subAwardFfataReporting;
    }

    public void setSubAwardFfataReporting(List<SubAwardFfataReporting> subAwardFfataReporting) {
        this.subAwardFfataReporting = subAwardFfataReporting;
    }

    public String getStatusDescription() {
        SubAwardStatus status = this.getSubAwardStatus();
        this.statusDescription = status != null ? status.getDescription() : null;
        return this.statusDescription;
    }

    protected void initializeCollections() {
        this.subAwardFundingSourceList = new AutoPopulatingList(SubAwardFundingSource.class);
        this.subAwardAmountInfoList = new AutoPopulatingList(SubAwardAmountInfo.class);
        this.subAwardContactsList = new AutoPopulatingList(SubAwardContact.class);
        this.subAwardCloseoutList = new AutoPopulatingList(SubAwardCloseout.class);
        this.subAwardCustomDataList = new AutoPopulatingList(SubAwardCustomData.class);
        this.subAwardReportList = new AutoPopulatingList(SubAwardReports.class);
        this.subAwardFfataReporting = new AutoPopulatingList(SubAwardFfataReporting.class);
        this.subAwardNotifications = new ArrayList<SubAwardNotification>();
        this.subAwardComments = new AutoPopulatingList(SubAwardComment.class);
        this.subAwardNotepads = new AutoPopulatingList(SubAwardNotepad.class);
    }

    public void setSubAwardDocument(SubAwardDocument subAwardDocument) {
        this.subAwardDocument = subAwardDocument;
    }

    public SubAwardDocument getSubAwardDocument() {
        if (this.subAwardDocument == null) {
            this.refreshReferenceObject("subAwardDocument");
        }
        return this.subAwardDocument;
    }

    public void setSubAwardStatus(SubAwardStatus subAwardStatus) {
        this.subAwardStatus = subAwardStatus;
    }

    public SubAwardStatus getSubAwardStatus() {
        if (this.subAwardStatus == null && this.statusCode != null) {
            this.refreshReferenceObject("subAwardStatus");
        }
        return this.subAwardStatus;
    }

    public void setSubAwardType(AwardType subAwardType) {
        this.subAwardType = subAwardType;
    }

    public AwardType getSubAwardType() {
        return this.subAwardType;
    }

    @Override
    public String getDocumentNumberForPermission() {
        if (this.subAwardId != null) {
            return this.subAwardId.toString();
        }
        return null;
    }

    @Override
    public String getDocumentKey() {
        return "SubAwardDocument";
    }

    @Override
    public List<String> getRoleNames() {
        return null;
    }

    @Override
    public String getNamespace() {
        return "KC-SUBAWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnit() != null ? this.getUnit().getUnitNumber() : "";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return null;
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (this.getSubAwardDocument() != null) {
            qualifiedRoleAttributes.put("documentNumber", this.getSubAwardDocument().getDocumentNumber());
        }
    }

    @Override
    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
    }

    @Override
    public void setSequenceOwner(SubAward newlyVersionedOwner) {
    }

    @Override
    public SubAward getSequenceOwner() {
        return this;
    }

    @Override
    public void resetPersistenceState() {
        this.subAwardId = null;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public String getVersionNameField() {
        return "subAwardCode";
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.subAwardCode;
    }

    public void setNewVersion(boolean newVersion) {
        this.newVersion = newVersion;
    }

    public boolean getNewVersion() {
        return this.newVersion;
    }

    public ScaleTwoDecimal getTotalObligatedAmount() {
        return this.totalObligatedAmount;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setTotalObligatedAmount(ScaleTwoDecimal totalObligatedAmount) {
        this.totalObligatedAmount = totalObligatedAmount;
    }

    public ScaleTwoDecimal getTotalAnticipatedAmount() {
        return this.totalAnticipatedAmount;
    }

    public void setTotalAnticipatedAmount(ScaleTwoDecimal totalAnticipatedAmount) {
        this.totalAnticipatedAmount = totalAnticipatedAmount;
    }

    public ScaleTwoDecimal getTotalAmountReleased() {
        return this.totalAmountReleased;
    }

    public void setTotalAmountReleased(ScaleTwoDecimal totalAmountReleased) {
        this.totalAmountReleased = totalAmountReleased;
    }

    public ScaleTwoDecimal getTotalAvailableAmount() {
        return this.totalAvailableAmount;
    }

    public void setTotalAvailableAmount(ScaleTwoDecimal totalAvailableAmount) {
        this.totalAvailableAmount = totalAvailableAmount;
    }

    public String getDocIdStatus() {
        return this.docIdStatus;
    }

    public void setDocIdStatus(String docIdStatus) {
        this.docIdStatus = docIdStatus;
    }

    public String getSiteInvestigatorId() {
        if (this.siteInvestigatorId == null && this.siteInvestigator != null) {
            this.siteInvestigatorId = this.siteInvestigator.toString();
        }
        return this.siteInvestigatorId;
    }

    public void setSiteInvestigatorId(String siteInvestigatorId) {
        this.siteInvestigatorId = siteInvestigatorId;
    }

    @Override
    public String getAssociatedDocumentId() {
        return this.getSubAwardCode();
    }

    @Override
    public String getLeadUnitName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : "";
    }

    @Override
    public String getPiName() {
        return "";
    }

    @Override
    public String getPiEmployeeName() {
        return "";
    }

    @Override
    public String getPiNonEmployeeName() {
        return "";
    }

    @Override
    public String getAdminPersonName() {
        return "";
    }

    @Override
    public String getSponsorCode() {
        return "";
    }

    @Override
    public String getSponsorName() {
        return "";
    }

    @Override
    public String getPrimeSponsorCode() {
        return "";
    }

    @Override
    public String getPrimeSponsorName() {
        return "";
    }

    @Override
    public String getSponsorAwardNumber() {
        return "";
    }

    @Override
    public String getSubAwardOrganizationName() {
        return this.getOrganization() != null ? this.getOrganization().getOrganizationName() : "";
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> people = new ArrayList<NegotiationPersonDTO>();
        if (this.getKcPerson() != null) {
            people.add(new NegotiationPersonDTO(this.getKcPerson(), "admin"));
        }
        return people;
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return "";
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return null;
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return this.getRequisitionerName();
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return this.getUnit() != null ? this.getUnit().getUnitNumber() : "";
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : "";
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return this.getRequisitionerId();
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public boolean isEditSubAward() {
        return this.editSubAward;
    }

    public void setEditSubAward(boolean editSubAward) {
        this.editSubAward = editSubAward;
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    public boolean isDefaultOpen() {
        return this.defaultOpen;
    }

    public void setDefaultOpen(boolean defaultOpen) {
        this.defaultOpen = defaultOpen;
    }

    public Integer getCostType() {
        return this.costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public String getRequisitionId() {
        return this.requisitionId;
    }

    public void setRequisitionId(String requisitionId) {
        this.requisitionId = requisitionId;
    }

    public SubAwardCostType getSubAwardCostType() {
        return this.subAwardCostType;
    }

    public void setSubAwardCostType(SubAwardCostType subAwardCostType) {
        this.subAwardCostType = subAwardCostType;
    }

    public Date getModificationEffectiveDate() {
        return this.modificationEffectiveDate;
    }

    public void setModificationEffectiveDate(Date modificationEffectiveDate) {
        this.modificationEffectiveDate = modificationEffectiveDate;
    }

    public String getModificationId() {
        return this.modificationId;
    }

    public void setModificationId(String modificationId) {
        this.modificationId = modificationId;
    }

    public Date getPerformanceStartDate() {
        return this.performanceStartDate;
    }

    public void setPerformanceStartDate(Date performanceStartDate) {
        this.performanceStartDate = performanceStartDate;
    }

    public Date getPerformanceEnddate() {
        return this.performanceEnddate;
    }

    public void setPerformanceEnddate(Date performanceEnddate) {
        this.performanceEnddate = performanceEnddate;
    }

    public VersionHistorySearchBo getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(VersionHistorySearchBo versionHistory) {
        this.versionHistory = versionHistory;
    }

    public Boolean getDeMinimus() {
        return this.deMinimus;
    }

    public void setDeMinimus(Boolean deMinimus) {
        this.deMinimus = deMinimus;
    }

    public Boolean getFfataRequired() {
        return this.ffataRequired;
    }

    public void setFfataRequired(Boolean ffataRequired) {
        this.ffataRequired = ffataRequired;
    }

    public String getFsrsSubawardNumber() {
        return this.fsrsSubawardNumber;
    }

    public void setFsrsSubawardNumber(String fsrsSubawardNumber) {
        this.fsrsSubawardNumber = fsrsSubawardNumber;
    }

    public ScaleTwoDecimal getfAndARate() {
        return this.fAndARate;
    }

    public void setfAndARate(ScaleTwoDecimal fAndARate) {
        this.fAndARate = fAndARate;
    }

    public String getFedAwardProjDesc() {
        return this.fedAwardProjDesc;
    }

    public void setFedAwardProjDesc(String fedAwardProjDesc) {
        this.fedAwardProjDesc = fedAwardProjDesc;
    }

    public SubAwardAmountInfo getLatestSubAwardAmountInfo() {
        if (this.getSubAwardAmountInfoList().size() > 0) {
            return this.getSubAwardAmountInfoList().get(this.getSubAwardAmountInfoList().size() - 1);
        }
        return null;
    }

    public ScaleTwoDecimal getTotalObligatedDirectAmount() {
        return this.totalObligatedDirectAmount;
    }

    public void setTotalObligatedDirectAmount(ScaleTwoDecimal totalObligatedDirectAmount) {
        this.totalObligatedDirectAmount = totalObligatedDirectAmount;
    }

    public ScaleTwoDecimal getTotalObligatedIndirectAmount() {
        return this.totalObligatedIndirectAmount;
    }

    public void setTotalObligatedIndirectAmount(ScaleTwoDecimal totalObligatedIndirectAmount) {
        this.totalObligatedIndirectAmount = totalObligatedIndirectAmount;
    }

    public ScaleTwoDecimal getTotalAnticipatedDirectAmount() {
        return this.totalAnticipatedDirectAmount;
    }

    public void setTotalAnticipatedDirectAmount(ScaleTwoDecimal totalAnticipatedDirectAmount) {
        this.totalAnticipatedDirectAmount = totalAnticipatedDirectAmount;
    }

    public ScaleTwoDecimal getTotalAnticipatedIndirectAmount() {
        return this.totalAnticipatedIndirectAmount;
    }

    public void setTotalAnticipatedIndirectAmount(ScaleTwoDecimal totalAnticipatedIndirectAmount) {
        this.totalAnticipatedIndirectAmount = totalAnticipatedIndirectAmount;
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getSubAwardCustomDataList();
    }

    public List<SubAwardNotification> getSubAwardNotifications() {
        return this.subAwardNotifications;
    }

    public void setSubAwardNotifications(List<SubAwardNotification> subAwardNotifications) {
        this.subAwardNotifications = subAwardNotifications;
    }

    public void addNotification(SubAwardNotification subAwardNotification) {
        this.allSubAwardNotifications = null;
        this.subAwardNotifications.add(subAwardNotification);
    }

    public void setAllSubAwardNotifications(List<SubAwardNotification> subAwardNotifications) {
        this.subAwardNotifications = subAwardNotifications;
    }

    public List<SubAwardNotification> getAllSubAwardNotifications() {
        if (this.allSubAwardNotifications == null) {
            this.allSubAwardNotifications = new ArrayList<SubAwardNotification>(this.getBusinessObjectService().findMatching(SubAwardNotification.class, Collections.singletonMap("subAwardCode", this.getSubAwardCode())));
        }
        return this.allSubAwardNotifications;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SubAwardFormsService getSubAwardFormsService() {
        if (this.subAwardFormsService == null) {
            this.subAwardFormsService = KcServiceLocator.getService(SubAwardFormsService.class);
        }
        return this.subAwardFormsService;
    }

    public void setSubAwardFormsService(SubAwardFormsService subAwardFormsService) {
        this.subAwardFormsService = subAwardFormsService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void add(SubAwardComment subAwardComment) {
        this.subAwardComments.add(subAwardComment);
        subAwardComment.setSubAward(this);
    }

    public void add(SubAwardNotepad subAwardNotepad) {
        subAwardNotepad.setEntryNumber(this.subAwardNotepads.size() + 1);
        subAwardNotepad.setSubAwardCode(this.getSubAwardCode());
        this.subAwardNotepads.add(subAwardNotepad);
        subAwardNotepad.setSubAward(this);
    }

    public List<SubAwardNotepad> getSubAwardNotepads() {
        return this.subAwardNotepads;
    }

    public void setSubAwardNotepads(List<SubAwardNotepad> subAwardNotepads) {
        this.subAwardNotepads = subAwardNotepads;
    }

    public List<SubAwardComment> getSubAwardComments() {
        return this.subAwardComments;
    }

    public void setSubAwardComments(List<SubAwardComment> subAwardComments) {
        this.subAwardComments = subAwardComments;
    }

    public SubAwardComment getSubAwardComment(int index) {
        while (this.getSubAwardComments().size() <= index) {
            this.getSubAwardComments().add(new SubAwardComment());
        }
        return this.getSubAwardComments().get(index);
    }

    private static boolean isEven(int i) {
        return (i & 1) == 0;
    }
}

