/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.reporting.printing.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.AcroFormPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.ActionDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.MapActionDto;
import org.kuali.coeus.common.api.pdf.dto.MappingDefinitionDto;
import org.kuali.coeus.common.api.pdf.dto.SingleTargetAction;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.api.unit.UnitDto;
import org.kuali.coeus.common.api.unit.UnitRestController;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.subaward.api.SubawardDocumentController;
import org.kuali.coeus.subaward.dto.SubawardDto;
import org.kuali.coeus.subaward.dto.SubawardTemplateAttachmentDto;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardPrintAgreement;
import org.kuali.kra.subaward.bo.SubAwardTemplateAttachment;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF294Print;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF295Print;
import org.kuali.kra.subaward.reporting.printing.service.SubAwardPrintingService;
import org.kuali.kra.subaward.service.SubAwardFormsService;
import org.kuali.kra.subawardReporting.printing.print.SubAwardFDPAgreement;
import org.kuali.kra.subawardReporting.printing.print.SubAwardFDPModification;
import org.kuali.kra.subawardReporting.printing.print.SubawardFdp;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.http.HttpMethod;

public class SubAwardPrintingServiceImpl
implements SubAwardPrintingService {
    private static final Logger LOG = LogManager.getLogger(SubAwardPrintingServiceImpl.class);
    private static final String SF_295_REPORT = "SF295";
    private static final String SF_294_REPORT = "SF294";
    private static final String SUB_AWARD_FDP_TEMPLATE = "fdpAgreement";
    private static final String SUB_AWARD_FDP_MODIFICATION = "fdpModification";
    private static final String FDP_FROM_PARENT_AWARD = "FDP_FROM_PARENT_AWARD";
    private static final String APPLICATION_URL = "application.url";
    private SubAwardSF294Print subAwardSF294Print;
    private SubAwardSF295Print subAwardSF295Print;
    private PrintingService printingService;
    private SubAwardFDPModification subAwardFDPModification;
    private SubAwardFDPAgreement subAwardFDPAgreement;
    private SubAwardFormsService subAwardFormsService;
    private ParameterService parameterService;
    private AwardVersionService awardVersionService;
    private AwardHierarchyService awardHierarchyService;
    private PdfService pdfService;
    private ConfigurationService configurationService;
    private SubawardDocumentController subawardDocumentController;
    private UnitRestController unitRestController;
    private JwtService jwtService;
    private ObjectMapper objectMapper;

    public SubAwardFDPModification getSubAwardFDPModification() {
        return this.subAwardFDPModification;
    }

    public void setSubAwardFDPModification(SubAwardFDPModification subAwardFDPModification) {
        this.subAwardFDPModification = subAwardFDPModification;
    }

    public SubAwardFDPAgreement getSubAwardFDPAgreement() {
        return this.subAwardFDPAgreement;
    }

    public void setSubAwardFDPAgreement(SubAwardFDPAgreement subAwardFDPAgreement) {
        this.subAwardFDPAgreement = subAwardFDPAgreement;
    }

    @Override
    public AttachmentDataSource printSubAwardReport(KcPersistableBusinessObjectBase awardDocument, SubAwardPrintType subAwardPrintType, Map<String, Object> reportParameters) throws PrintingException {
        AbstractPrint printable = null;
        if (reportParameters.get("printType") != null) {
            printable = reportParameters.get("printType").equals(SF_295_REPORT) ? this.getSubAwardSF295Print() : this.getSubAwardSF294Print();
        }
        printable.setPrintableBusinessObject(awardDocument);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.getPrintingService().print(printable);
        source.setType("application/pdf");
        if (reportParameters.get("printType").equals(SF_295_REPORT)) {
            source.setName("SF295.pdf");
        } else {
            source.setName("SF294.pdf");
        }
        return source;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public SubAwardSF294Print getSubAwardSF294Print() {
        return this.subAwardSF294Print;
    }

    public void setSubAwardSF294Print(SubAwardSF294Print subAwardSF294Print) {
        this.subAwardSF294Print = subAwardSF294Print;
    }

    public SubAwardSF295Print getSubAwardSF295Print() {
        return this.subAwardSF295Print;
    }

    public void setSubAwardSF295Print(SubAwardSF295Print subAwardSF295Print) {
        this.subAwardSF295Print = subAwardSF295Print;
    }

    protected AttachmentDataSource printSubAwardFDPReport(KcPersistableBusinessObjectBase subAwardDoc, Map<String, Object> reportParameters) throws PrintingException {
        SubawardFdp printable = null;
        if (reportParameters.get("fdpType") != null) {
            printable = reportParameters.get("fdpType").equals(SUB_AWARD_FDP_TEMPLATE) ? this.getSubAwardFDPAgreement() : this.getSubAwardFDPModification();
        }
        SubAward subAward = (SubAward)subAwardDoc;
        Map formAttachments = subAward.getSubAwardTemplateAttachmentsForPrint().stream().filter(SubAwardTemplateAttachment::getSelectToPrint).map(attach -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(attach.getAttachmentId().toString(), attach.getAttachmentContent())).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap(LinkedHashMap::new));
        this.resetSelectedFormList(subAward.getSubAwardTemplateAttachments());
        printable.setAttachments(formAttachments);
        printable.setPrintableBusinessObject(subAwardDoc);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.getPrintingService().print(printable);
        source.setType("application/pdf");
        if (reportParameters.get("fdpType").equals(SUB_AWARD_FDP_TEMPLATE)) {
            source.setName("fdpAgreement.pdf");
        } else {
            source.setName("fdpModification.pdf");
        }
        return source;
    }

    @Override
    public AttachmentDataSource printSubAwardFDPReport(SubAwardPrintAgreement agreement, SubAward subAward) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        List<SubAwardForms> printFormTemplates = this.getSponsorFormTemplates(agreement, subAward.getSubAwardForms());
        if (agreement.getFundingSource() != null) {
            for (SubAwardFundingSource subAwardFunding : subAward.getSubAwardFundingSourceList()) {
                if (!agreement.getFundingSource().equals(subAwardFunding.getSubAwardFundingSourceId().toString())) continue;
                Award workingAward = this.getAwardVersionService().getWorkingAwardVersion(subAwardFunding.getAward().getAwardNumber());
                Award award = workingAward != null ? workingAward : subAwardFunding.getAward();
                reportParameters.put("awardNumber", award.getAwardNumber());
                reportParameters.put("awardTitle", award.getParentTitle());
                reportParameters.put("sponsorAwardNumber", award.getSponsorAwardNumber());
                if (award.getSponsor() != null) {
                    reportParameters.put("sponsorName", award.getSponsor().getSponsorName());
                }
                reportParameters.put("cfdaNumber", award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.joining(",")));
                reportParameters.put("awardID", award.getAwardId());
                if (this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", FDP_FROM_PARENT_AWARD).booleanValue()) {
                    AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(subAwardFunding.getAward().getAwardNumber());
                    if (hierarchy != null) {
                        reportParameters.put("fain", hierarchy.getRoot().getAward().getFainId());
                        if (hierarchy.getRoot().getAward().getObligatedTotal() != null) {
                            reportParameters.put("obligatedTotal", hierarchy.getRoot().getAward().getObligatedTotal().bigDecimalValue());
                        }
                        if (hierarchy.getRoot().getAward().getAnticipatedTotal() != null) {
                            reportParameters.put("anticipatedTotal", hierarchy.getRoot().getAward().getAnticipatedTotal().bigDecimalValue());
                        }
                    }
                } else {
                    reportParameters.put("fain", award.getFainId());
                    if (award.getObligatedTotal() != null) {
                        reportParameters.put("obligatedTotal", award.getObligatedTotal().bigDecimalValue());
                    }
                    if (award.getAnticipatedTotal() != null) {
                        reportParameters.put("anticipatedTotal", award.getAnticipatedTotal().bigDecimalValue());
                    }
                }
                if (award.getPrimeSponsor() != null) {
                    reportParameters.put("primeSponsorName", award.getPrimeSponsor().getSponsorName());
                } else {
                    reportParameters.put("primeSponsorName", award.getSponsor().getSponsorName());
                }
                if (award.getNoticeDate() != null) {
                    Calendar noticeDate = Calendar.getInstance();
                    noticeDate.setTime(award.getNoticeDate());
                    reportParameters.put("noticeDate", noticeDate);
                }
                if (award.getFedAwardDate() == null) break;
                Calendar fedAwardDate = Calendar.getInstance();
                fedAwardDate.setTime(award.getFedAwardDate());
                reportParameters.put("fedAwardDate", fedAwardDate);
                break;
            }
        }
        if (!subAward.getSubAwardAmountInfoList().isEmpty()) {
            int index = subAward.getSubAwardAmountInfoList().size() - 1;
            String modificationTypeCode = subAward.getSubAwardAmountInfoList().get(index).getModificationTypeCode();
            if (StringUtils.isNotEmpty((CharSequence)modificationTypeCode)) {
                reportParameters.put("modificationType", modificationTypeCode);
            }
        }
        if (!subAward.getSubAwardTemplateInfo().isEmpty()) {
            reportParameters.put("fcoi", subAward.getSubAwardTemplateInfo().get(0).getFcio());
            reportParameters.put("invoicesEmailed", subAward.getSubAwardTemplateInfo().get(0).getInvoicesEmailed());
            reportParameters.put("invoiceAddressDifferent", subAward.getSubAwardTemplateInfo().get(0).getInvoiceAddressDifferent());
            reportParameters.put("invoiceEmailDifferent", subAward.getSubAwardTemplateInfo().get(0).getInvoiceEmailDifferent());
        }
        reportParameters.put("ffata", subAward.getFfataRequired());
        reportParameters.put("Selected Templates", printFormTemplates);
        reportParameters.put("fdpType", agreement.getFdpType());
        return this.printSubAwardFDPReport(subAward, reportParameters);
    }

    @Override
    public List<AttachmentDataSource> printSubawardTemplates(SubAwardPrintAgreement agreement, SubAward subAward) {
        if (agreement.getFundingSource() == null) {
            throw new PrintingException("Funding source is required");
        }
        try {
            SubawardDto subAwardDto = this.getSubawardDocumentController().getSubaward(subAward.getSubAwardDocument().getDocumentNumber(), true, Integer.parseInt(agreement.getFundingSource()), true);
            UnitDto topUnit = this.getUnitRestController().getTopUnit();
            Map<String, UnitDto> mappingInput = Map.of("subAward", subAwardDto, "topUnit", topUnit);
            JobDto job = new JobDto();
            Map actionIdToForms = agreement.getSelectedForms().stream().map(this.getSubAwardFormsService()::byId).map(form -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.addActions((SubAwardForms)form, subAwardDto.getSubAwardTemplateAttachments(), (Map<String, Object>)mappingInput, job), form)).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
            JobDto response = this.getPdfService().submitAndAwaitJob(job);
            if (response.getStatus() != Status.SUCCESS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)response);
                }
                throw new PrintingException("Pdf failed to process (Job " + response.getJobId() + ")");
            }
            return actionIdToForms.entrySet().stream().map(entry -> {
                try {
                    PrintableAttachment pdf = new PrintableAttachment();
                    URL targetUrl = new URL(this.findActionUrl((String)entry.getKey(), response.getActions()));
                    pdf.setData(IOUtils.toByteArray((URL)targetUrl));
                    pdf.setName(((SubAwardForms)entry.getValue()).getPdfFormFile().getFileName());
                    pdf.setType(((SubAwardForms)entry.getValue()).getPdfFormFile().getContentType());
                    return pdf;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (PrintingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new PrintingException(e);
        }
    }

    private String findActionUrl(String actionId, List<? extends ActionDto<?>> actions) {
        return actions.stream().filter(a -> a.getActionId().equals(actionId)).map(a -> (SingleTargetAction)((Object)a)).map(a -> a.getTarget().getUrl()).findFirst().orElseThrow();
    }

    private String addActions(SubAwardForms form, List<SubawardTemplateAttachmentDto> attachmentDtos, Map<String, Object> mappingInput, JobDto job) {
        String finalActionId;
        List mappings;
        if (form.getPdfFormFile() == null || form.getMappingFile() == null) {
            throw new PrintingException("Printing " + form + " requires a pdf form and mapping file");
        }
        try {
            mappings = (List)this.getObjectMapper().readValue(form.getMappingFile().getData(), (TypeReference)new TypeReference<List<MappingDefinitionDto>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MapActionDto mapAction = new MapActionDto().input(mappingInput).mappings(mappings).actionId("map" + form.getId());
        LinkDto fieldActionSource = new LinkDto().url("action://{$jobId}/map" + form.getId() + "/0");
        AcroFormPutActionDto acroFormPutAction = new AcroFormPutActionDto().fieldActions(Collections.emptyMap()).source(this.createPdfFormLink(form.getPdfFormFile())).fieldActionSource(fieldActionSource).actionId("acroFormPut" + form.getId());
        if (CollectionUtils.isNotEmpty(attachmentDtos)) {
            LinkDto attachmentPutSource = new LinkDto().url("action://{$jobId}/acroFormPut" + form.getId() + "/0");
            Map<String, AttachmentDto> attachments = attachmentDtos.stream().map(a -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(a.getFileName(), new AttachmentDto().embedded(true).fileDisplay(a.getFileName()).description(a.getDescription()).mimeType(a.getMimeType()).location(this.createFileLink((SubawardTemplateAttachmentDto)a)))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
            AttachmentPutActionDto attachmentPutAction = new AttachmentPutActionDto().source(attachmentPutSource).attachments(attachments).actionId("attachmentPut" + form.getId());
            finalActionId = attachmentPutAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction).addActionsItem(attachmentPutAction);
        } else {
            finalActionId = acroFormPutAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction);
        }
        return finalActionId;
    }

    private LinkDto createFileLink(SubawardTemplateAttachmentDto a) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + a.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    private String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    private LinkDto createPdfFormLink(AttachmentFile pdf) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + pdf.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    protected void resetsubAwardFormList(List<SubAwardForms> subAwardFormList) {
        for (SubAwardForms subAwardFormValues : subAwardFormList) {
            subAwardFormValues.setSelectToPrint(false);
        }
    }

    public boolean isCostSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_DC_IDC");
    }

    protected List<SubAwardForms> getSponsorFormTemplates(SubAwardPrintAgreement subAwardPrint, List<SubAwardForms> subAwardFormList) {
        ArrayList<SubAwardForms> printFormTemplates = new ArrayList<SubAwardForms>();
        if (subAwardPrint.getFdpType().equals(SUB_AWARD_FDP_TEMPLATE)) {
            printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP Cost Reimbursement Subaward"));
        } else if (subAwardPrint.getFdpType().equals(SUB_AWARD_FDP_MODIFICATION)) {
            if (this.isCostSplitEnabled()) {
                printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP Unilateral Subaward Amendment"));
            } else {
                printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP Bilateral Subaward Amendment"));
            }
        }
        if (subAwardPrint.getAttachment3A().booleanValue()) {
            printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP_ATT_3A"));
        }
        if (subAwardPrint.getAttachment3B().booleanValue()) {
            printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP_ATT_3B"));
        }
        if (subAwardPrint.getAttachment3BPage2().booleanValue()) {
            printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP_ATT_3B_2"));
        }
        if (subAwardPrint.getAttachment4().booleanValue()) {
            printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP_ATT_4"));
        }
        if (subAwardFormList != null) {
            for (SubAwardForms subAwardFormValues : subAwardFormList) {
                if (!subAwardFormValues.getSelectToPrint().booleanValue()) continue;
                String description = subAwardFormValues.getDescription();
                String[] token = description.split("\\s");
                printFormTemplates.add(this.getSubAwardFormsService().activeByFormId("FDP_" + token[0]));
            }
            this.resetsubAwardFormList(subAwardFormList);
        }
        return printFormTemplates.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected void resetSelectedFormList(List<SubAwardTemplateAttachment> subAwardFormList) {
        for (SubAwardTemplateAttachment subAwardFormValues : subAwardFormList) {
            subAwardFormValues.setSelectToPrint(false);
        }
    }

    public SubAwardFormsService getSubAwardFormsService() {
        return this.subAwardFormsService;
    }

    public void setSubAwardFormsService(SubAwardFormsService subAwardFormsService) {
        this.subAwardFormsService = subAwardFormsService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardVersionService getAwardVersionService() {
        return this.awardVersionService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }

    public PdfService getPdfService() {
        return this.pdfService;
    }

    public void setPdfService(PdfService pdfService) {
        this.pdfService = pdfService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public SubawardDocumentController getSubawardDocumentController() {
        return this.subawardDocumentController;
    }

    public void setSubawardDocumentController(SubawardDocumentController subawardDocumentController) {
        this.subawardDocumentController = subawardDocumentController;
    }

    public UnitRestController getUnitRestController() {
        return this.unitRestController;
    }

    public void setUnitRestController(UnitRestController unitRestController) {
        this.unitRestController = unitRestController;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

