/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.impl.version.SequenceUtils;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.util.ObjectCopyUtils;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardCopyCriteria;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardCopyService;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="subAwardCopyService")
public class SubAwardCopyServiceImpl
implements SubAwardCopyService {
    @Autowired
    @Qualifier(value="versioningService")
    private VersioningService versioningService;
    @Autowired
    @Qualifier(value="subAwardService")
    private SubAwardService subAwardService;

    @Override
    public SubAward copy(SubAwardDocument subAwardDocument, SubAwardCopyCriteria subAwardCopyCriteria) {
        SubAward sourceSubAward = subAwardDocument.getSubAward();
        SubAward newSubAward = this.initializeSubAwardCopy(sourceSubAward);
        new SequenceUtils().sequenceAssociations(newSubAward);
        this.cleanUpSubAward(newSubAward, subAwardCopyCriteria);
        this.fixAttachments(newSubAward);
        this.copySupplementalInfo(sourceSubAward, newSubAward);
        return newSubAward;
    }

    private SubAward initializeSubAwardCopy(SubAward subAward) {
        ObjectCopyUtils.prepareObjectForDeepCopy((PersistableBusinessObject)subAward);
        SubAward newSubAward = this.getVersioningService().createNewVersion(subAward);
        newSubAward.setSubAwardCode(this.getSubAwardService().getNextSubAwardCode());
        newSubAward.setSequenceNumber(1);
        newSubAward.setSubAwardSequenceStatus(VersionStatus.PENDING.name());
        newSubAward.setNewVersion(false);
        return newSubAward;
    }

    private void cleanUpSubAward(SubAward subAward, SubAwardCopyCriteria subAwardCopyCriteria) {
        subAward.getSubAwardFfataReporting().clear();
        subAward.getSubAwardAmountInfoList().clear();
        subAward.getSubAwardNotepads().clear();
        subAward.getSubAwardComments().clear();
        subAward.setTotalObligatedAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalObligatedDirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalObligatedIndirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedDirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedIndirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAvailableAmount(ScaleTwoDecimal.ZERO);
        subAward.setFfataRequired(false);
        if (!subAwardCopyCriteria.isIncludeSubRecipient()) {
            subAward.setOrganizationId(null);
            subAward.setOrganization(null);
        }
        if (!subAwardCopyCriteria.isIncludeAttachments()) {
            subAward.getSubAwardAttachments().clear();
            subAward.getSubAwardTemplateAttachments().clear();
        }
        if (!subAwardCopyCriteria.isIncludeContacts()) {
            subAward.getSubAwardContactsList().clear();
        }
    }

    private void fixAttachments(SubAward subAward) {
        subAward.getSubAwardAttachments().forEach(subAwardAttachment -> {
            subAwardAttachment.setLastUpdateTimestamp(new Timestamp(new Date().getTime()));
            subAwardAttachment.setLastUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        });
        subAward.getSubAwardTemplateAttachments().forEach(subAwardTemplateAttachment -> {
            subAwardTemplateAttachment.setLastUpdateTimestamp(new Timestamp(new Date().getTime()));
            subAwardTemplateAttachment.setLastUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        });
    }

    protected void copySupplementalInfo(SubAward sourceSubAward, SubAward newSubAward) {
        newSubAward.getSubAwardCustomDataList().clear();
        newSubAward.getSubAwardDocument().getCustomAttributeDocuments().entrySet().stream().map(entry -> (CustomAttributeDocument)entry.getValue()).filter(CustomAttributeDocument::isActive).forEach(customAttributeDocument -> sourceSubAward.getCustomDataList().stream().filter(document -> document.getCustomAttributeId().equals(customAttributeDocument.getCustomAttribute().getId())).findFirst().ifPresent(customData -> {
            SubAwardCustomData subAwardCustomData = new SubAwardCustomData();
            subAwardCustomData.setCustomAttributeId(customData.getCustomAttributeId());
            subAwardCustomData.setCustomAttribute(customData.getCustomAttribute());
            subAwardCustomData.setValue(customAttributeDocument.isCopyToNewDoc() ? customData.getValue() : customData.getCustomAttribute().getDefaultValue());
            subAwardCustomData.setSubAward(newSubAward);
            newSubAward.getSubAwardCustomDataList().add(subAwardCustomData);
        }));
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public SubAwardService getSubAwardService() {
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }
}

