/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.service.SubAwardFormsService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="subAwardFormsService")
public class SubAwardFormsServiceImpl
implements SubAwardFormsService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<SubAwardForms> activeByTemplateTypeCode(Integer templateTypeCode) {
        if (templateTypeCode == null) {
            throw new IllegalArgumentException("templateTypeCode is null");
        }
        return this.getBusinessObjectService().findMatching(SubAwardForms.class, Map.of("active", true, "templateTypeCode", templateTypeCode));
    }

    @Override
    public SubAwardForms byId(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is null");
        }
        return (SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)id);
    }

    @Override
    public SubAwardForms activeByFormId(String formId) {
        if (StringUtils.isBlank((String)formId)) {
            throw new IllegalArgumentException("formId is blank");
        }
        return this.getBusinessObjectService().findMatching(SubAwardForms.class, Map.of("active", true, "formId", formId)).stream().findAny().orElse(null);
    }

    @Override
    public Set<String> systemDefaults() {
        return SubAwardForms.SYSTEM_DEFAULTS;
    }

    @Override
    public Set<String> validFormIds() {
        return SubAwardForms.VALID_FORM_ID;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

