/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subawardReporting.printing.print;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.kra.award.printing.schema.AwardType;
import org.kuali.kra.subaward.bo.AnimalPteSendNotRequiredReason;
import org.kuali.kra.subaward.bo.DataSharing;
import org.kuali.kra.subaward.bo.FcioSubrecipientPolicy;
import org.kuali.kra.subaward.bo.HumanDataExchangeAgreement;
import org.kuali.kra.subaward.bo.HumanDataExchangeTerms;
import org.kuali.kra.subaward.bo.HumanPteSendNotRequiredReason;
import org.kuali.kra.subaward.bo.MpiLeadershipPlan;
import org.kuali.kra.subaward.bo.PteSend;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.printing.schema.SubContractDataDocument;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.springframework.core.io.Resource;

public abstract class SubawardFdp
extends AbstractPrint {
    private static final String COPYRIGHTS_GRANT_CODE = "1";
    private static final String COPYRIGHTS_SHALL_GRANT_CODE = "2";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final List<String> FORM_ORDER = Stream.of(AgreementForm.FDP_AGREEMENT.getId(), SupplementalFormsForAgreement.FDP_ATTACHMENT_CERTIFICATION.getId(), ModificationForm.FDP_MODIFICATION.getId(), "FDP Unilateral Subaward Amendment", Attachment2Form.FDP_AFOSR.getId(), Attachment2Form.FDP_AMRAA.getId(), Attachment2Form.FDP_AMRMC.getId(), Attachment2Form.FDP_ARO.getId(), Attachment2Form.FDP_DOE.getId(), Attachment2Form.FDP_EPA.getId(), Attachment2Form.FDP_NASA.getId(), Attachment2Form.FDP_NIH.getId(), Attachment2Form.FDP_NSF.getId(), Attachment2Form.FDP_ONR.getId(), Attachment2Form.FDP_USDA.getId(), Attachment3aForm.ATTACHMENT_3A.getId(), Attachment3bForm.ATTACHMENT_3B.getId(), Attachment3bPage2Form.ATTACHMENT_3B_PAGE2.getId(), "FDP_ATT_4").collect(Collectors.toList());
    private Map<String, Resource> pdfForms;

    @Override
    public Map<String, Source> getXSLTemplateWithBookmarks() {
        return this.getSelectedTemplates().stream().map(s -> CollectionUtils.entry(s.getFormId(), new StreamSource(s.getAttachmentContent() != null ? new ByteArrayInputStream(s.getAttachmentContent()) : new ByteArrayInputStream(new byte[0])))).collect(CollectionUtils.entriesToMap());
    }

    private Collection<SubAwardForms> getSelectedTemplates() {
        return (Collection)this.getReportParameters().get("Selected Templates");
    }

    @Override
    public Map<String, Resource> getPdfForms() {
        return this.pdfForms;
    }

    public void setPdfForms(Map<String, Resource> pdfForms) {
        this.pdfForms = pdfForms;
    }

    @Override
    public Map<String, byte[]> fillPdfForms(Map<String, Resource> pdfForms, Map<String, XmlObject> xml) {
        Collection selected = this.getSelectedTemplates().stream().map(SubAwardForms::getFormId).collect(Collectors.toList());
        if (selected.stream().anyMatch(form -> form.equalsIgnoreCase(AgreementForm.FDP_AGREEMENT.getId()))) {
            selected.add(SupplementalFormsForAgreement.FDP_ATTACHMENT_CERTIFICATION.getId());
        }
        return pdfForms.entrySet().stream().filter(pdfForm -> selected.contains(pdfForm.getKey())).map(selectedForm -> {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Map.Entry<String, byte[]> entry;
                block14: {
                    PDDocument pdfDocument = PDDocument.load((InputStream)((Resource)selectedForm.getValue()).getInputStream());
                    try {
                        PdfBoxUtils.doMissingDefaultResourcesWorkaround(pdfDocument.getDocumentCatalog().getAcroForm().getDefaultResources());
                        SubContractDataDocument xmlObject = (SubContractDataDocument)xml.get(SubAwardPrintType.SUB_AWARD_FDP_TEMPLATE.getSubAwardPrintType());
                        if (xmlObject != null) {
                            this.fillTemplateOrAttachment((Map.Entry<String, Resource>)selectedForm, pdfDocument, xmlObject);
                        }
                        PdfBoxUtils.flatten(pdfDocument);
                        pdfDocument.save((OutputStream)out);
                        entry = CollectionUtils.entry((String)selectedForm.getKey(), out.toByteArray());
                        if (pdfDocument == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (pdfDocument != null) {
                            try {
                                pdfDocument.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pdfDocument.close();
                }
                return entry;
            }
            catch (IOException e1) {
                throw new PrintingException(e1);
            }
        }).collect(CollectionUtils.entriesToMap());
    }

    public void fillTemplateOrAttachment(Map.Entry<String, Resource> selectedForm, PDDocument pdfDocument, SubContractDataDocument xmlObject) {
        boolean agreement = Stream.of(AgreementForm.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        boolean certification = Stream.of(SupplementalFormsForAgreement.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        boolean attachment3a = Stream.of(Attachment3aForm.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        boolean attachment3b = Stream.of(Attachment3bForm.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        boolean attachment3bPage2 = Stream.of(Attachment3bPage2Form.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        boolean modification = Stream.of(ModificationForm.values()).anyMatch(form -> form.getId().equals(selectedForm.getKey()));
        if (agreement) {
            this.fillAgreementForm(pdfDocument, xmlObject);
        } else if (certification) {
            this.fillCertificationForm(pdfDocument, xmlObject);
        } else if (attachment3a) {
            this.fillAttachment3aForm(pdfDocument, xmlObject);
        } else if (attachment3b) {
            this.fillAttachment3bForm(pdfDocument, xmlObject);
        } else if (attachment3bPage2) {
            this.fillAttachment3bPage2Form(pdfDocument, xmlObject);
        } else if (modification) {
            this.fillModificationForm(pdfDocument, xmlObject);
        } else {
            Stream.of(Attachment2Form.values()).filter(attachment2Form -> attachment2Form.getId().equals(selectedForm.getKey())).findFirst().ifPresent(attachment2Form -> this.fillAttachment2Form(pdfDocument, xmlObject, (Attachment2Form)((Object)attachment2Form)));
        }
    }

    private void fillModificationForm(PDDocument pdfDocument, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        AwardType award = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getAwardArray()) ? xmlObject.getSubContractData().getAwardArray()[0] : AwardType.Factory.newInstance();
        this.setSubrecipientInfo(pdfDocument, subcontractDetail);
        this.setPteInfo(pdfDocument, xmlObject);
        this.setAwardSubawardNumbers(pdfDocument, subcontractDetail, award);
        this.setTitle(pdfDocument, award);
        this.setDates(pdfDocument, xmlObject);
        this.setAmounts(pdfDocument, xmlObject);
        this.setTermsAndConditions(pdfDocument, xmlObject);
        this.setMiscellaneousItems(pdfDocument, xmlObject);
    }

    protected abstract void setMiscellaneousItems(PDDocument var1, SubContractDataDocument var2);

    private void fillAgreementForm(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        AwardType award = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getAwardArray()) ? xmlObject.getSubContractData().getAwardArray()[0] : AwardType.Factory.newInstance();
        this.setFederalAwardingAgency(document, award);
        this.setPteInfo(document, xmlObject);
        this.setSubrecipientInfo(document, subcontractDetail);
        this.setAwardSubawardNumbers(document, subcontractDetail, award);
        this.setTitle(document, award);
        this.setDates(document, xmlObject);
        this.setAmounts(document, xmlObject);
        this.setTermsAndConditions(document, xmlObject);
    }

    private void fillCertificationForm(PDDocument pdfDocument, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        PdfBoxUtils.setField(pdfDocument, AgreementCertificationPdf.Field.SUBAWARD_NO.getfName(), subcontractDetail.getFsrsSubawardNumber());
    }

    protected void setFederalAwardingAgency(PDDocument document, AwardType award) {
        if (award.getAwardDetails() != null && award.getAwardDetails().getAwardHeader() != null) {
            PdfBoxUtils.setField(document, AgreementPdf.Field.FEDERAL_AWARDING_AGENCY.getfName(), award.getAwardDetails().getAwardHeader().getSponsorDescription());
        }
    }

    protected abstract void setPteInfo(PDDocument var1, SubContractDataDocument var2);

    protected abstract void setSubrecipientInfo(PDDocument var1, SubContractDataDocument.SubContractData.SubcontractDetail var2);

    protected abstract void setAwardSubawardNumbers(PDDocument var1, SubContractDataDocument.SubContractData.SubcontractDetail var2, AwardType var3);

    protected abstract void setTitle(PDDocument var1, AwardType var2);

    protected abstract void setDates(PDDocument var1, SubContractDataDocument var2);

    protected abstract void setAmounts(PDDocument var1, SubContractDataDocument var2);

    protected abstract void setTermsAndConditions(PDDocument var1, SubContractDataDocument var2);

    private void fillAttachment2Form(PDDocument document, SubContractDataDocument xmlObject, Attachment2Form formId) {
        Attachment2SponsorFormType type = formId.getSponsorFormType();
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        SubContractDataDocument.SubContractData.OtherConfigInfo configInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getOtherConfigInfoArray()) ? xmlObject.getSubContractData().getOtherConfigInfoArray(0) : SubContractDataDocument.SubContractData.OtherConfigInfo.Factory.newInstance();
        SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractTemplateInfoArray()) ? xmlObject.getSubContractData().getSubcontractTemplateInfoArray(0) : SubContractDataDocument.SubContractData.SubcontractTemplateInfo.Factory.newInstance();
        AwardType award = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getAwardArray()) ? xmlObject.getSubContractData().getAwardArray(0) : AwardType.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()) ? xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()[0] : SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()) ? xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()[0] : SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAdministrativeContactArray()) ? xmlObject.getSubContractData().getPrimeAdministrativeContactArray()[0] : SubContractDataDocument.SubContractData.PrimeAdministrativeContact.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeFinancialContactArray()) ? xmlObject.getSubContractData().getPrimeFinancialContactArray()[0] : SubContractDataDocument.SubContractData.PrimeFinancialContact.Factory.newInstance();
        this.setHeaderInformation(document, subcontractDetail);
        this.setRequiredDataElements(document, subcontractDetail, templateInfo, award);
        this.setGenTermsAndConditions(document, configInfo, templateInfo, primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact, type);
        this.setMpiInfo(document, templateInfo, type);
        this.setStcCopyrights(document, templateInfo);
        this.setDataSharingPubAccessPolicy(document, templateInfo);
        this.setPromotingObjectivityFcio(document, templateInfo, configInfo, type);
        this.setHumanAnimalSubjects(document, templateInfo, primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact);
        this.setHumanPteVerification(document, templateInfo);
        this.setAnimalPteVerification(document, templateInfo);
        this.setHumanSubjectsDataExchange(document, templateInfo);
        this.setHumanSubjectsDataExchangeTerms(document, templateInfo);
        this.setAdditionalTerms(document, templateInfo);
    }

    private void setDataSharingPubAccessPolicy(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        if (DataSharing.ATTACHED.getCode().equals(templateInfo.getDataSharingCd())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_SHARING_PLAN.getfName(), true);
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_SHARING_DROPDOWN.getfName(), "attached.");
        } else if (DataSharing.PROVIDED_UPON_REQUEST.getCode().equals(templateInfo.getDataSharingCd())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_SHARING_PLAN.getfName(), true);
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_SHARING_DROPDOWN.getfName(), "provided upon request.");
        } else {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_SHARING_DROPDOWN.getfName(), "");
        }
    }

    private void setPromotingObjectivityFcio(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo, SubContractDataDocument.SubContractData.OtherConfigInfo configInfo, Attachment2SponsorFormType type) {
        if (FcioSubrecipientPolicy.PTE.getCode().equals(templateInfo.getFcioSubrecPolicyCd())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.FCOI_PTE_DROPDOWN.getfName(), "PTE");
        } else if (FcioSubrecipientPolicy.SUBRECIPIENT.getCode().equals(templateInfo.getFcioSubrecPolicyCd())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.FCOI_PTE_DROPDOWN.getfName(), "Subrecipient");
        } else {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.FCOI_PTE_DROPDOWN.getfName(), "");
        }
        if (type == Attachment2SponsorFormType.NIH) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpNihFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.NSF) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpNsfFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.NASA) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpNasaFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.ONR) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpOnrFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.ARO) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpAroFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.AFOSR) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpAfosrFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.EPA) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpEpaFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.AMRMC) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpAmrmcFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.AMRAA) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpAmraaFCoiGuidance());
        } else if (type == Attachment2SponsorFormType.USDA) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.SPONSOR_AGENCY.getfName(), configInfo.getFdpUsdaFCoiGuidance());
        }
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.FCOI_OTHER_SPONSOR_AGENCY.getfName(), "");
    }

    private void setHumanSubjectsDataExchangeTerms(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        PdfBoxUtils.hideField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_TERMS_TIP.getfName());
        if (this.fromYN(templateInfo.getHumanFlag()) && (HumanDataExchangeAgreement.SUBRECIPIENT_TO_PTE.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.PTE_TO_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.FROM_BOTH_PTE_AND_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()))) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_TERMS_LABEL.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_TERMS_DROPDOWN.getfName());
            if (HumanDataExchangeTerms.ADDITIONAL_TERMS.getCode().equals(templateInfo.getHumanDataExchangeTermsCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_TERMS_DROPDOWN.getfName(), "In the Additional Terms section below");
            } else if (HumanDataExchangeTerms.SEPARATE_AGREEMENT.getCode().equals(templateInfo.getHumanDataExchangeTermsCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_TERMS_DROPDOWN.getfName(), "Via a separate Data Use Agreement");
            }
        }
    }

    private void setAdditionalTerms(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_ADD_TERMS_TEXT.getfName(), templateInfo.getAdditionalTerms());
    }

    private void setHumanSubjectsDataExchange(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_APPLICABLE.getfName(), "Not Applicable");
        if (this.fromYN(templateInfo.getHumanFlag())) {
            PdfBoxUtils.hideField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_BLANK.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_APPLICABLE.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_EXCHANGE_LABEL.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_EXCHANGE2_LABEL.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_SUB_TO_PTE.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_PTE_TO_SUB.getfName());
            if (HumanDataExchangeAgreement.NOT_APPLICABLE.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_APPLICABLE.getfName(), "Not Applicable");
            } else if (HumanDataExchangeAgreement.SUBRECIPIENT_TO_PTE.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.PTE_TO_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.FROM_BOTH_PTE_AND_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_APPLICABLE.getfName(), "Applicable");
            }
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_SUB_TO_PTE.getfName(), HumanDataExchangeAgreement.SUBRECIPIENT_TO_PTE.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.FROM_BOTH_PTE_AND_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()));
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_DATA_PTE_TO_SUB.getfName(), HumanDataExchangeAgreement.PTE_TO_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()) || HumanDataExchangeAgreement.FROM_BOTH_PTE_AND_SUBRECIPIENT.getCode().equals(templateInfo.getHumanDataExchangeAgreeCd()));
        }
    }

    private void setAnimalPteVerification(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        if (this.fromYN(templateInfo.getAnimalFlag())) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName());
            if (PteSend.UPON_REQUEST.getCode().equals(templateInfo.getAnimalPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName(), "Upon Request");
            } else if (PteSend.PRIOR_TO_EXECUTION.getCode().equals(templateInfo.getAnimalPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName(), "Prior to execution of this agreement");
            } else if (PteSend.PRIOR_TO_EXECUTION_AND_ANNUALLY.getCode().equals(templateInfo.getAnimalPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName(), "Prior to execution of this agreement and annually thereafter");
            } else if (PteSend.NOT_REQUIRED.getCode().equals(templateInfo.getAnimalPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName(), "Not required for the following reason:");
            } else {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_DROPDOWN.getfName(), "");
            }
            if (PteSend.NOT_REQUIRED.getCode().equals(templateInfo.getAnimalPteSendCd())) {
                PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IACUC_NOT_REQUIRED_REASON.getfName());
                AnimalPteSendNotRequiredReason hReason = AnimalPteSendNotRequiredReason.fromCode(templateInfo.getAnimalPteNrCd());
                if (hReason != null) {
                    PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IACUC_NOT_REQUIRED_REASON.getfName(), hReason.getDescription());
                }
            }
        }
    }

    private void setHumanPteVerification(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        if (this.fromYN(templateInfo.getHumanFlag())) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName());
            if (PteSend.UPON_REQUEST.getCode().equals(templateInfo.getHumanPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName(), "Upon Request");
            } else if (PteSend.PRIOR_TO_EXECUTION.getCode().equals(templateInfo.getHumanPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName(), "Prior to execution of this agreement");
            } else if (PteSend.PRIOR_TO_EXECUTION_AND_ANNUALLY.getCode().equals(templateInfo.getHumanPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName(), "Prior to execution of this agreement and annually thereafter");
            } else if (PteSend.NOT_REQUIRED.getCode().equals(templateInfo.getHumanPteSendCd())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName(), "Not required for the following reason:");
            } else {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_DROPDOWN.getfName(), "");
            }
            if (PteSend.NOT_REQUIRED.getCode().equals(templateInfo.getHumanPteSendCd())) {
                PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IRB_NOT_REQUIRED_REASON.getfName());
                HumanPteSendNotRequiredReason hReason = HumanPteSendNotRequiredReason.fromCode(templateInfo.getHumanPteNrCd());
                if (hReason != null) {
                    PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_IRB_NOT_REQUIRED_REASON.getfName(), hReason.getDescription());
                }
            }
        }
    }

    private void setHumanAnimalSubjects(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo, SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial, SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator, SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact, SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact) {
        boolean human = this.fromYN(templateInfo.getHumanFlag());
        boolean animal = this.fromYN(templateInfo.getAnimalFlag());
        PdfBoxUtils.hideField(document, Attachment2Pdf.Field.IRB_IACUC_LABEL.getfName());
        PdfBoxUtils.showField(document, Attachment2Pdf.Field.IRB_IACUC_BLANK_LABEL.getfName());
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.HUMAN_SUBJECTS_CHECKBOX.getfName(), human);
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.ANIMAL_SUBJECTS_CHECKBOX.getfName(), animal);
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.NO_HUMAN_ANIMAL_SUBJECTS_CHECKBOX.getfName(), !animal && !human);
        if (human || animal) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.IRB_IACUC_LABEL.getfName());
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_REQUIRES_VERIFICATON_LABEL.getfName());
            PdfBoxUtils.hideField(document, Attachment2Pdf.Field.IRB_IACUC_BLANK_LABEL.getfName());
        }
        if (human) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IRB_LABEL.getfName());
        }
        if (animal) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_IACUC_LABEL.getfName());
        }
        if (human || animal) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.PTE_VERIFICATION_CONTACT.getfName());
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_VERIFICATION_CONTACT.getfName(), "");
            String pteVerContact = StringUtils.isBlank((CharSequence)templateInfo.getIrbIacucContactCd()) ? "" : (templateInfo.getIrbIacucContactCd().equals(primeAuthorizedOfficial.getContactTypeCode()) ? "Authorized Official" : (templateInfo.getIrbIacucContactCd().equals(primePrincipalInvestigator.getContactTypeCode()) ? "Principal Investigator" : (templateInfo.getIrbIacucContactCd().equals(primeAdministrativeContact.getContactTypeCode()) ? "Administrative Contact" : (templateInfo.getIrbIacucContactCd().equals(primeFinancialContact.getContactTypeCode()) ? "Financial Contact" : ""))));
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.PTE_VERIFICATION_CONTACT.getfName(), pteVerContact);
        }
    }

    private void setStcCopyrights(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo) {
        if (COPYRIGHTS_GRANT_CODE.equals(templateInfo.getCopyRights())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.COPYRIGHT.getfName(), "Subrecipient Grants");
        } else if (COPYRIGHTS_SHALL_GRANT_CODE.equals(templateInfo.getCopyRights())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.COPYRIGHT.getfName(), "Subrecipient Shall Grant");
        } else {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.COPYRIGHT.getfName(), "");
        }
    }

    private void setMpiInfo(PDDocument document, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo, Attachment2SponsorFormType type) {
        PdfBoxUtils.toggleFieldVisibility(document, Attachment2Pdf.Field.MPI_SECTION_LABEL.getfName(), type != Attachment2SponsorFormType.NIH);
        PdfBoxUtils.hideField(document, Attachment2Pdf.Field.MPI_SECTION_HELP.getfName());
        PdfBoxUtils.toggleFieldVisibility(document, Attachment2Pdf.Field.MPI_SECTION_SELECT.getfName(), type != Attachment2SponsorFormType.NIH);
        PdfBoxUtils.toggleFieldVisibility(document, Attachment2Pdf.Field.MPI_SECTION_BLANK.getfName(), type == Attachment2SponsorFormType.NIH);
        if (type == Attachment2SponsorFormType.NIH) {
            if (this.fromYN(templateInfo.getMpiAward())) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.MPI_SECTION_SELECT.getfName(), "This subaward is subject to an MPI Leadership Plan. Both parties will follow the finalized MPI Leadership Plan.");
                PdfBoxUtils.showField(document, Attachment2Pdf.Field.MPI_PLAN_SELECT.getfName());
                MpiLeadershipPlan mpiLeadershipPlan = MpiLeadershipPlan.fromCode(templateInfo.getMpiLeadershipPlan());
                if (MpiLeadershipPlan.ATTACHED == mpiLeadershipPlan) {
                    PdfBoxUtils.setField(document, Attachment2Pdf.Field.MPI_PLAN_SELECT.getfName(), "The MPI plan is attached as part of Attachment 6.");
                } else if (MpiLeadershipPlan.REQUEST == mpiLeadershipPlan) {
                    PdfBoxUtils.setField(document, Attachment2Pdf.Field.MPI_PLAN_SELECT.getfName(), "The PTE will make the MPI plan available upon request.");
                } else {
                    PdfBoxUtils.setField(document, Attachment2Pdf.Field.MPI_PLAN_SELECT.getfName(), "");
                }
            } else {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.MPI_SECTION_SELECT.getfName(), "This subaward is not subject to an MPI Leadership Plan.");
            }
        }
    }

    private void setGenTermsAndConditions(PDDocument document, SubContractDataDocument.SubContractData.OtherConfigInfo configInfo, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo, SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial, SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator, SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact, SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact, Attachment2SponsorFormType type) {
        String nceContact = StringUtils.isBlank((CharSequence)templateInfo.getNoCostExtensionContactCd()) ? "" : (templateInfo.getNoCostExtensionContactCd().equals(primeAuthorizedOfficial.getContactTypeCode()) ? "Authorized Official" : (templateInfo.getNoCostExtensionContactCd().equals(primePrincipalInvestigator.getContactTypeCode()) ? "Principal Investigator" : (templateInfo.getNoCostExtensionContactCd().equals(primeAdministrativeContact.getContactTypeCode()) ? "Administrative" : (templateInfo.getNoCostExtensionContactCd().equals(primeFinancialContact.getContactTypeCode()) ? "Financial" : ""))));
        if (type == Attachment2SponsorFormType.NIH) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpNihPolicy(), configInfo.getFdpNihCfr(), configInfo.getFdpNihGrantsPolicyStatement(), configInfo.getFdpNihInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.NSF) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpNsfPolicy(), configInfo.getFdpNsfCfr(), configInfo.getFdpNsfGrantsPolicyStatement(), configInfo.getFdpNsfInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.NASA) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpNasaPolicy(), configInfo.getFdpNasaCfr(), configInfo.getFdpNasaGrantsPolicyStatement(), configInfo.getFdpNasaInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.ONR) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpOnrPolicy(), configInfo.getFdpOnrCfr(), configInfo.getFdpOnrGrantsPolicyStatement(), configInfo.getFdpOnrInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.ARO) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpAroPolicy(), configInfo.getFdpAroCfr(), configInfo.getFdpAroGrantsPolicyStatement(), configInfo.getFdpAroInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.AFOSR) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpAfosrPolicy(), configInfo.getFdpAfosrCfr(), configInfo.getFdpAfosrGrantsPolicyStatement(), configInfo.getFdpAfosrInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.EPA) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpEpaPolicy(), configInfo.getFdpEpaCfr(), configInfo.getFdpEpaGrantsPolicyStatement(), configInfo.getFdpEpaInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.AMRMC) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpAmrmcPolicy(), configInfo.getFdpAmrmcCfr(), configInfo.getFdpAmrmcGrantsPolicyStatement(), configInfo.getFdpAmrmcInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.AMRAA) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpAmraaPolicy(), configInfo.getFdpAmraaCfr(), configInfo.getFdpAmraaGrantsPolicyStatement(), configInfo.getFdpAmraaInterimResearchTerms(), nceContact);
        } else if (type == Attachment2SponsorFormType.USDA) {
            this.setGenTermsAndConditions1To4(document, configInfo.getFdpUsdaPolicy(), configInfo.getFdpUsdaCfr(), configInfo.getFdpUsdaGrantsPolicyStatement(), configInfo.getFdpUsdaInterimResearchTerms(), nceContact);
        } else {
            this.setGenTermsAndConditions1To4(document, "", "", "", "", "");
        }
        if (this.fromYN(templateInfo.getTreatmentPrgmIncomeAdditive())) {
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.TREATMENT_OF_PROGRAM_INCOME.getfName(), "Additive");
        } else {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.TREATMENT_OF_PROGRAM_INCOME_OTHER_SPECIFY.getfName());
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.TREATMENT_OF_PROGRAM_INCOME.getfName(), "Other [enter text]");
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.TREATMENT_OF_PROGRAM_INCOME_OTHER_SPECIFY.getfName(), templateInfo.getTreatmentOfIncome());
        }
    }

    private void setGenTermsAndConditions1To4(PDDocument document, String policy, String cfr, String policyStatement, String intTerms, String nceContact) {
        PdfBoxUtils.setFieldAppearance(document, Attachment2Pdf.Field.FEDERAL_AWARD_CONDITIONS.getfName(), StringUtils.length((CharSequence)policyStatement) < 100 ? "/ArialMT 10 Tf 0 g" : (StringUtils.length((CharSequence)policyStatement) > 100 && StringUtils.length((CharSequence)policyStatement) < 175 ? "/ArialMT 8 Tf 0 g" : "/ArialMT 5 Tf 0 g"));
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.FEDERAL_AWARD_CONDITIONS.getfName(), policyStatement);
        if (StringUtils.isNotBlank((CharSequence)cfr)) {
            PdfBoxUtils.showField(document, Attachment2Pdf.Field.AGENCY_IMPLEMENTATION.getfName());
            PdfBoxUtils.setFieldAppearance(document, Attachment2Pdf.Field.AGENCY_IMPLEMENTATION.getfName(), StringUtils.length((CharSequence)cfr) < 16 ? "/ArialMT 10 Tf 0 g" : (StringUtils.length((CharSequence)cfr) > 16 && StringUtils.length((CharSequence)cfr) < 20 ? "/ArialMT 8 Tf 0 g" : "/ArialMT 5 Tf 0 g"));
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.AGENCY_IMPLEMENTATION.getfName(), cfr);
        }
        PdfBoxUtils.setFieldAppearance(document, Attachment2Pdf.Field.GRANTS_POLICY_STATEMENT.getfName(), StringUtils.length((CharSequence)policy) < 100 ? "/ArialMT 10 Tf 0 g" : (StringUtils.length((CharSequence)policy) > 100 && StringUtils.length((CharSequence)policy) < 175 ? "/ArialMT 8 Tf 0 g" : "/ArialMT 5 Tf 0 g"));
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.GRANTS_POLICY_STATEMENT.getfName(), policy);
        PdfBoxUtils.setFieldAppearance(document, Attachment2Pdf.Field.RES_TERMS_COND.getfName(), StringUtils.length((CharSequence)intTerms) < 75 ? "/ArialMT 10 Tf 0 g" : (StringUtils.length((CharSequence)intTerms) > 75 && StringUtils.length((CharSequence)intTerms) < 150 ? "/ArialMT 8 Tf 0 g" : "/ArialMT 5 Tf 0 g"));
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.RES_TERMS_COND.getfName(), intTerms);
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.NO_COST_EXT_CONTACT.getfName(), nceContact);
    }

    private void setRequiredDataElements(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail, SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo, AwardType award) {
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.DATA_ELEMENTS_REQUIRED.getfName(), "in the attached Federal Award.");
        PdfBoxUtils.hideField(document, Attachment2Pdf.Field.DATA_ELEMENTS_TIP.getfName());
        PdfBoxUtils.hideField(document, Attachment2Pdf.Field.NOA_TIP.getfName());
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.RESEARCH_AND_DEVELOPMENT.getfName(), this.fromYN(templateInfo.getRAndD()));
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.SUBJECT_TO_FFATA.getfName(), this.fromYN(subcontractDetail.getFFATA()));
        if (award.getAwardDetails() != null && award.getAwardDetails().getOtherHeaderDetails() != null) {
            if (award.getAwardDetails().getOtherHeaderDetails().getFAID() != null) {
                PdfBoxUtils.setField(document, Attachment2Pdf.Field.FAID.getfName(), this.formatDate(award.getAwardDetails().getOtherHeaderDetails().getFAID().getTime()));
            }
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.FAIN.getfName(), award.getAwardDetails().getOtherHeaderDetails().getFAIN());
            PdfBoxUtils.setField(document, Attachment2Pdf.Field.CFDA.getfName(), award.getAwardDetails().getOtherHeaderDetails().getCFDANumber());
        }
    }

    private void setHeaderInformation(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail) {
        PdfBoxUtils.setField(document, Attachment2Pdf.Field.SUBAWARD_NUMBER.getfName(), subcontractDetail.getFsrsSubawardNumber());
    }

    private void fillAttachment3aForm(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeRecipientContacts primeRecipientContacts = xmlObject.getSubContractData().getPrimeRecipientContacts() != null ? xmlObject.getSubContractData().getPrimeRecipientContacts() : SubContractDataDocument.SubContractData.PrimeRecipientContacts.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()) ? xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()[0] : SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()) ? xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()[0] : SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAdministrativeContactArray()) ? xmlObject.getSubContractData().getPrimeAdministrativeContactArray()[0] : SubContractDataDocument.SubContractData.PrimeAdministrativeContact.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeFinancialContactArray()) ? xmlObject.getSubContractData().getPrimeFinancialContactArray()[0] : SubContractDataDocument.SubContractData.PrimeFinancialContact.Factory.newInstance();
        this.setHeaderInformationAtt3a(document, subcontractDetail);
        this.setPteInfoAtt3a(document, primeRecipientContacts);
        this.setPteContacts(document, primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact);
        this.setPteAddresses(document, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact);
    }

    private void setHeaderInformationAtt3a(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail) {
        PdfBoxUtils.setField(document, Attachment3aPdf.Field.SUBAWARD_NUMBER.getfName(), subcontractDetail.getFsrsSubawardNumber());
    }

    private void setPteInfoAtt3a(PDDocument document, SubContractDataDocument.SubContractData.PrimeRecipientContacts primeRecipientContacts) {
        if (primeRecipientContacts.getRequisitionerOrgDetails() != null) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_INFO_ENTITY_NAME.getfName(), primeRecipientContacts.getRequisitionerOrgDetails().getOrganizationName());
        }
        if (primeRecipientContacts.getOrgRolodexDetails() != null) {
            String address = this.createAddress(primeRecipientContacts.getOrgRolodexDetails().getAddress1(), primeRecipientContacts.getOrgRolodexDetails().getAddress2(), primeRecipientContacts.getOrgRolodexDetails().getAddress3(), primeRecipientContacts.getOrgRolodexDetails().getCity(), primeRecipientContacts.getOrgRolodexDetails().getStateDescription(), primeRecipientContacts.getOrgRolodexDetails().getPincode());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_INFO_LEGAL_ADDRESS.getfName(), address);
        }
    }

    private void setPteContacts(PDDocument document, SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial, SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator, SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact, SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact) {
        PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_CENTRAL_EMAIL.getfName(), primeAuthorizedOfficial.getCentralEmail());
        if (primePrincipalInvestigator.getPersonDetailsType() != null) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_PI_NAME.getfName(), primePrincipalInvestigator.getPersonDetailsType().getFullName());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_PI_EMAIL.getfName(), primePrincipalInvestigator.getPersonDetailsType().getEmailAddress());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_PI_PHONE.getfName(), primePrincipalInvestigator.getPersonDetailsType().getMobilePhoneNumber());
        }
        if (primeAdministrativeContact.getRolodexDetails() != null) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_ADMIN_NAME.getfName(), primeAdministrativeContact.getRolodexDetails().getRolodexName());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_ADMIN_EMAIL.getfName(), primeAdministrativeContact.getRolodexDetails().getEmail());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_ADMIN_PHONE.getfName(), primeAdministrativeContact.getRolodexDetails().getPhoneNumber());
        }
        PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_COI_EMAIL.getfName(), primeAdministrativeContact.getCoiContactEmail());
        if (primeFinancialContact.getRolodexDetails() != null) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_FIN_NAME.getfName(), primeFinancialContact.getRolodexDetails().getRolodexName());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_FIN_EMAIL.getfName(), primeFinancialContact.getRolodexDetails().getEmail());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_FIN_PHONE.getfName(), primeFinancialContact.getRolodexDetails().getPhoneNumber());
        }
        PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_EMAIL_INVOICES.getfName(), this.fromYN(primeFinancialContact.getInvoicesEmailed()) ? "Yes" : "No");
        PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_INVOICE_EMAIL.getfName(), primeFinancialContact.getInvoiceEmailDifferent());
        if (primeAuthorizedOfficial.getRolodexDetails() != null) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_AUTH_OFFICIAL_NAME.getfName(), primeAuthorizedOfficial.getRolodexDetails().getRolodexName());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_AUTH_OFFICIAL_EMAIL.getfName(), primeAuthorizedOfficial.getRolodexDetails().getEmail());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_AUTH_OFFCIAL_PHONE.getfName(), primeAuthorizedOfficial.getRolodexDetails().getPhoneNumber());
        }
    }

    private void setPteAddresses(PDDocument document, SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator, SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact, SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact) {
        if (primePrincipalInvestigator.getPersonDetailsType() != null) {
            String piAddress = this.createAddress(primePrincipalInvestigator.getPersonDetailsType().getAddressLine1(), primePrincipalInvestigator.getPersonDetailsType().getAddressLine2(), primePrincipalInvestigator.getPersonDetailsType().getAddressLine3(), primePrincipalInvestigator.getPersonDetailsType().getCity(), primePrincipalInvestigator.getPersonDetailsType().getState(), primePrincipalInvestigator.getPersonDetailsType().getPostalCode());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_PI_ADDRESS.getfName(), piAddress);
        }
        if (primeAdministrativeContact.getRolodexDetails() != null) {
            String adminAddress = this.createAddress(primeAdministrativeContact.getRolodexDetails().getAddress1(), primeAdministrativeContact.getRolodexDetails().getAddress2(), primeAdministrativeContact.getRolodexDetails().getAddress3(), primeAdministrativeContact.getRolodexDetails().getCity(), primeAdministrativeContact.getRolodexDetails().getStateDescription(), primeAdministrativeContact.getRolodexDetails().getPincode());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_ADMIN_ADDRESS.getfName(), adminAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)primeFinancialContact.getInvoiceAddressDifferent())) {
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_INVOICE_ADDRESS.getfName(), primeFinancialContact.getInvoiceAddressDifferent());
        } else if (primeFinancialContact.getRolodexDetails() != null) {
            String invoiceAddress = this.createAddress(primeFinancialContact.getRolodexDetails().getAddress1(), primeFinancialContact.getRolodexDetails().getAddress2(), primeFinancialContact.getRolodexDetails().getAddress3(), primeFinancialContact.getRolodexDetails().getCity(), primeFinancialContact.getRolodexDetails().getStateDescription(), primeFinancialContact.getRolodexDetails().getPincode());
            PdfBoxUtils.setField(document, Attachment3aPdf.Field.PTE_CONTACTS_INVOICE_ADDRESS.getfName(), invoiceAddress);
        }
    }

    private String createAddress(String address1, String address2, String address3, String city, String state, String zip) {
        StringBuilder address = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)address1)) {
            address.append(address1);
            address.append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)address2)) {
            address.append(address2);
            address.append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)address3)) {
            address.append(address3);
            address.append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)city)) {
            address.append(city);
            address.append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            address.append(state);
            address.append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)zip)) {
            address.append(zip);
        }
        return address.toString();
    }

    private void fillAttachment3bForm(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        PdfBoxUtils.setField(document, Attachment3bPdf.Field.SUBAWARD_NUMBER.getfName(), subcontractDetail.getFsrsSubawardNumber());
    }

    private void fillAttachment3bPage2Form(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        PdfBoxUtils.setField(document, Attachment3bPage2Pdf.Field.SUBAWARD_NUMBER.getfName(), subcontractDetail.getFsrsSubawardNumber());
        PdfBoxUtils.setField(document, Attachment3bPage2Pdf.Field.ENTITY_NAME.getfName(), subcontractDetail.getSubcontractorName());
        PdfBoxUtils.setField(document, Attachment3bPage2Pdf.Field.PI_NAME.getfName(), subcontractDetail.getSiteInvestigator());
    }

    @Override
    public Map<String, byte[]> sortPdfForms(Map<String, byte[]> forms) {
        TreeMap<String, byte[]> sorted = new TreeMap<String, byte[]>(Comparator.comparing(FORM_ORDER::indexOf));
        sorted.putAll(forms);
        return sorted;
    }

    protected boolean fromYN(String s) {
        return "Y".equals(s);
    }

    protected String formatDate(Date date) {
        return new SimpleDateFormat(MM_DD_YYYY).format(date);
    }

    public static interface PdfField {
        public String getfName();

        public Set<String> getValues();

        public boolean isReadOnly();
    }

    static final class Attachment3bPage2Pdf {
        private Attachment3bPage2Pdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBAWARD_NUMBER("SubawardNumber"),
            ENTITY_NAME("SubEntityName"),
            PI_NAME("SubPIName");

            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    private static enum Attachment3bPage2Form {
        ATTACHMENT_3B_PAGE2("FDP_ATT_3B_2");

        private final String id;

        private Attachment3bPage2Form(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    static final class Attachment3bPdf {
        private Attachment3bPdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBAWARD_NUMBER("SubawardNumber");

            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    private static enum Attachment3bForm {
        ATTACHMENT_3B("FDP_ATT_3B");

        private final String id;

        private Attachment3bForm(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    static final class Attachment3aPdf {
        private Attachment3aPdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBAWARD_NUMBER("SubawardNumber"),
            PTE_INFO_ENTITY_NAME("PassThroughEntityPTE"),
            PTE_INFO_LEGAL_ADDRESS("PTELegalAddress"),
            PTE_INFO_WEBSITE("PTEWebsite"),
            PTE_CONTACTS_CENTRAL_EMAIL("PTECentralEmail"),
            PTE_CONTACTS_PI_NAME("PTEPI"),
            PTE_CONTACTS_PI_EMAIL("PTEPIEmail"),
            PTE_CONTACTS_PI_PHONE("PTEPIPhone"),
            PTE_CONTACTS_ADMIN_NAME("PTEACName"),
            PTE_CONTACTS_ADMIN_EMAIL("PTEACEmail"),
            PTE_CONTACTS_ADMIN_PHONE("PTEACPhone"),
            PTE_CONTACTS_COI_EMAIL("PTECOIEmail"),
            PTE_CONTACTS_FIN_NAME("PTEFCName"),
            PTE_CONTACTS_FIN_EMAIL("PTEFCEmail"),
            PTE_CONTACTS_FIN_PHONE("PTEFCPhone"),
            PTE_CONTACTS_EMAIL_INVOICES("EmailInvoices", Stream.of("Yes", "No").collect(Collectors.toSet())),
            PTE_CONTACTS_INVOICE_EMAIL("PTEInvoiceEmail"),
            PTE_CONTACTS_AUTH_OFFICIAL_NAME("PTEAOName"),
            PTE_CONTACTS_AUTH_OFFICIAL_EMAIL("PTEAOEmail"),
            PTE_CONTACTS_AUTH_OFFCIAL_PHONE("PTEAOPhone"),
            PTE_CONTACTS_PI_ADDRESS("PTEPIAddress"),
            PTE_CONTACTS_ADMIN_ADDRESS("PTEAdminAddress"),
            PTE_CONTACTS_INVOICE_ADDRESS("PTEInvoiceAddress");

            private static final String EMAIL_INVOICES_TRUE = "Yes";
            private static final String EMAIL_INVOICES_FALSE = "No";
            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    private static enum Attachment3aForm {
        ATTACHMENT_3A("FDP_ATT_3A");

        private final String id;

        private Attachment3aForm(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    static final class Attachment2Pdf {
        private Attachment2Pdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBAWARD_NUMBER("SubawardNumber"),
            DATA_ELEMENTS_REQUIRED("RequiredDataElements", Stream.of("in the attached Federal Award.", "as entered.").collect(Collectors.toSet())),
            DATA_ELEMENTS_TIP("KPTooltip", true),
            NOA_TIP("NOATooltip", true),
            RESEARCH_AND_DEVELOPMENT("R&D"),
            SUBJECT_TO_FFATA("FFATAYes"),
            FAID("FAID"),
            FAIN("FAIN"),
            CFDA("CFDA"),
            COPYRIGHT("Copyright", Stream.of("Subrecipient Grants", "Subrecipient Shall Grant", "").collect(Collectors.toSet())),
            MPI_SECTION_LABEL("MPI"),
            MPI_SECTION_HELP("MPITooltip", true),
            MPI_SECTION_BLANK("BlankMPI"),
            MPI_SECTION_SELECT("MPIYesNo", Stream.of("This subaward is not subject to an MPI Leadership Plan.", "This subaward is subject to an MPI Leadership Plan. Both parties will follow the finalized MPI Leadership Plan.", "").collect(Collectors.toSet())),
            MPI_PLAN_SELECT("MPIPlan", Stream.of("The MPI plan is attached as part of Attachment 6.", "The PTE will make the MPI plan available upon request.", "").collect(Collectors.toSet())),
            ANIMAL_SUBJECTS_CHECKBOX("VertebrateAnimals"),
            HUMAN_SUBJECTS_CHECKBOX("HumanSubjects"),
            NO_HUMAN_ANIMAL_SUBJECTS_CHECKBOX("NeitherHumanAnimal"),
            IRB_IACUC_LABEL("HSASLang"),
            IRB_IACUC_BLANK_LABEL("IntentionallyBlank"),
            PTE_REQUIRES_VERIFICATON_LABEL("HSASLang2"),
            PTE_VERIFICATION_CONTACT("HSVBDropdown", Stream.of("Administrative Contact", "Authorized Official", "Financial Contact", "Principal Investigator").collect(Collectors.toSet())),
            PTE_IRB_LABEL("IRB"),
            PTE_IRB_DROPDOWN("IRBDrop", Stream.of("Upon Request", "Prior to execution of this agreement", "Prior to execution of this agreement and annually thereafter", "Not required for the following reason:").collect(Collectors.toSet())),
            PTE_IRB_NOT_REQUIRED_REASON("IRBNotRequiredWhy", Stream.of(HumanPteSendNotRequiredReason.values()).map(HumanPteSendNotRequiredReason::getDescription).collect(Collectors.toSet())),
            PTE_IACUC_LABEL("IACUC"),
            PTE_IACUC_DROPDOWN("IACUCDrop", Stream.of("Upon Request", "Prior to execution of this agreement", "Prior to execution of this agreement and annually thereafter", "Not required for the following reason:").collect(Collectors.toSet())),
            PTE_IACUC_NOT_REQUIRED_REASON("IACUCNotRequiredWhy", Stream.of(AnimalPteSendNotRequiredReason.values()).map(AnimalPteSendNotRequiredReason::getDescription).collect(Collectors.toSet())),
            HUMAN_SUBJECTS_DATA_BLANK("BlankHumanData"),
            HUMAN_SUBJECTS_DATA_EXCHANGE_LABEL("HSDexchange"),
            HUMAN_SUBJECTS_DATA_EXCHANGE2_LABEL("HSDExchange"),
            HUMAN_SUBJECTS_DATA_APPLICABLE("HumanDataYesNo", Stream.of("Not Applicable", "Applicable", "Human subjects data will not be addressed in this agreement", "").collect(Collectors.toSet())),
            HUMAN_SUBJECTS_DATA_TERMS_LABEL("TermorDUA"),
            HUMAN_SUBJECTS_DATA_TERMS_TIP("AddTermTooltip", true),
            HUMAN_SUBJECTS_DATA_SUB_TO_PTE("SubToPTEYes"),
            HUMAN_SUBJECTS_DATA_PTE_TO_SUB("PTEToSubYes"),
            HUMAN_SUBJECTS_DATA_TERMS_DROPDOWN("TermDUA", Stream.of("Via a separate Data Use Agreement", "In the Additional Terms section below", "").collect(Collectors.toSet())),
            HUMAN_SUBJECTS_DATA_ADD_TERMS_TEXT("AdditionalTerms"),
            DATA_SHARING_PLAN("DataSharingPlan"),
            DATA_SHARING_DROPDOWN("DataSharingDropdown", Stream.of("attached.", "provided upon request.", "").collect(Collectors.toSet())),
            FCOI_PTE_DROPDOWN("COISubPTE", Stream.of("Subrecipient", "PTE", "").collect(Collectors.toSet())),
            FCOI_OTHER_SPONSOR_AGENCY("FCOIOtherSponsor"),
            SPONSOR_AGENCY("SponsorAgency"),
            FEDERAL_AWARD_CONDITIONS("FederalAwardConditions"),
            AGENCY_IMPLEMENTATION("AgencyImplementation"),
            GRANTS_POLICY_STATEMENT("GrantsPolicy"),
            RES_TERMS_COND("RTC"),
            NO_COST_EXT_CONTACT("NCEContact", Stream.of("Administrative", "Authorized Official", "Financial", "Principal Investigator").collect(Collectors.toSet())),
            TREATMENT_OF_PROGRAM_INCOME("ProgramIncome", Stream.of("Additive", "Other [enter text]", "").collect(Collectors.toSet())),
            TREATMENT_OF_PROGRAM_INCOME_OTHER_SPECIFY("ProgramIncomeText");

            private static final String VERIFICATION_CONTACT_ADMINISTRATIVE_CONTACT_VALUE = "Administrative Contact";
            private static final String VERIFICATION_CONTACT_FINANCIAL_CONTACT_VALUE = "Financial Contact";
            private static final String VERIFICATION_CONTACT_PI_VALUE = "Principal Investigator";
            private static final String VERIFICATION_CONTACT_AUTHORIZED_OFFICIAL_VALUE = "Authorized Official";
            private static final String TPI_ADDITIVE_VALUE = "Additive";
            private static final String TPI_OTHER_VALUE = "Other [enter text]";
            private static final String TPI_UNSELECTED_VALUE = "";
            private static final String DE_ATTACHED = "in the attached Federal Award.";
            private static final String DE_AS_ENTERED = "as entered.";
            private static final String COPYRIGHT_SUBRECIPIENT_GRANTS = "Subrecipient Grants";
            private static final String COPYRIGHT_SUBRECIPIENT_SHALL_GRANT = "Subrecipient Shall Grant";
            private static final String MPI_NOT_SUBJECT = "This subaward is not subject to an MPI Leadership Plan.";
            private static final String MPI_IS_SUBJECT = "This subaward is subject to an MPI Leadership Plan. Both parties will follow the finalized MPI Leadership Plan.";
            private static final String MPI_PLAN_ATTACHED = "The MPI plan is attached as part of Attachment 6.";
            private static final String MPI_PLAN_UPON_REQUEST = "The PTE will make the MPI plan available upon request.";
            private static final String PTE_UPON_REQUEST = "Upon Request";
            private static final String PTE_PRIOR_TO_EXECUTION_OF_THIS_AGREEMENT = "Prior to execution of this agreement";
            private static final String PTE_PRIOR_TO_EXECUTION_OF_THIS_AGREEMENT_ANNUALLY = "Prior to execution of this agreement and annually thereafter";
            private static final String PTE_NOT_REQUIRED = "Not required for the following reason:";
            private static final String HUMAN_DATA_NOT_APPLICABLE = "Not Applicable";
            private static final String HUMAN_DATA_APPLICABLE = "Applicable";
            private static final String HUMAN_DATA_NOT_ADDRESSED = "Human subjects data will not be addressed in this agreement";
            private static final String HUMAN_DATA_TERMS_SEPARATE_AGREEMENT = "Via a separate Data Use Agreement";
            private static final String HUMAN_DATA_TERMS_BELOW = "In the Additional Terms section below";
            private static final String DATA_SHARING_ATTACHED = "attached.";
            private static final String DATA_SHARING_PROVIDED_UPON_REQUEST = "provided upon request.";
            private static final String FCOI_SUBRECIPIENT = "Subrecipient";
            private static final String FCOI_PTE = "PTE";
            private static final String NCE_CONTACT_ADMINISTRATIVE = "Administrative";
            private static final String NCE_CONTACT_AUTHORIZED_OFFICIAL = "Authorized Official";
            private static final String NCE_CONTACT_FINANCIAL = "Financial";
            private static final String NCE_CONTACT_PI = "Principal Investigator";
            private static final String DEFAULT_APPEARANCE_STR_FONT_5 = "/ArialMT 5 Tf 0 g";
            private static final String DEFAULT_APPEARANCE_STR_FONT_8 = "/ArialMT 8 Tf 0 g";
            private static final String DEFAULT_APPEARANCE_STR_FONT_10 = "/ArialMT 10 Tf 0 g";
            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    private static enum Attachment2SponsorFormType {
        AFOSR,
        AMRMC,
        AMRAA,
        ARO,
        DOE,
        EPA,
        NASA,
        NIH,
        NSF,
        ONR,
        USDA;

    }

    private static enum Attachment2Form {
        FDP_AFOSR("FDP_AFOSR", Attachment2SponsorFormType.AFOSR),
        FDP_AMRMC("FDP_AMRMC", Attachment2SponsorFormType.AMRMC),
        FDP_AMRAA("FDP_AMRAA", Attachment2SponsorFormType.AMRAA),
        FDP_ARO("FDP_ARO", Attachment2SponsorFormType.ARO),
        FDP_DOE("FDP_DOE", Attachment2SponsorFormType.DOE),
        FDP_EPA("FDP_EPA", Attachment2SponsorFormType.EPA),
        FDP_NASA("FDP_NASA", Attachment2SponsorFormType.NASA),
        FDP_NIH("FDP_NIH", Attachment2SponsorFormType.NIH),
        FDP_NSF("FDP_NSF", Attachment2SponsorFormType.NSF),
        FDP_ONR("FDP_ONR", Attachment2SponsorFormType.ONR),
        FDP_USDA("FDP_USDA", Attachment2SponsorFormType.USDA);

        private final String id;
        private final Attachment2SponsorFormType sponsorFormType;

        private Attachment2Form(String id, Attachment2SponsorFormType sponsorFormType) {
            this.id = id;
            this.sponsorFormType = sponsorFormType;
        }

        public String getId() {
            return this.id;
        }

        public Attachment2SponsorFormType getSponsorFormType() {
            return this.sponsorFormType;
        }
    }

    static final class AgreementCertificationPdf {
        private AgreementCertificationPdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBAWARD_NO("SubawardNumber");

            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    static final class AgreementPdf {
        private AgreementPdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            FEDERAL_AWARDING_AGENCY("FederalAwardingAgency"),
            PASS_THROUGH_ENTITY("PassThroughEntityPTE"),
            PTE_PI("PTEPI"),
            PTE_FEDERAL_AWARD_NO("PTEFederalAwardNo"),
            SUBRECIPIENT("SubrecipientEntityName"),
            SUB_PI("SubPI"),
            SUBAWARD_NO("SubawardNumber"),
            PROJECT_TITLE("ProjectTitle"),
            POP_START("POPStart"),
            POP_END("POPEnd"),
            PROJECT_START("ProjectStart"),
            PROJECT_START_TIP("StartDateTooltip", true),
            PROJECT_END("ProjectEnd"),
            PROJECT_END_TIP("EndDateTooltip", true),
            AMOUNT_FUNDED_THIS_ACTION("AmountFundedThisAction"),
            INCREMENTALLY_ESTIMATED_TOTAL("IncrementallyEstimatedTotal"),
            TERM_2_CONTACT("Term2Contact", Stream.of("Financial", "Administrative", "Principal Investigator", "Authorized Official").collect(Collectors.toSet())),
            TERM_3_CONTACT("Term3Contact", Stream.of("Financial", "Administrative", "Principal Investigator", "Authorized Official").collect(Collectors.toSet())),
            PROJECT_BUDGET_INVOICE_DROPDOWN("ProjectBudgetInvoiceDrop", Stream.of("Project Period end date.", "Budget Period end date.").collect(Collectors.toSet())),
            TERM_6_CONTACT("Term6Contact", Stream.of("Financial", "Administrative", "Principal Investigator", "Authorized Official").collect(Collectors.toSet())),
            UNI_BI_MOD_DROPOWN("UniBiModDrop", Stream.of("Unilaterally", "Bilaterally").collect(Collectors.toSet())),
            TERM_7_CONTACT("Term7Contact", Stream.of("Financial", "Administrative", "Principal Investigator", "Authorized Official").collect(Collectors.toSet())),
            TERM_9_CONTACT("Term9Contact", Stream.of("Financial", "Administrative", "Principal Investigator", "Authorized Official").collect(Collectors.toSet()));

            protected static final String BUDGET_PERIOD_END_DATE_VALUE = "Budget Period end date.";
            protected static final String PROJECT_PERIOD_END_DATE_VALUE = "Project Period end date.";
            protected static final String UNILATERALLY_VALUE = "Unilaterally";
            protected static final String BILATERALLY_VALUE = "Bilaterally";
            protected static final String TERM_CONTACT_FINANCIAL = "Financial";
            protected static final String TERM_CONTACT_ADMIN = "Administrative";
            protected static final String TERM_CONTACT_PI = "Principal Investigator";
            protected static final String TERM_CONTACT_AUTH = "Authorized Official";
            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    static final class ModificationPdf {
        private ModificationPdf() {
            throw new UnsupportedOperationException("do not call");
        }

        static enum Field implements PdfField
        {
            SUBRECIPIENT("SubEntityName"),
            SUBEMAIL("SubEmail"),
            SUBPI("SubPI"),
            PTE_ENTITY_NAME("PTEEntityName"),
            PTEPI("PTEPI"),
            PTE_EMAIL("PTEEmail"),
            PTE_FEDERAL_AWARD_NO("PTEFederalAwardNo"),
            FEDERAL_AWARDING_AGENCY("FederalAwardingAgency"),
            PROJECT_TITLE("ProjectTitle"),
            START_DATE("StartDate"),
            END_DATE("EndDate"),
            EFFECTIVE_DATE("EffectiveDate"),
            AMENDMENT_NUMBER("AmendmentNumber"),
            AMOUNT_FUNDED_THIS_ACTION("AmountFundedThisAction"),
            TOTAL_FEDERAL_FUNDS_OBLIGATED("TotalFederalFundsObligated"),
            ACTION("Action"),
            SUBAWARD_NUMBER("SubawardNumber"),
            SUBJECTO_FFATA("SubjectoFFATA", Stream.of("Yes", "No").collect(Collectors.toSet())),
            CARRYOVER_RADIO_BUTTON("Carryover", Stream.of("CarryoverYes", "CarryoverNo").collect(Collectors.toSet()));

            protected static final String DEFAULT_APPEARANCE_STR_FONT_8 = "/ArialMT 8 Tf 0 g";
            protected static final String CARRYOVER_YES = "CarryoverYes";
            protected static final String CARRYOVER_NO = "CarryoverNo";
            protected static final String YES = "Yes";
            protected static final String NO = "No";
            private final String fName;
            private final Set<String> values;
            private final boolean readOnly;

            private Field(String fName, Set<String> values) {
                this.fName = fName;
                this.values = values;
                this.readOnly = false;
            }

            private Field(String fName) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = false;
            }

            private Field(String fName, boolean readOnly) {
                this.fName = fName;
                this.values = Collections.emptySet();
                this.readOnly = readOnly;
            }

            @Override
            public String getfName() {
                return this.fName;
            }

            @Override
            public Set<String> getValues() {
                return this.values;
            }

            @Override
            public boolean isReadOnly() {
                return this.readOnly;
            }
        }
    }

    private static enum SupplementalFormsForAgreement {
        FDP_ATTACHMENT_CERTIFICATION("FDP Attachment 1 Certification");

        private final String id;

        private SupplementalFormsForAgreement(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static enum ModificationForm {
        FDP_MODIFICATION("FDP Bilateral Subaward Amendment");

        private final String id;

        private ModificationForm(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static enum AgreementForm {
        FDP_AGREEMENT("FDP Cost Reimbursement Subaward");

        private final String id;

        private AgreementForm(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

