/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.timeandmoney.AwardAmountInfoHistory;
import org.kuali.kra.timeandmoney.AwardVersionHistory;
import org.kuali.kra.timeandmoney.TimeAndMoneyDocumentHistory;
import org.kuali.kra.timeandmoney.dao.TimeAndMoneyDao;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.kra.timeandmoney.history.TransactionType;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;

public class TimeAndMoneyHistoryServiceImpl
implements TimeAndMoneyHistoryService {
    private static final String AWARD_VERSIONS_TO_DISPLAY_PARM = "AWARD_VERSIONS_TO_DISPLAY_FOR_TIME_AND_MONEY_HISTORY";
    private static final String TIME_AND_MONEY_DOCUMENT_NUMBER = "timeAndMoneyDocumentNumber";
    private static final String ROOT_AWARD_NUMBER = "rootAwardNumber";
    private static final String SOURCE_AWARD_NUMBER = "sourceAwardNumber";
    private static final String DESTINATION_AWARD_NUMBER = "destinationAwardNumber";
    private static final String TRANSACTION_DETAIL_TYPE = "transactionDetailType";
    private static final String TRANSACTION_ID = "transactionId";
    private static final String TRANSACTION_DETAIL_ID = "transactionDetailId";
    private static final int NUMBER_30 = 30;
    private static final String DASH = "-";
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private static final String DOCUMENT_NUMBER = "documentNumber";
    private static final String NONE = "None";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String ROOT_AWARD_NUMBER_VAL = "00001";
    private static final String MM_DD_YY_FORMAT = "MM/dd/yy";
    private BusinessObjectService businessObjectService;
    private DocHandlerService docHandlerService;
    private DateTimeService dateTimeService;
    private GlobalVariableService globalVariableService;
    private AwardDao awardDao;
    private TimeAndMoneyDao timeAndMoneyDao;
    private ParameterService parameterService;

    @Override
    public List<AwardVersionHistory> buildTimeAndMoneyHistoryObjects(String awardNumber, boolean bounded) throws WorkflowException {
        Integer maxAwards = new Integer(this.getParameterService().getParameterValueAsString("KC-T", "Document", AWARD_VERSIONS_TO_DISPLAY_PARM));
        ArrayList<Award> awardVersionList = new ArrayList<Award>(this.awardDao.retrieveAwardsByCriteria(Collections.singletonMap(AWARD_NUMBER, awardNumber), null, 1, bounded ? maxAwards : -1).getResults());
        List<TimeAndMoneyDocument> docs = this.getTimeAndMoneyDao().getTimeAndMoneyDocumentForAwards(awardVersionList.stream().map(award -> award.getAwardId()).collect(Collectors.toList()));
        return this.buildAwardVersionHistoryList(awardVersionList, docs);
    }

    List<AwardVersionHistory> buildAwardVersionHistoryList(List<Award> awardVersionList, List<TimeAndMoneyDocument> docs) throws WorkflowException {
        ArrayList<AwardVersionHistory> awardVersionHistoryCollection = new ArrayList<AwardVersionHistory>();
        for (Award award : awardVersionList) {
            if (award.getAwardSequenceStatus().equalsIgnoreCase(VersionStatus.CANCELED.toString())) continue;
            AwardVersionHistory awardVersionHistory = new AwardVersionHistory(award);
            awardVersionHistory.setDocumentUrl(this.buildForwardUrl(award.getAwardDocument().getDocumentNumber()));
            awardVersionHistory.setAwardDescriptionLine(award.getAwardDescriptionLine());
            awardVersionHistory.setTimeAndMoneyDocumentHistoryList(this.getDocHistoryAndValidInfosAssociatedWithAwardVersion(docs, award.getAwardAmountInfos(), award));
            awardVersionHistoryCollection.add(awardVersionHistory);
        }
        return awardVersionHistoryCollection;
    }

    @Override
    public List<TimeAndMoneyDocumentHistory> getDocHistoryAndValidInfosAssociatedWithAwardVersion(List<TimeAndMoneyDocument> docs, List<AwardAmountInfo> awardAmountInfos, Award award) throws WorkflowException {
        ArrayList<TimeAndMoneyDocumentHistory> timeAndMoneyDocumentHistoryList = new ArrayList<TimeAndMoneyDocumentHistory>();
        List<AwardAmountInfo> validInfos = this.getValidAwardAmountInfosAssociatedWithAwardVersion(awardAmountInfos, award);
        List<TimeAndMoneyDocument> awardVersionDocs = this.getValidDocumentsCreatedForAwardVersion(docs, validInfos);
        Collections.reverse(awardVersionDocs);
        for (TimeAndMoneyDocument doc : awardVersionDocs) {
            TimeAndMoneyDocumentHistory docHistory = new TimeAndMoneyDocumentHistory();
            docHistory.setTimeAndMoneyDocument(doc);
            docHistory.setDocumentUrl(this.buildForwardUrl(doc.getDocumentNumber()));
            docHistory.setTimeAndMoneyDocumentDescriptionLine(this.buildNewTimeAndMoneyDescriptionLine(doc));
            docHistory.setValidAwardAmountInfoHistoryList(this.retrieveAwardAmountInfosFromPrimaryTransactions(doc, validInfos));
            timeAndMoneyDocumentHistoryList.add(docHistory);
        }
        return timeAndMoneyDocumentHistoryList;
    }

    protected List<AwardAmountInfoHistory> retrieveAwardAmountInfosFromPrimaryTransactions(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> primaryInfos = new ArrayList<AwardAmountInfoHistory>();
        primaryInfos.addAll(this.captureMoneyInfos(doc.getDocumentNumber(), validInfos));
        primaryInfos.addAll(this.captureDateInfos(doc, validInfos));
        primaryInfos.addAll(this.captureInitialTransactionInfo(doc, validInfos));
        return primaryInfos;
    }

    protected List<AwardAmountInfoHistory> captureMoneyInfos(String timeAndMoneyDocumentNumber, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> moneyInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((CharSequence)timeAndMoneyDocumentNumber, (CharSequence)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
            CollectionUtils.addIgnoreNull(moneyInfoHistoryList, (Object)this.getMoneyInfoHistory(awardAmountInfo, this.getTransactions(awardAmountInfo.getTransactionId())));
        }
        return moneyInfoHistoryList;
    }

    private AwardAmountInfoHistory getMoneyInfoHistory(AwardAmountInfo awardAmountInfo, List<TransactionDetail> transactions) {
        TransactionDetail primaryTransaction = this.getPrimaryTransaction(transactions);
        if (primaryTransaction != null) {
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.MONEY.toString());
            awardAmountInfoHistory.setPrimaryDetail(primaryTransaction);
            awardAmountInfoHistory.setIntermediateDetails(this.getIntermediateTransactions(transactions));
            return awardAmountInfoHistory;
        }
        return null;
    }

    protected TransactionDetail getPrimaryTransaction(List<TransactionDetail> transactions) {
        for (TransactionDetail detail : transactions) {
            if (!TransactionDetailType.PRIMARY.toString().equals(detail.getTransactionDetailType())) continue;
            return detail;
        }
        return null;
    }

    protected List<TransactionDetail> getIntermediateTransactions(List<TransactionDetail> transactions) {
        return ListUtils.select(transactions, (Predicate)new Predicate<TransactionDetail>(){

            public boolean evaluate(TransactionDetail detail) {
                return TransactionDetailType.INTERMEDIATE.toString().equals(detail.getTransactionDetailType());
            }
        });
    }

    protected List<TransactionDetail> getTransactions(Long transactionId) {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put(TRANSACTION_ID, transactionId);
        return this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, values, TRANSACTION_DETAIL_ID, true);
    }

    protected List<AwardAmountInfoHistory> captureDateInfos(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> dateInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((CharSequence)doc.getDocumentNumber(), (CharSequence)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
            fieldValues.put(SOURCE_AWARD_NUMBER, awardAmountInfo.getAwardNumber());
            fieldValues.put(TRANSACTION_DETAIL_TYPE, TransactionDetailType.DATE.toString());
            fieldValues.put(TIME_AND_MONEY_DOCUMENT_NUMBER, awardAmountInfo.getTimeAndMoneyDocumentNumber());
            fieldValues.put(TRANSACTION_ID, awardAmountInfo.getTransactionId());
            List dateTransactionDetails = this.businessObjectService.findMatching(TransactionDetail.class, fieldValues);
            if (dateTransactionDetails.isEmpty()) continue;
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.DATE.toString());
            awardAmountInfoHistory.setDateDetail((TransactionDetail)dateTransactionDetails.iterator().next());
            dateInfoHistoryList.add(awardAmountInfoHistory);
        }
        return dateInfoHistoryList;
    }

    protected List<AwardAmountInfoHistory> captureInitialTransactionInfo(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        ArrayList<AwardAmountInfoHistory> initialInfoHistoryList = new ArrayList<AwardAmountInfoHistory>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !StringUtils.equalsIgnoreCase((CharSequence)doc.getDocumentNumber(), (CharSequence)awardAmountInfo.getTimeAndMoneyDocumentNumber())) continue;
            fieldValues.put(DESTINATION_AWARD_NUMBER, awardAmountInfo.getAwardNumber());
            fieldValues.put(TRANSACTION_ID, 0);
            fieldValues.put(TIME_AND_MONEY_DOCUMENT_NUMBER, awardAmountInfo.getTimeAndMoneyDocumentNumber());
            fieldValues.put(TRANSACTION_DETAIL_TYPE, TransactionDetailType.PRIMARY.toString());
            List transactionDetailsA = this.businessObjectService.findMatchingOrderBy(TransactionDetail.class, fieldValues, SOURCE_AWARD_NUMBER, true);
            if (transactionDetailsA.size() <= 0) break;
            AwardAmountInfoHistory awardAmountInfoHistory = new AwardAmountInfoHistory();
            awardAmountInfoHistory.setAwardAmountInfo(awardAmountInfo);
            awardAmountInfoHistory.setTransactionType(TransactionType.INITIAL.toString());
            initialInfoHistoryList.add(awardAmountInfoHistory);
            break;
        }
        return initialInfoHistoryList;
    }

    protected String buildNewTimeAndMoneyDescriptionLine(TimeAndMoneyDocument doc) {
        AwardAmountTransaction aat = doc.getAwardAmountTransactions().get(0);
        String noticeDate = aat.getNoticeDate() != null ? aat.getNoticeDate().toString() : NONE;
        String transactionTypeDescription = aat.getAwardTransactionType() != null ? aat.getAwardTransactionType().getDescription() : NONE;
        return "Time And Money Document: " + transactionTypeDescription + ", notice date: " + noticeDate + ", updated " + this.getUpdateTimeAndUser(doc) + ". Comments: " + (aat.getComments() == null ? NONE : aat.getComments());
    }

    protected List<AwardAmountInfo> getValidAwardAmountInfosAssociatedWithAwardVersion(List<AwardAmountInfo> awardAmountInfos, Award award) {
        ArrayList<AwardAmountInfo> validInfos = new ArrayList<AwardAmountInfo>();
        for (AwardAmountInfo awardAmountInfo : awardAmountInfos) {
            if (awardAmountInfo.getOriginatingAwardVersion() == null || !awardAmountInfo.getOriginatingAwardVersion().equals(award.getSequenceNumber())) continue;
            validInfos.add(awardAmountInfo);
        }
        return validInfos;
    }

    protected List<TimeAndMoneyDocument> getValidDocumentsCreatedForAwardVersion(List<TimeAndMoneyDocument> docs, List<AwardAmountInfo> validInfos) {
        ArrayList<TimeAndMoneyDocument> validDocs = new ArrayList<TimeAndMoneyDocument>();
        for (TimeAndMoneyDocument doc : docs) {
            if (!this.isInValidInfosCollection(doc, validInfos).booleanValue()) continue;
            validDocs.add(doc);
        }
        return validDocs;
    }

    protected Boolean isInValidInfosCollection(TimeAndMoneyDocument doc, List<AwardAmountInfo> validInfos) {
        Boolean valid = false;
        for (AwardAmountInfo awardAmountInfo : validInfos) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null || !awardAmountInfo.getTimeAndMoneyDocumentNumber().equals(doc.getDocumentNumber())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    protected void removeCanceledDocs(List<TimeAndMoneyDocument> docs) {
        ArrayList<TimeAndMoneyDocument> tempCanceledDocs = new ArrayList<TimeAndMoneyDocument>();
        for (TimeAndMoneyDocument doc : docs) {
            if (!this.isDocCancelled(doc)) continue;
            tempCanceledDocs.add(doc);
        }
        docs.removeAll(tempCanceledDocs);
    }

    protected boolean isDocCancelled(KcTransactionalDocumentBase doc) {
        return doc.getDocumentHeader().hasWorkflowDocument() && doc.getDocumentHeader().getWorkflowDocument().isCanceled();
    }

    @Override
    public List<TimeAndMoneyDocument> buildTimeAndMoneyListForAwardDisplay(Award award, boolean bounded) throws WorkflowException {
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put(ROOT_AWARD_NUMBER, award.getAwardNumber());
        List docs = this.businessObjectService.findMatchingOrderBy(TimeAndMoneyDocument.class, fieldValues1, DOCUMENT_NUMBER, true);
        this.removeCanceledDocs(docs);
        return docs;
    }

    protected String getUpdateTimeAndUser(TimeAndMoneyDocument doc) {
        String createDateStr = null;
        String updateUser = null;
        if (doc.getUpdateTimestamp() != null) {
            createDateStr = this.getDateTimeService().toString((Date)doc.getUpdateTimestamp(), MM_DD_YY_FORMAT);
            updateUser = doc.getUpdateUser().length() > 30 ? doc.getUpdateUser().substring(0, 30) : doc.getUpdateUser();
        }
        return createDateStr + " by " + updateUser;
    }

    protected String buildForwardUrl(String documentNumber) {
        Object forward = this.getDocHandlerUrl(documentNumber);
        forward = !((String)(forward = ((String)forward).replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB))).contains("?") ? (String)forward + "?" : (String)forward + "&";
        forward = (String)forward + "docId=" + documentNumber;
        forward = (String)forward + "&command=displayDocSearchView";
        if (this.isBackdoorUserInUse()) {
            forward = (String)forward + "&backdoorId=" + this.globalVariableService.getUserSession().getPrincipalName();
        }
        return "<a href=\"" + (String)forward + "\"target=\"_blank\">" + documentNumber + "</a>";
    }

    boolean isBackdoorUserInUse() {
        return this.globalVariableService.getUserSession().isBackdoorInUse();
    }

    String getDocHandlerUrl(String documentNumber) {
        String forward = this.getDocHandlerService().getDocHandlerUrl(documentNumber);
        return forward;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocHandlerService getDocHandlerService() {
        return this.docHandlerService;
    }

    public void setDocHandlerService(DocHandlerService docHandlerService) {
        this.docHandlerService = docHandlerService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }

    public void setAwardDao(AwardDao awardDao) {
        this.awardDao = awardDao;
    }

    public TimeAndMoneyDao getTimeAndMoneyDao() {
        return this.timeAndMoneyDao;
    }

    public void setTimeAndMoneyDao(TimeAndMoneyDao timeAndMoneyDao) {
        this.timeAndMoneyDao = timeAndMoneyDao;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

