/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.InactivatableFromTo;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.provider.annotation.ExtensionFor;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.InactivateableFromToService;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.impl.LookupCriteriaGenerator;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.ForeignKeyFieldsPopulationState;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class KRADLegacyDataAdapterImpl
implements LegacyDataAdapter {
    private DataObjectService dataObjectService;
    private LookupCriteriaGenerator lookupCriteriaGenerator;
    private ConfigurationService kualiConfigurationService;
    private KualiModuleService kualiModuleService;
    private DataDictionaryService dataDictionaryService;
    private ViewDictionaryService viewDictionaryService;
    private InactivateableFromToService inactivateableFromToService;
    private DocumentAdHocService documentAdHocService;

    public <T> T save(T dataObject) {
        if (dataObject instanceof Collection) {
            ArrayList newList = new ArrayList(((Collection)dataObject).size());
            for (Object obj : (Collection)dataObject) {
                newList.add(this.save(obj));
            }
            return (T)newList;
        }
        return (T)this.dataObjectService.save(dataObject, new PersistenceOption[0]);
    }

    public <T> T linkAndSave(T dataObject) {
        return (T)this.dataObjectService.save(dataObject, new PersistenceOption[]{PersistenceOption.LINK_KEYS});
    }

    public <T> T saveDocument(T document) {
        return (T)this.dataObjectService.save(document, new PersistenceOption[]{PersistenceOption.LINK_KEYS, PersistenceOption.FLUSH});
    }

    public <T> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        return (T)this.dataObjectService.find(clazz, (Object)new CompoundKey(primaryKeys));
    }

    public <T> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return (T)this.dataObjectService.find(clazz, primaryKey);
    }

    public void delete(Object dataObject) {
        if (dataObject instanceof Collection) {
            for (Object dobj : (Collection)dataObject) {
                this.delete(dobj);
            }
        } else {
            this.dataObjectService.delete(dataObject);
        }
    }

    public <T> void deleteMatching(Class<T> type, Map<String, ?> fieldValues) {
        this.dataObjectService.deleteMatching(type, QueryByCriteria.Builder.andAttributes(fieldValues).build());
    }

    public <T> T retrieve(T dataObject) {
        Map primaryKeyValues = this.dataObjectService.wrap(dataObject).getPrimaryKeyValues();
        if (primaryKeyValues.isEmpty()) {
            throw new IllegalArgumentException("Given data object has no primary key!");
        }
        Object id = primaryKeyValues.size() == 1 ? primaryKeyValues.values().iterator().next() : new CompoundKey(primaryKeyValues);
        return (T)this.dataObjectService.find(dataObject.getClass(), id);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findMatching(clazz, Collections.emptyMap());
    }

    public <T> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest) {
        return this.findMatching(clazz, Collections.emptyMap(), pagingRequest);
    }

    public <T> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        QueryResults result = this.dataObjectService.findMatching(clazz, QueryByCriteria.Builder.andAttributes(fieldValues).build());
        return result.getResults();
    }

    public <T> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.andAttributes(fieldValues);
        builder.setStartAtIndex(Integer.valueOf(pagingRequest.getStartAtIndex()));
        builder.setMaxResults(Integer.valueOf(pagingRequest.getMaxResults()));
        builder.setCountFlag(CountFlag.INCLUDE);
        QueryResults result = this.dataObjectService.findMatching(clazz, builder.build());
        return new QueryPagingResults(pagingRequest, result.getResults(), result.getTotalRowCount().intValue());
    }

    public <T> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        OrderDirection direction = sortAscending ? OrderDirection.ASCENDING : OrderDirection.DESCENDING;
        OrderByField orderBy = OrderByField.Builder.create((String)sortField, (OrderDirection)direction).build();
        QueryResults result = this.dataObjectService.findMatching(clazz, QueryByCriteria.Builder.andAttributes(fieldValues).setOrderByFields(new OrderByField[]{orderBy}).build());
        return result.getResults();
    }

    public <T> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        OrderDirection direction = sortAscending ? OrderDirection.ASCENDING : OrderDirection.DESCENDING;
        OrderByField orderBy = OrderByField.Builder.create((String)sortField, (OrderDirection)direction).build();
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.andAttributes(fieldValues).setOrderByFields(new OrderByField[]{orderBy});
        builder.setStartAtIndex(Integer.valueOf(pagingRequest.getStartAtIndex()));
        builder.setMaxResults(Integer.valueOf(pagingRequest.getMaxResults()));
        builder.setCountFlag(CountFlag.INCLUDE);
        QueryResults result = this.dataObjectService.findMatching(clazz, builder.build());
        return new QueryPagingResults(pagingRequest, result.getResults(), result.getTotalRowCount().intValue());
    }

    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject) {
        return this.dataObjectService.wrap(dataObject).getPrimaryKeyValues();
    }

    public void retrieveNonKeyFields(Object persistableObject) {
        List relationships = this.dataObjectService.getMetadataRepository().getMetadata(persistableObject.getClass()).getRelationships();
        for (DataObjectRelationship relationship : relationships) {
            this.retrieveReferenceObject(persistableObject, relationship.getName());
        }
    }

    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        this.dataObjectService.wrap(persistableObject).fetchRelationship(referenceObjectName);
    }

    public void refreshAllNonUpdatingReferences(Object persistableObject) {
        List<DataObjectRelationship> nonUpdateableRelationships = this.findNonUpdateableRelationships(persistableObject);
        for (DataObjectRelationship relationship : nonUpdateableRelationships) {
            this.retrieveReferenceObject(persistableObject, relationship.getName());
        }
    }

    protected List<DataObjectRelationship> findNonUpdateableRelationships(Object persistableObject) {
        ArrayList<DataObjectRelationship> nonUpdateableRelationships = new ArrayList<DataObjectRelationship>();
        DataObjectMetadata dataObjectMetadata = this.dataObjectService.getMetadataRepository().getMetadata(persistableObject.getClass());
        if (dataObjectMetadata != null) {
            List relationships = dataObjectMetadata.getRelationships();
            for (DataObjectRelationship relationship : relationships) {
                if (relationship.isSavedWithParent()) continue;
                nonUpdateableRelationships.add(relationship);
            }
        }
        return nonUpdateableRelationships;
    }

    public boolean isProxied(Object object) {
        return false;
    }

    public Object resolveProxy(Object o) {
        return o;
    }

    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        return this.performDataObjectServiceLookup(dataObjectClass, formProperties, unbounded, allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties, List<String> wildcardAsLiteralPropertyNames, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        return this.performDataObjectServiceLookup(dataObjectClass, formProperties, wildcardAsLiteralPropertyNames, unbounded, allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    protected <T> Collection<T> performDataObjectServiceLookup(Class<T> dataObjectClass, Map<String, String> formProperties, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        if (!unbounded && searchResultsLimit == null) {
            searchResultsLimit = LookupUtils.getSearchResultsLimit(dataObjectClass);
        }
        QueryByCriteria.Builder query = this.lookupCriteriaGenerator.generateCriteria(dataObjectClass, formProperties, allPrimaryKeyValuesPresentAndNotWildcard);
        if (!unbounded && searchResultsLimit != null) {
            query.setMaxResults(searchResultsLimit);
        }
        List results = this.dataObjectService.findMatching(dataObjectClass, query.build()).getResults();
        return this.filterCurrentDataObjects(dataObjectClass, results, formProperties);
    }

    protected <T> Collection<T> performDataObjectServiceLookup(Class<T> dataObjectClass, Map<String, String> formProperties, List<String> wildcardAsLiteralPropertyNames, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        if (!unbounded && searchResultsLimit == null) {
            searchResultsLimit = LookupUtils.getSearchResultsLimit(dataObjectClass);
        }
        QueryByCriteria.Builder query = this.lookupCriteriaGenerator.generateCriteria(dataObjectClass, formProperties, wildcardAsLiteralPropertyNames, allPrimaryKeyValuesPresentAndNotWildcard);
        if (!unbounded && searchResultsLimit != null) {
            query.setMaxResults(searchResultsLimit);
        }
        List results = this.dataObjectService.findMatching(dataObjectClass, query.build()).getResults();
        return this.filterCurrentDataObjects(dataObjectClass, results, formProperties);
    }

    protected <T> Collection<T> filterCurrentDataObjects(Class<T> dataObjectClass, Collection<T> unfiltered, Map<String, String> formProps) {
        Boolean currentSpecifier;
        if (InactivatableFromTo.class.isAssignableFrom(dataObjectClass) && (currentSpecifier = this.lookupCriteriaCurrentSpecifier(formProps)) != null) {
            List onlyCurrent = this.getInactivateableFromToService().filterOutNonCurrent(new ArrayList<T>(unfiltered), new Date(org.kuali.rice.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria(formProps).getTime()));
            if (currentSpecifier.booleanValue()) {
                return onlyCurrent;
            }
            unfiltered.removeAll(onlyCurrent);
            return unfiltered;
        }
        return unfiltered;
    }

    protected Boolean lookupCriteriaCurrentSpecifier(Map<String, String> formProps) {
        String value = formProps.get("current");
        if (StringUtils.isNotBlank((String)value)) {
            String currentBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)value);
            if ("Y".equals(currentBooleanStr)) {
                return Boolean.TRUE;
            }
            if ("N".equals(currentBooleanStr)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public <T> T findObjectBySearch(Class<T> type, Map<String, String> formProps) {
        QueryByCriteria.Builder queryByCriteria = this.lookupCriteriaGenerator.createObjectCriteriaFromMap(type, formProps);
        List results = this.dataObjectService.findMatching(type, queryByCriteria.build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() != 1) {
            throw new IncorrectResultSizeDataAccessException("Incorrect number of results returned when finding object", 1, results.size());
        }
        return (T)results.get(0);
    }

    public boolean allPrimaryKeyValuesPresentAndNotWildcard(Class<?> boClass, Map<String, String> formProps) {
        List<String> pkFields = this.listPrimaryKeyFieldNames(boClass);
        Iterator<String> pkIter = pkFields.iterator();
        boolean returnVal = true;
        block0: while (returnVal && pkIter.hasNext()) {
            String pkName = pkIter.next();
            String pkValue = formProps.get(pkName);
            if (StringUtils.isBlank((String)pkValue)) {
                returnVal = false;
                continue;
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                returnVal = false;
                continue block0;
            }
        }
        return returnVal;
    }

    public List<String> listPrimaryKeyFieldNames(Class<?> type) {
        List keys = Collections.emptyList();
        if (this.dataObjectService.getMetadataRepository().contains(type)) {
            keys = this.dataObjectService.getMetadataRepository().getMetadata(type).getPrimaryKeyAttributeNames();
        } else {
            DataObjectEntry dataObjectEntry = this.dataDictionaryService.getDataDictionary().getDataObjectEntry(type.getName());
            if (dataObjectEntry != null) {
                List pks = dataObjectEntry.getPrimaryKeys();
                if (pks != null) {
                    keys = pks;
                }
            } else {
                ModuleService responsibleModuleService = this.kualiModuleService.getResponsibleModuleService(type);
                if (responsibleModuleService != null && responsibleModuleService.isExternalizable(type)) {
                    keys = responsibleModuleService.listPrimaryKeyFieldNames(type);
                }
            }
        }
        return keys;
    }

    protected List<String> listPrimaryKeyFieldNamesConsultingAllServices(Class<?> type) {
        List<String> keys = new ArrayList<String>();
        if (this.dataObjectService.getMetadataRepository().contains(type)) {
            keys = this.dataObjectService.getMetadataRepository().getMetadata(type).getPrimaryKeyAttributeNames();
        }
        return keys;
    }

    public Class<?> determineCollectionObjectType(Class<?> containingType, String collectionPropertyName) {
        DataObjectCollection collection;
        if (this.dataObjectService.getMetadataRepository().contains(containingType)) {
            DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(containingType);
            collection = metadata.getCollection(collectionPropertyName);
            if (collection == null) {
                throw new IllegalArgumentException("Failed to locate a collection property with the given name: " + collectionPropertyName);
            }
        } else {
            throw new IllegalArgumentException("Given containing class is not a valid data object, no metadata could be located for " + containingType.getName());
        }
        Class collectionObjectType = collection.getRelatedType();
        return collectionObjectType;
    }

    public boolean hasReference(Class<?> boClass, String referenceName) {
        throw new UnsupportedOperationException("hasReference not valid for KRAD data operation");
    }

    public boolean hasCollection(Class<?> boClass, String collectionName) {
        throw new UnsupportedOperationException("hasCollection not valid for KRAD data operation");
    }

    public boolean isExtensionAttribute(Class<?> boClass, String attributePropertyName, Class<?> propertyType) {
        Class relatedType;
        ExtensionFor annotation;
        DataObjectRelationship relationship;
        DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(boClass);
        if (metadata != null && (relationship = metadata.getRelationship(attributePropertyName)) != null && (annotation = (relatedType = relationship.getRelatedType()).getAnnotation(ExtensionFor.class)) != null) {
            return annotation.value().equals(boClass);
        }
        return false;
    }

    public Class<?> getExtensionAttributeClass(Class<?> boClass, String attributePropertyName) {
        DataObjectRelationship relationship;
        DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(boClass);
        if (metadata != null && (relationship = metadata.getRelationship(attributePropertyName)) != null) {
            return relationship.getRelatedType();
        }
        return null;
    }

    public Map<String, ?> getPrimaryKeyFieldValuesDOMDS(Object dataObject) {
        return this.dataObjectService.wrap(dataObject).getPrimaryKeyValues();
    }

    public boolean equalsByPrimaryKeys(Object do1, Object do2) {
        return this.dataObjectService.wrap(do1).equalsByPrimaryKey(do2);
    }

    public void materializeAllSubObjects(Object object) {
        DataObjectWrapper wrappedObject = this.dataObjectService.wrap(object);
        wrappedObject.materializeReferencedObjectsToDepth(3, new MaterializeOption[0]);
    }

    public Class<?> getPropertyType(Object object, String propertyName) {
        DataObjectWrapper wrappedObject = this.dataObjectService.wrap(object);
        if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
            return wrappedObject.getPropertyTypeNullSafe(wrappedObject.getWrappedClass(), propertyName);
        }
        return wrappedObject.getPropertyType(propertyName);
    }

    public Object getExtension(Class<?> businessObjectClass) throws InstantiationException, IllegalAccessException {
        DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(businessObjectClass);
        DataObjectRelationship extensionRelationship = metadata.getRelationship("extension");
        if (extensionRelationship != null) {
            Class extensionType = extensionRelationship.getRelatedType();
            return extensionType.newInstance();
        }
        return null;
    }

    public void refreshReferenceObject(Object businessObject, String referenceObjectName) {
        this.dataObjectService.wrap(businessObject).fetchRelationship(referenceObjectName);
    }

    public boolean isLockable(Object object) {
        return this.isPersistable(object.getClass());
    }

    public void verifyVersionNumber(Object dataObject) {
        DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(dataObject.getClass());
        if (metadata == null) {
            return;
        }
        if (metadata.isSupportsOptimisticLocking() && dataObject instanceof Versioned) {
            Map keyPropertyValues = this.dataObjectService.wrap(dataObject).getPrimaryKeyValues();
            CompoundKey key = new CompoundKey(keyPropertyValues);
            Object persistableDataObject = null;
            if (!key.hasNullKeyValues()) {
                persistableDataObject = this.dataObjectService.find(dataObject.getClass(), (Object)key);
            }
            if (persistableDataObject != null) {
                Long databaseVersionNumber = ((Versioned)persistableDataObject).getVersionNumber();
                Long documentVersionNumber = ((Versioned)dataObject).getVersionNumber();
                if (databaseVersionNumber != null && !databaseVersionNumber.equals(documentVersionNumber)) {
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.version.mismatch", new String[0]);
                    throw new ValidationException("Version mismatch between the local business object and the database business object");
                }
            }
        }
    }

    public RemotableQuickFinder.Builder createQuickFinder(Class<?> containingClass, String attributeName) {
        return this.createQuickFinderNew(containingClass, attributeName);
    }

    protected RemotableQuickFinder.Builder createQuickFinderNew(Class<?> containingClass, String attributeName) {
        if (this.dataObjectService.getMetadataRepository().contains(containingClass)) {
            String lookupClassName = null;
            HashMap<String, String> fieldConversions = new HashMap<String, String>();
            HashMap<Object, String> lookupParameters = new HashMap<Object, String>();
            DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(containingClass);
            DataObjectRelationship relationship = metadata.getRelationshipByLastAttributeInRelationship(attributeName);
            if (relationship != null) {
                DataObjectMetadata lookupClassMetadata = this.dataObjectService.getMetadataRepository().getMetadata(relationship.getRelatedType());
                lookupClassName = lookupClassMetadata.getClass().getName();
                for (DataObjectAttributeRelationship attributeRelationship : relationship.getAttributeRelationships()) {
                    fieldConversions.put(attributeRelationship.getChildAttributeName(), attributeRelationship.getParentAttributeName());
                    lookupParameters.put(attributeRelationship.getParentAttributeName(), attributeRelationship.getChildAttributeName());
                }
                if (lookupClassMetadata.hasDistinctBusinessKey().booleanValue()) {
                    lookupParameters.clear();
                    for (String businessKeyAttributeName : lookupClassMetadata.getBusinessKeyAttributeNames()) {
                        lookupParameters.put(relationship.getName() + "." + businessKeyAttributeName, businessKeyAttributeName);
                    }
                }
            } else {
                String primaryDisplayAttributeName = metadata.getPrimaryDisplayAttributeName();
                if (StringUtils.equals((String)primaryDisplayAttributeName, (String)attributeName)) {
                    lookupClassName = containingClass.getName();
                    List primaryKeyAttributes = metadata.getPrimaryKeyAttributeNames();
                    for (String primaryKeyAttribute : primaryKeyAttributes) {
                        fieldConversions.put(primaryKeyAttribute, primaryKeyAttribute);
                        if (StringUtils.equals((String)primaryKeyAttribute, (String)attributeName)) continue;
                        lookupParameters.put(primaryKeyAttribute, primaryKeyAttribute);
                    }
                }
            }
            if (StringUtils.isNotBlank(lookupClassName)) {
                String baseUrl = this.kualiConfigurationService.getPropertyValueAsString("krad.lookup.url");
                RemotableQuickFinder.Builder builder = RemotableQuickFinder.Builder.create((String)baseUrl, (String)lookupClassName);
                builder.setLookupParameters(lookupParameters);
                builder.setFieldConversions(fieldConversions);
                return builder;
            }
        }
        return null;
    }

    public boolean isReferenceUpdatable(Class<?> type, String referenceName) {
        DataObjectRelationship relationship;
        if (this.dataObjectService.getMetadataRepository().contains(type) && (relationship = this.dataObjectService.getMetadataRepository().getMetadata(type).getRelationship(referenceName)) != null) {
            return relationship.isSavedWithParent();
        }
        return false;
    }

    public Map<String, Class<?>> listReferenceObjectFields(Class<?> type) {
        HashMap referenceNameToTypeMap = new HashMap();
        if (this.dataObjectService.getMetadataRepository().contains(type)) {
            List relationships = this.dataObjectService.getMetadataRepository().getMetadata(type).getRelationships();
            for (DataObjectRelationship rel : relationships) {
                referenceNameToTypeMap.put(rel.getName(), rel.getRelatedType());
            }
        }
        return referenceNameToTypeMap;
    }

    public boolean isCollectionUpdatable(Class<?> type, String collectionName) {
        DataObjectCollection collection;
        if (this.dataObjectService.getMetadataRepository().contains(type) && (collection = this.dataObjectService.getMetadataRepository().getMetadata(type).getCollection(collectionName)) != null) {
            return collection.isSavedWithParent();
        }
        return false;
    }

    public Map<String, Class<?>> listCollectionObjectTypes(Class<?> type) {
        HashMap collectionNameToTypeMap = new HashMap();
        if (this.dataObjectService.getMetadataRepository().contains(type)) {
            List collections = this.dataObjectService.getMetadataRepository().getMetadata(type).getCollections();
            for (DataObjectCollection coll : collections) {
                collectionNameToTypeMap.put(coll.getName(), coll.getRelatedType());
            }
        }
        return collectionNameToTypeMap;
    }

    public Object getReferenceIfExists(Object bo, String referenceName) {
        DataObjectWrapper dataObjectWrapper = this.dataObjectService.wrap(bo);
        dataObjectWrapper.fetchRelationship(referenceName);
        return dataObjectWrapper.getPropertyValueNullSafe(referenceName);
    }

    public boolean allForeignKeyValuesPopulatedForReference(Object bo, String referenceName) {
        Map<String, String> fkReferences = this.getForeignKeysForReference(bo.getClass(), referenceName);
        if (fkReferences.size() > 0) {
            DataObjectWrapper dataObjectWrapper = this.dataObjectService.wrap(bo);
            for (String fkFieldName : fkReferences.keySet()) {
                Object fkFieldValue = dataObjectWrapper.getForeignKeyAttributeValue(fkFieldName);
                if (fkFieldValue == null) {
                    return false;
                }
                if (fkFieldValue instanceof CompoundKey) {
                    return !((CompoundKey)fkFieldValue).hasNullKeyValues();
                }
                if (!String.class.isAssignableFrom(fkFieldValue.getClass()) || !StringUtils.isBlank((String)((String)fkFieldValue))) continue;
                return false;
            }
        }
        return true;
    }

    public RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName) {
        DataDictionaryEntry entryBase = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(c.getName());
        if (entryBase == null) {
            return null;
        }
        RelationshipDefinition relationship = null;
        List ddRelationships = entryBase.getRelationships();
        int minKeys = Integer.MAX_VALUE;
        block0: for (RelationshipDefinition def : ddRelationships) {
            if (def.getPrimitiveAttributes().size() == 1) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                    relationship = def;
                    minKeys = 1;
                    continue block0;
                }
                continue;
            }
            if (def.getPrimitiveAttributes().size() >= minKeys) continue;
            for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                relationship = def;
                minKeys = def.getPrimitiveAttributes().size();
                continue block0;
            }
        }
        if (relationship == null) {
            for (RelationshipDefinition def : ddRelationships) {
                if (!def.hasIdentifier() || !def.getIdentifier().getSourceName().equals(attributeName)) continue;
                relationship = def;
            }
        }
        return relationship;
    }

    public String getTitleAttribute(Class<?> dataObjectClass) {
        String titleAttribute = null;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    protected DataObjectEntry getDataObjectEntry(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        return this.dataDictionaryService.getDataDictionary().getDataObjectEntry(dataObjectClass.getName());
    }

    public boolean areNotesSupported(Class<?> dataObjectClass) {
        boolean hasNotesSupport = false;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            hasNotesSupport = entry.isBoNotesEnabled();
        }
        return hasNotesSupport;
    }

    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject, boolean sortFieldNames) {
        Map<String, ?> keyFieldValues = this.getPrimaryKeyFieldValues(dataObject);
        if (sortFieldNames) {
            return new TreeMap(keyFieldValues);
        }
        return keyFieldValues;
    }

    public String getDataObjectIdentifierString(Object dataObject) {
        StringBuilder identifierString = new StringBuilder();
        if (dataObject == null) {
            identifierString = new StringBuilder("Null");
            return identifierString.toString();
        }
        Map<String, ?> primaryKeyFieldValues = this.getPrimaryKeyFieldValues(dataObject, true);
        for (Map.Entry<String, ?> primaryKeyValue : primaryKeyFieldValues.entrySet()) {
            if (primaryKeyValue.getValue() == null) {
                identifierString.append("Null");
            } else {
                identifierString.append(primaryKeyValue.getValue());
            }
            identifierString.append(":");
        }
        return StringUtils.removeEnd((String)identifierString.toString(), (String)":");
    }

    public Class<?> getInquiryObjectClassIfNotTitle(Object dataObject, String propertyName) {
        DataObjectRelationship dataObjectRelationship;
        DataObjectMetadata objectMetadata = this.getDataObjectService().getMetadataRepository().getMetadata(dataObject.getClass());
        if (objectMetadata != null && (dataObjectRelationship = objectMetadata.getRelationship(propertyName)) != null) {
            return dataObjectRelationship.getRelatedType();
        }
        return null;
    }

    public Map<String, String> getInquiryParameters(Object dataObject, List<String> keys, String propertyName) {
        HashMap<String, String> inquiryParameters = new HashMap<String, String>();
        DataObjectRelationship dataObjectRelationship = null;
        DataObjectMetadata objectMetadata = this.getDataObjectService().getMetadataRepository().getMetadata(dataObject.getClass());
        if (objectMetadata != null) {
            dataObjectRelationship = objectMetadata.getRelationshipByLastAttributeInRelationship(propertyName);
        }
        for (String keyName : keys) {
            Object keyConversion = keyName;
            if (dataObjectRelationship != null) {
                keyConversion = dataObjectRelationship.getParentAttributeNameRelatedToChildAttributeName(keyName);
            } else if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
                String nestedAttributePrefix = KRADUtils.getNestedAttributePrefix((String)propertyName);
                keyConversion = nestedAttributePrefix + "." + keyName;
            }
            inquiryParameters.put((String)keyConversion, keyName);
        }
        return inquiryParameters;
    }

    public boolean hasLocalLookup(Class<?> dataObjectClass) {
        return this.viewDictionaryService.isLookupable(dataObjectClass);
    }

    public boolean hasLocalInquiry(Class<?> dataObjectClass) {
        return this.viewDictionaryService.isInquirable(dataObjectClass);
    }

    public org.kuali.rice.krad.bo.DataObjectRelationship getDataObjectRelationship(Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        RelationshipDefinition ddReference = this.getDictionaryRelationship(dataObjectClass, attributeName);
        org.kuali.rice.krad.bo.DataObjectRelationship relationship = null;
        if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)attributeName)) {
            int nextObjectIndex;
            if (ddReference != null && this.classHasSupportedFeatures(ddReference.getTargetClass(), supportsLookup, supportsInquiry)) {
                relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, attributePrefix, keysOnly);
                return relationship;
            }
            if (dataObject == null) {
                try {
                    dataObject = KRADUtils.createNewObjectFromClass(dataObjectClass);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            if ((nextObjectIndex = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)attributeName)) == -1) {
                nextObjectIndex = attributeName.length();
            }
            String localPrefix = StringUtils.substring((String)attributeName, (int)0, (int)nextObjectIndex);
            String localAttributeName = StringUtils.substring((String)attributeName, (int)(nextObjectIndex + 1));
            Object nestedObject = ObjectPropertyUtils.getPropertyValue((Object)dataObject, (String)localPrefix);
            Class nestedClass = nestedObject == null ? ObjectPropertyUtils.getPropertyType((Object)dataObject, (String)localPrefix) : nestedObject.getClass();
            Object fullPrefix = localPrefix;
            if (StringUtils.isNotBlank((String)attributePrefix)) {
                fullPrefix = attributePrefix + "." + localPrefix;
            }
            relationship = this.getDataObjectRelationship(nestedObject, nestedClass, localAttributeName, (String)fullPrefix, keysOnly, supportsLookup, supportsInquiry);
            return relationship;
        }
        int maxSize = Integer.MAX_VALUE;
        if (this.isPersistable(dataObjectClass)) {
            DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(dataObjectClass);
            DataObjectRelationship dataObjectRelationship = metadata.getRelationship(attributeName);
            if (dataObjectRelationship != null) {
                List attributeRelationships = dataObjectRelationship.getAttributeRelationships();
                for (DataObjectAttributeRelationship dataObjectAttributeRelationship : attributeRelationships) {
                    if (!this.classHasSupportedFeatures(dataObjectRelationship.getRelatedType(), supportsLookup, supportsInquiry)) continue;
                    maxSize = attributeRelationships.size();
                    relationship = this.transformToDeprecatedDataObjectRelationship(dataObjectClass, attributeName, attributePrefix, dataObjectRelationship.getRelatedType(), dataObjectAttributeRelationship);
                    break;
                }
            }
        } else {
            ModuleService moduleService = this.kualiModuleService.getResponsibleModuleService(dataObjectClass);
            if (moduleService != null && moduleService.isExternalizable(dataObjectClass)) {
                relationship = this.getRelationshipMetadata(dataObjectClass, attributeName, attributePrefix);
                if (relationship != null && this.classHasSupportedFeatures(relationship.getRelatedClass(), supportsLookup, supportsInquiry)) {
                    return relationship;
                }
                return null;
            }
        }
        if (ddReference != null && ddReference.getPrimitiveAttributes().size() < maxSize && this.classHasSupportedFeatures(ddReference.getTargetClass(), supportsLookup, supportsInquiry)) {
            relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, null, keysOnly);
        }
        return relationship;
    }

    protected org.kuali.rice.krad.bo.DataObjectRelationship transformToDeprecatedDataObjectRelationship(Class<?> dataObjectClass, String attributeName, String attributePrefix, Class<?> relatedObjectClass, DataObjectAttributeRelationship relationship) {
        org.kuali.rice.krad.bo.DataObjectRelationship rel = new org.kuali.rice.krad.bo.DataObjectRelationship(dataObjectClass, attributeName, relatedObjectClass);
        if (StringUtils.isBlank((String)attributePrefix)) {
            rel.getParentToChildReferences().put(relationship.getParentAttributeName(), relationship.getChildAttributeName());
        } else {
            rel.getParentToChildReferences().put(attributePrefix + "." + relationship.getParentAttributeName(), relationship.getChildAttributeName());
        }
        return rel;
    }

    protected org.kuali.rice.krad.bo.DataObjectRelationship populateRelationshipFromDictionaryReference(Class<?> dataObjectClass, RelationshipDefinition ddReference, String attributePrefix, boolean keysOnly) {
        org.kuali.rice.krad.bo.DataObjectRelationship relationship = new org.kuali.rice.krad.bo.DataObjectRelationship(dataObjectClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
        for (PrimitiveAttributeDefinition def : ddReference.getPrimitiveAttributes()) {
            if (StringUtils.isNotBlank((String)attributePrefix)) {
                relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                continue;
            }
            relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
        }
        if (!keysOnly) {
            for (PrimitiveAttributeDefinition def : ddReference.getSupportAttributes()) {
                if (StringUtils.isNotBlank((String)attributePrefix)) {
                    relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                    if (!def.isIdentifier()) continue;
                    relationship.setUserVisibleIdentifierKey(attributePrefix + "." + def.getSourceName());
                    continue;
                }
                relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
                if (!def.isIdentifier()) continue;
                relationship.setUserVisibleIdentifierKey(def.getSourceName());
            }
        }
        return relationship;
    }

    public boolean isPersistable(Class<?> dataObjectClass) {
        return this.dataObjectService.getMetadataRepository().contains(dataObjectClass);
    }

    protected org.kuali.rice.krad.bo.DataObjectRelationship getRelationshipMetadata(Class<?> dataObjectClass, String attributeName, String attributePrefix) {
        RelationshipDefinition relationshipDefinition = this.getDictionaryRelationship(dataObjectClass, attributeName);
        if (relationshipDefinition == null) {
            return null;
        }
        org.kuali.rice.krad.bo.DataObjectRelationship dataObjectRelationship = new org.kuali.rice.krad.bo.DataObjectRelationship(relationshipDefinition.getSourceClass(), relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
        if (!StringUtils.isEmpty((String)attributePrefix)) {
            attributePrefix = (String)attributePrefix + ".";
        }
        List primitives = relationshipDefinition.getPrimitiveAttributes();
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitives) {
            dataObjectRelationship.getParentToChildReferences().put((String)attributePrefix + primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
        }
        return dataObjectRelationship;
    }

    protected boolean classHasSupportedFeatures(Class<?> relationshipClass, boolean supportsLookup, boolean supportsInquiry) {
        boolean hasSupportedFeatures = true;
        if (supportsLookup && !this.getViewDictionaryService().isLookupable(relationshipClass)) {
            hasSupportedFeatures = false;
        }
        if (supportsInquiry && !this.getViewDictionaryService().isInquirable(relationshipClass)) {
            hasSupportedFeatures = false;
        }
        return hasSupportedFeatures;
    }

    public ForeignKeyFieldsPopulationState getForeignKeyFieldsPopulationState(Object dataObject, String referenceName) {
        DataObjectWrapper dataObjectWrapper = this.dataObjectService.wrap(dataObject);
        return new ForeignKeyFieldsPopulationState(dataObjectWrapper.areAllPrimaryKeyAttributesPopulated(), dataObjectWrapper.areAnyPrimaryKeyAttributesPopulated(), dataObjectWrapper.getUnpopulatedPrimaryKeyAttributeNames());
    }

    public Map<String, String> getForeignKeysForReference(Class<?> clazz, String attributeName) {
        if (this.dataObjectService.getMetadataRepository().contains(clazz)) {
            DataObjectRelationship relationship = this.dataObjectService.getMetadataRepository().getMetadata(clazz).getRelationship(attributeName);
            List attributeRelationships = relationship.getAttributeRelationships();
            HashMap<String, String> parentChildKeyRelationships = new HashMap<String, String>(attributeRelationships.size());
            for (DataObjectAttributeRelationship doar : attributeRelationships) {
                parentChildKeyRelationships.put(doar.getParentAttributeName(), doar.getChildAttributeName());
            }
            return parentChildKeyRelationships;
        }
        return Collections.emptyMap();
    }

    public <T> void setObjectPropertyDeep(Object bo, String propertyName, Class<T> type, T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] propertyDescriptors;
        DataObjectWrapper dataObjectWrapper = this.dataObjectService.wrap(bo);
        if (KRADUtils.isNull((Object)bo) || !PropertyUtils.isReadable((Object)bo, (String)propertyName) || propertyValue != null && propertyValue.equals(dataObjectWrapper.getPropertyValueNullSafe(propertyName)) || type != null && !type.equals(KRADUtils.easyGetPropertyType((Object)bo, (String)propertyName))) {
            return;
        }
        KRADUtils.setObjectProperty((Object)bo, (String)propertyName, type, propertyValue);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(bo.getClass())) {
            if (propertyDescriptor.getPropertyType() != null && BusinessObject.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && PropertyUtils.isReadable((Object)bo, (String)propertyDescriptor.getName())) {
                Object nestedBo = dataObjectWrapper.getPropertyValueNullSafe(propertyDescriptor.getName());
                if (!(nestedBo instanceof BusinessObject)) continue;
                this.setObjectPropertyDeep(nestedBo, propertyName, type, propertyValue);
                continue;
            }
            if (propertyDescriptor.getPropertyType() == null || !List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || dataObjectWrapper.getPropertyValueNullSafe(propertyDescriptor.getName()) == null) continue;
            List propertyList = (List)dataObjectWrapper.getPropertyValueNullSafe(propertyDescriptor.getName());
            for (Object listedBo : propertyList) {
                if (!(listedBo instanceof BusinessObject)) continue;
                this.setObjectPropertyDeep(listedBo, propertyName, type, propertyValue);
            }
        }
    }

    public boolean hasPrimaryKeyFieldValues(Object dataObject) {
        DataObjectWrapper dataObjectWrapper = this.dataObjectService.wrap(dataObject);
        return dataObjectWrapper.areAllPrimaryKeyAttributesPopulated();
    }

    public <T> Class<T> materializeClassForProxiedObject(T object) {
        Object o;
        if (object == null) {
            return null;
        }
        if (LegacyUtils.isKradDataManaged(object.getClass()) && (o = this.resolveProxy(object)) != null) {
            return o.getClass();
        }
        return object.getClass();
    }

    public Object getNestedValue(Object bo, String fieldName) {
        return this.getDataObjectService().wrap(bo).getPropertyValueNullSafe(fieldName);
    }

    public <T> T createNewObjectFromClass(Class<T> clazz) {
        T object;
        if (clazz == null) {
            throw new IllegalArgumentException("Class was passed in as null");
        }
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    public boolean isNull(Object object) {
        return object == null;
    }

    public <T> void setObjectProperty(Object bo, String propertyName, Class<T> propertyType, T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, propertyValue);
    }

    public <T extends Document> T findByDocumentHeaderId(Class<T> documentClass, String id) {
        Document document = (Document)this.getDataObjectService().find(documentClass, (Object)id);
        this.getDocumentAdHocService().addAdHocs(document);
        return (T)document;
    }

    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> documentClass, List<String> ids) {
        ArrayList<T> documents = new ArrayList<T>();
        for (String id : ids) {
            T document = this.findByDocumentHeaderId(documentClass, id);
            if (document == null) continue;
            documents.add(document);
        }
        return documents;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Required
    public void setLookupCriteriaGenerator(LookupCriteriaGenerator lookupCriteriaGenerator) {
        this.lookupCriteriaGenerator = lookupCriteriaGenerator;
    }

    @Required
    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @Required
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    @Required
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public ViewDictionaryService getViewDictionaryService() {
        return this.viewDictionaryService;
    }

    public void setViewDictionaryService(ViewDictionaryService viewDictionaryService) {
        this.viewDictionaryService = viewDictionaryService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public LookupCriteriaGenerator getLookupCriteriaGenerator() {
        return this.lookupCriteriaGenerator;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public InactivateableFromToService getInactivateableFromToService() {
        return this.inactivateableFromToService;
    }

    public void setInactivateableFromToService(InactivateableFromToService inactivateableFromToService) {
        this.inactivateableFromToService = inactivateableFromToService;
    }

    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentAdHocService;
    }

    public void setDocumentAdHocService(DocumentAdHocService documentAdHocService) {
        this.documentAdHocService = documentAdHocService;
    }
}

