/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.util;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.uif.AttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotablePasswordInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextExpand;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.control.ButtonControlDefinition;
import org.kuali.rice.kns.datadictionary.control.CurrencyControlDefinition;
import org.kuali.rice.kns.datadictionary.control.KualiUserControlDefinition;
import org.kuali.rice.kns.datadictionary.control.LinkControlDefinition;
import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.inquiry.Inquirable;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.MaintenanceUtils;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.PropertyRenderingConfigElement;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.KualiCode;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.keyvalues.IndicatorValuesFinder;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;
import org.springframework.util.CollectionUtils;

@Deprecated
public final class FieldUtils {
    private static final Logger LOG = LogManager.getLogger(FieldUtils.class);
    private static DataDictionaryService dataDictionaryService = null;
    private static BusinessObjectMetaDataService businessObjectMetaDataService = null;
    private static BusinessObjectDictionaryService businessObjectDictionaryService = null;
    private static KualiModuleService kualiModuleService = null;

    private FieldUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getContentType(Field field, BusinessObject bo) {
        Object fileNameProp;
        String propertyName = field.getPropertyName();
        if (propertyName.contains(".")) {
            String parent = propertyName.substring(0, propertyName.lastIndexOf(46) + 1);
            fileNameProp = parent + "contentType";
        } else {
            fileNameProp = "contentType";
        }
        return (String)ObjectUtils.getNestedValue(bo, (String)fileNameProp);
    }

    public static String getFileName(Field field, BusinessObject bo) {
        Object fileNameProp;
        String propertyName = field.getPropertyName();
        if (propertyName.contains(".")) {
            String parent = propertyName.substring(0, propertyName.lastIndexOf(46) + 1);
            fileNameProp = parent + "fileName";
        } else {
            fileNameProp = "fileName";
        }
        return (String)ObjectUtils.getNestedValue(bo, (String)fileNameProp);
    }

    public static void setInquiryURL(Field field, BusinessObject bo, String propertyName) {
        HtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        Boolean b = FieldUtils.getBusinessObjectDictionaryService().noInquiryFieldInquiry(bo.getClass(), propertyName);
        if (b == null || !b.booleanValue()) {
            Class inquirableClass = FieldUtils.getBusinessObjectDictionaryService().getInquirableClass(bo.getClass());
            Boolean b2 = FieldUtils.getBusinessObjectDictionaryService().forceLookupResultFieldInquiry(bo.getClass(), propertyName);
            try {
                Inquirable inq;
                if (inquirableClass != null) {
                    inq = (Inquirable)inquirableClass.newInstance();
                } else {
                    inq = KNSServiceLocator.getKualiInquirable();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Default Inquirable Class: " + inq.getClass());
                    }
                }
                inquiryHref = inq.getInquiryUrl(bo, propertyName, null != b2 && b2 != false);
            }
            catch (Exception ex) {
                LOG.error("unable to create inquirable to get inquiry URL", (Throwable)ex);
            }
        }
        field.setInquiryURL(inquiryHref);
    }

    public static void setFieldControl(Class businessObjectClass, String attributeName, boolean convertForLookup, Field field) {
        ControlDefinition control = FieldUtils.getDataDictionaryService().getAttributeControlDefinition(businessObjectClass, attributeName);
        String fieldType = "text";
        if (control != null) {
            String keyFinderClassName;
            Integer size;
            if (control.isSelect()) {
                if (control.getScript() != null && control.getScript().length() > 0) {
                    fieldType = "dropdown_script";
                    field.setScript(control.getScript());
                } else {
                    fieldType = "dropdown";
                }
            }
            if (control.isMultiselect()) {
                fieldType = "multiselect";
            }
            if (control.isCheckbox()) {
                fieldType = "checkbox";
            }
            if (control.isRadio()) {
                fieldType = "radio";
            }
            if (control.isHidden()) {
                fieldType = "hidden";
            }
            if (control.isKualiUser()) {
                fieldType = "kualiuser";
                KualiUserControlDefinition kualiUserControl = (KualiUserControlDefinition)control;
                field.setUniversalIdAttributeName(kualiUserControl.getUniversalIdAttributeName());
                field.setUserIdAttributeName(kualiUserControl.getUserIdAttributeName());
                field.setPersonNameAttributeName(kualiUserControl.getPersonNameAttributeName());
            }
            if (control.isWorkflowWorkgroup()) {
                fieldType = "workflowworkgroup";
            }
            if (control.isFile()) {
                fieldType = "file";
            }
            if (control.isTextarea() && !convertForLookup) {
                fieldType = "textarea";
            }
            if (control.isLookupHidden()) {
                fieldType = "lookuphidden";
            }
            if (control.isLookupReadonly()) {
                fieldType = "lookupreadonly";
            }
            if (control.isCurrency()) {
                fieldType = "currency";
            }
            if (control.isButton()) {
                fieldType = "button";
            }
            if (control.isLink()) {
                fieldType = "link";
            }
            if ("currency".equals(fieldType) && control instanceof CurrencyControlDefinition) {
                CurrencyControlDefinition currencyControl = (CurrencyControlDefinition)control;
                field.setStyleClass("amount");
                field.setSize(currencyControl.getSize());
                field.setFormattedMaxLength(currencyControl.getFormattedMaxLength());
            }
            if ("text".equals(fieldType)) {
                size = control.getSize();
                field.setSize(Objects.requireNonNullElse(size, 30));
                field.setDatePicker(control.isDatePicker());
                field.setDatePickerFormat(control.getDatePickerFormat());
                field.setRanged(control.isRanged());
            }
            if ("workflowworkgroup".equals(fieldType)) {
                size = control.getSize();
                field.setSize(Objects.requireNonNullElse(size, 30));
            }
            if ("textarea".equals(fieldType)) {
                Integer rows = control.getRows();
                field.setRows(Objects.requireNonNullElse(rows, 3));
                Integer cols = control.getCols();
                field.setCols(Objects.requireNonNullElse(cols, 40));
                field.setExpandedTextArea(control.isExpandedTextArea());
            }
            if ("multiselect".equals(fieldType) && (size = control.getSize()) != null) {
                field.setSize(size);
            }
            if (("dropdown".equals(fieldType) || "radio".equals(fieldType) || "dropdown_script".equals(fieldType) || "multiselect".equals(fieldType)) && StringUtils.isNotBlank((String)(keyFinderClassName = control.getValuesFinderClass()))) {
                try {
                    Class keyFinderClass = ClassLoaderUtils.getClass((String)keyFinderClassName);
                    KeyValuesFinder finder = (KeyValuesFinder)keyFinderClass.newInstance();
                    if (!CollectionUtils.isEmpty((Map)control.getValuesFinderProperties())) {
                        for (Map.Entry entry : control.getValuesFinderProperties().entrySet()) {
                            BeanUtils.setProperty((Object)finder, (String)((String)entry.getKey()), entry.getValue());
                        }
                    }
                    field.setFieldValidValues(finder.getKeyValues());
                    field.setFieldInactiveValidValues(finder.getKeyValues(false));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    LOG.error("Unable to get new instance of finder class: " + keyFinderClassName);
                    throw new RuntimeException("Unable to get new instance of finder class: " + keyFinderClassName, e);
                }
            }
            if ("checkbox".equals(fieldType) && convertForLookup) {
                fieldType = "radio";
                field.setFieldValidValues(IndicatorValuesFinder.INSTANCE.getKeyValues());
            }
            if ("button".equals(fieldType)) {
                ButtonControlDefinition buttonControl = (ButtonControlDefinition)control;
                field.setImageSrc(buttonControl.getImageSrc());
                field.setStyleClass(buttonControl.getStyleClass());
            }
            if ("link".equals(fieldType)) {
                LinkControlDefinition linkControl = (LinkControlDefinition)control;
                field.setStyleClass(linkControl.getStyleClass());
                field.setTarget(linkControl.getTarget());
                field.setHrefText(linkControl.getHrefText());
            }
        }
        field.setFieldType(fieldType);
    }

    public static Field getPropertyField(Class businessObjectClass, String attributeName, boolean convertForLookup) {
        Integer maxLength;
        Field field = new Field();
        field.setPropertyName(attributeName);
        if (ExternalizableBusinessObjectUtils.isExternalizableBusinessObject((Class)businessObjectClass)) {
            ModuleService moduleService = FieldUtils.getKualiModuleService().getResponsibleModuleService(businessObjectClass);
            businessObjectClass = moduleService.getExternalizableBusinessObjectDictionaryEntry(businessObjectClass).getDataObjectClass();
        }
        field.setFieldLabel(FieldUtils.getDataDictionaryService().getAttributeLabel(businessObjectClass, attributeName));
        FieldUtils.setFieldControl(businessObjectClass, attributeName, convertForLookup, field);
        Boolean fieldRequired = FieldUtils.getBusinessObjectDictionaryService().getLookupAttributeRequired(businessObjectClass, attributeName);
        if (fieldRequired != null) {
            field.setFieldRequired(fieldRequired);
        }
        if ((maxLength = FieldUtils.getDataDictionaryService().getAttributeMaxLength(businessObjectClass, attributeName)) != null) {
            field.setMaxLength(maxLength);
        }
        Boolean upperCase = null;
        try {
            upperCase = FieldUtils.getDataDictionaryService().getAttributeForceUppercase(businessObjectClass, attributeName);
        }
        catch (UnknownBusinessClassAttributeException t) {
            LOG.warn("UnknownBusinessClassAttributeException in fieldUtils.getPropertyField() : " + t.getMessage());
        }
        if (upperCase != null) {
            field.setUpperCase(upperCase);
        }
        if (!businessObjectClass.isInterface()) {
            try {
                field.setFormatter(ObjectUtils.getFormatterWithDataDictionary(businessObjectClass.newInstance(), attributeName));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.info("Unable to get new instance of business object class: " + businessObjectClass.getName(), (Throwable)e);
            }
        }
        field.setBusinessObjectClassName(businessObjectClass.getName());
        field.setFieldHelpName(attributeName);
        field.setFieldHelpSummary(FieldUtils.getDataDictionaryService().getAttributeSummary(businessObjectClass, attributeName));
        return field;
    }

    public static void setAdditionalDisplayPropertyForCodes(Class businessObjectClass, String attributeName, PropertyRenderingConfigElement field) {
        try {
            DataObjectRelationship relationship = FieldUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationship(businessObjectClass.newInstance(), attributeName);
            if (relationship != null && attributeName.startsWith(relationship.getParentAttributeName()) && KualiCode.class.isAssignableFrom(relationship.getRelatedClass())) {
                field.setAdditionalDisplayPropertyName(relationship.getParentAttributeName() + ".name");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get new instance of class to check for KualiCode references: " + e.getMessage(), e);
        }
    }

    public static List wrapFields(List fields) {
        return FieldUtils.wrapFields(fields, 1);
    }

    public static List<Row> wrapFields(List<Field> fields, int numberOfColumns) {
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<Field> fieldOnlyList = new ArrayList<Field>();
        List<Field> visableFields = FieldUtils.getVisibleFields(fields);
        List<Field> nonVisableFields = FieldUtils.getNonVisibleFields(fields);
        int fieldsPosition = 0;
        for (Field element : visableFields) {
            if ("subSectionSeparator".equals(element.getFieldType()) || "container".equals(element.getFieldType())) {
                fieldsPosition = FieldUtils.createBlankSpace(fieldOnlyList, rows, numberOfColumns, fieldsPosition);
                ArrayList<Field> fieldList = new ArrayList<Field>();
                fieldList.add(element);
                rows.add(new Row(fieldList));
                continue;
            }
            if (fieldsPosition < numberOfColumns) {
                fieldOnlyList.add(element);
                ++fieldsPosition;
                continue;
            }
            rows.add(new Row(new ArrayList<Field>(fieldOnlyList)));
            fieldOnlyList.clear();
            fieldOnlyList.add(element);
            fieldsPosition = 1;
        }
        FieldUtils.createBlankSpace(fieldOnlyList, rows, numberOfColumns, fieldsPosition);
        if (nonVisableFields != null && !nonVisableFields.isEmpty()) {
            Row nonVisRow = new Row();
            nonVisRow.setFields(nonVisableFields);
            rows.add(nonVisRow);
        }
        return rows;
    }

    private static List<Field> getVisibleFields(List<Field> fields) {
        ArrayList<Field> rList = new ArrayList<Field>();
        for (Field f : fields) {
            if ("hidden".equals(f.getFieldType()) || "blankSpace".equals(f.getFieldType())) continue;
            rList.add(f);
        }
        return rList;
    }

    private static List<Field> getNonVisibleFields(List<Field> fields) {
        ArrayList<Field> rList = new ArrayList<Field>();
        for (Field f : fields) {
            if (!"hidden".equals(f.getFieldType()) && !"blankSpace".equals(f.getFieldType())) continue;
            rList.add(f);
        }
        return rList;
    }

    private static int createBlankSpace(List<Field> fieldOnlyList, List<Row> rows, int numberOfColumns, int fieldsPosition) {
        int fieldOnlySize = fieldOnlyList.size();
        if (fieldOnlySize > 0) {
            for (int i = 0; i < numberOfColumns - fieldOnlySize; ++i) {
                Field empty = new Field();
                empty.setFieldType("blankSpace");
                empty.setPropertyName("blankSpace");
                fieldOnlyList.add(empty);
            }
            rows.add(new Row(new ArrayList<Field>(fieldOnlyList)));
            fieldOnlyList.clear();
            fieldsPosition = 0;
        }
        return fieldsPosition;
    }

    public static Field constructContainerField(String name, String label, List fields) {
        return FieldUtils.constructContainerField(name, label, fields, 1);
    }

    public static Field constructContainerField(String name, String label, List fields, int numberOfColumns) {
        Field containerField = new Field();
        containerField.setPropertyName(name);
        containerField.setFieldLabel(label);
        containerField.setFieldType("container");
        containerField.setNumberOfColumnsForCollection(numberOfColumns);
        List<Row> rows = FieldUtils.wrapFields(fields, numberOfColumns);
        containerField.setContainerRows(rows);
        return containerField;
    }

    public static List<Field> populateFieldsFromBusinessObject(List<Field> fields, BusinessObject bo) {
        ArrayList<Field> populatedFields = new ArrayList<Field>();
        if (bo instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)bo).refreshNonUpdateableReferences();
        }
        for (Field element : fields) {
            if (element.containsBOData()) {
                String propertyName = element.getPropertyName();
                if (!(!FieldUtils.isPropertyNested(propertyName) || FieldUtils.isObjectTreeNonNullAllTheWayDown(bo, propertyName) || element.getFieldType().equals("imagesubmit") || element.getFieldType().equals("container") || element.getFieldType().equals("quickFinder"))) {
                    element.setPropertyValue(null);
                } else if (FieldUtils.isPropertyReadable(bo, propertyName)) {
                    FieldUtils.populateReadableField(element, bo);
                }
                if (StringUtils.isNotBlank((String)element.getAlternateDisplayPropertyName())) {
                    String alternatePropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, element.getAlternateDisplayPropertyName());
                    element.setAlternateDisplayPropertyValue(alternatePropertyValue);
                }
                if (StringUtils.isNotBlank((String)element.getAdditionalDisplayPropertyName())) {
                    String additionalPropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, element.getAdditionalDisplayPropertyName());
                    element.setAdditionalDisplayPropertyValue(additionalPropertyValue);
                }
            }
            populatedFields.add(element);
        }
        return populatedFields;
    }

    private static boolean isPropertyReadable(Object bean, String name) {
        try {
            return PropertyUtils.isReadable((Object)bean, (String)name);
        }
        catch (NestedNullException e) {
            return false;
        }
    }

    private static boolean isPropertyWritable(Object bean, String name) {
        try {
            return PropertyUtils.isWriteable((Object)bean, (String)name);
        }
        catch (NestedNullException e) {
            return false;
        }
    }

    public static void populateReadableField(Field field, BusinessObject businessObject) {
        Object obj = ObjectUtils.getNestedValue(businessObject, field.getPropertyName());
        if ("file".equals(field.getFieldType())) {
            field.setImageSrc(WebUtils.getAttachmentImageForUrl(FieldUtils.getContentType(field, businessObject)));
            field.setPropertyValue(FieldUtils.getFileName(field, businessObject));
        }
        if (obj != null) {
            String formattedValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(businessObject, field.getPropertyName());
            field.setPropertyValue(formattedValue);
            if (field.getFieldType().equals("kualiuser")) {
                try {
                    Object personName;
                    Object principalId;
                    if (StringUtils.isNotBlank((String)field.getUniversalIdAttributeName()) && (principalId = ObjectUtils.getNestedValue(businessObject, field.getUniversalIdAttributeName())) != null) {
                        field.setUniversalIdValue(principalId.toString());
                    }
                    if (StringUtils.isNotBlank((String)field.getPersonNameAttributeName()) && (personName = ObjectUtils.getNestedValue(businessObject, field.getPersonNameAttributeName())) != null) {
                        field.setPersonNameValue(personName.toString());
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Unable to get principal ID or person name property in FieldBridge.", (Throwable)ex);
                }
            }
        }
        FieldUtils.populateSecureField(field, obj);
    }

    public static void populateSecureField(Field field, Object fieldValue) {
        if (field.isSecure()) {
            try {
                if (fieldValue != null && fieldValue.toString().endsWith("(&^HSH#&)")) {
                    field.setEncryptedValue(fieldValue.toString());
                } else if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    field.setEncryptedValue(CoreApiServiceLocator.getEncryptionService().encrypt(fieldValue) + "(&^#&)");
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Unable to encrypt secure field " + e.getMessage(), e);
            }
        }
    }

    private static boolean isPropertyNested(String propertyName) {
        return -1 != propertyName.indexOf(46);
    }

    private static boolean isObjectTreeNonNullAllTheWayDown(BusinessObject bo, String propertyName) {
        String[] propertyParts = propertyName.split("\\.");
        StringBuilder property = new StringBuilder();
        for (int i = 0; i < propertyParts.length - 1; ++i) {
            property.append(0 == property.length() ? "" : ".").append(propertyParts[i]);
            try {
                if (null != PropertyUtils.getNestedProperty((Object)bo, (String)property.toString())) continue;
                return false;
            }
            catch (Throwable t) {
                LOG.debug("Either getter or setter not specified for property \"" + property.toString() + "\"", t);
                return false;
            }
        }
        return true;
    }

    public static Map populateBusinessObjectFromMap(BusinessObject bo, Map fieldValues) {
        return FieldUtils.populateBusinessObjectFromMap(bo, fieldValues, "");
    }

    public static Map populateBusinessObjectFromMap(BusinessObject bo, Map<String, ?> fieldValues, String propertyNamePrefix) {
        HashMap cachedValues = new HashMap();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        try {
            for (String propertyName : fieldValues.keySet()) {
                if (propertyName.endsWith("{CheckboxPresentOnFormAnnotation}")) {
                    Class type;
                    String checkboxName;
                    String checkboxValue;
                    if (!StringUtils.isNotBlank((String)((String)fieldValues.get(propertyName))) || (checkboxValue = (String)fieldValues.get(checkboxName = StringUtils.removeEnd((String)propertyName, (String)"{CheckboxPresentOnFormAnnotation}"))) != null || !FieldUtils.isPropertyWritable(bo, checkboxName) || (type = ObjectUtils.easyGetPropertyType(bo, checkboxName)) != Boolean.TYPE && type != Boolean.class) continue;
                    ObjectUtils.setObjectProperty(bo, checkboxName, type, "false");
                    continue;
                }
                if (!FieldUtils.isPropertyWritable(bo, propertyName) || fieldValues.get(propertyName) == null) continue;
                Class type = ObjectUtils.easyGetPropertyType(bo, propertyName);
                try {
                    Object fieldValue = fieldValues.get(propertyName);
                    ObjectUtils.setObjectProperty(bo, propertyName, type, fieldValue);
                }
                catch (FormatException e) {
                    cachedValues.put((CallSite)((Object)(propertyNamePrefix + propertyName)), fieldValues.get(propertyName));
                    errorMap.putError(propertyNamePrefix + propertyName, e.getErrorKey(), e.getErrorArgs());
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("unable to populate business object" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return cachedValues;
    }

    public static Field fixFieldForForm(Field field, List keyFieldNames, String namePrefix, String maintenanceAction, boolean readOnly, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        String propertyName = field.getPropertyName();
        if (field.containsBOData()) {
            Object conversionTo;
            Object conversionFrom;
            String[] conversionPair;
            String conversion;
            int l;
            String[] conversions;
            if (!propertyName.startsWith("methodToCall")) {
                if (field.getPropertyPrefix() == null || field.getPropertyPrefix().equals("")) {
                    field.setPropertyName(namePrefix + propertyName);
                } else {
                    field.setPropertyName(field.getPropertyPrefix() + "." + propertyName);
                }
            }
            if (readOnly) {
                field.setReadOnly(true);
            }
            if ("Edit".equals(maintenanceAction)) {
                if (keyFieldNames.contains(propertyName)) {
                    field.setReadOnly(true);
                    field.setKeyField(true);
                } else if (StringUtils.isNotBlank((String)field.getUniversalIdAttributeName()) && keyFieldNames.contains(field.getUniversalIdAttributeName())) {
                    field.setReadOnly(true);
                    field.setKeyField(true);
                }
            }
            FieldUtils.applyAuthorization(field, maintenanceAction, auths, documentStatus, documentInitiatorPrincipalId);
            if (StringUtils.isNotBlank((String)field.getFieldConversions())) {
                String fieldConversions = field.getFieldConversions();
                StringBuilder newFieldConversions = new StringBuilder("");
                conversions = StringUtils.split((String)fieldConversions, (String)",");
                for (l = 0; l < conversions.length; ++l) {
                    conversion = conversions[l];
                    conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
                    conversionFrom = conversionPair[0];
                    conversionTo = conversionPair[1];
                    conversionTo = "document.newMaintainableObject." + (String)conversionTo;
                    newFieldConversions.append((String)conversionFrom).append(":").append((String)conversionTo);
                    if (l >= conversions.length) continue;
                    newFieldConversions.append(",");
                }
                field.setFieldConversions(newFieldConversions.toString());
            }
            if (StringUtils.isNotBlank((String)field.getInquiryParameters())) {
                String inquiryParameters = field.getInquiryParameters();
                StringBuilder newInquiryParameters = new StringBuilder();
                String[] parameters = StringUtils.split((String)inquiryParameters, (String)",");
                for (l = 0; l < parameters.length; ++l) {
                    String parameter = parameters[l];
                    String[] parameterPair = StringUtils.split((String)parameter, (String)":", (int)2);
                    conversionFrom = parameterPair[0];
                    conversionTo = parameterPair[1];
                    newInquiryParameters.append("document.newMaintainableObject.").append((String)conversionFrom);
                    newInquiryParameters.append(":").append((String)conversionTo);
                    if (l >= parameters.length - 1) continue;
                    newInquiryParameters.append(",");
                }
                field.setInquiryParameters(newInquiryParameters.toString());
            }
            if ("kualiuser".equals(field.getFieldType())) {
                int suffixIndex = field.getPropertyName().indexOf(field.getUserIdAttributeName());
                if (suffixIndex != -1) {
                    field.setPersonNameAttributeName(field.getPropertyName().substring(0, suffixIndex) + field.getPersonNameAttributeName());
                    field.setUniversalIdAttributeName(field.getPropertyName().substring(0, suffixIndex) + field.getUniversalIdAttributeName());
                } else {
                    field.setPersonNameAttributeName(namePrefix + field.getPersonNameAttributeName());
                    field.setUniversalIdAttributeName(namePrefix + field.getUniversalIdAttributeName());
                }
            }
            if (StringUtils.isNotBlank((String)field.getLookupParameters())) {
                String lookupParameters = field.getLookupParameters();
                Object newLookupParameters = "";
                conversions = StringUtils.split((String)lookupParameters, (String)",");
                for (int m = 0; m < conversions.length; ++m) {
                    conversion = conversions[m];
                    conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
                    conversionFrom = conversionPair[0];
                    conversionTo = conversionPair[1];
                    conversionFrom = "document.newMaintainableObject." + (String)conversionFrom;
                    newLookupParameters = (String)newLookupParameters + (String)conversionFrom + ":" + (String)conversionTo;
                    if (m >= conversions.length) continue;
                    newLookupParameters = (String)newLookupParameters + ",";
                }
                field.setLookupParameters((String)newLookupParameters);
            }
            if ("container".equals(field.getFieldType())) {
                List<Row> containerRows = field.getContainerRows();
                ArrayList<Row> fixedRows = new ArrayList<Row>();
                for (Row containerRow : containerRows) {
                    List<Field> containerFields = containerRow.getFields();
                    ArrayList<Field> fixedFields = new ArrayList<Field>();
                    for (Field containerField : containerFields) {
                        containerField = FieldUtils.fixFieldForForm(containerField, keyFieldNames, namePrefix, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId);
                        fixedFields.add(containerField);
                    }
                    fixedRows.add(new Row(fixedFields));
                }
                field.setContainerRows(fixedRows);
            }
        }
        return field;
    }

    public static void applyAuthorization(Field field, String maintenanceAction, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        String fieldName = "";
        FieldRestriction fieldAuth = null;
        Person user = GlobalVariables.getUserSession().getPerson();
        if (field.getPropertyName().startsWith("document.newMaintainableObject.")) {
            fieldName = field.getPropertyName().substring("document.newMaintainableObject.".length());
            if (auths.hasRestriction(fieldName)) {
                String displayMaskValue;
                MaskFormatter maskFormatter;
                fieldAuth = auths.getFieldRestriction(fieldName);
                if (!(!"New".equals(maintenanceAction) && !"Copy".equals(maintenanceAction) || ("S".equals(documentStatus) || "I".equals(documentStatus)) && user.getPrincipalId().equals(documentInitiatorPrincipalId))) {
                    if (fieldAuth.isPartiallyMasked()) {
                        field.setSecure(true);
                        fieldAuth.setShouldBeEncrypted(true);
                        maskFormatter = fieldAuth.getMaskFormatter();
                        displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                        field.setDisplayMaskValue(displayMaskValue);
                        FieldUtils.populateSecureField(field, field.getPropertyValue());
                    } else if (fieldAuth.isMasked()) {
                        field.setSecure(true);
                        fieldAuth.setShouldBeEncrypted(true);
                        maskFormatter = fieldAuth.getMaskFormatter();
                        displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                        field.setDisplayMaskValue(displayMaskValue);
                        FieldUtils.populateSecureField(field, field.getPropertyValue());
                    }
                }
                if ("Edit".equals(maintenanceAction) || "newWithExisting".equals(maintenanceAction)) {
                    if (fieldAuth.isPartiallyMasked()) {
                        field.setSecure(true);
                        fieldAuth.setShouldBeEncrypted(true);
                        maskFormatter = fieldAuth.getMaskFormatter();
                        displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                        field.setDisplayMaskValue(displayMaskValue);
                        FieldUtils.populateSecureField(field, field.getPropertyValue());
                    } else if (fieldAuth.isMasked()) {
                        field.setSecure(true);
                        fieldAuth.setShouldBeEncrypted(true);
                        maskFormatter = fieldAuth.getMaskFormatter();
                        displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                        field.setDisplayMaskValue(displayMaskValue);
                        FieldUtils.populateSecureField(field, field.getPropertyValue());
                    }
                }
                if (Field.isInputField(field.getFieldType()) || field.getFieldType().equalsIgnoreCase("checkbox")) {
                    if (fieldAuth.isReadOnly()) {
                        if (!(field.isReadOnly() || fieldAuth.isMasked() || fieldAuth.isPartiallyMasked())) {
                            field.setReadOnly(true);
                        }
                    } else if (fieldAuth.isHidden() && !field.getFieldType().equals("hidden")) {
                        field.setFieldType("hidden");
                    }
                }
                if ("button".equalsIgnoreCase(field.getFieldType()) && fieldAuth.isHidden()) {
                    field.setFieldType("hidden");
                }
                if (field.isReadOnly() && fieldAuth.isHidden()) {
                    field.setFieldType("hidden");
                }
            }
        } else if (field.getPropertyName().startsWith("document.oldMaintainableObject.") && auths.hasRestriction(fieldName = field.getPropertyName().substring("document.oldMaintainableObject.".length()))) {
            String displayMaskValue;
            MaskFormatter maskFormatter;
            fieldAuth = auths.getFieldRestriction(fieldName);
            if (fieldAuth.isPartiallyMasked()) {
                field.setSecure(true);
                maskFormatter = fieldAuth.getMaskFormatter();
                displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                field.setDisplayMaskValue(displayMaskValue);
                field.setPropertyValue(displayMaskValue);
                FieldUtils.populateSecureField(field, field.getPropertyValue());
            }
            if (fieldAuth.isMasked()) {
                field.setSecure(true);
                maskFormatter = fieldAuth.getMaskFormatter();
                displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                field.setDisplayMaskValue(displayMaskValue);
                field.setPropertyValue(displayMaskValue);
                FieldUtils.populateSecureField(field, field.getPropertyValue());
            }
            if (fieldAuth.isHidden()) {
                field.setFieldType("hidden");
            }
        }
    }

    public static List meshSections(List oldSections, List newSections, List keyFieldNames, String maintenanceAction, boolean readOnly, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        ArrayList<Section> meshedSections = new ArrayList<Section>();
        for (int i = 0; i < newSections.size(); ++i) {
            Section maintSection = (Section)newSections.get(i);
            List<Row> sectionRows = maintSection.getRows();
            Section oldMaintSection = (Section)oldSections.get(i);
            List<Row> oldSectionRows = oldMaintSection.getRows();
            List meshedRows = FieldUtils.meshRows(oldSectionRows, sectionRows, keyFieldNames, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId);
            maintSection.setRows(meshedRows);
            if (StringUtils.isBlank((String)maintSection.getErrorKey())) {
                maintSection.setErrorKey(MaintenanceUtils.generateErrorKeyForSection(maintSection));
            }
            meshedSections.add(maintSection);
        }
        return meshedSections;
    }

    public static List meshRows(List oldRows, List newRows, List keyFieldNames, String maintenanceAction, boolean readOnly, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        ArrayList<Row> meshedRows = new ArrayList<Row>();
        for (int j = 0; j < newRows.size(); ++j) {
            List meshedFields;
            Row sectionRow = (Row)newRows.get(j);
            List<Field> rowFields = sectionRow.getFields();
            List<Object> oldRowFields = new ArrayList();
            if (null != oldRows && oldRows.size() > j) {
                Row oldSectionRow = (Row)oldRows.get(j);
                oldRowFields = oldSectionRow.getFields();
            }
            if ((meshedFields = FieldUtils.meshFields(oldRowFields, rowFields, keyFieldNames, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId)).size() <= 0) continue;
            Row meshedRow = new Row(meshedFields);
            if (sectionRow.isHidden()) {
                meshedRow.setHidden(true);
            }
            meshedRows.add(meshedRow);
        }
        return meshedRows;
    }

    public static List meshFields(List oldFields, List newFields, List keyFieldNames, String maintenanceAction, boolean readOnly, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        ArrayList<Field> meshedFields = new ArrayList<Field>();
        ArrayList<Field> newFieldsToMerge = new ArrayList<Field>();
        ArrayList<Field> oldFieldsToMerge = new ArrayList<Field>();
        for (int k = 0; k < newFields.size(); ++k) {
            Field oldMaintField;
            Field newMaintField = (Field)newFields.get(k);
            newMaintField.getPropertyName();
            if ("imagesubmit".equals(newMaintField.getFieldType())) {
                meshedFields.add(newMaintField);
                continue;
            }
            if ("container".equals(newMaintField.getFieldType())) {
                if (oldFields.size() > k) {
                    oldMaintField = (Field)oldFields.get(k);
                    newMaintField = FieldUtils.meshContainerFields(oldMaintField, newMaintField, keyFieldNames, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId);
                } else {
                    newMaintField = FieldUtils.meshContainerFields(newMaintField, newMaintField, keyFieldNames, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId);
                }
                meshedFields.add(newMaintField);
                continue;
            }
            newMaintField = FieldUtils.fixFieldForForm(newMaintField, keyFieldNames, "document.newMaintainableObject.", maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId);
            if ("Edit".equals(maintenanceAction) || "Copy".equals(maintenanceAction)) {
                oldMaintField = (Field)oldFields.get(k);
                if (!StringUtils.equalsIgnoreCase((String)newMaintField.getPropertyValue(), (String)oldMaintField.getPropertyValue()) && !"hidden".equals(newMaintField.getFieldType())) {
                    newMaintField.setHighlightField(true);
                }
                oldMaintField = FieldUtils.fixFieldForForm(oldMaintField, keyFieldNames, "document.oldMaintainableObject.", maintenanceAction, true, auths, documentStatus, documentInitiatorPrincipalId);
                oldFieldsToMerge.add(oldMaintField);
            }
            newFieldsToMerge.add(newMaintField);
            meshedFields.addAll(oldFieldsToMerge);
            meshedFields.addAll(newFieldsToMerge);
        }
        return meshedFields;
    }

    protected static boolean isLookupFieldLevelHelpEnabled(Class businessObjectClass, String attributeName) {
        return false;
    }

    protected static boolean isLookupFieldLevelHelpDisabled(Class businessObjectClass, String attributeName) {
        return false;
    }

    public static List<Field> createAndPopulateFieldsForLookup(List<String> lookupFieldAttributeList, List<String> readOnlyFieldsList, Class businessObjectClass) throws InstantiationException, IllegalAccessException {
        ArrayList<Field> fields = new ArrayList<Field>();
        BusinessObjectEntry boe = (BusinessObjectEntry)FieldUtils.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName());
        HashMap<String, Boolean> isHiddenMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> isReadOnlyMap = new HashMap<String, Boolean>();
        if (boe.hasLookupDefinition()) {
            List<FieldDefinition> fieldDefs = boe.getLookupDefinition().getLookupFields();
            for (FieldDefinition fieldDefinition : fieldDefs) {
                isReadOnlyMap.put(fieldDefinition.getAttributeName(), fieldDefinition.isReadOnly());
                isHiddenMap.put(fieldDefinition.getAttributeName(), fieldDefinition.isHidden());
            }
        }
        for (String attributeName : lookupFieldAttributeList) {
            Class defaultValueFinderClass;
            String defaultValue;
            BusinessObject newBusinessObjectInstance;
            Field field = FieldUtils.getPropertyField(businessObjectClass, attributeName, true);
            if (field.isDatePicker() && field.isRanged()) {
                Field newDate = FieldUtils.createRangeDateField(field);
                fields.add(newDate);
            }
            if (ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface((Class)businessObjectClass)) {
                ModuleService moduleService = FieldUtils.getKualiModuleService().getResponsibleModuleService(businessObjectClass);
                newBusinessObjectInstance = moduleService.createNewObjectFromExternalizableClass(businessObjectClass);
            } else {
                newBusinessObjectInstance = (BusinessObject)businessObjectClass.newInstance();
            }
            Field field3 = LookupUtils.setFieldQuickfinder(newBusinessObjectInstance, attributeName, field, lookupFieldAttributeList);
            field3 = LookupUtils.setFieldDirectInquiry(newBusinessObjectInstance, attributeName, field3);
            if (!"multiselect".equals(field3.getFieldType())) {
                field3.setMaxLength(100);
            }
            if (attributeName.equals("active") && MutableInactivatable.class.isAssignableFrom(businessObjectClass)) {
                field3.setPropertyValue("Y");
                field3.setDefaultValue("Y");
            }
            if ((defaultValue = FieldUtils.getBusinessObjectMetaDataService().getLookupFieldDefaultValue(businessObjectClass, attributeName)) != null) {
                field3.setPropertyValue(defaultValue);
                field3.setDefaultValue(defaultValue);
            }
            if ((defaultValueFinderClass = FieldUtils.getBusinessObjectMetaDataService().getLookupFieldDefaultValueFinderClass(businessObjectClass, attributeName)) != null) {
                field3.setPropertyValue(((ValueFinder)defaultValueFinderClass.newInstance()).getValue());
                field3.setDefaultValue(((ValueFinder)defaultValueFinderClass.newInstance()).getValue());
            }
            if (readOnlyFieldsList != null && readOnlyFieldsList.contains(field3.getPropertyName()) || isReadOnlyMap.containsKey(field3.getPropertyName()) && ((Boolean)isReadOnlyMap.get(field3.getPropertyName())).booleanValue()) {
                field3.setReadOnly(true);
            }
            FieldUtils.populateQuickfinderDefaultsForLookup(businessObjectClass, attributeName, field3);
            if (isHiddenMap.containsKey(field3.getPropertyName()) && ((Boolean)isHiddenMap.get(field3.getPropertyName())).booleanValue()) {
                field3.setFieldType("hidden");
            }
            boolean triggerOnChange = FieldUtils.getBusinessObjectDictionaryService().isLookupFieldTriggerOnChange(businessObjectClass, attributeName);
            field3.setTriggerOnChange(triggerOnChange);
            field3.setFieldLevelHelpEnabled(FieldUtils.isLookupFieldLevelHelpEnabled(businessObjectClass, attributeName));
            field3.setFieldLevelHelpDisabled(FieldUtils.isLookupFieldLevelHelpDisabled(businessObjectClass, attributeName));
            fields.add(field3);
        }
        return fields;
    }

    private static void populateQuickfinderDefaultsForLookup(Class businessObjectClass, String attributeName, Field field) throws InstantiationException, IllegalAccessException {
        String[] params;
        String quickfinderParamString = FieldUtils.getBusinessObjectMetaDataService().getLookupFieldQuickfinderParameterString(businessObjectClass, attributeName);
        Class<? extends ValueFinder> quickfinderParameterFinderClass = FieldUtils.getBusinessObjectMetaDataService().getLookupFieldQuickfinderParameterStringBuilderClass(businessObjectClass, attributeName);
        if (quickfinderParameterFinderClass != null) {
            quickfinderParamString = quickfinderParameterFinderClass.newInstance().getValue();
        }
        if (!StringUtils.isEmpty((String)quickfinderParamString) && (params = quickfinderParamString.split(",")) != null) {
            for (String param : params) {
                if (!param.contains("=")) continue;
                String[] paramChunks = param.split("=", 2);
                field.appendLookupParameters("literal=" + paramChunks[1] + ":" + paramChunks[0]);
            }
        }
    }

    public static Field createRangeDateField(Field field) {
        Field newDate = (Field)SerializationUtils.deepCopy((Serializable)field);
        newDate.setFieldLabel(newDate.getFieldLabel() + " From");
        field.setFieldLabel(field.getFieldLabel() + " To");
        newDate.setPropertyName("rangeLowerBoundKeyPrefix_" + newDate.getPropertyName());
        return newDate;
    }

    private static Field meshContainerFields(Field oldMaintField, Field newMaintField, List keyFieldNames, String maintenanceAction, boolean readOnly, MaintenanceDocumentRestrictions auths, String documentStatus, String documentInitiatorPrincipalId) {
        ArrayList<Row> resultingRows = new ArrayList<Row>();
        resultingRows.addAll(FieldUtils.meshRows(oldMaintField.getContainerRows(), newMaintField.getContainerRows(), keyFieldNames, maintenanceAction, readOnly, auths, documentStatus, documentInitiatorPrincipalId));
        Field resultingField = newMaintField;
        resultingField.setFieldType("container");
        resultingField.setContainerElementName(newMaintField.getContainerElementName());
        resultingField.setContainerDisplayFields(newMaintField.getContainerDisplayFields());
        resultingField.setNumberOfColumnsForCollection(newMaintField.getNumberOfColumnsForCollection());
        resultingField.setContainerRows(resultingRows);
        List<Row> resultingRowsList = newMaintField.getContainerRows();
        if (resultingRowsList.size() > 0) {
            List<Field> resultingFieldsList = resultingRowsList.get(0).getFields();
            if (resultingFieldsList.size() > 0) {
                String containedFieldName = resultingFieldsList.get(0).getPropertyName();
                resultingField.setPropertyName(containedFieldName.substring(0, containedFieldName.lastIndexOf(46)));
            }
        } else {
            resultingField.setPropertyName(oldMaintField.getPropertyName());
        }
        return resultingField;
    }

    public static void modifyFieldToSupportMultipleValueLookups(Field field, String parents, MaintainableCollectionDefinition definition) {
        field.setMultipleValueLookedUpCollectionName(parents + definition.getName());
        field.setMultipleValueLookupClassName(definition.getSourceClassName().getName());
        field.setMultipleValueLookupClassLabel(FieldUtils.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(definition.getSourceClassName().getName()).getObjectLabel());
    }

    public static boolean isCollectionMultipleLookupEnabled(MaintainableCollectionDefinition definition) {
        return definition.getSourceClassName() != null && definition.isIncludeMultipleLookupLine();
    }

    public static String scrubWhitespace(String s) {
        return s.replaceAll("(\\s)(\\s+)", " ");
    }

    public static List<Row> convertRemotableAttributeFields(List<RemotableAttributeField> remotableAttributeFields) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (RemotableAttributeField remotableAttributeField : remotableAttributeFields) {
            List<Field> fields = FieldUtils.convertRemotableAttributeField(remotableAttributeField);
            for (Field field : fields) {
                Row row = new Row(field);
                rows.add(row);
            }
        }
        return rows;
    }

    public static List<Field> convertRemotableAttributeField(RemotableAttributeField remotableAttributeField) {
        List<Field> fields = FieldUtils.constructFieldsForAttributeDefinition(remotableAttributeField);
        for (Field field : fields) {
            FieldUtils.applyControlAttributes(remotableAttributeField, field);
            FieldUtils.applyLookupAttributes(remotableAttributeField, field);
            FieldUtils.applyWidgetAttributes(remotableAttributeField, field);
        }
        return fields;
    }

    private static List<Field> constructFieldsForAttributeDefinition(RemotableAttributeField remotableAttributeField) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (remotableAttributeField.getAttributeLookupSettings() != null && remotableAttributeField.getAttributeLookupSettings().isRanged()) {
            AttributeLookupSettings lookupSettings = remotableAttributeField.getAttributeLookupSettings();
            String attrLabel = StringUtils.isBlank((String)remotableAttributeField.getLongLabel()) ? remotableAttributeField.getShortLabel() : remotableAttributeField.getLongLabel();
            String label = StringUtils.defaultString((String)lookupSettings.getLowerLabel(), (String)(attrLabel + " From"));
            Field lowerField = new Field("rangeLowerBoundKeyPrefix_" + remotableAttributeField.getName(), label);
            lowerField.setMemberOfRange(true);
            lowerField.setAllowInlineRange(false);
            lowerField.setRangeFieldInclusive(lookupSettings.isLowerBoundInclusive());
            if (lookupSettings.isLowerDatePicker() != null) {
                lowerField.setDatePicker(lookupSettings.isLowerDatePicker());
            }
            if (!remotableAttributeField.getDataType().equals((Object)DataType.CURRENCY)) {
                lowerField.setFieldDataType(remotableAttributeField.getDataType().name().toLowerCase());
            }
            fields.add(lowerField);
            label = StringUtils.defaultString((String)lookupSettings.getUpperLabel(), (String)(attrLabel + " To"));
            Field upperField = new Field(remotableAttributeField.getName(), label);
            upperField.setMemberOfRange(true);
            upperField.setAllowInlineRange(false);
            upperField.setRangeFieldInclusive(lookupSettings.isUpperBoundInclusive());
            if (lookupSettings.isUpperDatePicker() != null) {
                upperField.setDatePicker(lookupSettings.isUpperDatePicker());
            }
            if (!remotableAttributeField.getDataType().equals((Object)DataType.CURRENCY)) {
                upperField.setFieldDataType(remotableAttributeField.getDataType().name().toLowerCase());
            }
            fields.add(upperField);
        } else {
            Field tempField = new Field(remotableAttributeField.getName(), remotableAttributeField.getLongLabel());
            if (remotableAttributeField.getMaxLength() != null) {
                tempField.setMaxLength(remotableAttributeField.getMaxLength());
            }
            if (remotableAttributeField.getShortLabel() != null) {
                tempField.setFieldLabel(remotableAttributeField.getShortLabel());
            }
            if (!remotableAttributeField.getDataType().equals((Object)DataType.CURRENCY)) {
                tempField.setFieldDataType(remotableAttributeField.getDataType().name().toLowerCase());
            } else {
                tempField.setFieldDataType("float");
            }
            tempField.setMainFieldLabel(remotableAttributeField.getLongLabel());
            tempField.setFieldHelpSummary(remotableAttributeField.getHelpSummary());
            tempField.setUpperCase(remotableAttributeField.isForceUpperCase());
            if (remotableAttributeField.getMaxLength() != null) {
                if (remotableAttributeField.getMaxLength() > 0) {
                    tempField.setMaxLength(remotableAttributeField.getMaxLength());
                } else {
                    tempField.setMaxLength(100);
                }
            }
            tempField.setFieldRequired(remotableAttributeField.isRequired());
            fields.add(tempField);
        }
        return fields;
    }

    public static List<RemotableAttributeField> convertRowsToAttributeFields(List<Row> rows) {
        ArrayList<RemotableAttributeField> attributeFields = new ArrayList<RemotableAttributeField>();
        for (Row row : rows) {
            attributeFields.addAll(FieldUtils.convertRowToAttributeFields(row));
        }
        return attributeFields;
    }

    public static List<RemotableAttributeField> convertRowToAttributeFields(Row row) {
        ArrayList<RemotableAttributeField> attributeFields = new ArrayList<RemotableAttributeField>();
        for (Field field : row.getFields()) {
            RemotableAttributeField remotableAttributeField = FieldUtils.convertFieldToAttributeField(field);
            if (remotableAttributeField == null) continue;
            attributeFields.add(remotableAttributeField);
        }
        return attributeFields;
    }

    public static RemotableAttributeField convertFieldToAttributeField(Field field) {
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)field.getPropertyName());
        ArrayList<Object> widgets = new ArrayList<Object>();
        builder.setDataType(DataType.valueOf((String)field.getFieldDataType().toUpperCase()));
        builder.setShortLabel(field.getFieldLabel());
        builder.setLongLabel(field.getMainFieldLabel());
        builder.setHelpSummary(field.getFieldHelpSummary());
        builder.setForceUpperCase(field.isUpperCase());
        if (field.getMaxLength() > 0) {
            builder.setMaxLength(Integer.valueOf(field.getMaxLength()));
        } else {
            builder.setMaxLength(Integer.valueOf(100));
        }
        builder.setRequired(field.isFieldRequired());
        builder.setDefaultValues(Collections.singletonList(field.getDefaultValue()));
        builder.setControl(FieldUtils.constructControl(field, field.getFieldValidValues()));
        if (field.getHasLookupable()) {
            builder.setAttributeLookupSettings(RemotableAttributeLookupSettings.Builder.create());
            RemotableQuickFinder.Builder quickfinder = RemotableQuickFinder.Builder.create((String)field.getBaseLookupUrl(), (String)field.getQuickFinderClassNameImpl());
            quickfinder.setFieldConversions(FieldUtils.toMap(field.getFieldConversions()));
            quickfinder.setLookupParameters(FieldUtils.toMap(field.getLookupParameters()));
            widgets.add(quickfinder);
        }
        RemotableAttributeLookupSettings.Builder lookupSettings = null;
        if ((builder.getDataType().equals((Object)DataType.DATETIME) || builder.getDataType().equals((Object)DataType.DATE)) && field.isRanged()) {
            lookupSettings = RemotableAttributeLookupSettings.Builder.create();
            lookupSettings.setRanged(field.isRanged());
            if (field.isDatePicker()) {
                lookupSettings.setLowerDatePicker(Boolean.TRUE);
                lookupSettings.setUpperDatePicker(Boolean.TRUE);
            }
            if (ObjectUtils.isNull(field.getRangeFieldInclusive())) {
                lookupSettings.setUpperBoundInclusive(true);
                lookupSettings.setLowerBoundInclusive(true);
            }
        }
        if (!field.isColumnVisible()) {
            if (ObjectUtils.isNull(lookupSettings)) {
                lookupSettings = RemotableAttributeLookupSettings.Builder.create();
            }
            lookupSettings.setInResults(field.isColumnVisible());
        }
        if (ObjectUtils.isNotNull(lookupSettings)) {
            builder.setAttributeLookupSettings(lookupSettings);
        }
        if (field.getFieldType().equals("currency")) {
            builder.setDataType(DataType.CURRENCY);
            builder.setMaxLength(Integer.valueOf(field.getFormattedMaxLength()));
        }
        if (field.isDatePicker()) {
            widgets.add(RemotableDatepicker.Builder.create());
        }
        if (field.isExpandedTextArea()) {
            widgets.add(RemotableTextExpand.Builder.create());
        }
        builder.setWidgets(widgets);
        return builder.build();
    }

    private static RemotableAbstractControl.Builder constructControl(Field field, List<KeyValue> options) {
        RemotableTextInput.Builder control;
        String type;
        LinkedHashMap<String, String> optionMap = new LinkedHashMap<String, String>();
        if (options != null) {
            for (KeyValue option : options) {
                optionMap.put(option.getKey(), option.getValue());
            }
        }
        if ("text".equals(type = field.getFieldType()) || "datePicker".equals(type)) {
            control = RemotableTextInput.Builder.create();
            control.setSize(Integer.valueOf(field.getSize()));
            return control;
        }
        if ("textarea".equals(type)) {
            control = RemotableTextarea.Builder.create();
            control.setCols(Integer.valueOf(field.getCols()));
            control.setRows(Integer.valueOf(field.getRows()));
            return control;
        }
        if ("dropdown".equals(type)) {
            return RemotableSelect.Builder.create(optionMap);
        }
        if ("dropdown_refresh".equals(type)) {
            control = RemotableSelect.Builder.create(optionMap);
            control.setRefreshOnChange(true);
            return control;
        }
        if ("checkbox".equals(type)) {
            return RemotableCheckbox.Builder.create();
        }
        if ("radio".equals(type)) {
            return RemotableRadioButtonGroup.Builder.create(optionMap);
        }
        if ("hidden".equals(type)) {
            return RemotableHiddenInput.Builder.create();
        }
        if ("multibox".equals(type)) {
            control = RemotableSelect.Builder.create(optionMap);
            control.setMultiple(true);
            return control;
        }
        if ("multiselect".equals(type)) {
            control = RemotableSelect.Builder.create(optionMap);
            control.setMultiple(true);
            return control;
        }
        if ("currency".equals(type)) {
            control = RemotableTextInput.Builder.create();
            control.setSize(Integer.valueOf(field.getSize()));
            return control;
        }
        throw new IllegalArgumentException("Illegal field type found: " + type);
    }

    private static void applyControlAttributes(RemotableAttributeField remotableField, Field field) {
        String fieldType;
        RemotableControlContract control = remotableField.getControl();
        if (control == null) {
            throw new IllegalStateException("Given attribute field with the following name has a null control: " + remotableField.getName());
        }
        if (control == null || control instanceof RemotableTextInput) {
            fieldType = "text";
            if (((RemotableTextInput)remotableField.getControl()).getSize() != null) {
                field.setSize(((RemotableTextInput)remotableField.getControl()).getSize());
            }
            if (((RemotableTextInput)remotableField.getControl()).getSize() != null) {
                field.setFormattedMaxLength(((RemotableTextInput)remotableField.getControl()).getSize());
            }
        } else if (control instanceof RemotableCheckboxGroup) {
            RemotableCheckboxGroup checkbox = (RemotableCheckboxGroup)control;
            fieldType = "checkbox";
            field.setFieldValidValues(FieldUtils.convertMapToKeyValueList(checkbox.getKeyLabels()));
        } else if (control instanceof RemotableCheckbox) {
            fieldType = "checkbox";
        } else if (control instanceof RemotableHiddenInput) {
            fieldType = "hidden";
        } else {
            if (control instanceof RemotablePasswordInput) {
                throw new IllegalStateException("Password control not currently supported.");
            }
            if (control instanceof RemotableRadioButtonGroup) {
                fieldType = "radio";
                RemotableRadioButtonGroup radioControl = (RemotableRadioButtonGroup)control;
                field.setFieldValidValues(FieldUtils.convertMapToKeyValueList(radioControl.getKeyLabels()));
            } else if (control instanceof RemotableSelect) {
                RemotableSelect selectControl = (RemotableSelect)control;
                field.setFieldValidValues(FieldUtils.convertMapToKeyValueList(selectControl.getKeyLabels()));
                fieldType = selectControl.isMultiple() ? "multiselect" : (selectControl.isRefreshOnChange() ? "dropdown_refresh" : "dropdown");
            } else if (control instanceof RemotableTextarea) {
                fieldType = "textarea";
                if (((RemotableTextarea)remotableField.getControl()).getCols() != null && ((RemotableTextarea)remotableField.getControl()).getRows() != null) {
                    field.setCols(((RemotableTextarea)remotableField.getControl()).getCols());
                    field.setSize(((RemotableTextarea)remotableField.getControl()).getRows());
                }
            } else {
                throw new IllegalArgumentException("Given control type is not supported: " + control.getClass());
            }
        }
        if (!remotableField.getDefaultValues().isEmpty()) {
            field.setDefaultValue((String)remotableField.getDefaultValues().iterator().next());
            field.setPropertyValues(remotableField.getDefaultValues().toArray(new String[0]));
            field.setPropertyValue(field.getDefaultValue());
        }
        field.setFieldType(fieldType);
    }

    private static List<KeyValue> convertMapToKeyValueList(Map<String, String> values) {
        ArrayList<KeyValue> validValues = new ArrayList<KeyValue>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            validValues.add((KeyValue)new ConcreteKeyValue(entry.getKey(), entry.getValue()));
        }
        return validValues;
    }

    private static void applyLookupAttributes(RemotableAttributeField remotableField, Field field) {
        AttributeLookupSettings lookupSettings = remotableField.getAttributeLookupSettings();
        if (lookupSettings != null) {
            field.setColumnVisible(lookupSettings.isInResults());
            if (!lookupSettings.isInCriteria()) {
                field.setFieldType("hidden");
            }
            field.setRanged(lookupSettings.isRanged());
            boolean datePickerLow = lookupSettings.isLowerDatePicker() != null && lookupSettings.isLowerDatePicker() != false;
            boolean datePickerUpper = lookupSettings.isUpperDatePicker() != null && lookupSettings.isUpperDatePicker() != false;
            field.setDatePicker(datePickerLow || datePickerUpper);
        }
    }

    private static void applyWidgetAttributes(RemotableAttributeField remotableField, Field field) {
        Collection widgets = remotableField.getWidgets();
        for (RemotableAbstractWidget widget : widgets) {
            if (widget instanceof RemotableQuickFinder) {
                field.setQuickFinderClassNameImpl(((RemotableQuickFinder)widget).getDataObjectClass());
                field.setBaseLookupUrl(((RemotableQuickFinder)widget).getBaseLookupUrl());
                field.setLookupParameters(((RemotableQuickFinder)widget).getLookupParameters());
                field.setFieldConversions(((RemotableQuickFinder)widget).getFieldConversions());
                continue;
            }
            if (!(widget instanceof RemotableTextExpand)) continue;
            field.setExpandedTextArea(true);
        }
    }

    public static Column constructColumnFromAttributeField(RemotableAttributeField attributeField) {
        if (attributeField == null) {
            throw new IllegalArgumentException("attributeField was null");
        }
        DataType dataType = DataType.STRING;
        if (attributeField.getDataType() != null) {
            dataType = attributeField.getDataType();
        }
        Column column = new Column();
        String columnTitle = StringUtils.isBlank((String)attributeField.getShortLabel()) ? (StringUtils.isBlank((String)attributeField.getLongLabel()) ? attributeField.getName() : attributeField.getLongLabel()) : attributeField.getShortLabel();
        column.setColumnTitle(columnTitle);
        column.setSortable(Boolean.TRUE.toString());
        if (attributeField.getMaxLength() != null) {
            column.setMaxLength(attributeField.getMaxLength());
        }
        column.setPropertyName(attributeField.getName());
        if (attributeField.getDataType() == DataType.MARKUP) {
            column.setEscapeXMLValue(false);
            column.setColumnAnchor(new HtmlData.AnchorHtmlData());
        } else {
            column.setEscapeXMLValue(true);
        }
        column.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(dataType.getType()));
        column.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(dataType.getType()));
        if (StringUtils.isNotEmpty((String)attributeField.getFormatterName())) {
            try {
                column.setFormatter(Formatter.getFormatter(Class.forName(attributeField.getFormatterName())));
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to find formatter class: " + attributeField.getFormatterName(), (Throwable)e);
                column.setFormatter(FieldUtils.getFormatterForDataType(dataType));
            }
        } else {
            column.setFormatter(FieldUtils.getFormatterForDataType(dataType));
        }
        return column;
    }

    public static List<Column> constructColumnsFromAttributeFields(List<RemotableAttributeField> attributeFields) {
        ArrayList<Column> attributeColumns = new ArrayList<Column>();
        if (attributeFields != null) {
            for (RemotableAttributeField attributeField : attributeFields) {
                attributeColumns.add(FieldUtils.constructColumnFromAttributeField(attributeField));
            }
        }
        return attributeColumns;
    }

    public static Formatter getFormatterForDataType(DataType dataType) {
        return Formatter.getFormatter((Class)dataType.getType());
    }

    public static String generateCollectionSubTabName(Field field) {
        String containerName = field.getContainerElementName();
        String cleanedContainerName = containerName == null ? "" : containerName.replaceAll("\\d+", "");
        StringBuilder subTabName = new StringBuilder(cleanedContainerName);
        if (field.getContainerDisplayFields() != null) {
            for (Field containerField : field.getContainerDisplayFields()) {
                subTabName.append(containerField.getPropertyValue());
            }
        }
        return subTabName.toString();
    }

    private static Map<String, String> toMap(String s) {
        if (StringUtils.isBlank((String)s)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : s.split(",")) {
            String[] keyVal = string.split(":");
            map.put(keyVal[0], keyVal[1]);
        }
        return Collections.unmodifiableMap(map);
    }

    private static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    private static BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (businessObjectMetaDataService == null) {
            businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return businessObjectMetaDataService;
    }

    private static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (businessObjectDictionaryService == null) {
            businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return businessObjectDictionaryService;
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }
}

