/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.form;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class KualiMaintenanceForm
extends KualiDocumentFormBase {
    protected static final Logger LOG = LogManager.getLogger(KualiMaintenanceForm.class);
    protected static final long serialVersionUID = 1L;
    protected String businessObjectClassName;
    protected String description;
    protected boolean readOnly;
    protected Map<String, String> oldMaintainableValues;
    protected Map<String, String> newMaintainableValues;
    protected String maintenanceAction;
    private static final Pattern ELEMENT_IN_COLLECTION = Pattern.compile("(.*)(\\[)([0-9]*)(\\])(.*)");
    protected String lookupResultsSequenceNumber;
    protected String lookupResultsBOClassName;
    protected String lookedUpCollectionName;
    protected MaintenanceDocumentRestrictions authorizations;

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        this.registerRequiredNonEditableProperty("businessObjectClassName");
        this.registerRequiredNonEditableProperty("lookupResultsBOClassName");
        this.registerRequiredNonEditableProperty("lookedUpCollectionName");
        this.registerRequiredNonEditableProperty("lookupResultsSequenceNumber");
        this.registerRequiredNonEditableProperty("fieldNameToFocusOnAfterSubmit");
    }

    @Override
    public void postprocessRequestParameters(Map requestParameters) {
        super.postprocessRequestParameters(requestParameters);
        String docTypeName = null;
        String[] docTypeNames = (String[])requestParameters.get("docTypeName");
        if (docTypeNames != null && docTypeNames.length > 0) {
            docTypeName = docTypeNames[0];
        }
        if (StringUtils.isNotBlank(docTypeName) && this.getDocument() == null) {
            Document document;
            this.setDocTypeName(docTypeName);
            Class documentClass = KRADServiceLocatorWeb.getDataDictionaryService().getDocumentClassByTypeName(docTypeName);
            if (documentClass == null) {
                throw new UnknownDocumentTypeException("unable to get class for unknown documentTypeName '" + docTypeName + "'");
            }
            if (!MaintenanceDocumentBase.class.isAssignableFrom(documentClass)) {
                throw new ConfigurationException("Document class '" + documentClass + "' is not assignable to '" + MaintenanceDocumentBase.class + "'");
            }
            try {
                Class[] defaultConstructor = new Class[]{String.class};
                Constructor cons = documentClass.getConstructor(defaultConstructor);
                if (ObjectUtils.isNull(cons)) {
                    throw new ConfigurationException("Could not find constructor with document type name parameter needed for Maintenance Document Base class");
                }
                document = (Document)cons.newInstance(docTypeName);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error instantiating Maintenance Document", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Error instantiating Maintenance Document: No constructor with String parameter found", e);
            }
            this.setDocument(document);
        }
        MaintenanceDocumentBase maintenanceDocument = (MaintenanceDocumentBase)this.getDocument();
        for (Map.Entry obj : requestParameters.entrySet()) {
            String parameter = (String)obj.getKey();
            if (!parameter.toUpperCase().startsWith("document.newMaintainableObject.".toUpperCase())) continue;
            String propertyName = parameter.substring("document.newMaintainableObject.".length());
            Object propertyValue = requestParameters.get(parameter);
            if (!(propertyValue instanceof FormFile) || !StringUtils.isNotBlank((String)((FormFile)propertyValue).getFileName())) continue;
            this.populateAttachmentFile(maintenanceDocument, propertyName, (FormFile)propertyValue);
            if (propertyName.startsWith("add.")) {
                String parsedPropertyName = propertyName.substring("add.".length());
                String collectionName = this.parseAddCollectionName(this.parseAddCollectionName(parsedPropertyName));
                maintenanceDocument.setAttachmentCollectionName(collectionName);
                maintenanceDocument.setAttachmentListPropertyName(propertyName.substring("add.".length()).substring(collectionName.length() + 1));
                continue;
            }
            Matcher matcher = ELEMENT_IN_COLLECTION.matcher(propertyName);
            if (matcher.matches()) continue;
            maintenanceDocument.setAttachmentPropertyName(propertyName);
        }
    }

    private void populateAttachmentFile(MaintenanceDocumentBase maintenanceDocument, String propertyName, FormFile propertyValue) {
        if (StringUtils.isNotEmpty((String)propertyValue.getFileName())) {
            Matcher matcher = ELEMENT_IN_COLLECTION.matcher(propertyName);
            if (propertyName.startsWith("add.")) {
                String prefix = matcher.matches() ? "" : "add.";
                String collectionName = this.parseAddCollectionName(propertyName.substring(prefix.length()));
                PersistableBusinessObject boClass = maintenanceDocument.getNewMaintainableObject().getNewCollectionLine(collectionName);
                String boPropertyName = propertyName.substring(prefix.length()).substring(collectionName.length() + 1);
                this.setAttachmentProperty(boClass, boPropertyName, propertyValue);
            } else {
                PersistableBusinessObject boClass = maintenanceDocument.getNewMaintainableObject().getBusinessObject();
                String boPropertyName = propertyName;
                if (StringUtils.isNotEmpty((String)propertyValue.getFileName()) && !matcher.matches()) {
                    maintenanceDocument.setFileAttachment(propertyValue);
                }
                this.setAttachmentProperty(boClass, boPropertyName, propertyValue);
            }
        }
    }

    private void setAttachmentProperty(Object boClass, String propertyName, Object propertyValue) {
        try {
            PropertyUtils.setProperty((Object)boClass, (String)propertyName, (Object)propertyValue);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("no setter for property '" + boClass.getClass().getName() + "." + propertyName + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("problem accessing property '" + boClass.getClass().getName() + "." + propertyName + "'", e);
        }
    }

    @Override
    public void populate(HttpServletRequest request) {
        super.populate(request);
        if (StringUtils.isNotBlank((String)this.getDocTypeName())) {
            HashMap<String, String> localOldMaintainableValues = new HashMap<String, String>();
            HashMap<String, String> localNewMaintainableValues = new HashMap<String, String>();
            HashMap<String, String> localNewCollectionValues = new HashMap<String, String>();
            Enumeration i = request.getParameterNames();
            while (i.hasMoreElements()) {
                String propertyName;
                String string = (String)i.nextElement();
                if (string.toUpperCase().startsWith("document.oldMaintainableObject.".toUpperCase()) && this.shouldPropertyBePopulatedInForm(string, request)) {
                    propertyName = string.substring("document.oldMaintainableObject.".length());
                    localOldMaintainableValues.put(propertyName, request.getParameter(string));
                }
                if (!string.toUpperCase().startsWith("document.newMaintainableObject.".toUpperCase()) || !this.shouldPropertyBePopulatedInForm(string, request)) continue;
                propertyName = string.substring("document.newMaintainableObject.".length());
                localNewMaintainableValues.put(propertyName, request.getParameter(string));
            }
            for (Map.Entry entry : localNewMaintainableValues.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("add.")) continue;
                localNewCollectionValues.put(key.substring("add.".length()), (String)entry.getValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("checked for add line parameters - got: " + localNewCollectionValues);
            }
            this.newMaintainableValues = localNewMaintainableValues;
            this.oldMaintainableValues = localOldMaintainableValues;
            MaintenanceDocumentBase maintenanceDocument = (MaintenanceDocumentBase)this.getDocument();
            GlobalVariables.getMessageMap().addToErrorPath("document.oldMaintainableObject");
            maintenanceDocument.getOldMaintainableObject().populateBusinessObject(localOldMaintainableValues, maintenanceDocument, this.getMethodToCall());
            GlobalVariables.getMessageMap().removeFromErrorPath("document.oldMaintainableObject");
            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
            Map map = maintenanceDocument.getNewMaintainableObject().populateBusinessObject(localNewMaintainableValues, maintenanceDocument, this.getMethodToCall());
            if (maintenanceDocument.getFileAttachment() != null) {
                this.populateAttachmentPropertyForBO(maintenanceDocument);
            }
            localNewCollectionValues = KimApiServiceLocator.getPersonService().resolvePrincipalNamesToPrincipalIds((BusinessObject)maintenanceDocument.getNewMaintainableObject().getBusinessObject(), localNewCollectionValues);
            map.putAll(maintenanceDocument.getNewMaintainableObject().populateNewCollectionLines(localNewCollectionValues, maintenanceDocument, this.getMethodToCall()));
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
            if (map.size() > 0) {
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.formattingError", new String[0]);
                for (Object o : map.keySet()) {
                    String propertyName = (String)o;
                    String value = (String)map.get(propertyName);
                    this.cacheUnconvertedValue("document.newMaintainableObject." + propertyName, value);
                }
            }
        }
    }

    protected void populateAttachmentPropertyForBO(MaintenanceDocumentBase maintenanceDocument) {
        try {
            Object dataObject = maintenanceDocument.getNewMaintainableObject().getDataObject();
            if (dataObject instanceof PersistableAttachment && maintenanceDocument.isAttachmentPropertyNameRootLevel()) {
                Class type = ObjectUtils.easyGetPropertyType(maintenanceDocument.getNewMaintainableObject().getDataObject(), maintenanceDocument.getAttachmentPropertyName());
                ObjectUtils.setObjectProperty(maintenanceDocument.getNewMaintainableObject().getBusinessObject(), maintenanceDocument.getAttachmentPropertyName(), type, maintenanceDocument.getFileAttachment());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | FormatException e) {
            throw new RuntimeException("Exception occurred while setting attachment property on NewMaintainable bo", e);
        }
    }

    public List getSections() {
        if (this.getDocument() == null) {
            throw new RuntimeException("Document not set in maintenance form.");
        }
        if (((MaintenanceDocumentBase)this.getDocument()).getNewMaintainableObject() == null) {
            throw new RuntimeException("New maintainable not set in document.");
        }
        if (("Edit".equals(this.getMaintenanceAction()) || "Copy".equals(this.getMaintenanceAction()) || "Delete".equals(this.getMaintenanceAction())) && ((MaintenanceDocumentBase)this.getDocument()).getOldMaintainableObject() == null) {
            throw new RuntimeException("Old maintainable not set in document.");
        }
        List keyFieldNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(((MaintenanceDocumentBase)this.getDocument()).getNewMaintainableObject().getBusinessObject().getClass());
        Maintainable oldMaintainable = ((MaintenanceDocumentBase)this.getDocument()).getOldMaintainableObject();
        oldMaintainable.setMaintenanceAction(this.getMaintenanceAction());
        List oldMaintSections = oldMaintainable.getSections((MaintenanceDocument)this.getDocument(), null);
        Maintainable newMaintainable = ((MaintenanceDocumentBase)this.getDocument()).getNewMaintainableObject();
        newMaintainable.setMaintenanceAction(this.getMaintenanceAction());
        List newMaintSections = newMaintainable.getSections((MaintenanceDocument)this.getDocument(), oldMaintainable);
        WorkflowDocument workflowDocument = this.getDocument().getDocumentHeader().getWorkflowDocument();
        String documentStatus = workflowDocument.getStatus().getCode();
        String documentInitiatorPrincipalId = workflowDocument.getInitiatorPrincipalId();
        List meshedSections = FieldUtils.meshSections(oldMaintSections, newMaintSections, keyFieldNames, this.getMaintenanceAction(), this.isReadOnly(), this.authorizations, documentStatus, documentInitiatorPrincipalId);
        return meshedSections;
    }

    public String getMaintenanceAction() {
        return this.maintenanceAction;
    }

    public String getBusinessObjectClassName() {
        return this.businessObjectClassName;
    }

    public void setBusinessObjectClassName(String businessObjectClassName) {
        this.businessObjectClassName = businessObjectClassName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map getNewMaintainableValues() {
        return this.newMaintainableValues;
    }

    public Map getOldMaintainableValues() {
        return this.oldMaintainableValues;
    }

    public void setMaintenanceAction(String maintenanceAction) {
        this.maintenanceAction = maintenanceAction;
    }

    public MaintenanceDocumentRestrictions getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(MaintenanceDocumentRestrictions authorizations) {
        this.authorizations = authorizations;
    }

    public void setNewMaintainableValues(Map newMaintainableValues) {
        this.newMaintainableValues = newMaintainableValues;
    }

    public void setOldMaintainableValues(Map oldMaintainableValues) {
        this.oldMaintainableValues = oldMaintainableValues;
    }

    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    public String getLookedUpCollectionName() {
        return this.lookedUpCollectionName;
    }

    public void setLookedUpCollectionName(String lookedUpCollectionName) {
        this.lookedUpCollectionName = lookedUpCollectionName;
    }

    public String getAdditionalSectionsFile() {
        if (this.businessObjectClassName != null) {
            try {
                MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
                maintenanceDocumentDictionaryService.getDocumentTypeName(Class.forName(this.businessObjectClassName));
                return maintenanceDocumentDictionaryService.getMaintenanceDocumentEntry(this.businessObjectClassName).getAdditionalSectionsFile();
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Unable to resolve business object class", (Throwable)ex);
            }
        } else {
            MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
            return maintenanceDocumentDictionaryService.getMaintenanceDocumentEntry(this.getDocTypeName()).getAdditionalSectionsFile();
        }
        return null;
    }

    @Override
    public String retrieveFormValueForLookupInquiryParameters(String parameterName, String parameterValueLocation) {
        String propertyName;
        MaintenanceDocument maintDoc = (MaintenanceDocument)this.getDocument();
        if (parameterValueLocation.toLowerCase().startsWith("document.oldMaintainableObject.".toLowerCase())) {
            propertyName = parameterValueLocation.substring("document.oldMaintainableObject.".length());
            if (maintDoc.getOldMaintainableObject() != null && maintDoc.getOldMaintainableObject().getBusinessObject() != null) {
                Object parameterValue = ObjectUtils.getPropertyValue(maintDoc.getOldMaintainableObject().getBusinessObject(), propertyName);
                if (parameterValue == null) {
                    return null;
                }
                if (parameterValue instanceof String) {
                    return (String)parameterValue;
                }
                Formatter formatter = Formatter.getFormatter(parameterValue.getClass());
                return (String)formatter.format(parameterValue);
            }
        }
        if (parameterValueLocation.toLowerCase().startsWith("document.newMaintainableObject.".toLowerCase())) {
            propertyName = parameterValueLocation.substring("document.newMaintainableObject.".length());
            String addPrefix = "add".toLowerCase() + ".";
            if (propertyName.toLowerCase().startsWith(addPrefix)) {
                PersistableBusinessObject newCollectionLine;
                Object parameterValue;
                propertyName = propertyName.substring(addPrefix.length());
                String collectionName = this.parseAddCollectionName(propertyName);
                if ((propertyName = propertyName.substring(collectionName.length())).startsWith(".")) {
                    propertyName = propertyName.substring(1);
                }
                if ((parameterValue = ObjectUtils.getPropertyValue(newCollectionLine = maintDoc.getNewMaintainableObject().getNewCollectionLine(collectionName), propertyName)) == null) {
                    return null;
                }
                if (parameterValue instanceof String) {
                    return (String)parameterValue;
                }
                Formatter formatter = Formatter.getFormatter(parameterValue.getClass());
                return (String)formatter.format(parameterValue);
            }
            if (maintDoc.getNewMaintainableObject() != null && maintDoc.getNewMaintainableObject().getBusinessObject() != null) {
                Object parameterValue = ObjectUtils.getPropertyValue(maintDoc.getNewMaintainableObject().getBusinessObject(), propertyName);
                if (parameterValue == null) {
                    return null;
                }
                if (parameterValue instanceof String) {
                    return (String)parameterValue;
                }
                Formatter formatter = Formatter.getFormatter(parameterValue.getClass());
                return (String)formatter.format(parameterValue);
            }
        }
        return super.retrieveFormValueForLookupInquiryParameters(parameterName, parameterValueLocation);
    }

    protected String parseAddCollectionName(String propertyName) {
        StringBuilder collectionNameBuilder = new StringBuilder();
        boolean firstPathElement = true;
        for (String pathElement : propertyName.split("\\.")) {
            if (StringUtils.isBlank((String)pathElement)) continue;
            if (firstPathElement) {
                firstPathElement = false;
            } else {
                collectionNameBuilder.append(".");
            }
            collectionNameBuilder.append(pathElement);
            if (!pathElement.endsWith("]") || !pathElement.contains("[")) break;
        }
        String collectionName = collectionNameBuilder.toString();
        return collectionName;
    }

    @Override
    public boolean shouldPropertyBePopulatedInForm(String requestParameterName, HttpServletRequest request) {
        String methodToCallActionName = request.getParameter("methodToCall");
        if (StringUtils.equals((String)methodToCallActionName, (String)"copy") || StringUtils.equals((String)methodToCallActionName, (String)"edit") || StringUtils.equals((String)methodToCallActionName, (String)"start") || StringUtils.equals((String)methodToCallActionName, (String)"newWithExisting") || StringUtils.equals((String)methodToCallActionName, (String)"delete")) {
            return true;
        }
        if (StringUtils.indexOf((String)methodToCallActionName, (String)"toggleInactiveRecordDisplay") == 0) {
            return true;
        }
        return super.shouldPropertyBePopulatedInForm(requestParameterName, request);
    }

    @Override
    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if (StringUtils.equals((String)methodToCallParameterValue, (String)"copy") || StringUtils.equals((String)methodToCallParameterValue, (String)"edit") || StringUtils.equals((String)methodToCallParameterValue, (String)"start") || StringUtils.equals((String)methodToCallParameterValue, (String)"newWithExisting") || StringUtils.equals((String)methodToCallParameterValue, (String)"delete")) {
            return true;
        }
        if (StringUtils.indexOf((String)methodToCallParameterName, (String)"methodToCall.toggleInactiveRecordDisplay") == 0) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }
}

