/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.model;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;

public class SyncClientSideStateTask
extends ViewLifecycleTaskBase<Component> {
    public SyncClientSideStateTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        Component component = (Component)this.getElementState().getElement();
        ViewModel model = (ViewModel)ViewLifecycle.getModel();
        Map clientSideState = model.getClientStateForSyncing();
        if (!(component instanceof View) && clientSideState.containsKey(component.getId())) {
            Map componentState;
            clientSideState = componentState = (Map)clientSideState.get(component.getId());
        }
        if (clientSideState != null && !clientSideState.isEmpty()) {
            Map<String, Annotation> annotatedFields = CopyUtils.getFieldsWithAnnotation(component.getClass(), ClientSideState.class);
            for (Map.Entry<String, Annotation> annotatedField : annotatedFields.entrySet()) {
                ClientSideState clientSideStateAnnot = (ClientSideState)annotatedField.getValue();
                String variableName = clientSideStateAnnot.variableName();
                if (StringUtils.isBlank((String)variableName)) {
                    variableName = annotatedField.getKey();
                }
                if (!clientSideState.containsKey(variableName)) continue;
                Object value = clientSideState.get(variableName);
                ObjectPropertyUtils.setPropertyValue(component, annotatedField.getKey(), value);
            }
        }
    }
}

