/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttribute;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicyMapAdapter;
import org.w3c.dom.Element;

@XmlRootElement(name="documentType")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentTypeType", propOrder={"id", "name", "documentTypeVersion", "label", "description", "parentId", "active", "unresolvedDocHandlerUrl", "resolvedDocumentHandlerUrl", "helpDefinitionUrl", "docSearchHelpUrl", "postProcessorName", "applicationId", "current", "blanketApproveGroupId", "superUserGroupId", "policies", "documentTypeAttributes", "versionNumber", "objectId", "authorizer", "_futureElements"})
public final class DocumentType
extends AbstractDataTransferObject
implements DocumentTypeContract {
    private static final long serialVersionUID = 6866926296038814812L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="documentTypeVersion", required=false)
    private final Integer documentTypeVersion;
    @XmlElement(name="label", required=false)
    private final String label;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="parentId", required=false)
    private final String parentId;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="unresolvedDocHandlerUrl", required=false)
    private final String unresolvedDocHandlerUrl;
    @XmlElement(name="resolvedDocumentHandlerUrl", required=false)
    private final String resolvedDocumentHandlerUrl;
    @XmlElement(name="helpDefinitionUrl", required=false)
    private final String helpDefinitionUrl;
    @XmlElement(name="docSearchHelpUrl", required=false)
    private final String docSearchHelpUrl;
    @XmlElement(name="postProcessorName", required=false)
    private final String postProcessorName;
    @XmlElement(name="applicationId", required=false)
    private final String applicationId;
    @XmlElement(name="current", required=true)
    private final boolean current;
    @XmlElement(name="blanketApproveGroupId", required=false)
    private final String blanketApproveGroupId;
    @XmlElement(name="superUserGroupId", required=false)
    private final String superUserGroupId;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="policies", required=true)
    @XmlJavaTypeAdapter(value=DocumentTypePolicyMapAdapter.class)
    private final Map<DocumentTypePolicy, String> policies;
    @XmlElementWrapper(name="documentTypeAttributes", required=false)
    @XmlElement(name="documentTypeAttribute", required=false)
    private final List<DocumentTypeAttribute> documentTypeAttributes;
    @XmlElement(name="authorizer", required=false)
    private final String authorizer;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentType() {
        this.id = null;
        this.name = null;
        this.documentTypeVersion = null;
        this.label = null;
        this.description = null;
        this.parentId = null;
        this.active = false;
        this.unresolvedDocHandlerUrl = null;
        this.resolvedDocumentHandlerUrl = null;
        this.helpDefinitionUrl = null;
        this.docSearchHelpUrl = null;
        this.postProcessorName = null;
        this.applicationId = null;
        this.current = false;
        this.blanketApproveGroupId = null;
        this.superUserGroupId = null;
        this.policies = null;
        this.versionNumber = null;
        this.objectId = null;
        this.documentTypeAttributes = null;
        this.authorizer = null;
    }

    private DocumentType(Builder builder) {
        this.name = builder.getName();
        this.id = builder.getId();
        this.documentTypeVersion = builder.getDocumentTypeVersion();
        this.label = builder.getLabel();
        this.description = builder.getDescription();
        this.parentId = builder.getParentId();
        this.active = builder.isActive();
        this.unresolvedDocHandlerUrl = builder.getUnresolvedDocHandlerUrl();
        this.resolvedDocumentHandlerUrl = builder.getResolvedDocumentHandlerUrl();
        this.helpDefinitionUrl = builder.getHelpDefinitionUrl();
        this.docSearchHelpUrl = builder.getDocSearchHelpUrl();
        this.postProcessorName = builder.getPostProcessorName();
        this.applicationId = builder.getApplicationId();
        this.current = builder.isCurrent();
        this.blanketApproveGroupId = builder.getBlanketApproveGroupId();
        this.superUserGroupId = builder.getSuperUserGroupId();
        this.policies = builder.getPolicies() == null ? Collections.emptyMap() : Map.copyOf(builder.getPolicies());
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        ArrayList<DocumentTypeAttribute> tempAttributes = new ArrayList<DocumentTypeAttribute>();
        if (CollectionUtils.isNotEmpty(builder.getDocumentTypeAttributes())) {
            for (DocumentTypeAttribute.Builder externalId : builder.getDocumentTypeAttributes()) {
                tempAttributes.add(externalId.build());
            }
        }
        this.documentTypeAttributes = Collections.unmodifiableList(tempAttributes);
        this.authorizer = builder.getAuthorizer();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getDocumentTypeVersion() {
        return this.documentTypeVersion;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getUnresolvedDocHandlerUrl() {
        return this.unresolvedDocHandlerUrl;
    }

    @Override
    public String getHelpDefinitionUrl() {
        return this.helpDefinitionUrl;
    }

    @Override
    public String getDocSearchHelpUrl() {
        return this.docSearchHelpUrl;
    }

    @Override
    public String getPostProcessorName() {
        return this.postProcessorName;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public boolean isCurrent() {
        return this.current;
    }

    @Override
    public String getBlanketApproveGroupId() {
        return this.blanketApproveGroupId;
    }

    @Override
    public String getSuperUserGroupId() {
        return this.superUserGroupId;
    }

    @Override
    public Map<DocumentTypePolicy, String> getPolicies() {
        return this.policies;
    }

    public List<DocumentTypeAttribute> getDocumentTypeAttributes() {
        return this.documentTypeAttributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getResolvedDocumentHandlerUrl() {
        return this.resolvedDocumentHandlerUrl;
    }

    @Override
    public String getAuthorizer() {
        return this.authorizer;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/DocumentTypeType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String DOCUMENT_TYPE_VERSION = "documentTypeVersion";
        static final String LABEL = "label";
        static final String DESCRIPTION = "description";
        static final String PARENT_ID = "parentId";
        static final String ACTIVE = "active";
        static final String UNRESOLVED_DOC_HANDLER_URL = "unresolvedDocHandlerUrl";
        static final String RESOLVED_DOC_HANDLER_URL = "resolvedDocumentHandlerUrl";
        static final String HELP_DEFINITION_URL = "helpDefinitionUrl";
        static final String DOC_SEARCH_HELP_URL = "docSearchHelpUrl";
        static final String POST_PROCESSOR_NAME = "postProcessorName";
        static final String APPLICATION_ID = "applicationId";
        static final String CURRENT = "current";
        static final String BLANKET_APPROVE_GROUP_ID = "blanketApproveGroupId";
        static final String SUPER_USER_GROUP_ID = "superUserGroupId";
        static final String POLICIES = "policies";
        static final String DOCUMENT_TYPE_ATTRIBUTES = "documentTypeAttributes";
        static final String DOCUMENT_TYPE_ATTRIBUTE = "documentTypeAttribute";
        static final String AUTHORIZER = "authorizer";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentType";
        static final String TYPE_NAME = "DocumentTypeType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentTypeContract {
        private static final long serialVersionUID = 1678979180435181578L;
        private String id;
        private String name;
        private Integer documentTypeVersion;
        private String label;
        private String description;
        private String parentId;
        private boolean active;
        private String unresolvedDocHandlerUrl;
        private String resolvedDocumentHandlerUrl;
        private String helpDefinitionUrl;
        private String docSearchHelpUrl;
        private String postProcessorName;
        private String applicationId;
        private boolean current;
        private String blanketApproveGroupId;
        private String superUserGroupId;
        private Map<DocumentTypePolicy, String> policies;
        private List<DocumentTypeAttribute.Builder> documentTypeAttributes;
        private Long versionNumber;
        private String objectId;
        private String authorizer;

        private Builder(String name) {
            this.setName(name);
            this.setActive(true);
            this.setCurrent(true);
            this.policies = new HashMap<DocumentTypePolicy, String>();
            this.documentTypeAttributes = Collections.emptyList();
        }

        public static Builder create(String name) {
            return new Builder(name);
        }

        public static Builder create(DocumentTypeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getName());
            builder.setId(contract.getId());
            builder.setDocumentTypeVersion(contract.getDocumentTypeVersion());
            builder.setLabel(contract.getLabel());
            builder.setDescription(contract.getDescription());
            builder.setParentId(contract.getParentId());
            builder.setActive(contract.isActive());
            builder.setUnresolvedDocHandlerUrl(contract.getUnresolvedDocHandlerUrl());
            builder.setResolvedDocHandlerUrl(contract.getResolvedDocumentHandlerUrl());
            builder.setHelpDefinitionUrl(contract.getHelpDefinitionUrl());
            builder.setDocSearchHelpUrl(contract.getDocSearchHelpUrl());
            builder.setPostProcessorName(contract.getPostProcessorName());
            builder.setApplicationId(contract.getApplicationId());
            builder.setCurrent(contract.isCurrent());
            builder.setBlanketApproveGroupId(contract.getBlanketApproveGroupId());
            builder.setSuperUserGroupId(contract.getSuperUserGroupId());
            builder.setPolicies(new HashMap<DocumentTypePolicy, String>(contract.getPolicies()));
            if (contract.getDocumentTypeAttributes() != null) {
                ArrayList<DocumentTypeAttribute.Builder> tempAttrs = new ArrayList<DocumentTypeAttribute.Builder>();
                for (DocumentTypeAttributeContract documentTypeAttributeContract : contract.getDocumentTypeAttributes()) {
                    tempAttrs.add(DocumentTypeAttribute.Builder.create(documentTypeAttributeContract));
                }
                builder.setDocumentTypeAttributes(tempAttrs);
            }
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setAuthorizer(contract.getAuthorizer());
            return builder;
        }

        public DocumentType build() {
            return new DocumentType(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Integer getDocumentTypeVersion() {
            return this.documentTypeVersion;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getParentId() {
            return this.parentId;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public String getUnresolvedDocHandlerUrl() {
            return this.unresolvedDocHandlerUrl;
        }

        @Override
        public String getResolvedDocumentHandlerUrl() {
            return this.resolvedDocumentHandlerUrl;
        }

        @Override
        public String getHelpDefinitionUrl() {
            return this.helpDefinitionUrl;
        }

        @Override
        public String getDocSearchHelpUrl() {
            return this.docSearchHelpUrl;
        }

        @Override
        public String getPostProcessorName() {
            return this.postProcessorName;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public boolean isCurrent() {
            return this.current;
        }

        @Override
        public String getBlanketApproveGroupId() {
            return this.blanketApproveGroupId;
        }

        @Override
        public String getSuperUserGroupId() {
            return this.superUserGroupId;
        }

        @Override
        public Map<DocumentTypePolicy, String> getPolicies() {
            return this.policies;
        }

        public List<DocumentTypeAttribute.Builder> getDocumentTypeAttributes() {
            return this.documentTypeAttributes;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Override
        public String getAuthorizer() {
            return this.authorizer;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.name = name;
        }

        public void setDocumentTypeVersion(Integer documentTypeVersion) {
            this.documentTypeVersion = documentTypeVersion;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setUnresolvedDocHandlerUrl(String unresolvedDocHandlerUrl) {
            this.unresolvedDocHandlerUrl = unresolvedDocHandlerUrl;
        }

        public void setResolvedDocHandlerUrl(String resolvedDocumentHandlerUrl) {
            this.resolvedDocumentHandlerUrl = resolvedDocumentHandlerUrl;
        }

        public void setHelpDefinitionUrl(String helpDefinitionUrl) {
            this.helpDefinitionUrl = helpDefinitionUrl;
        }

        public void setDocSearchHelpUrl(String docSearchHelpUrl) {
            this.docSearchHelpUrl = docSearchHelpUrl;
        }

        public void setPostProcessorName(String postProcessorName) {
            this.postProcessorName = postProcessorName;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public void setBlanketApproveGroupId(String blanketApproveGroupId) {
            this.blanketApproveGroupId = blanketApproveGroupId;
        }

        public void setSuperUserGroupId(String superUserGroupId) {
            this.superUserGroupId = superUserGroupId;
        }

        public void setPolicies(Map<DocumentTypePolicy, String> policies) {
            this.policies = policies;
        }

        public void setDocumentTypeAttributes(List<DocumentTypeAttribute.Builder> documentTypeAttributes) {
            this.documentTypeAttributes = documentTypeAttributes;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setAuthorizer(String authorizer) {
            this.authorizer = authorizer;
        }
    }
}

