/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        final Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Settings finalSettings;
                Settings.Builder indexSettings;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i2 = 0; i2 < request.indices().length; ++i2) {
                    Index index = request.indices()[i2];
                    actualIndices[i2] = index.getName();
                    IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
                    if (metadata.getState() == IndexMetadata.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                    int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
                    if (!preserveExisting) {
                        int totalNewShards = Arrays.stream(request.indices()).mapToInt(i -> MetadataUpdateSettingsService.this.getTotalNewShards(i, currentState, updatedNumberOfReplicas)).sum();
                        Optional<String> error = MetadataUpdateSettingsService.this.shardLimitValidator.checkShardLimit(totalNewShards, currentState);
                        if (error.isPresent()) {
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error.get());
                            throw ex;
                        }
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                    }
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                for (IndexMetadata.APIBlock aPIBlock : IndexMetadata.APIBlock.values()) {
                    MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, aPIBlock.block, aPIBlock.setting, openSettings);
                }
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        IndexMetadata indexMetadata = metadataBuilder.getSafe(index);
                        Settings.Builder builder = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, builder, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        IndexMetadata indexMetadata = metadataBuilder.getSafe(index);
                        Settings.Builder builder = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, indexSettings, builder, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                    for (String string : actualIndices) {
                        MetadataCreateIndexService.validateTranslogRetentionSettings(metadataBuilder.get(string).getSettings());
                    }
                }
                for (String string : actualIndices) {
                    if (IndexSettings.same(currentState.metadata().index(string).getSettings(), metadataBuilder.get(string).getSettings())) continue;
                    IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(string));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metadataBuilder.put(builder);
                }
                ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
                updatedState = MetadataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetadata updatedMetadata;
                    for (Index index : openIndices) {
                        IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(indexMetadata, updatedMetadata);
                    }
                    for (Index index : closeIndices) {
                        IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(indexMetadata, updatedMetadata);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToElastic(ex);
                }
                return updatedState;
            }
        });
    }

    private int getTotalNewShards(Index index, ClusterState currentState, int updatedNumberOfReplicas) {
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        int shardsInIndex = indexMetadata.getNumberOfShards();
        int oldNumberOfReplicas = indexMetadata.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    private static void maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    blocks.addIndexBlock(index, block);
                    continue;
                }
                blocks.removeIndexBlock(index, block);
            }
        }
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetadata indexMetadata = metadataBuilder.get(index);
                    if (indexMetadata == null || Version.CURRENT.equals(indexMetadata.getCreationVersion())) continue;
                    metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", (Version)entry.getValue().v1())).settingsVersion(1L + indexMetadata.getSettingsVersion()));
                }
                return ClusterState.builder(currentState).metadata(metadataBuilder).build();
            }
        });
    }
}

