/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.rate;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.rate.RateTypeContract;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateClassType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;

@Entity
@Table(name="RATE_TYPE")
@IdClass(value=RateTypeId.class)
public class RateType
extends KcPersistableBusinessObjectBase
implements Comparable<RateType>,
RateTypeContract {
    @Id
    @Column(name="RATE_CLASS_CODE")
    private String rateClassCode;
    @Id
    @Column(name="RATE_TYPE_CODE")
    private String rateTypeCode;
    @Column(name="DESCRIPTION")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;

    public String getRateClassCode() {
        return this.rateClassCode;
    }

    public void setRateClassCode(String rateClassCode) {
        this.rateClassCode = rateClassCode;
    }

    public String getRateTypeCode() {
        return this.rateTypeCode;
    }

    public void setRateTypeCode(String rateTypeCode) {
        this.rateTypeCode = rateTypeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRateClassPrefix() {
        this.refreshReferenceObject("rateClass");
        RateClassType rateClassType = this.getRateClass().getRateClassType();
        return rateClassType.getDescription();
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    @Override
    public int compareTo(RateType rateType) {
        return new CompareToBuilder().append((Object)this.rateClassCode, (Object)rateType.rateClassCode).append((Object)this.rateTypeCode, (Object)rateType.rateTypeCode).toComparison();
    }

    public static final class RateTypeId
    implements Serializable,
    Comparable<RateTypeId> {
        private String rateClassCode;
        private String rateTypeCode;

        public String getRateClassCode() {
            return this.rateClassCode;
        }

        public void setRateClassCode(String rateClassCode) {
            this.rateClassCode = rateClassCode;
        }

        public String getRateTypeCode() {
            return this.rateTypeCode;
        }

        public void setRateTypeCode(String rateTypeCode) {
            this.rateTypeCode = rateTypeCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("rateClassCode", (Object)this.rateClassCode).append("rateTypeCode", (Object)this.rateTypeCode).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            RateTypeId rhs = (RateTypeId)other;
            return new EqualsBuilder().append((Object)this.rateClassCode, (Object)rhs.rateClassCode).append((Object)this.rateTypeCode, (Object)rhs.rateTypeCode).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.rateClassCode).append((Object)this.rateTypeCode).toHashCode();
        }

        @Override
        public int compareTo(RateTypeId other) {
            return new CompareToBuilder().append((Object)this.rateClassCode, (Object)other.rateClassCode).append((Object)this.rateTypeCode, (Object)other.rateTypeCode).toComparison();
        }
    }
}

