/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.util.Map;
import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AppointmentTypeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String ERROR_DURATION_INVALID = "error.appointmentType.duration.invalid";
    private static final String ERROR_PERIOD_EXISTS = "error.appointmentType.period.exists";
    private static final String ERROR_PERIOD_INVALID = "error.appointmentType.period.invalid";
    private static final String ERROR_PERIOD_TYPE_INVALID = "error.appointmentType.periodType.invalid";
    private BusinessObjectService businessObjectService;

    public boolean processSaveDocument(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        AppointmentType appointmentType = null;
        if (maintenanceDocument.getDocumentDataObject() != null) {
            appointmentType = (AppointmentType)maintenanceDocument.getDocumentDataObject();
        } else if (maintenanceDocument.getNewMaintainableObject() != null) {
            appointmentType = (AppointmentType)maintenanceDocument.getNewMaintainableObject();
        }
        if (appointmentType != null) {
            return this.hasDurationOrValidPeriod(appointmentType) & this.isNotDuplicatePeriod(appointmentType);
        }
        return true;
    }

    private boolean hasDurationOrValidPeriod(AppointmentType appointmentType) {
        return this.hasDuration(appointmentType) | this.validPeriod(appointmentType) & this.validPeriodType(appointmentType);
    }

    private boolean validPeriod(AppointmentType appointmentType) {
        boolean periodValid;
        boolean bl = periodValid = appointmentType.getStartDate() != null && appointmentType.getEndDate() != null && !appointmentType.getStartDate().equals(appointmentType.getEndDate());
        if (!periodValid) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.startDate", ERROR_PERIOD_INVALID, new String[0]);
        }
        return periodValid;
    }

    private boolean validPeriodType(AppointmentType appointmentType) {
        boolean hasType;
        boolean bl = hasType = appointmentType.getBudgetPeriodType() != null || appointmentType.getBudgetPeriodTypeCode() != null;
        if (!hasType) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.budgetPeriodTypeCode", ERROR_PERIOD_TYPE_INVALID, new String[0]);
        }
        return hasType;
    }

    private boolean hasDuration(AppointmentType appointmentType) {
        boolean valid;
        boolean bl = valid = appointmentType.getDuration() != null && appointmentType.getDuration().doubleValue() > 0.0;
        if (!valid) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.duration", ERROR_DURATION_INVALID, new String[0]);
        }
        return valid;
    }

    private boolean isNotDuplicatePeriod(AppointmentType appointmentType) {
        if (appointmentType.getStartDate() != null && appointmentType.getEndDate() != null && appointmentType.getBudgetPeriodTypeCode() != null) {
            Map<String, String> search = Map.of("startDate", appointmentType.getStartDate(), "endDate", appointmentType.getEndDate(), "budgetPeriodTypeCode", appointmentType.getBudgetPeriodTypeCode());
            if (this.getBusinessObjectService().countMatching(AppointmentType.class, search) > 0) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.startDate", ERROR_PERIOD_EXISTS, new String[0]);
                return false;
            }
        }
        return true;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

