/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromToUtils;

public final class DateUtils {
    private static final Pattern TIME_PATTERN_12_HOUR = Pattern.compile("(0?[1-9]|1[0-2])(?:(?::|\\.)([0-5][0-9]))?(?:\\s*(([ap]m?|[ap]\\.m\\.)))?", 2);
    private static final Pattern TIME_PATTERN_24_HOUR = Pattern.compile("([01][0-9]|2[0-3])(?:(?::|\\.)?([0-5][0-9]))(?:\\s*(([ap]m?|[ap]\\.m\\.)))?", 2);

    private DateUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static java.sql.Date clearTimeFields(java.sql.Date date) {
        GregorianCalendar timelessCal = new GregorianCalendar();
        timelessCal.setTime(date);
        timelessCal.set(11, 0);
        timelessCal.set(12, 0);
        timelessCal.set(13, 0);
        timelessCal.set(14, 0);
        return new java.sql.Date(timelessCal.getTimeInMillis());
    }

    public static java.sql.Date newDate(Integer year, Integer month, Integer day) {
        if (year == null) {
            throw new IllegalArgumentException("Argument 'year' passed in was null.");
        }
        if (month == null) {
            throw new IllegalArgumentException("Argument 'month' passed in was null.");
        }
        if (day == null) {
            throw new IllegalArgumentException("Argument 'day' passed in was null.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static java.sql.Date newDate(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        if (year == null) {
            throw new IllegalArgumentException("Argument 'year' passed in was null.");
        }
        if (month == null) {
            throw new IllegalArgumentException("Argument 'month' passed in was null.");
        }
        if (day == null) {
            throw new IllegalArgumentException("Argument 'day' passed in was null.");
        }
        if (hour == null) {
            throw new IllegalArgumentException("Argument 'hour' passed in was null.");
        }
        if (minute == null) {
            throw new IllegalArgumentException("Argument 'minute' passed in was null.");
        }
        if (second == null) {
            throw new IllegalArgumentException("Argument 'second' passed in was null.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.clear(14);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    @Deprecated
    public static String formatFrom12Or24Str(String input) {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            Matcher matcher = TIME_PATTERN_12_HOUR.matcher(input = input.trim());
            if (matcher.matches()) {
                return DateUtils.parseTwelveHourTime(matcher);
            }
            matcher = TIME_PATTERN_24_HOUR.matcher(input);
            if (matcher.matches()) {
                return DateUtils.parseTwentyFourHourTime(matcher);
            }
            return "Invalid Time";
        }
        return "";
    }

    private static String parseTwelveHourTime(Matcher matcher) {
        Object amPmMarker;
        String minute;
        String hour = matcher.group(1);
        if (hour.startsWith("0")) {
            hour = hour.substring(1);
        }
        if ((minute = matcher.group(2)) == null) {
            minute = "00";
        }
        if ((amPmMarker = matcher.group(3)) == null) {
            amPmMarker = "12".equals(hour) ? "PM" : "AM";
        } else if (((String)(amPmMarker = ((String)amPmMarker).replaceAll("\\.", "").toUpperCase())).length() == 1) {
            amPmMarker = (String)amPmMarker + "M";
        }
        return hour + ":" + minute + " " + (String)amPmMarker;
    }

    private static String parseTwentyFourHourTime(Matcher matcher) {
        String hour = matcher.group(1);
        String minute = matcher.group(2);
        int intHour = Integer.parseInt(hour);
        String amPmMarker = "AM";
        if (intHour == 0) {
            intHour = 12;
        } else if (intHour >= 12) {
            amPmMarker = "PM";
            if (intHour > 12) {
                intHour -= 12;
            }
        }
        if (minute == null) {
            minute = "00";
        }
        return intHour + ":" + minute + " " + amPmMarker;
    }

    public static boolean isCurrentDateInRange(Date startDate, Date endDate) {
        return DateUtils.isDateInRange(startDate, endDate, null);
    }

    private static boolean isDateInRange(Date startDate, Date endDate, Date currentDate) {
        DateTime currentDateTime = currentDate == null ? DateTime.now() : new DateTime(currentDate.getTime());
        DateTime startDateTime = startDate == null ? null : new DateTime(startDate.getTime());
        DateTime endDateTime = endDate == null ? null : new DateTime(endDate.getTime());
        return InactivatableFromToUtils.isActive((DateTime)startDateTime, (DateTime)endDateTime, (DateTime)currentDateTime);
    }

    public static Date toUtc(Date localDate) {
        if (localDate == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(localDate.getTime());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return new Date(localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    public static boolean periodsOverlap(MonthDay start1, MonthDay end1, MonthDay start2, MonthDay end2) {
        if (start1 == null || start2 == null || end1 == null || end2 == null) {
            return false;
        }
        if (start1.isBefore(start2)) {
            return start2.isBefore(end1) || end1.isBefore(start1) || end2.isBefore(start2) && start1.isBefore(end2);
        }
        if (start2.isBefore(start1)) {
            return start1.isBefore(end2) || end2.isBefore(start2) || end1.isBefore(start1) && start2.isBefore(end1);
        }
        return true;
    }
}

