/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.List;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardSponsorTermRule;
import org.kuali.kra.award.AwardSponsorTermRuleEvent;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class AwardSponsorTermRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardSponsorTermRule {
    private static final String NEW_AWARD_SPONSOR_TERM = "newAwardSponsorTerm[";
    private AwardSponsorTerm awardSponsorTerm;
    private GlobalVariableService globalVariableService;
    List<AuditError> auditWarnings;

    @Override
    public boolean processAddSponsorTermBusinessRules(AwardSponsorTermRuleEvent awardSponsorTermRuleEvent) {
        this.awardSponsorTerm = awardSponsorTermRuleEvent.getAwardSponsorTermForValidation();
        int typeCode = awardSponsorTermRuleEvent.getSponsorTermTypeCode();
        String sponsorTermCode = awardSponsorTermRuleEvent.getSponsorTermCode();
        boolean valid = this.validateAwardSponsorTermNotEmpty(sponsorTermCode, typeCode);
        valid &= this.validateAwardSponsorTermValid(awardSponsorTermRuleEvent.getAwardSponsorTermForValidation().getSponsorTerm(), sponsorTermCode, typeCode);
        valid &= this.validateAwardSponsorTermNotDuplicate(this.awardSponsorTerm, awardSponsorTermRuleEvent.getAwardDocument().getAward().getAwardSponsorTerms(), true);
        return valid &= this.validateSponsorTermIsActive(this.awardSponsorTerm);
    }

    public boolean processAddSponsorTermFromMultiValueLookupRules(AwardSponsorTermRuleEvent awardSponsorTermRuleEvent) {
        this.awardSponsorTerm = awardSponsorTermRuleEvent.getAwardSponsorTermForValidation();
        boolean valid = true;
        valid &= this.validateAwardSponsorTermNotDuplicate(this.awardSponsorTerm, awardSponsorTermRuleEvent.getAwardDocument().getAward().getAwardSponsorTerms(), false);
        return valid &= this.validateSponsorTermIsActive(this.awardSponsorTerm);
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        Award award = ((AwardDocument)document).getAward();
        for (AwardSponsorTerm term : award.getAwardSponsorTerms()) {
            if (term.getSponsorTerm().isActive()) continue;
            valid = false;
            this.auditWarnings.add(new AuditError("document.termsAuditRules", "warning.awardSponsorTerm.inactive.term", "paymentReportsAndTerms.terms"));
            break;
        }
        this.reportAndCreateAuditCluster();
        return valid;
    }

    private boolean validateAwardSponsorTermNotEmpty(String sponsorTermCode, int sponsorTermTypeCode) {
        boolean valid = true;
        if (sponsorTermCode == null) {
            this.reportError(NEW_AWARD_SPONSOR_TERM + sponsorTermTypeCode + "]", "error.awardSponsorTerm.no.term", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateAwardSponsorTermValid(SponsorTerm sponsorTerm, String sponsorTermCode, int sponsorTermTypeCode) {
        boolean valid = true;
        if (sponsorTerm == null) {
            this.reportError(NEW_AWARD_SPONSOR_TERM + sponsorTermTypeCode + "]", "error.awardSponsorTerm.invalid.term", sponsorTermCode);
            valid = false;
        }
        return valid;
    }

    boolean validateAwardSponsorTermNotDuplicate(AwardSponsorTerm awardSponsorTerm, List<AwardSponsorTerm> awardSponsorTerms, boolean shouldReportError) {
        boolean valid = true;
        for (AwardSponsorTerm tempAwardSponsorTerm : awardSponsorTerms) {
            if (!awardSponsorTerm.getSponsorTermId().equals(tempAwardSponsorTerm.getSponsorTermId())) continue;
            valid = false;
            if (!shouldReportError) continue;
            this.reportError(NEW_AWARD_SPONSOR_TERM + awardSponsorTerm.getSponsorTerm().getSponsorTermTypeCode() + "]", "error.awardSponsorTerm.duplicate.term", new String[0]);
        }
        return valid;
    }

    boolean validateSponsorTermIsActive(AwardSponsorTerm awardSponsorTerm) {
        if (!awardSponsorTerm.getSponsorTerm().isActive()) {
            this.reportError(NEW_AWARD_SPONSOR_TERM + awardSponsorTerm.getSponsorTerm().getSponsorTermTypeCode() + "]", "error.awardSponsorTerm.inactive.term", awardSponsorTerm.getSponsorTerm().getSponsorTermCode());
            return false;
        }
        return true;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditWarnings != null && this.auditWarnings.size() > 0) {
            AuditCluster existingWarnings = this.getGlobalVariableService().getAuditErrorMap().get("termsAuditErrors");
            if (existingWarnings == null) {
                this.getGlobalVariableService().getAuditErrorMap().put("termsAuditErrors", new AuditCluster("Terms", this.auditWarnings, "Warnings"));
            } else {
                existingWarnings.getAuditErrorList().addAll(this.auditWarnings);
            }
        }
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

