/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.notification;

import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.notification.ExconProjectNotificationRenderer;
import org.kuali.kra.excon.project.notification.ExconProjectRoleQualifierService;

public class ExconProjectNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 6654171896176203664L;
    private ExconProject exconProject;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private String forwardName;

    public ExconProjectNotificationContext(ExconProject exconProject, String actionTypeCode, String contextName, NotificationRenderer renderer, String forwardName) {
        super(renderer);
        this.exconProject = exconProject;
        this.documentNumber = exconProject.getExconProjectDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.forwardName = forwardName;
        this.setNotificationService(KcServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService(KcServiceLocator.getService(ExconProjectRoleQualifierService.class));
        ((ExconProjectRoleQualifierService)this.getNotificationRoleQualifierService()).setExconProject(exconProject);
    }

    public ExconProjectNotificationContext(ExconProject exconProject, String actionTypeCode, String contextName) {
        this(exconProject, actionTypeCode, contextName, "projectActions");
    }

    public ExconProjectNotificationContext(ExconProject exconProject, String actionTypeCode, String contextName, String forwardName) {
        this(exconProject, actionTypeCode, contextName, new ExconProjectNotificationRenderer(exconProject), forwardName);
        ((ExconProjectNotificationRenderer)this.getRenderer()).setExconProject(exconProject);
    }

    @Override
    public String getModuleCode() {
        return "12";
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public ExconProject getExconProject() {
        return this.exconProject;
    }

    public void setExconProject(ExconProject exconProject) {
        this.exconProject = exconProject;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

