/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.service.impl;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocument;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.kra.excon.project.customdata.ExconProjectCustomData;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class ExconProjectServiceImpl
implements ExconProjectService {
    private static final Logger LOG = LogManager.getLogger(ExconProjectServiceImpl.class);
    private static final String EXCON_PROJECT_ID_FIELD = "projectId";
    private static final String PROJECT_NUMBER_FIELD = "projectNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String EXCON_PROJECT_NUMBER_SEQUENCE = "EXCON_PROJECT_NUMBER_S";
    private static final String PROJECT_NUMBER_PATTERN = "000000";
    private static final String EXCON_PROJECT_SEQUENCE_STATUS_FIELD = "exconProjectSequenceStatus";
    public static final String SEQUENCE_OWNER_VERSION_NAME_VALUE_FIELD = "sequenceOwnerVersionNameValue";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;
    private SequenceAccessorService sequenceAccessorService;
    private transient AwardService awardService;
    private transient InstitutionalProposalService institutionalProposalService;
    private transient ProposalDevelopmentService proposalDevelopmentService;
    private transient DataObjectService dataObjectService;
    private transient ConfigurationService configurationService;

    @Override
    public ExconProject getExconProject(Long exconProjectId) {
        return exconProjectId != null ? (ExconProject)this.businessObjectService.findByPrimaryKey(ExconProject.class, Map.of(EXCON_PROJECT_ID_FIELD, exconProjectId)) : null;
    }

    @Override
    public List<ExconProject> getExconProject(String projectNumber) {
        return StringUtils.isNotBlank((CharSequence)projectNumber) ? new ArrayList(this.businessObjectService.findMatchingOrderBy(ExconProject.class, Collections.singletonMap(PROJECT_NUMBER_FIELD, projectNumber), SEQUENCE_NUMBER, false)) : Collections.emptyList();
    }

    @Override
    public String getNextExconProjectNumber() {
        Long nextExconProjectNumber = this.sequenceAccessorService.getNextAvailableSequenceNumber(EXCON_PROJECT_NUMBER_SEQUENCE);
        DecimalFormat formatter = new DecimalFormat(PROJECT_NUMBER_PATTERN);
        return formatter.format(nextExconProjectNumber);
    }

    @Override
    public ExconProjectDocument createNewExconProjectVersion(ExconProjectDocument exconProjectDocument) throws VersionException, WorkflowException {
        ExconProject newVersion = this.getVersioningService().createNewVersion(exconProjectDocument.getExconProject());
        for (ExconProjectAttachment attach : newVersion.getExconProjectAttachments()) {
            ExconProjectAttachment orignalAttachment = this.findMatchingExconProjectAttachment(exconProjectDocument.getExconProject().getExconProjectAttachments(), attach.getFileId());
            attach.setUpdateUser(orignalAttachment.getUpdateUser());
            attach.setUpdateTimestamp(orignalAttachment.getUpdateTimestamp());
            attach.setUpdateUserSet(true);
        }
        this.incrementVersionNumberIfCanceledVersionsExist(newVersion);
        ExconProjectDocument newExconProjectDocument = (ExconProjectDocument)this.getDocumentService().getNewDocument(ExconProjectDocument.class);
        newExconProjectDocument.getDocumentHeader().setDocumentDescription(exconProjectDocument.getDocumentHeader().getDocumentDescription());
        newExconProjectDocument.setExconProject(newVersion);
        newVersion.setExconProjectDocument(newExconProjectDocument);
        this.synchNewCustomAttributes(newVersion, exconProjectDocument.getExconProject());
        return newExconProjectDocument;
    }

    @Override
    public void synchNewCustomAttributes(ExconProject newExconProject, ExconProject oldExconProject) {
        HashSet<Long> availableCustomAttributes = new HashSet<Long>();
        for (ExconProjectCustomData exconProjectCustomData : newExconProject.getExconProjectCustomDataList()) {
            availableCustomAttributes.add(exconProjectCustomData.getCustomAttributeId());
        }
        if (oldExconProject.getExconProjectDocument() != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = oldExconProject.getExconProjectDocument().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                if (availableCustomAttributes.contains(customAttributeDocument.getId())) continue;
                ExconProjectCustomData exconProjectCustomData = new ExconProjectCustomData();
                exconProjectCustomData.setCustomAttributeId(customAttributeDocument.getId());
                exconProjectCustomData.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                exconProjectCustomData.setValue(customAttributeDocument.getCustomAttribute().getDefaultValue());
                exconProjectCustomData.setExconProject(newExconProject);
                newExconProject.getExconProjectCustomDataList().add(exconProjectCustomData);
            }
            newExconProject.getExconProjectCustomDataList().removeAll(this.getInactiveCustomDataList(newExconProject.getExconProjectCustomDataList(), customAttributeDocuments));
        }
    }

    private List<ExconProjectCustomData> getInactiveCustomDataList(List<ExconProjectCustomData> exconProjectCustomDataList, Map<String, CustomAttributeDocument> customAttributeDocuments) {
        ArrayList<ExconProjectCustomData> inactiveCustomDataList = new ArrayList<ExconProjectCustomData>();
        for (ExconProjectCustomData exconProjectCustomData : exconProjectCustomDataList) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(exconProjectCustomData.getCustomAttributeId().toString());
            if (customAttributeDocument != null && customAttributeDocument.isActive()) continue;
            inactiveCustomDataList.add(exconProjectCustomData);
        }
        return inactiveCustomDataList;
    }

    private ExconProjectAttachment findMatchingExconProjectAttachment(List<ExconProjectAttachment> originalExconProjectList, Long currentFileId) throws VersionException {
        for (ExconProjectAttachment attach : originalExconProjectList) {
            if (!attach.getFileId().equals(currentFileId)) continue;
            return attach;
        }
        throw new VersionException("Unable to find matching attachment.");
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(ExconProject exconProject) {
        List versionHistory = (List)this.businessObjectService.findMatching(VersionHistory.class, this.getHashMap(exconProject.getProjectNumber()));
        exconProject.setSequenceNumber(versionHistory.size() + 1);
    }

    protected Map<String, String> getHashMap(String exconProjectNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SEQUENCE_OWNER_VERSION_NAME_VALUE_FIELD, exconProjectNumber);
        return map;
    }

    @Override
    public void updateExconProjectSequenceStatus(ExconProject exconProject, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveExconProject(exconProject.getProjectNumber());
        }
        exconProject.setExconProjectSequenceStatus(status.toString());
        if (exconProject.getExconProjectDocument() != null) {
            this.businessObjectService.save((PersistableBusinessObject)exconProject);
        }
    }

    protected void archiveCurrentActiveExconProject(String exconProjectNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(PROJECT_NUMBER_FIELD, exconProjectNumber);
        values.put(EXCON_PROJECT_SEQUENCE_STATUS_FIELD, VersionStatus.ACTIVE.name());
        Collection exconProjects = this.businessObjectService.findMatching(ExconProject.class, values);
        for (ExconProject exconProject : exconProjects) {
            exconProject.setExconProjectSequenceStatus(VersionStatus.ARCHIVED.name());
            exconProject.setAllowUpdateTimestampToBeReset(false);
            this.businessObjectService.save((PersistableBusinessObject)exconProject);
        }
    }

    @Override
    public Optional<Document> getAssociatedDocument(ExconProjectAssociatedDocument associatedDocument) {
        block13: {
            if (associatedDocument != null && associatedDocument.getAssocDocTypeCode() != null) {
                if ("AWARD".equals(associatedDocument.getAssocDocTypeCode())) {
                    return Optional.ofNullable(this.getAwardService().getActiveOrNewestAward(associatedDocument.getAssocDocNumber())).map(Award::getAwardDocument);
                }
                if ("INSTPROP".equals(associatedDocument.getAssocDocTypeCode())) {
                    return Optional.ofNullable(this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(associatedDocument.getAssocDocNumber())).or(() -> Optional.ofNullable(this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(associatedDocument.getAssocDocNumber()))).map(InstitutionalProposal::getInstitutionalProposalDocument);
                }
                if ("DEVPROP".equals(associatedDocument.getAssocDocTypeCode())) {
                    return Optional.ofNullable((DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)associatedDocument.getAssocDocNumber())).map(DevelopmentProposal::getProposalDocument);
                }
                if ("EXCONPRJ".equals(associatedDocument.getAssocDocTypeCode())) {
                    return this.getExconProject(associatedDocument.getAssocDocNumber()).stream().findFirst().map(ExconProject::getExconProjectDocument);
                }
                try {
                    Method m;
                    if (StringUtils.isEmpty((CharSequence)associatedDocument.getAssocDocType().getAssocDocTypeClassName())) break block13;
                    String className = associatedDocument.getAssocDocType().getAssocDocTypeClassName();
                    String shortClassName = className.substring(className.lastIndexOf(46) + 1);
                    String documentName = shortClassName + "Document";
                    HashMap<String, String> lookupVals = new HashMap<String, String>();
                    lookupVals.put(associatedDocument.getAssocDocType().getAssocDocTypeNumberAttr(), associatedDocument.getAssocDocNumber());
                    Collection results = this.getBusinessObjectService().findMatchingOrderBy(associatedDocument.getAssocDocTypeClass(), lookupVals, "updateTimestamp", false);
                    if (results == null || results.size() <= 0) break block13;
                    PersistableBusinessObject bo = (PersistableBusinessObject)results.iterator().next();
                    String docId = "";
                    try {
                        m = Class.forName(className).getDeclaredMethod("get" + documentName, null);
                        DocumentBase docClass = (DocumentBase)m.invoke((Object)bo, null);
                        m = Class.forName("org.kuali.rice.krad.document.DocumentBase").getDeclaredMethod("getDocumentNumber", null);
                        docId = (String)m.invoke((Object)docClass, null);
                    }
                    catch (Exception e) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    if (StringUtils.isEmpty((CharSequence)docId)) {
                        try {
                            m = Class.forName(className).getDeclaredMethod("getDocumentNumber", null);
                            docId = (String)m.invoke((Object)bo, null);
                        }
                        catch (Exception e) {
                            LOG.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)docId)) {
                        return Optional.ofNullable(this.getDocumentService().getByDocumentHeaderId(docId));
                    }
                }
                catch (WorkflowException e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public void syncAssociatedDocuments(ExconProject exconProject) {
        exconProject.getExconProjectAssociatedDocuments().forEach(associatedDoc -> this.getAssociatedDocument((ExconProjectAssociatedDocument)associatedDoc).ifPresent(document -> {
            if ("AWARD".equals(associatedDoc.getAssocDocTypeCode())) {
                this.getAwardService().createOrUpdateSpecialReview(document.getDocumentNumber(), exconProject.getProjectNumber(), "RESBOOT-1000", "RESBOOT-1000", exconProject.getProjectStartDate(), exconProject.getProjectEndDate());
            } else if ("INSTPROP".equals(associatedDoc.getAssocDocTypeCode())) {
                this.getInstitutionalProposalService().createOrUpdateSpecialReview(document.getDocumentNumber(), exconProject.getProjectNumber(), "RESBOOT-1000", "RESBOOT-1000", exconProject.getProjectStartDate(), exconProject.getProjectEndDate());
            } else if ("DEVPROP".equals(associatedDoc.getAssocDocTypeCode())) {
                this.getProposalDevelopmentService().createOrUpdateSpecialReview(document.getDocumentNumber(), exconProject.getProjectNumber(), "RESBOOT-1000", "RESBOOT-1000", exconProject.getProjectStartDate(), exconProject.getProjectEndDate());
            } else if ("EXCONPRJ".equals(associatedDoc.getAssocDocTypeCode())) {
                this.createOrUpdateAssociatedDocument(associatedDoc.getAssocDocNumber(), associatedDoc.getAssocDocTypeCode(), exconProject.getProjectNumber(), exconProject.getTitle());
            }
        }));
    }

    @Override
    public void deleteAssociatedDocumentLinks(String exconProjectNumber, List<ExconProjectAssociatedDocument> associatedDocuments) {
        for (ExconProjectAssociatedDocument toDelete : associatedDocuments) {
            Optional<Document> associatedDocument = this.getAssociatedDocument(toDelete);
            associatedDocument.ifPresent(document -> {
                if ("AWARD".equals(toDelete.getAssocDocTypeCode())) {
                    this.getAwardService().deleteSpecialReview(document.getDocumentNumber(), exconProjectNumber, "RESBOOT-1000");
                } else if ("INSTPROP".equals(toDelete.getAssocDocTypeCode())) {
                    this.getInstitutionalProposalService().deleteSpecialReview(document.getDocumentNumber(), exconProjectNumber, "RESBOOT-1000");
                } else if ("DEVPROP".equals(toDelete.getAssocDocTypeCode())) {
                    this.getProposalDevelopmentService().deleteSpecialReview(document.getDocumentNumber(), exconProjectNumber, "RESBOOT-1000");
                } else if ("EXCONPRJ".equals(toDelete.getAssocDocTypeCode())) {
                    this.deleteAssociatedDocument(((ExconProjectDocument)document).getExconProject().getProjectNumber(), toDelete.getAssocDocTypeCode(), exconProjectNumber);
                }
            });
        }
    }

    @Override
    public void createOrUpdateAssociatedDocument(String exconProjectNumber, String associatedDocType, String associatedDocNumber, String associatedDocTitle) {
        this.getExconProject(exconProjectNumber).stream().findFirst().ifPresent(exconProject -> {
            ExconProjectAssociatedDocument targetDoc = this.findAssociatedDocument((ExconProject)exconProject, associatedDocType, associatedDocNumber).orElseGet(() -> {
                ExconProjectAssociatedDocument associatedDocument = new ExconProjectAssociatedDocument();
                associatedDocument.setProjectNumber(exconProject.getProjectNumber());
                associatedDocument.setAssocDocTypeCode(associatedDocType);
                associatedDocument.setAssocDocNumber(associatedDocNumber);
                exconProject.getExconProjectAssociatedDocuments().add(associatedDocument);
                return associatedDocument;
            });
            targetDoc.setAssocDocTitle(associatedDocTitle);
            this.getBusinessObjectService().save((PersistableBusinessObject)exconProject);
        });
    }

    @Override
    public void deleteAssociatedDocument(String exconProjectNumber, String associatedDocType, String associatedDocNumber) {
        this.getExconProject(exconProjectNumber).stream().findFirst().ifPresent(exconProject -> this.findAssociatedDocument((ExconProject)exconProject, associatedDocType, associatedDocNumber).ifPresent(toDelete -> this.getBusinessObjectService().delete(toDelete)));
    }

    private Optional<ExconProjectAssociatedDocument> findAssociatedDocument(ExconProject exconProject, String associatedDocType, String associatedDocNumber) {
        return exconProject.getExconProjectAssociatedDocuments().stream().filter(ad -> ad.getAssocDocTypeCode().equals(associatedDocType) && ad.getAssocDocNumber().equals(associatedDocNumber)).findFirst();
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        if (this.proposalDevelopmentService == null) {
            this.proposalDevelopmentService = KcServiceLocator.getService(ProposalDevelopmentService.class);
        }
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

