/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.attribute;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDateTime;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDecimal;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeInteger;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;

public class DocumentAttributeFactory {
    public static DocumentAttributeString createStringAttribute(String name, String value) {
        DocumentAttributeString.Builder builder = DocumentAttributeString.Builder.create(name);
        builder.setValue(value);
        return builder.build();
    }

    public static DocumentAttributeDateTime createDateTimeAttribute(String name, DateTime value) {
        DocumentAttributeDateTime.Builder builder = DocumentAttributeDateTime.Builder.create(name);
        builder.setValue(value);
        return builder.build();
    }

    public static DocumentAttributeDateTime createDateTimeAttribute(String name, Date value) {
        return DocumentAttributeFactory.createDateTimeAttribute(name, new DateTime((Object)value));
    }

    public static DocumentAttributeDateTime createDateTimeAttribute(String name, long instant) {
        return DocumentAttributeFactory.createDateTimeAttribute(name, new DateTime(instant));
    }

    public static DocumentAttributeDateTime createDateTimeAttribute(String name, Calendar value) {
        return DocumentAttributeFactory.createDateTimeAttribute(name, new DateTime((Object)value));
    }

    public static DocumentAttributeDecimal createDecimalAttribute(String name, BigDecimal value) {
        DocumentAttributeDecimal.Builder builder = DocumentAttributeDecimal.Builder.create(name);
        builder.setValue(value);
        return builder.build();
    }

    public static DocumentAttributeDecimal createDecimalAttribute(String name, Number value) {
        return DocumentAttributeFactory.createDecimalAttribute(name, BigDecimal.valueOf(value.doubleValue()));
    }

    public static DocumentAttributeInteger createIntegerAttribute(String name, BigInteger value) {
        DocumentAttributeInteger.Builder builder = DocumentAttributeInteger.Builder.create(name);
        builder.setValue(value);
        return builder.build();
    }

    public static DocumentAttributeInteger createIntegerAttribute(String name, Number value) {
        return DocumentAttributeFactory.createIntegerAttribute(name, BigInteger.valueOf(value.longValue()));
    }

    public static DocumentAttribute.AbstractBuilder<?> loadContractIntoBuilder(DocumentAttributeContract contract) {
        if (contract == null) {
            throw new IllegalArgumentException("contract was null");
        }
        if (contract instanceof DocumentAttributeString) {
            DocumentAttributeString attribute = (DocumentAttributeString)contract;
            DocumentAttributeString.Builder builder = DocumentAttributeString.Builder.create(attribute.getName());
            builder.setValue(attribute.getValue());
            return builder;
        }
        if (contract instanceof DocumentAttributeDateTime) {
            DocumentAttributeDateTime attribute = (DocumentAttributeDateTime)contract;
            DocumentAttributeDateTime.Builder builder = DocumentAttributeDateTime.Builder.create(attribute.getName());
            builder.setValue(attribute.getValue());
            return builder;
        }
        if (contract instanceof DocumentAttributeInteger) {
            DocumentAttributeInteger attribute = (DocumentAttributeInteger)contract;
            DocumentAttributeInteger.Builder builder = DocumentAttributeInteger.Builder.create(attribute.getName());
            builder.setValue(attribute.getValue());
            return builder;
        }
        if (contract instanceof DocumentAttributeDecimal) {
            DocumentAttributeDecimal attribute = (DocumentAttributeDecimal)contract;
            DocumentAttributeDecimal.Builder builder = DocumentAttributeDecimal.Builder.create(attribute.getName());
            builder.setValue(attribute.getValue());
            return builder;
        }
        throw new IllegalArgumentException("Given document attribute class could not be converted: " + contract.getClass());
    }
}

