<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:HumanSubjectStudy_2_0="http://apply.grants.gov/forms/HumanSubjectStudy_2_0-V2.0"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
    <xsl:param name="studyNumber"/>
    <xsl:param name="govTrackingNumber"/>
    <xsl:param name="opportunityID"/>
    <xsl:param name="receivedDateTime"/>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="rest"
                                       page-height="11in" page-width="8.5in" margin-left="0.6in"
                                       margin-right="0.6in">
                    <fo:region-body margin-top="0.5in" margin-bottom="0.6in"/>
                    <fo:region-before region-name="header"/>
                    <fo:region-after region-name="footer" extent="0.6in"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="all-pages">
                    <fo:repeatable-page-master-alternatives>
                        <fo:conditional-page-master-reference
                                master-reference="rest" page-position="rest"/>
                    </fo:repeatable-page-master-alternatives>
                </fo:page-sequence-master>
            </fo:layout-master-set>

            <!-- Study -->
            <fo:page-sequence master-reference="rest" format="1">

                <fo:static-content flow-name="footer">
                    <fo:table width="100%" space-before.optimum="0pt"
                              space-after.optimum="0pt" table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell hyphenate="true" language="en"
                                               padding-start="0pt" padding-end="0pt" padding-before="1pt"
                                               padding-after="1pt" display-align="before" text-align="left"
                                               border-style="solid" border-width="0pt" border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Tracking Number:
                                            <xsl:value-of select="$govTrackingNumber"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell hyphenate="true" language="en"
                                               line-height="9pt" padding-start="0pt" padding-end="0pt"
                                               padding-before="1pt" padding-after="20pt" display-align="before"
                                               text-align="right" border-style="solid" border-width="0pt"
                                               border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Funding Opportunity Number:
                                            <xsl:value-of select="$opportunityID"/>
                                        </fo:inline>
                                        <fo:inline font-size="8px">
                                            Received Date:
                                            <xsl:value-of select="$receivedDateTime"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <xsl:call-template name="humanSubjectStudiesSection5"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section 5 -->
    <xsl:template name="humanSubjectStudiesSection5">
        <fo:block>
            <xsl:for-each select="//HumanSubjectStudy_2_0:HumanSubjectStudy_2_0">
                <fo:block>
                    <fo:table width="100%" table-layout="fixed" left="100pt"
                              font-size="9px">
                        <fo:table-column column-width="40%"/>
                        <fo:table-column column-width="60%"/>

                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="2">
                                    <fo:block padding="10pt" font-weight="bold">
                                        <fo:inline font-size="10px" padding="3pt">
                                            <xsl:text>Section 5 - Other Clinical Trial-related Attachments</xsl:text>
                                            <xsl:choose>
                                                <xsl:when test="normalize-space($studyNumber) != ''">
                                                    (Study <xsl:value-of select="$studyNumber"/>)
                                                </xsl:when>
                                            </xsl:choose>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>

                            <fo:table-row>
                                <fo:table-cell padding-start="3pt" padding-end="3pt"
                                               padding-before="1pt" padding-after="6pt" font-family="arialuni">
                                    <fo:block>
                                        5.1. Other Clinical Trial-related Attachments
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding-start="3pt" padding-end="3pt"
                                               padding-before="1pt" padding-after="6pt" font-family="arialuni">
                                    <fo:block>
                                        <xsl:if test="HumanSubjectStudy_2_0:OtherClinicalTrialAttachment">
                                            <fo:table width="100%" table-layout="fixed" left="100pt"
                                                      font-size="9px">
                                                <fo:table-column/>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each
                                                            select="HumanSubjectStudy_2_0:OtherClinicalTrialAttachment/att:AttachedFile">
                                                        <fo:table-row>
                                                            <fo:table-cell padding-start="3pt"
                                                                           padding-end="3pt" padding-before="1pt" padding-after="6pt" font-family="arialuni">
                                                                <fo:block>
                                                                    <xsl:value-of select="att:FileName"/>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </xsl:for-each>
        </fo:block>

    </xsl:template>
    <!-- End of Section 5 -->

</xsl:stylesheet>
