--
-- Copyright © 2005-2020 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

UPDATE EXCON_PROJECT_ASSOC_DOC_TYPE
SET ASSOC_DOC_TYPE_CLASS_NAME = 'org.kuali.coeus.propdev.impl.core.LookupableDevelopmentProposal'
WHERE ASSOC_DOC_TYPE_CODE = 'DEVPROP';

ALTER TABLE SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

INSERT INTO SPECIAL_REVIEW (SPECIAL_REVIEW_CODE, DESCRIPTION, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, SORT_ID)
VALUES ('RESBOOT-1000', 'Export Control', 'admin', NOW(), UUID(), 1, 13);

ALTER TABLE SPECIAL_REVIEW_USAGE
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE AWARD_SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE AWARD_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE SP_REV_APPROVAL_TYPE
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;

INSERT INTO SP_REV_APPROVAL_TYPE (APPROVAL_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1000', 'Link to EXCON', NOW(), 'admin', 1, UUID());

-- Usages
CREATE TABLE SEQ_SPECIAL_REVIEW_USAGE_ID
(
    id BIGINT(19) NOT NULL AUTO_INCREMENT,
    PRIMARY KEY (id)
);

ALTER TABLE SEQ_SPECIAL_REVIEW_USAGE_ID
    AUTO_INCREMENT = 1000;

-- Award
INSERT INTO SEQ_SPECIAL_REVIEW_USAGE_ID VALUES (null);
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES ((select max(ID) from SEQ_SPECIAL_REVIEW_USAGE_ID), 'RESBOOT-1000', 1, 'Y', NOW(), 'admin', UUID(), 'Y');

-- IP
INSERT INTO SEQ_SPECIAL_REVIEW_USAGE_ID VALUES (null);
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES ((select max(ID) from SEQ_SPECIAL_REVIEW_USAGE_ID), 'RESBOOT-1000', 2, 'Y', NOW(), 'admin', UUID(), 'Y');

-- PD
INSERT INTO SEQ_SPECIAL_REVIEW_USAGE_ID VALUES (null);
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES ((select max(ID) from SEQ_SPECIAL_REVIEW_USAGE_ID), 'RESBOOT-1000', 3, 'Y', NOW(), 'admin', UUID(), 'Y');