/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueFinderService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.uif.view.ViewModel;

public class BudgetPeriodValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KcServiceLocator.getService("keyValueFinderService");
    private String selectAllOption;

    public BudgetPeriodValuesFinder() {
        this("Select");
    }

    public BudgetPeriodValuesFinder(String selectAllOption) {
        this.selectAllOption = selectAllOption;
    }

    public List<KeyValue> getKeyValues() {
        List<BudgetPeriod> budgetPeriods;
        List<KeyValue> KeyValues = null;
        Document doc = this.getDocument();
        if (doc instanceof AwardBudgetDocument && (budgetPeriods = ((AwardBudgetDocument)doc).getBudget().getBudgetPeriods()).size() > 0) {
            KeyValues = this.buildKeyValues(budgetPeriods);
        }
        return KeyValues;
    }

    private List<KeyValue> buildKeyValues(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        KeyValues.add(ValuesFinderUtils.getSelectOption());
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getLabel()));
        }
        return KeyValues;
    }

    @Override
    public List<KeyValue> getKeyValues(ViewModel viewModel) {
        List<KeyValue> keyValues = null;
        List<BudgetPeriod> budgetPeriods = ((ProposalBudgetForm)viewModel).getBudget().getBudgetPeriods();
        if (budgetPeriods.size() > 0) {
            keyValues = this.buildKeyValues(budgetPeriods);
        }
        return keyValues;
    }

    public String getSelectAllOption() {
        return this.selectAllOption;
    }

    public void setSelectAllOption(String selectAllOption) {
        this.selectAllOption = selectAllOption;
    }
}

