/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionBase
extends ProtocolAssociateBase {
    private static final long serialVersionUID = -2148599171919464303L;
    protected static final String PROTOCOL_ACTION_ID_FIELD_KEY = "protocolActionId";
    protected static final String PROTOCOL_ACTION_TYPE_CODE_FIELD_KEY = "protocolActionTypeCode";
    protected static final String SUBMISSION_NUMBER_FIELD_KEY = "submissionNumber";
    protected static final String ACTION_ID_FIELD_KEY = "actionId";
    protected static final String PROTOCOL_NUMBER_FIELD_KEY = "protocolNumber";
    protected static final String COMMENT_PREFIX_RENEWAL = ProtocolSpecialVersion.RENEWAL.getCode() + "-";
    protected static final String COMMENT_PREFIX_AMMENDMENT = ProtocolSpecialVersion.AMENDMENT.getDescription() + "-";
    protected static final String COMMENT_PREFIX_FYI = ProtocolSpecialVersion.FYI.getDescription() + "-";
    private transient SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Long protocolActionId;
    private Integer actionId;
    private Integer submissionNumber;
    private Long submissionIdFk;
    private String protocolActionTypeCode;
    private String comments;
    private Timestamp actualActionDate;
    private Timestamp actionDate;
    private String prevSubmissionStatusCode;
    private String submissionTypeCode;
    private String prevProtocolStatusCode;
    private String followupActionCode;
    @SkipVersioning
    private transient ProtocolSubmissionBase protocolSubmission;
    private ProtocolActionTypeBase protocolActionType;
    private List<ProtocolCorrespondence> protocolCorrespondences;
    private List<KcNotification> protocolNotifications;
    @SkipVersioning
    private transient List<ProtocolSubmissionDocBase> protocolSubmissionDocs;
    private transient boolean isInFilterView = true;
    private String createUser;
    private Timestamp createTimestamp;
    private ProtocolSubmissionQuestionnaireHelper questionnaireHelper;
    private transient CommitteeServiceBase committeeService;
    private transient QuestionnairePrintOption questionnairePrintOption;
    private transient ProtocolActionAttachment newActionAttachment;

    public ProtocolActionBase() {
    }

    public ProtocolActionBase(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode, Timestamp actionDate) {
        this.initializeProtocolAction(protocol, protocolSubmission, protocolActionTypeCode, actionDate);
    }

    public ProtocolActionBase(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode) {
        this.initializeProtocolAction(protocol, protocolSubmission, protocolActionTypeCode, null);
    }

    public ProtocolActionBase(ProtocolBase protocol, String protocolActionTypeCode) {
        this.initializeProtocolAction(protocol, null, protocolActionTypeCode, null);
    }

    protected void initializeProtocolAction(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode, Timestamp actionDate) {
        if (protocolSubmission != null) {
            this.setSubmissionIdFk(protocolSubmission.getSubmissionId());
            this.setSubmissionNumber(protocolSubmission.getSubmissionNumber());
        }
        this.setProtocolId(protocol.getProtocolId());
        this.setProtocolNumber(protocol.getProtocolNumber());
        this.setSequenceNumber(0);
        this.setActionId(protocol.getNextValue(ACTION_ID_FIELD_KEY));
        this.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        this.setActionDate(actionDate == null ? new Timestamp(System.currentTimeMillis()) : actionDate);
        this.setProtocolActionTypeCode(protocolActionTypeCode);
        this.setProtocol(protocol);
        this.createUser = GlobalVariables.getUserSession().getPrincipalName();
        this.createTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.protocolCorrespondences = new ArrayList<ProtocolCorrespondence>();
    }

    public Long getProtocolActionId() {
        return this.protocolActionId;
    }

    public void setProtocolActionId(Long protocolActionId) {
        this.protocolActionId = protocolActionId;
    }

    public Integer getActionId() {
        return this.actionId;
    }

    public void setActionId(Integer actionId) {
        this.actionId = actionId;
    }

    public String getProtocolActionTypeCode() {
        return this.protocolActionTypeCode;
    }

    public void setProtocolActionTypeCode(String protocolActionTypeCode) {
        this.protocolActionTypeCode = protocolActionTypeCode;
    }

    public void setSubmissionNumber(Integer submissionNumber) {
        this.submissionNumber = submissionNumber;
    }

    public Integer getSubmissionNumber() {
        return this.submissionNumber;
    }

    public Long getSubmissionIdFk() {
        return this.submissionIdFk;
    }

    public void setSubmissionIdFk(Long submissionIdFk) {
        this.submissionIdFk = submissionIdFk;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Timestamp getActualActionDate() {
        return this.actualActionDate;
    }

    public void setActualActionDate(Timestamp actualActionDate) {
        this.actualActionDate = actualActionDate;
    }

    public Timestamp getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Timestamp actionDate) {
        this.actionDate = actionDate;
    }

    public void setProtocolSubmission(ProtocolSubmissionBase protocolSubmission) {
        this.protocolSubmission = protocolSubmission;
    }

    public ProtocolSubmissionBase getProtocolSubmission() {
        if (this.submissionIdFk == null) {
            this.protocolSubmission = null;
        } else {
            this.refreshReferenceObject("protocolSubmission");
        }
        return this.protocolSubmission;
    }

    public void setProtocolActionType(ProtocolActionTypeBase protocolActionType) {
        this.protocolActionType = protocolActionType;
    }

    public ProtocolActionTypeBase getProtocolActionType() {
        if (StringUtils.isBlank((CharSequence)this.protocolActionTypeCode)) {
            this.protocolActionType = null;
        } else {
            this.refreshReferenceObject("protocolActionType");
        }
        return this.protocolActionType;
    }

    public String getActualActionDateString() {
        if (this.getActualActionDate() == null) {
            return "";
        }
        return this.getDateFormat().format(this.getActualActionDate());
    }

    public String getActionDateString() {
        if (this.getActionDate() == null) {
            return "";
        }
        return this.getDateFormat().format(this.getActionDate());
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        }
        return this.dateFormat;
    }

    public String getSubmissionStatusString() {
        String status = "";
        if (this.protocolSubmission == null) {
            status = "";
        } else {
            if (this.protocolSubmission.getSubmissionStatus() == null && this.submissionIdFk != null) {
                this.protocolSubmission.refreshReferenceObject("submissionStatus");
            }
            status = this.protocolSubmission.getSubmissionStatus() == null ? "" : (this.protocolSubmission.getSubmissionStatus().getDescription() == null ? "" : this.protocolSubmission.getSubmissionStatus().getDescription());
        }
        return status;
    }

    public String getPrevSubmissionStatusCode() {
        return this.prevSubmissionStatusCode;
    }

    public void setPrevSubmissionStatusCode(String prevSubmissionStatusCode) {
        this.prevSubmissionStatusCode = prevSubmissionStatusCode;
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getPrevProtocolStatusCode() {
        return this.prevProtocolStatusCode;
    }

    public void setPrevProtocolStatusCode(String prevProtocolStatusCode) {
        this.prevProtocolStatusCode = prevProtocolStatusCode;
    }

    @Override
    public void resetPersistenceState() {
        this.protocolActionId = null;
        this.submissionIdFk = null;
        for (KcNotification notification : this.getProtocolNotifications()) {
            notification.setOwningDocumentIdFk(null);
        }
    }

    public void resetForeignKeys() {
        if (this.protocolSubmission != null) {
            this.submissionIdFk = this.protocolSubmission.getSubmissionId();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.protocolActionId == null ? 0 : this.protocolActionId.hashCode());
        result = 31 * result + (this.protocolActionTypeCode == null ? 0 : this.protocolActionTypeCode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolActionBase other = (ProtocolActionBase)obj;
        if (this.actionId == null ? other.actionId != null : !this.actionId.equals(other.actionId)) {
            return false;
        }
        return !(this.protocolActionTypeCode == null ? other.protocolActionTypeCode != null : !this.protocolActionTypeCode.equals(other.protocolActionTypeCode));
    }

    public List<ProtocolCorrespondence> getProtocolCorrespondences() {
        return this.protocolCorrespondences;
    }

    public void setProtocolCorrespondences(List<ProtocolCorrespondence> protocolCorrespondences) {
        this.protocolCorrespondences = protocolCorrespondences;
    }

    public List<KcNotification> getProtocolNotifications() {
        if (this.protocolNotifications == null) {
            this.protocolNotifications = new ArrayList<KcNotification>();
        }
        return this.protocolNotifications;
    }

    public void setProtocolNotifications(List<KcNotification> notifications) {
        this.protocolNotifications = notifications;
    }

    public List<KcNotification> getFilteredProtocolNotifications() {
        List<KcNotification> unfilteredList = this.getProtocolNotifications();
        String currentUser = GlobalVariables.getUserSession().getPrincipalName().trim();
        if (!this.getProtocol().isUserNamedInProtocol(currentUser)) {
            return unfilteredList;
        }
        ArrayList<KcNotification> filteredList = new ArrayList<KcNotification>();
        block0: for (KcNotification notification : unfilteredList) {
            if (currentUser.equals(notification.getCreateUser())) {
                filteredList.add(notification);
                continue;
            }
            for (String recipient : notification.getRecipients().split(",")) {
                if (!currentUser.equals(recipient.trim())) continue;
                filteredList.add(notification);
                continue block0;
            }
        }
        return filteredList;
    }

    public void addProtocolNotification(KcNotification notification) {
        this.getProtocolNotifications().add(notification);
    }

    public List<ProtocolSubmissionDocBase> getProtocolSubmissionDocs() {
        return this.protocolSubmissionDocs;
    }

    public void setProtocolSubmissionDocs(List<ProtocolSubmissionDocBase> protocolSubmissionDocs) {
        this.protocolSubmissionDocs = protocolSubmissionDocs;
    }

    public boolean getIsInFilterView() {
        return this.isInFilterView;
    }

    public void setIsInFilterView(boolean isInFilterView) {
        this.isInFilterView = isInFilterView;
    }

    public String getFollowupActionCode() {
        return this.followupActionCode;
    }

    public void setFollowupActionCode(String followupActionCode) {
        this.followupActionCode = followupActionCode;
    }

    public String getCreateUser() {
        return this.createUser == null ? this.getUpdateUser() : this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp == null ? this.getUpdateTimestamp() : this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public int getAnswerHeaderCount(String moduleSubItemCode, String moduleItemKey, String moduleSubItemKey) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", this.getCoeusModule());
        fieldValues.put("moduleItemKey", moduleItemKey);
        if (!moduleItemKey.contains(ProtocolSpecialVersion.AMENDMENT.getCode()) && !moduleItemKey.contains(ProtocolSpecialVersion.RENEWAL.getCode()) && !moduleItemKey.contains(ProtocolSpecialVersion.FYI.getCode()) && this.getProtocol().isNew()) {
            fieldValues.put("moduleSubItemCode", moduleSubItemCode);
        }
        fieldValues.put("moduleSubItemKey", moduleSubItemKey);
        return this.getBusinessObjectService().countMatching(AnswerHeader.class, fieldValues);
    }

    protected String getAmendmentRenewalNumber(String comment) {
        String retVal = comment.startsWith(COMMENT_PREFIX_AMMENDMENT) ? ProtocolSpecialVersion.AMENDMENT.getCode() + comment.substring(10, 13) : (this.comments.startsWith(COMMENT_PREFIX_FYI) ? ProtocolSpecialVersion.FYI.getCode() + comment.substring(4, 7) : ProtocolSpecialVersion.RENEWAL.getCode() + comment.substring(8, 11));
        return retVal;
    }

    public BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public boolean isActiveCommitteeMember() {
        boolean result = false;
        ProtocolSubmissionBase submission = this.getSubmission();
        List<CommitteeMembershipBase> committeeMembers = this.getCommitteeService().getAvailableMembers(submission.getCommitteeId(), submission.getScheduleId());
        if (CollectionUtils.isNotEmpty(committeeMembers)) {
            for (CommitteeMembershipBase member : committeeMembers) {
                if (!StringUtils.equals((CharSequence)GlobalVariables.getUserSession().getPrincipalId(), (CharSequence)member.getPersonId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private ProtocolSubmissionBase getSubmission() {
        ProtocolSubmissionBase submission = null;
        this.refreshReferenceObject("protocolSubmission");
        if (this.protocolSubmission != null) {
            submission = this.protocolSubmission;
        } else {
            for (ProtocolActionBase action : this.getProtocol().getSortedActions()) {
                if (action.getActionId() >= this.actionId || action.getSubmissionNumber() == null) continue;
                submission = this.getSubmissionForAction(action.getSubmissionNumber());
            }
        }
        return submission;
    }

    private ProtocolSubmissionBase getSubmissionForAction(Integer submissionNumber) {
        for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
            if (!submission.getSubmissionNumber().equals(submissionNumber)) continue;
            return submission;
        }
        return null;
    }

    public CommitteeServiceBase getCommitteeService() {
        if (this.committeeService == null) {
            this.committeeService = KcServiceLocator.getService(this.getCommitteeServiceClassHook());
        }
        return this.committeeService;
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    protected abstract String getCoeusModule();

    protected abstract ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase var1, String var2, String var3);

    public void addNotification(KcNotification notification) {
        this.getProtocolNotifications().add(notification);
    }

    public ProtocolSubmissionQuestionnaireHelper getQuestionnaireHelper() {
        this.setQuestionnaireHelper(this.getProtocolSubmissionQuestionnaireHelperHook(this.getProtocol(), this.protocolActionTypeCode, this.submissionNumber == null ? null : this.submissionNumber.toString()));
        this.questionnaireHelper.populateAnswers();
        return this.questionnaireHelper;
    }

    public void setQuestionnaireHelper(ProtocolSubmissionQuestionnaireHelper questionnaireHelper) {
        this.questionnaireHelper = questionnaireHelper;
    }

    public QuestionnairePrintOption getQuestionnairePrintOption() {
        return this.questionnairePrintOption;
    }

    public void setQuestionnairePrintOption(QuestionnairePrintOption questionnairePrintOption) {
        this.questionnairePrintOption = questionnairePrintOption;
    }

    protected QuestionnairePrintOption getQnPrintOptionForAction(String itemKey, String subItemKey, String subItemCode) {
        if (!this.getQuestionnaireHelper().getAnswerHeaders().isEmpty()) {
            QuestionnairePrintOption qnPrintOption = new QuestionnairePrintOption();
            qnPrintOption.setItemKey(itemKey);
            qnPrintOption.setSubItemCode(subItemCode);
            qnPrintOption.setSubItemKey(subItemKey);
            return qnPrintOption;
        }
        return null;
    }

    public ProtocolActionAttachment getNewActionAttachment() {
        return this.newActionAttachment;
    }

    public void setNewActionAttachment(ProtocolActionAttachment newActionAttachment) {
        this.newActionAttachment = newActionAttachment;
    }
}

