/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataChild;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.data.provider.impl.DataObjectWrapperBase;
import org.kuali.rice.krad.data.util.ReferenceLinker;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class ProviderBasedDataObjectService
implements DataObjectService {
    private static final Logger LOG = LogManager.getLogger(ProviderBasedDataObjectService.class);
    protected ProviderRegistry providerRegistry;
    protected MetadataRepository metadataRepository;
    protected ReferenceLinker referenceLinker;

    @Override
    public <T> T find(Class<T> type, Object id) {
        return this.persistenceProviderForType(type).find(type, this.reduceCompoundKey(id));
    }

    protected Object reduceCompoundKey(Object id) {
        CompoundKey compoundKey;
        if (id instanceof CompoundKey && (compoundKey = (CompoundKey)id).getKeys().size() == 1) {
            id = compoundKey.getKeys().values().iterator().next();
        }
        return id;
    }

    @Override
    public <T> QueryResults<T> findMatching(Class<T> type, QueryByCriteria queryByCriteria) {
        return this.persistenceProviderForType(type).findMatching(type, queryByCriteria);
    }

    @Override
    public <T> QueryResults<T> findAll(Class<T> type) {
        return this.persistenceProviderForType(type).findAll(type);
    }

    @Override
    public <T> T findUnique(Class<T> type, QueryByCriteria queryByCriteria) {
        QueryResults<T> results = this.findMatching(type, queryByCriteria);
        if (results.getResults().isEmpty()) {
            return null;
        }
        if (results.getResults().size() > 1) {
            throw new IncorrectResultSizeDataAccessException("Attempted to find single result but found more than one for class " + type + " and criteria " + queryByCriteria, 1, results.getResults().size());
        }
        return (T)results.getResults().get(0);
    }

    @Override
    public void delete(Object dataObject) {
        this.persistenceProviderForObject(dataObject).delete(dataObject);
    }

    @Override
    public <T> void deleteMatching(Class<T> type, QueryByCriteria queryByCriteria) {
        this.persistenceProviderForType(type).deleteMatching(type, queryByCriteria);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        this.persistenceProviderForType(type).deleteAll(type);
    }

    @Override
    public <T> T save(T dataObject, PersistenceOption ... options) {
        HashSet optionSet = Sets.newHashSet((Object[])options);
        this.pushOneToOneKeysToChildObjects(dataObject);
        T saved = this.persistenceProviderForObject(dataObject).save(dataObject, options);
        if (optionSet.contains(PersistenceOption.LINK_KEYS)) {
            DataObjectWrapper<T> wrapper = this.wrap(saved);
            wrapper.linkForeignKeys(true);
        }
        return saved;
    }

    protected void pushOneToOneKeysToChildObjects(Object dataObject) {
        DataObjectWrapper<Object> wrappedParent = this.wrap(dataObject);
        if (wrappedParent.getMetadata() == null) {
            return;
        }
        for (DataObjectRelationship rel : wrappedParent.getMetadata().getRelationships()) {
            Object child;
            if (!rel.isSavedWithParent() || !rel.isDeletedWithParent() || (child = wrappedParent.getPropertyValueNullSafe(rel.getName())) == null) continue;
            DataObjectWrapper<Object> wrappedChild = this.wrap(child);
            MetadataChild inverseRelationship = rel.getInverseRelationship();
            if (inverseRelationship == null || !(inverseRelationship instanceof DataObjectRelationship)) continue;
            try {
                wrappedChild.setPropertyValue(inverseRelationship.getName(), dataObject);
                for (DataObjectAttributeRelationship attr : inverseRelationship.getAttributeRelationships()) {
                    wrappedChild.setPropertyValue(attr.getParentAttributeName(), wrappedParent.getPropertyValueNullSafe(attr.getChildAttributeName()));
                }
            }
            catch (Exception ex) {
                LOG.warn("Unable to set 1:1 child keys.  Persistance of child object may not be correct.  Parent Object.property: " + dataObject.getClass().getName() + "." + rel.getName() + " / Child Type: " + child.getClass().getName(), (Throwable)ex);
            }
        }
    }

    @Override
    public MetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    @Override
    public <T> T copyInstance(T dataObject, CopyOption ... options) {
        return this.persistenceProviderForObject(dataObject).copyInstance(dataObject, options);
    }

    @Override
    public <T> DataObjectWrapper<T> wrap(T dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("data object was null");
        }
        DataObjectMetadata metadata = this.getMetadataRepository().getMetadata(dataObject.getClass());
        if (metadata == null) {
            LOG.warn("Non KRAD Data object passed - no metadata found for: " + dataObject.getClass());
        }
        return new DataObjectWrapperImpl<T>(dataObject, metadata, this, this.referenceLinker);
    }

    @Override
    public <T> boolean supports(Class<T> type) {
        return this.providerRegistry.getPersistenceProvider(type) != null;
    }

    protected PersistenceProvider persistenceProviderForType(Class<?> type) {
        PersistenceProvider provider = this.providerRegistry.getPersistenceProvider(type);
        if (provider == null) {
            throw new RuntimeException("No PersistenceProvider handles type: " + type);
        }
        return provider;
    }

    protected PersistenceProvider persistenceProviderForObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("data object was null");
        }
        return this.persistenceProviderForType(object.getClass());
    }

    @Override
    public void flush(Class<?> type) {
        PersistenceProvider persistenceProvider = this.persistenceProviderForType(type);
        if (persistenceProvider == null) {
            throw new RuntimeException("No PersistenceProvider handles type: " + type);
        }
        persistenceProvider.flush(type);
    }

    @Required
    public void setProviderRegistry(ProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    @Required
    public void setMetadataRepository(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    public ReferenceLinker getReferenceLinker() {
        return this.referenceLinker;
    }

    @Required
    public void setReferenceLinker(ReferenceLinker referenceLinker) {
        this.referenceLinker = referenceLinker;
    }

    private static final class DataObjectWrapperImpl<T>
    extends DataObjectWrapperBase<T> {
        private DataObjectWrapperImpl(T dataObject, DataObjectMetadata metadata, DataObjectService dataObjectService, ReferenceLinker referenceLinker) {
            super(dataObject, metadata, dataObjectService, referenceLinker);
        }
    }
}

