/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.MtoNCollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.ReferencePrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;

public class RelationshipPrefetcherFactory {
    private PersistenceBrokerImpl broker;

    public RelationshipPrefetcherFactory(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.broker = persistenceBrokerImpl;
    }

    public RelationshipPrefetcher createRelationshipPrefetcher(ObjectReferenceDescriptor objectReferenceDescriptor) {
        if (objectReferenceDescriptor instanceof CollectionDescriptor) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)objectReferenceDescriptor;
            if (collectionDescriptor.isMtoNRelation()) {
                return new MtoNCollectionPrefetcher(this.broker, collectionDescriptor);
            }
            return new CollectionPrefetcher(this.broker, collectionDescriptor);
        }
        return new ReferencePrefetcher(this.broker, objectReferenceDescriptor);
    }

    public RelationshipPrefetcher createRelationshipPrefetcher(ClassDescriptor classDescriptor, String string) {
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getCollectionDescriptorByName(string);
        if (objectReferenceDescriptor == null && (objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string)) == null) {
            throw new PersistenceBrokerException("Relationship named '" + string + "' not found in owner class " + (classDescriptor != null ? classDescriptor.getClassNameOfObject() : null));
        }
        return this.createRelationshipPrefetcher(objectReferenceDescriptor);
    }
}

